/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.cluster;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Duration;
import org.opensearch.ad.cluster.HourlyCron;
import org.opensearch.ad.cluster.diskcleanup.IndexCleanup;
import org.opensearch.ad.cluster.diskcleanup.ModelCheckpointIndexRetention;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.ad.util.DateUtils;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.client.Client;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.component.LifecycleListener;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class ClusterManagerEventListener
implements LocalNodeClusterManagerListener {
    private Scheduler.Cancellable checkpointIndexRetentionCron;
    private Scheduler.Cancellable hourlyCron;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Client client;
    private Clock clock;
    private ClientUtil clientUtil;
    private DiscoveryNodeFilterer nodeFilter;
    private Duration checkpointTtlDuration;

    public ClusterManagerEventListener(ClusterService clusterService, ThreadPool threadPool, Client client, Clock clock, ClientUtil clientUtil, DiscoveryNodeFilterer nodeFilter, Setting<TimeValue> checkpointTtl, Settings settings) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.clusterService.addLocalNodeClusterManagerListener((LocalNodeClusterManagerListener)this);
        this.clock = clock;
        this.clientUtil = clientUtil;
        this.nodeFilter = nodeFilter;
        this.checkpointTtlDuration = DateUtils.toDuration((TimeValue)checkpointTtl.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(checkpointTtl, it -> {
            this.checkpointTtlDuration = DateUtils.toDuration(it);
            this.cancel(this.checkpointIndexRetentionCron);
            IndexCleanup indexCleanup = new IndexCleanup(client, clientUtil, clusterService);
            this.checkpointIndexRetentionCron = threadPool.scheduleWithFixedDelay((Runnable)new ModelCheckpointIndexRetention(this.checkpointTtlDuration, clock, indexCleanup), TimeValue.timeValueHours((long)24L), this.executorName());
        });
    }

    public void onClusterManager() {
        if (this.hourlyCron == null) {
            this.hourlyCron = this.threadPool.scheduleWithFixedDelay((Runnable)new HourlyCron(this.client, this.nodeFilter), TimeValue.timeValueHours((long)1L), this.executorName());
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    ClusterManagerEventListener.this.cancel(ClusterManagerEventListener.this.hourlyCron);
                    ClusterManagerEventListener.this.hourlyCron = null;
                }
            });
        }
        if (this.checkpointIndexRetentionCron == null) {
            IndexCleanup indexCleanup = new IndexCleanup(this.client, this.clientUtil, this.clusterService);
            this.checkpointIndexRetentionCron = this.threadPool.scheduleWithFixedDelay((Runnable)new ModelCheckpointIndexRetention(this.checkpointTtlDuration, this.clock, indexCleanup), TimeValue.timeValueHours((long)24L), this.executorName());
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    ClusterManagerEventListener.this.cancel(ClusterManagerEventListener.this.checkpointIndexRetentionCron);
                    ClusterManagerEventListener.this.checkpointIndexRetentionCron = null;
                }
            });
        }
    }

    public void offClusterManager() {
        this.cancel(this.hourlyCron);
        this.cancel(this.checkpointIndexRetentionCron);
        this.hourlyCron = null;
        this.checkpointIndexRetentionCron = null;
    }

    private void cancel(Scheduler.Cancellable cron) {
        if (cron != null) {
            cron.cancel();
        }
    }

    @VisibleForTesting
    protected Scheduler.Cancellable getCheckpointIndexRetentionCron() {
        return this.checkpointIndexRetentionCron;
    }

    protected Scheduler.Cancellable getHourlyCron() {
        return this.hourlyCron;
    }

    private String executorName() {
        return "generic";
    }
}

