"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const coreServicesMock = {
  uiSettings: {
    get: jest.fn()
  },
  chrome: {
    setBreadcrumbs: jest.fn()
  },
  notifications: {
    toasts: {
      addDanger: jest.fn(() => ({})).mockName("addDanger"),
      addSuccess: jest.fn(() => ({})).mockName("addSuccess")
    }
  },
  docLinks: {
    links: {
      opensearch: {
        reindexData: {
          base: "https://opensearch.org/docs/latest/opensearch/reindex-data/",
          transform: "https://opensearch.org/docs/latest/opensearch/reindex-data/#transform-documents-during-reindexing"
        },
        queryDSL: {
          base: "https://opensearch.org/docs/opensearch/query-dsl/index/"
        },
        indexTemplates: {
          base: "https://opensearch.org/docs/latest/opensearch/index-templates"
        },
        indexAlias: {
          base: "https://opensearch.org/docs/latest/opensearch/index-alias/"
        }
      }
    }
  }
};
var _default = coreServicesMock;
exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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