/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.destination.message;

import java.io.IOException;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.commons.destination.message.LegacyBaseMessage;
import org.opensearch.commons.destination.message.LegacyDestinationType;

public class LegacyChimeMessage
extends LegacyBaseMessage {
    private final String message;

    private LegacyChimeMessage(String destinationName, String url, String message) {
        super(LegacyDestinationType.LEGACY_CHIME, destinationName, message, url);
        if (Strings.isNullOrEmpty((String)message)) {
            throw new IllegalArgumentException("Message content is missing");
        }
        this.message = message;
    }

    public LegacyChimeMessage(StreamInput streamInput) throws IOException {
        super(streamInput);
        this.message = super.getMessageContent();
    }

    public String toString() {
        return "DestinationType: " + this.getChannelType() + ", DestinationName:" + this.destinationName + ", Url: " + this.url + ", Message: <...>";
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public static class Builder {
        private String message;
        private final String destinationName;
        private String url;

        public Builder(String destinationName) {
            this.destinationName = destinationName;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public LegacyChimeMessage build() {
            return new LegacyChimeMessage(this.destinationName, this.url, this.message);
        }
    }
}

