"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _Node = _interopRequireWildcard(require("./Node"));

var _Range = _interopRequireDefault(require("./Range"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

class BlankLine extends _Node.default {
  constructor() {
    super(_Node.Type.BLANK_LINE);
  }

  get includesTrailingLines() {
    return true;
  }
  /**
   * Parses blank lines from the source
   *
   * @param {ParseContext} context
   * @param {number} start - Index of first \n character
   * @returns {number} - Index of the character after this
   */


  parse(context, start) {
    this.context = context;
    const src = context.src;
    let offset = start + 1;

    while (_Node.default.atBlank(src, offset)) {
      const lineEnd = _Node.default.endOfWhiteSpace(src, offset);

      if (lineEnd === '\n') offset = lineEnd + 1;else break;
    }

    this.range = new _Range.default(start, offset);
    return offset;
  }

}

exports.default = BlankLine;
module.exports = exports.default;
module.exports.default = exports.default;