/* qlite.vapi generated by valac 0.56.6, do not modify. */

namespace Qlite {
	[CCode (cheader_filename = "qlite.h")]
	public abstract class Column<T> {
		public class BoolInt : Qlite.Column<bool> {
			public BoolInt (string name);
			public override bool @get (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
		}
		public class BoolText : Qlite.Column<bool> {
			public BoolText (string name);
			public override bool @get (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
		}
		public class Integer : Qlite.Column<int> {
			public Integer (string name);
			public override int @get (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
			public override bool is_null (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
		}
		public class Long : Qlite.Column<long> {
			public Long (string name);
			public override long @get (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
			public override bool is_null (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
		}
		public class NonNullText : Qlite.Column<string> {
			public NonNullText (string name);
			public override string @get (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
			public override bool is_null (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
			public override bool not_null { get; set; }
		}
		public class NullableReal : Qlite.Column<double?> {
			public NullableReal (string name);
			public override double? @get (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
			public override bool is_null (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
			public override bool not_null { get; set; }
		}
		public class Text : Qlite.Column<string?> {
			public Text (string name);
			public override string? @get (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
			public override bool is_null (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
		}
		public const string DEFAULT_TABLE_NAME;
		public abstract T @get (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
		public virtual bool is_null (Qlite.Row row, string? table_name = DEFAULT_TABLE_NAME);
		public string to_column_definition ();
		public string to_string ();
		public bool auto_increment { get; set; }
		public string? @default { get; set; }
		public long max_version { get; set; }
		public long min_version { get; set; }
		public string name { get; private set; }
		public virtual bool not_null { get; set; }
		public bool primary_key { get; set; }
		public int sqlite_type { get; private set; }
		public bool unique { get; set; }
	}
	[CCode (cheader_filename = "qlite.h")]
	public class Database {
		public bool debug;
		public Database (string file_name, long expected_version);
		public Qlite.DeleteBuilder @delete ();
		public void ensure_init ();
		public void exec (string sql) throws GLib.Error;
		public void init (Qlite.Table[] tables);
		public Qlite.InsertBuilder insert ();
		public bool is_known_column (string table, string field);
		public virtual void migrate (long old_version);
		public Qlite.RowIterator query_sql (string sql, string[]? args = null);
		public Qlite.QueryBuilder select (Qlite.Column[]? columns = null);
		public Qlite.UpdateBuilder update (Qlite.Table table);
		public Qlite.UpdateBuilder update_named (string table);
		public Qlite.UpsertBuilder upsert (Qlite.Table table);
	}
	[CCode (cheader_filename = "qlite.h")]
	public class DeleteBuilder : Qlite.StatementBuilder {
		public Qlite.DeleteBuilder from (Qlite.Table table);
		public Qlite.DeleteBuilder from_name (string table);
		public void perform ();
		public Qlite.DeleteBuilder where (string selection, string[]? selection_args = null);
		public Qlite.DeleteBuilder @with<T> (Qlite.Column<T> column, string comp, T value);
	}
	[CCode (cheader_filename = "qlite.h")]
	public class InsertBuilder : Qlite.StatementBuilder {
		public Qlite.InsertBuilder into (Qlite.Table table);
		public Qlite.InsertBuilder into_name (string table);
		public Qlite.InsertBuilder or (string or);
		public int64 perform ();
		public Qlite.InsertBuilder replace ();
		public Qlite.InsertBuilder value<T> (Qlite.Column<T> column, T value);
		public Qlite.InsertBuilder value_null<T> (Qlite.Column<T> column);
	}
	[CCode (cheader_filename = "qlite.h")]
	public class MatchQueryBuilder : Qlite.QueryBuilder {
		public Qlite.MatchQueryBuilder match (Qlite.Column<string> column, string match);
	}
	[CCode (cheader_filename = "qlite.h")]
	public class QueryBuilder : Qlite.StatementBuilder {
		protected string selection;
		protected Qlite.Table? table;
		protected string? table_name;
		public int64 count ();
		public virtual Qlite.QueryBuilder from (Qlite.Table table);
		public virtual Qlite.QueryBuilder from_name (string table);
		public T @get<T> (Qlite.Column<T> field, T def = null);
		public Qlite.QueryBuilder group_by (Qlite.Column[] columns);
		public Qlite.RowIterator iterator ();
		public Qlite.QueryBuilder join_on (Qlite.Table table, string on, string? @as = null);
		public Qlite.QueryBuilder join_with<T> (Qlite.Table table, Qlite.Column<T> lhs, Qlite.Column<T> rhs, string? @as = null);
		public Qlite.QueryBuilder limit (int limit);
		public Qlite.QueryBuilder offset (int offset);
		public Qlite.QueryBuilder order_by (Qlite.Column column, string dir = "ASC");
		public Qlite.QueryBuilder order_by_name (string name, string dir);
		public Qlite.QueryBuilder outer_join_on (Qlite.Table table, string on, string? @as = null);
		public Qlite.QueryBuilder outer_join_with<T> (Qlite.Table table, Qlite.Column<T> lhs, Qlite.Column<T> rhs, string? @as = null);
		public Qlite.RowOption row ();
		public Qlite.QueryBuilder select (Qlite.Column[] columns = new Qlite.Column[0] { });
		public Qlite.QueryBuilder select_string (string column_selector);
		public Qlite.QueryBuilder single ();
		public Qlite.QueryBuilder where (string selection, string[] selection_args = new string[0] { });
		public Qlite.QueryBuilder @with<T> (Qlite.Column<T> column, string comp, T value);
		public Qlite.QueryBuilder with_null<T> (Qlite.Column<T> column);
		public Qlite.QueryBuilder without_null<T> (Qlite.Column<T> column);
	}
	[CCode (cheader_filename = "qlite.h")]
	public class Row {
		public T @get<T> (Qlite.Column<T> field);
		public long get_integer (string field, string? table = null);
		public double get_real (string field, string? table = null, double def = 0);
		public string? get_text (string field, string? table = null);
		public bool has_integer (string field, string? table = null);
		public bool has_real (string field, string? table = null);
		public string to_string ();
	}
	[CCode (cheader_filename = "qlite.h")]
	public class RowIterator {
		public RowIterator (Qlite.Database db, string sql, string[]? args = null);
		public RowIterator.from_query_builder (Qlite.Database db, Qlite.QueryBuilder query);
		public Qlite.Row @get ();
		public Qlite.Row? get_next ();
		public bool next ();
	}
	[CCode (cheader_filename = "qlite.h")]
	public class RowOption {
		public RowOption (Qlite.Row? row);
		public T @get<T> (Qlite.Column<T> field, T def = null);
		public bool is_present ();
		public Qlite.Row? inner { get; private set; }
	}
	[CCode (cheader_filename = "qlite.h")]
	public abstract class StatementBuilder {
		protected Qlite.Database db;
	}
	[CCode (cheader_filename = "qlite.h")]
	public class Table {
		protected Qlite.Column[]? columns;
		protected Qlite.Database db;
		public Table (Qlite.Database db, string name);
		public void add_columns_for_version (long old_version, long new_version);
		public void add_create_statement (string stmt);
		public void add_post_statement (string stmt);
		public void create_table_at_version (long version);
		public Qlite.DeleteBuilder @delete ();
		public void delete_columns_for_version (long old_version, long new_version);
		public void fts (Qlite.Column[] columns);
		public void fts_rebuild ();
		public void index (string index_name, Qlite.Column[] columns, bool unique = false);
		public void init (Qlite.Column[] columns, string constraints = "");
		public Qlite.InsertBuilder insert ();
		public bool is_known_column (string column);
		public Qlite.MatchQueryBuilder match (Qlite.Column<string> column, string query);
		public Qlite.RowOption row_with<T> (Qlite.Column<T> column, T value);
		public Qlite.QueryBuilder select (Qlite.Column[]? columns = null);
		public void unique (Qlite.Column[] columns, string? on_conflict = null);
		public Qlite.UpdateBuilder update ();
		public Qlite.UpsertBuilder upsert ();
		public string name { get; private set; }
	}
	[CCode (cheader_filename = "qlite.h")]
	public class UpdateBuilder : Qlite.StatementBuilder {
		public Qlite.UpdateBuilder or (string or);
		public void perform ();
		public Qlite.UpdateBuilder @set<T> (Qlite.Column<T> column, T value);
		public Qlite.UpdateBuilder set_null<T> (Qlite.Column<T> column);
		public Qlite.UpdateBuilder where (string selection, string[] selection_args = new string[0] { });
		public Qlite.UpdateBuilder @with<T> (Qlite.Column<T> column, string comp, T value);
		public Qlite.UpdateBuilder with_null<T> (Qlite.Column<T> column);
		public Qlite.UpdateBuilder without_null<T> (Qlite.Column<T> column);
	}
	[CCode (cheader_filename = "qlite.h")]
	public class UpsertBuilder : Qlite.StatementBuilder {
		public int64 perform ();
		public Qlite.UpsertBuilder value<T> (Qlite.Column<T> column, T value, bool key = false);
		public Qlite.UpsertBuilder value_null<T> (Qlite.Column<T> column);
	}
}
