# Namco 163 (also called N163, Namco C163, Namco 106 (sic), Namco 160 or Namco 129)

this is one of Namco's NES mappers, with up to 8 wavetable channels.

it has 256 nibbles (128 bytes) of internal RAM which is shared between channel state and waves.

wavetables are variable in size and may be allocated anywhere in RAM. at least 128 nibbles (64 bytes) can be dedicated to waves, with more available if not all channels are used - waveform RAM area becomes smaller as more channels are activated, since channel registers consume 8 bytes for each channel.

Namco 163 uses time-division multiplexing for its output. this means that only one channel is output per sample (like OPLL and OPN2). therefore, its sound quality gets worse as more channels are activated.

Furnace supports loading waveforms into RAM and waveform playback simultaneously, and channel limit is dynamically changeable with effect commands.

you must load waveform to RAM first for playback, as its load behavior auto-updates when every waveform changes.

both waveform playback and load command work independently per each channel columns.
(Global) commands don't care about the channel columns for work commands and its load behavior is independent with per-channel column load commands.

# effects

- `10xx`: set waveform for playback.
- `11xx`: set waveform position in RAM for playback (single nibble unit).
- `12xx`: set waveform length in RAM for playback (04 to FC, 4 nibble unit).
- `130x`: set playback waveform update behavior (0: off, bit 0: update now, bit 1: update when every waveform is changed).
- `14xx`: set waveform for load to RAM.
- `15xx`: set waveform position for load to RAM (single nibble unit).
- `16xx`: set waveform length for load to RAM (04 to FC, 4 nibble unit).
- `170x`: set waveform load behavior (0: off, bit 0: load now, bit 1: load when every waveform is changed).
- `180x`: set channel limit (0 to 7, x + 1).
- `20xx`: (Global) set waveform for load to RAM.
- `21xx`: (Global) set waveform position for load to RAM (single nibble unit).
- `22xx`: (Global) set waveform length for load to RAM (04 to FC, 4 nibble unit).
- `230x`: (Global) set waveform load behavior (0: off, bit 0: load now, bit 1: load when every waveform is changed).
