/*
 * Decompiled with CFR 0.152.
 */
package hdf.hdf5lib;

import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.HDFArray;
import hdf.hdf5lib.callbacks.H5A_iterate_cb;
import hdf.hdf5lib.callbacks.H5A_iterate_t;
import hdf.hdf5lib.callbacks.H5D_iterate_cb;
import hdf.hdf5lib.callbacks.H5D_iterate_t;
import hdf.hdf5lib.callbacks.H5E_walk_cb;
import hdf.hdf5lib.callbacks.H5E_walk_t;
import hdf.hdf5lib.callbacks.H5L_iterate_opdata_t;
import hdf.hdf5lib.callbacks.H5L_iterate_t;
import hdf.hdf5lib.callbacks.H5O_iterate_opdata_t;
import hdf.hdf5lib.callbacks.H5O_iterate_t;
import hdf.hdf5lib.callbacks.H5P_iterate_cb;
import hdf.hdf5lib.callbacks.H5P_iterate_t;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import hdf.hdf5lib.structs.H5AC_cache_config_t;
import hdf.hdf5lib.structs.H5A_info_t;
import hdf.hdf5lib.structs.H5FD_hdfs_fapl_t;
import hdf.hdf5lib.structs.H5FD_ros3_fapl_t;
import hdf.hdf5lib.structs.H5F_info2_t;
import hdf.hdf5lib.structs.H5G_info_t;
import hdf.hdf5lib.structs.H5L_info_t;
import hdf.hdf5lib.structs.H5O_info_t;
import hdf.hdf5lib.structs.H5O_native_info_t;
import hdf.hdf5lib.structs.H5O_token_t;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5
implements Serializable {
    private static final long serialVersionUID = 6129888282117053288L;
    private static final Logger log = LoggerFactory.getLogger(H5.class);
    public static final int[] LIB_VERSION = new int[]{1, 14, 0};
    public static final String H5PATH_PROPERTY_KEY = "hdf.hdf5lib.H5.hdf5lib";
    public static final String H5_LIBRARY_NAME_PROPERTY_KEY = "hdf.hdf5lib.H5.loadLibraryName";
    private static String s_libraryName;
    private static boolean isLibraryLoaded;
    private static final boolean IS_CRITICAL_PINNING = true;
    private static final LinkedHashSet<Long> OPEN_IDS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadH5Lib() {
        Comparable<File> comparable;
        Object object;
        String string;
        block20: {
            block22: {
                if (isLibraryLoaded) {
                    return;
                }
                s_libraryName = System.getProperty(H5_LIBRARY_NAME_PROPERTY_KEY, null);
                string = null;
                if (s_libraryName != null && s_libraryName.length() > 0) {
                    try {
                        string = System.mapLibraryName(s_libraryName);
                        System.loadLibrary(s_libraryName);
                        isLibraryLoaded = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            throwable.printStackTrace();
                            isLibraryLoaded = false;
                        }
                        catch (Throwable throwable2) {
                            log.info("HDF5 library: " + s_libraryName);
                            log.debug(" resolved to: " + string + "; ");
                            log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from system property");
                            throw throwable2;
                        }
                        log.info("HDF5 library: " + s_libraryName);
                        log.debug(" resolved to: " + string + "; ");
                        log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from system property");
                    }
                    log.info("HDF5 library: " + s_libraryName);
                    log.debug(" resolved to: " + string + "; ");
                    log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from system property");
                }
                if (isLibraryLoaded || (object = System.getProperty(H5PATH_PROPERTY_KEY, null)) == null || ((String)object).length() <= 0) break block20;
                comparable = new File((String)object);
                if (!((File)comparable).exists() || !((File)comparable).canRead() || !((File)comparable).isFile()) break block22;
                try {
                    System.load((String)object);
                    isLibraryLoaded = true;
                }
                catch (Throwable throwable) {
                    try {
                        throwable.printStackTrace();
                        isLibraryLoaded = false;
                    }
                    catch (Throwable throwable3) {
                        log.info("HDF5 library: ");
                        log.debug((String)object);
                        log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                        throw throwable3;
                    }
                    log.info("HDF5 library: ");
                    log.debug((String)object);
                    log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                    break block20;
                }
                log.info("HDF5 library: ");
                log.debug((String)object);
                log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                break block20;
            }
            isLibraryLoaded = false;
            throw new UnsatisfiedLinkError("Invalid HDF5 library, " + (String)object);
        }
        if (!isLibraryLoaded) {
            try {
                s_libraryName = "hdf5_java";
                string = System.mapLibraryName(s_libraryName);
                System.loadLibrary("hdf5_java");
                isLibraryLoaded = true;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    isLibraryLoaded = false;
                }
                catch (Throwable throwable4) {
                    log.info("HDF5 library: " + s_libraryName);
                    log.debug(" resolved to: " + string + "; ");
                    log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                    throw throwable4;
                }
                log.info("HDF5 library: " + s_libraryName);
                log.debug(" resolved to: " + string + "; ");
                log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
            }
            log.info("HDF5 library: " + s_libraryName);
            log.debug(" resolved to: " + string + "; ");
            log.info((isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
        }
        try {
            H5.H5dont_atexit();
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            System.exit(1);
        }
        if (!log.isDebugEnabled()) {
            H5.H5error_off();
        }
        object = Integer.getInteger("hdf.hdf5lib.H5.hdf5maj", null);
        comparable = Integer.getInteger("hdf.hdf5lib.H5.hdf5min", null);
        Integer n = Integer.getInteger("hdf.hdf5lib.H5.hdf5rel", null);
        if (object != null && comparable != null && n != null) {
            H5.H5check_version((Integer)object, (Integer)comparable, n);
        }
    }

    public static final int getOpenIDCount() {
        return OPEN_IDS.size();
    }

    public static final Collection<Long> getOpenIDs() {
        return OPEN_IDS;
    }

    public static synchronized native int H5check_version(int var0, int var1, int var2);

    public static synchronized native int H5close() throws HDF5LibraryException;

    public static synchronized native int H5open() throws HDF5LibraryException;

    private static synchronized native int H5dont_atexit() throws HDF5LibraryException;

    public static synchronized native int H5error_off();

    public static synchronized native void H5error_on();

    public static synchronized native int H5garbage_collect() throws HDF5LibraryException;

    public static synchronized native int H5get_libversion(int[] var0) throws HDF5LibraryException;

    public static synchronized native int H5set_free_list_limits(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException;

    public static synchronized native void H5export_dataset(String var0, long var1, String var3, int var4) throws HDF5LibraryException;

    public static synchronized native void H5export_attribute(String var0, long var1, String var3, int var4) throws HDF5LibraryException;

    private static synchronized native boolean H5is_library_threadsafe();

    public static int H5Aclose(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Aclose remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Aclose(l);
    }

    private static synchronized native int _H5Aclose(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Acopy(long var0, long var2) throws HDF5LibraryException;

    public static long H5Acreate(long l, String string, long l2, long l3, long l4, long l5) throws HDF5LibraryException, NullPointerException {
        long l6 = H5._H5Acreate2(l, string, l2, l3, l4, l5);
        if (l6 > 0L) {
            log.trace("OPEN_IDS: H5A create add {}", (Object)l6);
            OPEN_IDS.add(l6);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l6;
    }

    private static synchronized native long _H5Acreate2(long var0, String var2, long var3, long var5, long var7, long var9) throws HDF5LibraryException, NullPointerException;

    public static long H5Acreate_by_name(long l, String string, String string2, long l2, long l3, long l4, long l5, long l6) throws HDF5LibraryException, NullPointerException {
        long l7 = H5._H5Acreate_by_name(l, string, string2, l2, l3, l4, l5, l6);
        if (l7 > 0L) {
            log.trace("OPEN_IDS: H5Acreate_by_name add {}", (Object)l7);
            OPEN_IDS.add(l7);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l7;
    }

    private static synchronized native long _H5Acreate_by_name(long var0, String var2, String var3, long var4, long var6, long var8, long var10, long var12) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Adelete(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Adelete_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Adelete_by_name(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Aexists(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Aexists_by_name(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5A_info_t H5Aget_info(long var0) throws HDF5LibraryException;

    public static synchronized native H5A_info_t H5Aget_info_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5A_info_t H5Aget_info_by_name(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Aget_name(long var0) throws HDF5LibraryException;

    public static synchronized native String H5Aget_name_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static long H5Aget_space(long l) throws HDF5LibraryException {
        long l2 = H5._H5Aget_space(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Aget_space add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Aget_space(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Aget_storage_size(long var0) throws HDF5LibraryException;

    public static long H5Aget_type(long l) throws HDF5LibraryException {
        long l2 = H5._H5Aget_type(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Aget_type add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Aget_type(long var0) throws HDF5LibraryException;

    public static long H5Aopen(long l, String string, long l2) throws HDF5LibraryException, NullPointerException {
        long l3 = H5._H5Aopen(l, string, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Aopen add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Aopen(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static long H5Aopen_by_idx(long l, String string, int n, int n2, long l2, long l3, long l4) throws HDF5LibraryException, NullPointerException {
        long l5 = H5._H5Aopen_by_idx(l, string, n, n2, l2, l3, l4);
        if (l5 > 0L) {
            log.trace("OPEN_IDS: H5Aopen_by_idx add {}", (Object)l5);
            OPEN_IDS.add(l5);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l5;
    }

    private static synchronized native long _H5Aopen_by_idx(long var0, String var2, int var3, int var4, long var5, long var7, long var9) throws HDF5LibraryException, NullPointerException;

    public static long H5Aopen_by_name(long l, String string, String string2, long l2, long l3) throws HDF5LibraryException, NullPointerException {
        long l4 = H5._H5Aopen_by_name(l, string, string2, l2, l3);
        if (l4 > 0L) {
            log.trace("OPEN_IDS: H5Aopen_by_name add {}", (Object)l4);
            OPEN_IDS.add(l4);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l4;
    }

    private static synchronized native long _H5Aopen_by_name(long var0, String var2, String var3, long var4, long var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread(long var0, long var2, byte[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread(long l, long l2, byte[] byArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread(l, l2, byArray, true);
    }

    public static synchronized int H5Aread(long l, long l2, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Aread(l, l2, object, true);
    }

    public static synchronized int H5Aread(long l, long l2, Object object, boolean bl) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int n = -1;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDF5JavaException("H5Aread: data is not an array");
        }
        String string = clazz.getName();
        bl2 = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        log.trace("H5Aread: cname={} is1D={} dname={}", new Object[]{string, bl2, Character.valueOf(c)});
        if (bl2 && c == 'B') {
            log.trace("H5Aread_dname_B");
            n = H5.H5Aread(l, l2, (byte[])object, bl);
        } else if (bl2 && c == 'S') {
            log.trace("H5Aread_dname_S");
            n = H5.H5Aread_short(l, l2, (short[])object, bl);
        } else if (bl2 && c == 'I') {
            log.trace("H5Aread_dname_I");
            n = H5.H5Aread_int(l, l2, (int[])object, bl);
        } else if (bl2 && c == 'J') {
            log.trace("H5Aread_dname_J");
            n = H5.H5Aread_long(l, l2, (long[])object, bl);
        } else if (bl2 && c == 'F') {
            log.trace("H5Aread_dname_F");
            n = H5.H5Aread_float(l, l2, (float[])object, bl);
        } else if (bl2 && c == 'D') {
            log.trace("H5Aread_dname_D");
            n = H5.H5Aread_double(l, l2, (double[])object, bl);
        } else if (H5.H5Tdetect_class(l2, HDF5Constants.H5T_REFERENCE) && bl2 && clazz.getComponentType() == String.class || H5.H5Tequal(l2, HDF5Constants.H5T_STD_REF_DSETREG)) {
            log.trace("H5Aread_reg_ref");
            n = H5.H5Aread_reg_ref(l, l2, (String[])object);
        } else if (bl2 && clazz.getComponentType() == String.class) {
            log.trace("H5Aread_string type");
            n = H5.H5Aread_string(l, l2, (String[])object);
        } else if (H5.H5Tget_class(l2) == HDF5Constants.H5T_VLEN) {
            log.trace("H5AreadVL type");
            n = H5.H5AreadVL(l, l2, (Object[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            log.trace("H5Aread_else");
            n = H5.H5Aread(l, l2, byArray, bl);
            if (n >= 0) {
                object = hDFArray.arrayify(byArray);
            }
            byArray = null;
            hDFArray = null;
        }
        return n;
    }

    public static synchronized native int H5Aread_double(long var0, long var2, double[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_double(long l, long l2, double[] dArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_double(l, l2, dArray, true);
    }

    public static synchronized native int H5Aread_float(long var0, long var2, float[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_float(long l, long l2, float[] fArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_float(l, l2, fArray, true);
    }

    public static synchronized native int H5Aread_int(long var0, long var2, int[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_int(long l, long l2, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_int(l, l2, nArray, true);
    }

    public static synchronized native int H5Aread_long(long var0, long var2, long[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_long(long l, long l2, long[] lArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_long(l, l2, lArray, true);
    }

    public static synchronized native int H5Aread_reg_ref(long var0, long var2, String[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread_short(long var0, long var2, short[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread_short(long l, long l2, short[] sArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Aread_short(l, l2, sArray, true);
    }

    public static synchronized native int H5AreadVL(long var0, long var2, Object[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread_string(long var0, long var2, String[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread_VLStrings(long var0, long var2, Object[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5AreadComplex(long var0, long var2, String[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Arename(long var0, String var2, String var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Arename_by_name(long var0, String var2, String var3, String var4, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Awrite(long var0, long var2, byte[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite(long l, long l2, byte[] byArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite(l, l2, byArray, true);
    }

    public static synchronized int H5Awrite(long l, long l2, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Awrite(l, l2, object, true);
    }

    public static synchronized int H5Awrite(long l, long l2, Object object, boolean bl) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int n = -1;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDF5JavaException("H5Dwrite: data is not an array");
        }
        String string = clazz.getName();
        bl2 = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        if (bl2 && c == 'B') {
            n = H5.H5Awrite(l, l2, (byte[])object, bl);
        } else if (bl2 && c == 'S') {
            n = H5.H5Awrite_short(l, l2, (short[])object, bl);
        } else if (bl2 && c == 'I') {
            n = H5.H5Awrite_int(l, l2, (int[])object, bl);
        } else if (bl2 && c == 'J') {
            n = H5.H5Awrite_long(l, l2, (long[])object, bl);
        } else if (bl2 && c == 'F') {
            n = H5.H5Awrite_float(l, l2, (float[])object, bl);
        } else if (bl2 && c == 'D') {
            n = H5.H5Awrite_double(l, l2, (double[])object, bl);
        } else if (bl2 && clazz.getComponentType() == String.class) {
            log.trace("H5Dwrite_string type");
            n = H5.H5Awrite_string(l, l2, (String[])object);
        } else if (H5.H5Tget_class(l2) == HDF5Constants.H5T_VLEN) {
            log.trace("H5AwriteVL type");
            n = H5.H5AwriteVL(l, l2, (Object[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.byteify();
            n = H5.H5Awrite(l, l2, byArray);
            byArray = null;
            hDFArray = null;
        }
        return n;
    }

    public static synchronized native int H5Awrite_double(long var0, long var2, double[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_double(long l, long l2, double[] dArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_double(l, l2, dArray, true);
    }

    public static synchronized native int H5Awrite_float(long var0, long var2, float[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_float(long l, long l2, float[] fArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_float(l, l2, fArray, true);
    }

    public static synchronized native int H5Awrite_int(long var0, long var2, int[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_int(long l, long l2, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_int(l, l2, nArray, true);
    }

    public static synchronized native int H5Awrite_long(long var0, long var2, long[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_long(long l, long l2, long[] lArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_long(l, l2, lArray, true);
    }

    public static synchronized native int H5Awrite_short(long var0, long var2, short[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite_short(long l, long l2, short[] sArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Awrite_short(l, l2, sArray, true);
    }

    public static synchronized native int H5Awrite_string(long var0, long var2, String[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5AwriteVL(long var0, long var2, Object[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Awrite_VLStrings(long var0, long var2, Object[] var4) throws HDF5LibraryException, NullPointerException;

    public static long H5Aget_create_plist(long l) throws HDF5LibraryException {
        long l2 = H5._H5Aget_create_plist(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Aget_create_plist add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Aget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Aiterate(long var0, int var2, int var3, long var4, H5A_iterate_cb var6, H5A_iterate_t var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aiterate_by_name(long var0, String var2, int var3, int var4, long var5, H5A_iterate_cb var7, H5A_iterate_t var8, long var9) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dcopy(long var0, long var2) throws HDF5LibraryException;

    public static int H5Dclose(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Dclose remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Dclose(l);
    }

    private static synchronized native int _H5Dclose(long var0) throws HDF5LibraryException;

    public static long H5Dcreate(long l, String string, long l2, long l3, long l4, long l5, long l6) throws HDF5LibraryException, NullPointerException {
        long l7 = H5._H5Dcreate2(l, string, l2, l3, l4, l5, l6);
        if (l7 > 0L) {
            log.trace("OPEN_IDS: H5Dcreate add {}", (Object)l7);
            OPEN_IDS.add(l7);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l7;
    }

    private static synchronized native long _H5Dcreate2(long var0, String var2, long var3, long var5, long var7, long var9, long var11) throws HDF5LibraryException, NullPointerException;

    public static long H5Dcreate_anon(long l, long l2, long l3, long l4, long l5) throws HDF5LibraryException {
        long l6 = H5._H5Dcreate_anon(l, l2, l3, l4, l5);
        if (l6 > 0L) {
            log.trace("OPEN_IDS: H5Dcreate_anon add {}", (Object)l6);
            OPEN_IDS.add(l6);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l6;
    }

    private static synchronized native long _H5Dcreate_anon(long var0, long var2, long var4, long var6, long var8) throws HDF5LibraryException;

    public static synchronized native void H5Dfill(byte[] var0, long var1, byte[] var3, long var4, long var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Dget_access_plist(long var0) throws HDF5LibraryException;

    public static long H5Dget_create_plist(long l) throws HDF5LibraryException {
        long l2 = H5._H5Dget_create_plist(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Dget_create_plist add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Dget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Dget_offset(long var0) throws HDF5LibraryException;

    public static long H5Dget_space(long l) throws HDF5LibraryException {
        long l2 = H5._H5Dget_space(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Dget_space add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Dget_space(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Dget_space_status(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Dget_storage_size(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static long H5Dget_type(long l) throws HDF5LibraryException {
        long l2 = H5._H5Dget_type(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Dget_type add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Dget_type(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Diterate(byte[] var0, long var1, long var3, H5D_iterate_cb var5, H5D_iterate_t var6) throws HDF5LibraryException, NullPointerException;

    public static long H5Dopen(long l, String string, long l2) throws HDF5LibraryException, NullPointerException {
        long l3 = H5._H5Dopen2(l, string, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Dopen add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Dopen2(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread(long var0, long var2, long var4, long var6, long var8, byte[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread(long l, long l2, long l3, long l4, long l5, byte[] byArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread(l, l2, l3, l4, l5, byArray, true);
    }

    public static synchronized int H5Dread(long l, long l2, long l3, long l4, long l5, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Dread(l, l2, l3, l4, l5, object, true);
    }

    public static synchronized int H5Dread(long l, long l2, long l3, long l4, long l5, Object object, boolean bl) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int n = -1;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDF5JavaException("H5Dread: data is not an array");
        }
        String string = clazz.getName();
        bl2 = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        log.trace("H5Dread: cname={} is1D={} dname={}", new Object[]{string, bl2, Character.valueOf(c)});
        if (bl2 && c == 'B') {
            log.trace("H5Dread_dname_B");
            n = H5.H5Dread(l, l2, l3, l4, l5, (byte[])object, bl);
        } else if (bl2 && c == 'S') {
            log.trace("H5Dread_dname_S");
            n = H5.H5Dread_short(l, l2, l3, l4, l5, (short[])object, bl);
        } else if (bl2 && c == 'I') {
            log.trace("H5Dread_dname_I");
            n = H5.H5Dread_int(l, l2, l3, l4, l5, (int[])object, bl);
        } else if (bl2 && c == 'J') {
            log.trace("H5Dread_dname_J");
            n = H5.H5Dread_long(l, l2, l3, l4, l5, (long[])object, bl);
        } else if (bl2 && c == 'F') {
            log.trace("H5Dread_dname_F");
            n = H5.H5Dread_float(l, l2, l3, l4, l5, (float[])object, bl);
        } else if (bl2 && c == 'D') {
            log.trace("H5Dread_dname_D");
            n = H5.H5Dread_double(l, l2, l3, l4, l5, (double[])object, bl);
        } else if (H5.H5Tdetect_class(l2, HDF5Constants.H5T_REFERENCE) && bl2 && clazz.getComponentType() == String.class || H5.H5Tequal(l2, HDF5Constants.H5T_STD_REF_DSETREG)) {
            log.trace("H5Dread_reg_ref");
            n = H5.H5Dread_reg_ref(l, l2, l3, l4, l5, (String[])object);
        } else if (bl2 && clazz.getComponentType() == String.class) {
            log.trace("H5Dread_string type");
            n = H5.H5Dread_string(l, l2, l3, l4, l5, (String[])object);
        } else if (H5.H5Tget_class(l2) == HDF5Constants.H5T_VLEN) {
            log.trace("H5DreadVL type");
            n = H5.H5DreadVL(l, l2, l3, l4, l5, (Object[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.emptyBytes();
            log.trace("H5Dread_else");
            n = H5.H5Dread(l, l2, l3, l4, l5, byArray, bl);
            if (n >= 0) {
                object = hDFArray.arrayify(byArray);
            }
            byArray = null;
            hDFArray = null;
        }
        return n;
    }

    public static synchronized native int H5Dread_double(long var0, long var2, long var4, long var6, long var8, double[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_double(long l, long l2, long l3, long l4, long l5, double[] dArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_double(l, l2, l3, l4, l5, dArray, true);
    }

    public static synchronized native int H5Dread_float(long var0, long var2, long var4, long var6, long var8, float[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_float(long l, long l2, long l3, long l4, long l5, float[] fArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_float(l, l2, l3, l4, l5, fArray, true);
    }

    public static synchronized native int H5Dread_int(long var0, long var2, long var4, long var6, long var8, int[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_int(long l, long l2, long l3, long l4, long l5, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_int(l, l2, l3, l4, l5, nArray, true);
    }

    public static synchronized native int H5Dread_long(long var0, long var2, long var4, long var6, long var8, long[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_long(long l, long l2, long l3, long l4, long l5, long[] lArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_long(l, l2, l3, l4, l5, lArray, true);
    }

    public static synchronized native int H5Dread_reg_ref(long var0, long var2, long var4, long var6, long var8, String[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_short(long var0, long var2, long var4, long var6, long var8, short[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_short(long l, long l2, long l3, long l4, long l5, short[] sArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_short(l, l2, l3, l4, l5, sArray, true);
    }

    public static synchronized native int H5DreadVL(long var0, long var2, long var4, long var6, long var8, Object[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_string(long var0, long var2, long var4, long var6, long var8, String[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_VLStrings(long var0, long var2, long var4, long var6, long var8, Object[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Dset_extent(long var0, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Dvlen_get_buf_size(long var0, long var2, long var4) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Dvlen_reclaim(long var0, long var2, long var4, byte[] var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite(long var0, long var2, long var4, long var6, long var8, byte[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite(long l, long l2, long l3, long l4, long l5, byte[] byArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite(l, l2, l3, l4, l5, byArray, true);
    }

    public static synchronized int H5Dwrite(long l, long l2, long l3, long l4, long l5, Object object) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite(l, l2, l3, l4, l5, object, true);
    }

    public static synchronized int H5Dwrite(long l, long l2, long l3, long l4, long l5, Object object, boolean bl) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int n = -1;
        boolean bl2 = false;
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new HDF5JavaException("H5Dwrite: data is not an array");
        }
        String string = clazz.getName();
        bl2 = string.lastIndexOf(91) == string.indexOf(91);
        char c = string.charAt(string.lastIndexOf("[") + 1);
        if (bl2 && c == 'B') {
            n = H5.H5Dwrite(l, l2, l3, l4, l5, (byte[])object, bl);
        } else if (bl2 && c == 'S') {
            n = H5.H5Dwrite_short(l, l2, l3, l4, l5, (short[])object, bl);
        } else if (bl2 && c == 'I') {
            n = H5.H5Dwrite_int(l, l2, l3, l4, l5, (int[])object, bl);
        } else if (bl2 && c == 'J') {
            n = H5.H5Dwrite_long(l, l2, l3, l4, l5, (long[])object, bl);
        } else if (bl2 && c == 'F') {
            n = H5.H5Dwrite_float(l, l2, l3, l4, l5, (float[])object, bl);
        } else if (bl2 && c == 'D') {
            n = H5.H5Dwrite_double(l, l2, l3, l4, l5, (double[])object, bl);
        } else if (bl2 && clazz.getComponentType() == String.class) {
            log.trace("H5Dwrite_string type");
            n = H5.H5Dwrite_string(l, l2, l3, l4, l5, (String[])object);
        } else if (H5.H5Tget_class(l2) == HDF5Constants.H5T_VLEN) {
            log.trace("H5DwriteVL type");
            n = H5.H5DwriteVL(l, l2, l3, l4, l5, (Object[])object);
        } else {
            HDFArray hDFArray = new HDFArray(object);
            byte[] byArray = hDFArray.byteify();
            n = H5.H5Dwrite(l, l2, l3, l4, l5, byArray, bl);
            byArray = null;
            hDFArray = null;
        }
        return n;
    }

    public static synchronized native int H5Dwrite_double(long var0, long var2, long var4, long var6, long var8, double[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_double(long l, long l2, long l3, long l4, long l5, double[] dArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_double(l, l2, l3, l4, l5, dArray, true);
    }

    public static synchronized native int H5Dwrite_float(long var0, long var2, long var4, long var6, long var8, float[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_float(long l, long l2, long l3, long l4, long l5, float[] fArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_float(l, l2, l3, l4, l5, fArray, true);
    }

    public static synchronized native int H5Dwrite_int(long var0, long var2, long var4, long var6, long var8, int[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_int(long l, long l2, long l3, long l4, long l5, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_int(l, l2, l3, l4, l5, nArray, true);
    }

    public static synchronized native int H5Dwrite_long(long var0, long var2, long var4, long var6, long var8, long[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_long(long l, long l2, long l3, long l4, long l5, long[] lArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_long(l, l2, l3, l4, l5, lArray, true);
    }

    public static synchronized native int H5Dwrite_short(long var0, long var2, long var4, long var6, long var8, short[] var10, boolean var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_short(long l, long l2, long l3, long l4, long l5, short[] sArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_short(l, l2, l3, l4, l5, sArray, true);
    }

    public static synchronized native int H5Dwrite_string(long var0, long var2, long var4, long var6, long var8, String[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5DwriteVL(long var0, long var2, long var4, long var6, long var8, Object[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite_VLStrings(long var0, long var2, long var4, long var6, long var8, Object[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Dflush(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Drefresh(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Eauto_is_v2(long var0) throws HDF5LibraryException;

    public static int H5Eclear() throws HDF5LibraryException {
        H5.H5Eclear2(HDF5Constants.H5E_DEFAULT);
        return 0;
    }

    public static void H5Eclear(long l) throws HDF5LibraryException {
        H5.H5Eclear2(l);
    }

    public static synchronized native void H5Eclear2(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Eclose_msg(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Eclose_stack(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Ecreate_msg(long var0, int var2, String var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Ecreate_stack() throws HDF5LibraryException;

    public static synchronized native String H5Eget_class_name(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Eget_current_stack() throws HDF5LibraryException;

    public static synchronized native void H5Eset_current_stack(long var0) throws HDF5LibraryException;

    public static synchronized native String H5Eget_msg(long var0, int[] var2) throws HDF5LibraryException;

    public static synchronized native long H5Eget_num(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Eprint2(long var0, Object var2) throws HDF5LibraryException;

    public static synchronized native void H5Epop(long var0, long var2) throws HDF5LibraryException;

    public static void H5Epush(long l, String string, String string2, int n, long l2, long l3, long l4, String string3) throws HDF5LibraryException, NullPointerException {
        H5.H5Epush2(l, string, string2, n, l2, l3, l4, string3);
    }

    public static synchronized native void H5Epush2(long var0, String var2, String var3, int var4, long var5, long var7, long var9, String var11) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Eregister_class(String var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Eunregister_class(long var0) throws HDF5LibraryException;

    public static void H5Ewalk(long l, long l2, H5E_walk_cb h5E_walk_cb, H5E_walk_t h5E_walk_t) throws HDF5LibraryException, NullPointerException {
        H5.H5Ewalk2(l, l2, h5E_walk_cb, h5E_walk_t);
    }

    public static synchronized native void H5Ewalk2(long var0, long var2, H5E_walk_cb var4, H5E_walk_t var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Fclose(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Fclose remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Fclose(l);
    }

    private static synchronized native int _H5Fclose(long var0) throws HDF5LibraryException;

    public static long H5Fopen(String string, int n, long l) throws HDF5LibraryException, NullPointerException {
        long l2 = H5._H5Fopen(string, n, l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Fopen add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Fopen(String var0, int var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static long H5Freopen(long l) throws HDF5LibraryException {
        long l2 = H5._H5Freopen(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Freopen add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Freopen(long var0) throws HDF5LibraryException;

    public static long H5Fcreate(String string, int n, long l, long l2) throws HDF5LibraryException, NullPointerException {
        long l3 = H5._H5Fcreate(string, n, l, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Fcreate add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Fcreate(String var0, int var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fflush(long var0, int var2) throws HDF5LibraryException;

    public static long H5Fget_access_plist(long l) throws HDF5LibraryException {
        long l2 = H5._H5Fget_access_plist(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Fget_access_plist add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Fget_access_plist(long var0) throws HDF5LibraryException;

    public static long H5Fget_create_plist(long l) throws HDF5LibraryException {
        long l2 = H5._H5Fget_create_plist(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Fget_create_plist add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Fget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_filesize(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_freespace(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_intent(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_fileno(long var0) throws HDF5LibraryException;

    public static synchronized native double H5Fget_mdc_hit_rate(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_mdc_size(long var0, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Fget_name(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_obj_count(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native long H5Fget_obj_ids(long var0, int var2, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native boolean H5Fis_hdf5(String var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Fis_accessible(String var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fmount(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Funmount(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Freset_mdc_hit_rate_stats(long var0) throws HDF5LibraryException;

    public static synchronized native H5F_info2_t H5Fget_info(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fclear_elink_file_cache(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fstart_swmr_write(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fstart_mdc_logging(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fstop_mdc_logging(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fget_mdc_logging_status(long var0, boolean[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Fget_dset_no_attrs_hint(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Fset_dset_no_attrs_hint(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native void H5Fset_libver_bounds(long var0, int var2, int var3) throws HDF5LibraryException;

    public static int H5Gclose(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Gclose remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Gclose(l);
    }

    private static synchronized native int _H5Gclose(long var0) throws HDF5LibraryException;

    public static long H5Gcreate(long l, String string, long l2, long l3, long l4) throws HDF5LibraryException, NullPointerException {
        long l5 = H5._H5Gcreate2(l, string, l2, l3, l4);
        if (l5 > 0L) {
            log.trace("OPEN_IDS: H5Gcreate add {}", (Object)l5);
            OPEN_IDS.add(l5);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l5;
    }

    private static synchronized native long _H5Gcreate2(long var0, String var2, long var3, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static long H5Gcreate_anon(long l, long l2, long l3) throws HDF5LibraryException {
        long l4 = H5._H5Gcreate_anon(l, l2, l3);
        if (l4 > 0L) {
            log.trace("OPEN_IDS: H5Gcreate_anon add {}", (Object)l4);
            OPEN_IDS.add(l4);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l4;
    }

    private static synchronized native long _H5Gcreate_anon(long var0, long var2, long var4) throws HDF5LibraryException;

    public static synchronized native long H5Gget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native H5G_info_t H5Gget_info(long var0) throws HDF5LibraryException;

    public static synchronized native H5G_info_t H5Gget_info_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5G_info_t H5Gget_info_by_name(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Gget_obj_info_all(long l, String string, String[] stringArray, int[] nArray, H5O_token_t[] h5O_token_tArray) throws HDF5LibraryException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): name array is null");
        }
        return H5.H5Gget_obj_info_all(l, string, stringArray, nArray, null, null, h5O_token_tArray, HDF5Constants.H5_INDEX_NAME);
    }

    public static synchronized int H5Gget_obj_info_all(long l, String string, String[] stringArray, int[] nArray, int[] nArray2, H5O_token_t[] h5O_token_tArray, int n) throws HDF5LibraryException, NullPointerException {
        return H5.H5Gget_obj_info_full(l, string, stringArray, nArray, nArray2, null, h5O_token_tArray, n, -1);
    }

    public static synchronized int H5Gget_obj_info_all(long l, String string, String[] stringArray, int[] nArray, int[] nArray2, long[] lArray, H5O_token_t[] h5O_token_tArray, int n) throws HDF5LibraryException, NullPointerException {
        return H5.H5Gget_obj_info_full(l, string, stringArray, nArray, nArray2, lArray, h5O_token_tArray, n, -1);
    }

    public static synchronized int H5Gget_obj_info_full(long l, String string, String[] stringArray, int[] nArray, int[] nArray2, long[] lArray, H5O_token_t[] h5O_token_tArray, int n, int n2) throws HDF5LibraryException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("H5Gget_obj_info_full(): name array is null");
        }
        if (nArray == null) {
            throw new NullPointerException("H5Gget_obj_info_full(): object type array is null");
        }
        if (stringArray.length == 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_full(): array size is zero");
        }
        if (stringArray.length != nArray.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_full(): name and type array sizes are different");
        }
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (lArray == null) {
            lArray = new long[h5O_token_tArray.length];
        }
        if (n < 0) {
            n = HDF5Constants.H5_INDEX_NAME;
        }
        if (n2 < 0) {
            n2 = HDF5Constants.H5_ITER_INC;
        }
        log.trace("H5Gget_obj_info_full: objNames_len={}", (Object)stringArray.length);
        int n3 = H5.H5Gget_obj_info_full(l, string, stringArray, nArray, nArray2, lArray, h5O_token_tArray, stringArray.length, n, n2);
        for (int i = 0; i < stringArray.length; ++i) {
            log.trace("H5Gget_obj_info_full: objNames={}", (Object)stringArray[i]);
        }
        return n3;
    }

    private static synchronized native int H5Gget_obj_info_full(long var0, String var2, String[] var3, int[] var4, int[] var5, long[] var6, H5O_token_t[] var7, int var8, int var9, int var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Gget_obj_info_idx(long l, String string, int n, String[] stringArray, int[] nArray) throws HDF5LibraryException, NullPointerException {
        String[] stringArray2 = new String[]{new String("")};
        stringArray[0] = H5.H5Lget_name_by_idx(l, string, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC, n, HDF5Constants.H5P_DEFAULT);
        H5L_info_t h5L_info_t = H5.H5Lget_info_by_idx(l, string, HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC, n, HDF5Constants.H5P_DEFAULT);
        nArray[0] = h5L_info_t.type;
        return 0;
    }

    public static synchronized int H5Gget_obj_info_max(long l, String[] stringArray, int[] nArray, int[] nArray2, H5O_token_t[] h5O_token_tArray, long l2) throws HDF5LibraryException, NullPointerException {
        if (stringArray == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): name array is null");
        }
        if (nArray == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): object type array is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): link type array is null");
        }
        if (stringArray.length <= 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): array size is zero");
        }
        if (l2 <= 0L) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): maximum array size is zero");
        }
        if (stringArray.length != nArray.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): name and type array sizes are different");
        }
        return H5.H5Gget_obj_info_max(l, stringArray, nArray, nArray2, h5O_token_tArray, l2, stringArray.length);
    }

    private static synchronized native int H5Gget_obj_info_max(long var0, String[] var2, int[] var3, int[] var4, H5O_token_t[] var5, long var6, int var8) throws HDF5LibraryException, NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long H5Gn_members(long l, String string) throws HDF5LibraryException, NullPointerException {
        long l2 = H5.H5Gopen(l, string, HDF5Constants.H5P_DEFAULT);
        long l3 = -1L;
        try {
            H5G_info_t h5G_info_t = H5.H5Gget_info(l2);
            l3 = h5G_info_t.nlinks;
        }
        finally {
            H5.H5Gclose(l2);
        }
        return l3;
    }

    public static long H5Gopen(long l, String string, long l2) throws HDF5LibraryException, NullPointerException {
        long l3 = H5._H5Gopen2(l, string, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Gopen add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Gopen2(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Gflush(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Grefresh(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Iget_file_id(long var0) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native long H5Iget_name_long(long var0, String[] var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Iget_name(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Iget_ref(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Idec_ref(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iinc_ref(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iget_type(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Iget_type_ref(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Idec_type_ref(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Iinc_type_ref(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Inmembers(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Iis_valid(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Itype_exists(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Iclear_type(int var0, boolean var1) throws HDF5LibraryException;

    public static synchronized native void H5Idestroy_type(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Lcopy(long var0, String var2, long var3, String var5, long var6, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_external(String var0, String var1, long var2, String var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_hard(long var0, String var2, long var3, String var5, long var6, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_soft(String var0, long var1, String var3, long var4, long var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ldelete(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ldelete_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Lexists(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5L_info_t H5Lget_info(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5L_info_t H5Lget_info_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Lget_name_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lget_value(long var0, String var2, String[] var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lget_value_by_idx(long var0, String var2, int var3, int var4, long var5, String[] var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Literate(long var0, int var2, int var3, long var4, H5L_iterate_t var6, H5L_iterate_opdata_t var7) throws HDF5LibraryException;

    public static synchronized native int H5Literate_by_name(long var0, String var2, int var3, int var4, long var5, H5L_iterate_t var7, H5L_iterate_opdata_t var8, long var9) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lmove(long var0, String var2, long var3, String var5, long var6, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lvisit(long var0, int var2, int var3, H5L_iterate_t var4, H5L_iterate_opdata_t var5) throws HDF5LibraryException;

    public static synchronized native int H5Lvisit_by_name(long var0, String var2, int var3, int var4, H5L_iterate_t var5, H5L_iterate_opdata_t var6, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lis_registered(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Lunregister(int var0) throws HDF5LibraryException;

    public static int H5Oclose(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Oclose remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Oclose(l);
    }

    private static synchronized native int _H5Oclose(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Ocopy(long var0, String var2, long var3, String var5, long var6, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Oget_comment(long var0) throws HDF5LibraryException, IllegalArgumentException;

    @Deprecated
    public static synchronized native void H5Oset_comment(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native String H5Oget_comment_by_name(long var0, String var2, long var3) throws HDF5LibraryException, IllegalArgumentException, NullPointerException;

    @Deprecated
    public static synchronized native void H5Oset_comment_by_name(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static H5O_info_t H5Oget_info(long l) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_info(l, HDF5Constants.H5O_INFO_ALL);
    }

    public static synchronized native H5O_info_t H5Oget_info(long var0, int var2) throws HDF5LibraryException, NullPointerException;

    public static H5O_info_t H5Oget_info_by_idx(long l, String string, int n, int n2, long l2, long l3) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_info_by_idx(l, string, n, n2, l2, HDF5Constants.H5O_INFO_ALL, l3);
    }

    public static synchronized native H5O_info_t H5Oget_info_by_idx(long var0, String var2, int var3, int var4, long var5, int var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static H5O_info_t H5Oget_info_by_name(long l, String string, long l2) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_info_by_name(l, string, HDF5Constants.H5O_INFO_ALL, l2);
    }

    public static synchronized native H5O_info_t H5Oget_info_by_name(long var0, String var2, int var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Olink(long var0, long var2, String var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static long H5Oopen(long l, String string, long l2) throws HDF5LibraryException, NullPointerException {
        long l3 = H5._H5Oopen(l, string, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Oopen add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Oopen(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Ovisit(long l, int n, int n2, H5O_iterate_t h5O_iterate_t, H5O_iterate_opdata_t h5O_iterate_opdata_t) throws HDF5LibraryException, NullPointerException {
        return H5.H5Ovisit(l, n, n2, h5O_iterate_t, h5O_iterate_opdata_t, HDF5Constants.H5O_INFO_ALL);
    }

    public static synchronized native int H5Ovisit(long var0, int var2, int var3, H5O_iterate_t var4, H5O_iterate_opdata_t var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static int H5Ovisit_by_name(long l, String string, int n, int n2, H5O_iterate_t h5O_iterate_t, H5O_iterate_opdata_t h5O_iterate_opdata_t, long l2) throws HDF5LibraryException, NullPointerException {
        return H5.H5Ovisit_by_name(l, string, n, n2, h5O_iterate_t, h5O_iterate_opdata_t, HDF5Constants.H5O_INFO_ALL, l2);
    }

    public static synchronized native int H5Ovisit_by_name(long var0, String var2, int var3, int var4, H5O_iterate_t var5, H5O_iterate_opdata_t var6, int var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Oexists_by_name(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Odecr_refcount(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Oincr_refcount(long var0) throws HDF5LibraryException;

    public static long H5Oopen_by_token(long l, H5O_token_t h5O_token_t) throws HDF5LibraryException {
        long l2 = H5._H5Oopen_by_token(l, h5O_token_t);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Oopen_by_token add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Oopen_by_token(long var0, H5O_token_t var2) throws HDF5LibraryException, NullPointerException;

    public static long H5Oopen_by_idx(long l, String string, int n, int n2, long l2, long l3) throws HDF5LibraryException, NullPointerException {
        long l4 = H5._H5Oopen_by_idx(l, string, n, n2, l2, l3);
        if (l4 > 0L) {
            log.trace("OPEN_IDS: H5Oopen_by_idx add {}", (Object)l4);
            OPEN_IDS.add(l4);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l4;
    }

    private static synchronized native long _H5Oopen_by_idx(long var0, String var2, int var3, int var4, long var5, long var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Oflush(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Orefresh(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Odisable_mdc_flushes(long var0);

    public static synchronized native void H5Oenable_mdc_flushes(long var0);

    public static synchronized native boolean H5Oare_mdc_flushes_disabled(long var0);

    public static H5O_native_info_t H5Oget_native_info(long l) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_native_info(l, HDF5Constants.H5O_NATIVE_INFO_ALL);
    }

    public static synchronized native H5O_native_info_t H5Oget_native_info(long var0, int var2) throws HDF5LibraryException, NullPointerException;

    public static H5O_native_info_t H5Oget_native_info_by_idx(long l, String string, int n, int n2, long l2, long l3) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_native_info_by_idx(l, string, n, n2, l2, HDF5Constants.H5O_NATIVE_INFO_ALL, l3);
    }

    public static synchronized native H5O_native_info_t H5Oget_native_info_by_idx(long var0, String var2, int var3, int var4, long var5, int var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static H5O_native_info_t H5Oget_native_info_by_name(long l, String string, long l2) throws HDF5LibraryException, NullPointerException {
        return H5.H5Oget_native_info_by_name(l, string, HDF5Constants.H5O_NATIVE_INFO_ALL, l2);
    }

    public static synchronized native H5O_native_info_t H5Oget_native_info_by_name(long var0, String var2, int var3, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Pget_class_name(long var0) throws HDF5LibraryException;

    public static long H5Pcreate(long l) throws HDF5LibraryException {
        long l2 = H5._H5Pcreate(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Pcreate add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Pcreate(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset(long var0, String var2, int var3) throws HDF5LibraryException;

    public static synchronized native boolean H5Pexist(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_size(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_nprops(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Pget_class(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Pget_class_parent(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pequal(long var0, long var2) throws HDF5LibraryException;

    public static boolean H5P_equal(long l, long l2) throws HDF5LibraryException {
        return H5.H5Pequal(l, l2) == 1;
    }

    public static synchronized native int H5Pisa_class(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pcopy_prop(long var0, long var2, String var4) throws HDF5LibraryException;

    public static synchronized native int H5Premove(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native int H5Punregister(long var0, String var2) throws HDF5LibraryException;

    public static int H5Pclose_class(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Pclose_class remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Pclose_class(l);
    }

    private static synchronized native int _H5Pclose_class(long var0) throws HDF5LibraryException;

    public static int H5Pclose(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Pclose remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Pclose(l);
    }

    private static synchronized native int _H5Pclose(long var0) throws HDF5LibraryException;

    public static long H5Pcopy(long l) throws HDF5LibraryException {
        long l2 = H5._H5Pcopy(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Pcopy add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Pcopy(long var0) throws HDF5LibraryException;

    public static long H5Pcreate_class_nocb(long l, String string) throws HDF5LibraryException {
        long l2 = H5._H5Pcreate_class_nocb(l, string);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Pcreate_class_nocb add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Pcreate_class_nocb(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native void H5Pregister2_nocb(long var0, String var2, long var3, byte[] var5) throws HDF5LibraryException;

    public static synchronized native void H5Pinsert2_nocb(long var0, String var2, long var3, byte[] var5) throws HDF5LibraryException;

    public static synchronized native int H5Piterate(long var0, int[] var2, H5P_iterate_cb var3, H5P_iterate_t var4) throws HDF5LibraryException;

    public static synchronized native int H5Pget_attr_phase_change(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_attr_phase_change(long var0, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_attr_creation_order(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_attr_creation_order(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_obj_track_times(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_obj_track_times(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native int H5Pmodify_filter(long var0, long var2, int var4, long var5, int[] var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_filter(long var0, int var2, int var3, long var4, int[] var6) throws HDF5LibraryException;

    public static synchronized native int H5Pget_nfilters(long var0) throws HDF5LibraryException;

    public static int H5Pget_filter(long l, int n, int[] nArray, long[] lArray, int[] nArray2, long l2, String[] stringArray, int[] nArray3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException {
        return H5.H5Pget_filter2(l, n, nArray, lArray, nArray2, l2, stringArray, nArray3);
    }

    private static synchronized native int H5Pget_filter2(long var0, int var2, int[] var3, long[] var4, int[] var5, long var6, String[] var8, int[] var9) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static int H5Pget_filter_by_id(long l, long l2, int[] nArray, long[] lArray, int[] nArray2, long l3, String[] stringArray, int[] nArray3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException {
        return H5.H5Pget_filter_by_id2(l, l2, nArray, lArray, nArray2, l3, stringArray, nArray3);
    }

    public static synchronized native int H5Pget_filter_by_id2(long var0, long var2, int[] var4, long[] var5, int[] var6, long var7, String[] var9, int[] var10) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pall_filters_avail(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Premove_filter(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset_deflate(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset_fletcher32(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_userblock(long var0, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_userblock(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sizes(long var0, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_sizes(long var0, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sym_k(long var0, int[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_sym_k(long var0, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_istore_k(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_istore_k(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_shared_mesg_nindexes(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_shared_mesg_nindexes(long var0, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_shared_mesg_index(long var0, int var2, int[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_shared_mesg_index(long var0, int var2, int var3, int var4) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_shared_mesg_phase_change(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_shared_mesg_phase_change(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native void H5Pset_file_space_strategy(long var0, int var2, boolean var3, long var4) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_file_space_strategy(long var0, boolean[] var2, long[] var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native boolean H5Pget_file_space_strategy_persist(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_file_space_strategy_threshold(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native void H5Pset_file_space_page_size(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_file_space_page_size(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_alignment(long var0, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_alignment(long var0, long var2, long var4) throws HDF5LibraryException;

    public static synchronized native long H5Pget_driver(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Pget_family_offset(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_family_offset(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_cache(long var0, int[] var2, long[] var3, long[] var4, double[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_cache(long var0, int var2, long var3, long var5, double var7) throws HDF5LibraryException;

    public static synchronized native H5AC_cache_config_t H5Pget_mdc_config(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_mdc_config(long var0, H5AC_cache_config_t var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_gc_references(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_gc_references(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_fclose_degree(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fclose_degree(long var0, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_meta_block_size(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_meta_block_size(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_sieve_buf_size(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_sieve_buf_size(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_small_data_block_size(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_small_data_block_size(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_libver_bounds(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_libver_bounds(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_elink_file_cache_size(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_elink_file_cache_size(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Pset_mdc_log_options(long var0, boolean var2, String var3, boolean var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Pget_mdc_log_options(long var0, boolean[] var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_metadata_read_attempts(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_metadata_read_attempts(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_evict_on_close(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_evict_on_close(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_use_file_locking(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_ignore_disabled_file_locking(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_file_locking(long var0, boolean var2, boolean var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_layout(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_layout(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_chunk(long var0, int var2, long[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_chunk(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized int H5Pset_chunk(long l, int n, long[] lArray) throws HDF5Exception, NullPointerException, IllegalArgumentException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n2 = H5.H5Pset_chunk(l, n, byArray);
        byArray = null;
        hDFArray = null;
        return n2;
    }

    public static synchronized native void H5Pset_virtual(long var0, long var2, String var4, String var5, long var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Pget_virtual_count(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_virtual_vspace(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_virtual_srcspace(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native String H5Pget_virtual_filename(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native String H5Pget_virtual_dsetname(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_external(long var0, int var2, long var3, String[] var5, long[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_external(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_external_count(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_szip(long var0, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_shuffle(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_nbit(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_scaleoffset(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_fill_value(long var0, long var2, byte[] var4) throws HDF5Exception;

    public static synchronized int H5Pget_fill_value(long l, long l2, Object object) throws HDF5Exception {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.emptyBytes();
        int n = H5.H5Pget_fill_value(l, l2, byArray);
        if (n >= 0) {
            object = hDFArray.arrayify(byArray);
        }
        return n;
    }

    public static synchronized native int H5Pset_fill_value(long var0, long var2, byte[] var4) throws HDF5Exception;

    public static synchronized int H5Pset_fill_value(long l, long l2, Object object) throws HDF5Exception {
        HDFArray hDFArray = new HDFArray(object);
        byte[] byArray = hDFArray.byteify();
        int n = H5.H5Pset_fill_value(l, l2, byArray);
        byArray = null;
        hDFArray = null;
        return n;
    }

    public static synchronized native int H5Pfill_value_defined(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_alloc_time(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_alloc_time(long var0, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fill_time(long var0, int[] var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset_fill_time(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Pset_chunk_opts(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_chunk_opts(long var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_dset_no_attrs_hint(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_dset_no_attrs_hint(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native void H5Pget_chunk_cache(long var0, long[] var2, long[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_chunk_cache(long var0, long var2, long var4, double var6) throws HDF5LibraryException;

    public static synchronized native void H5Pset_virtual_view(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_virtual_view(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_virtual_printf_gap(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_virtual_printf_gap(long var0) throws HDF5LibraryException;

    public static synchronized native String H5Pget_virtual_prefix(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_virtual_prefix(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Pget_efile_prefix(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_efile_prefix(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_data_transform(long var0, String[] var2, long var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_data_transform(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_buffer(long var0, byte[] var2, byte[] var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_buffer_size(long var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native void H5Pset_buffer_size(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_edc_check(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_edc_check(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_btree_ratios(long var0, double[] var2, double[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_btree_ratios(long var0, double var2, double var4, double var6) throws HDF5LibraryException;

    public static synchronized native int H5Pget_hyper_vector_size(long var0, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_hyper_vector_size(long var0, long var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pget_create_intermediate_group(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_create_intermediate_group(long var0, boolean var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_local_heap_size_hint(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_local_heap_size_hint(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_link_phase_change(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_link_phase_change(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_est_link_info(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_est_link_info(long var0, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_link_creation_order(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_link_creation_order(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_char_encoding(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_char_encoding(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native long H5Pget_nlinks(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_nlinks(long var0, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_elink_prefix(long var0, String[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_elink_prefix(long var0, String var2) throws HDF5LibraryException, NullPointerException;

    public static long H5Pget_elink_fapl(long l) throws HDF5LibraryException {
        long l2 = H5._H5Pget_elink_fapl(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Pget_elink_fapl add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Pget_elink_fapl(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_elink_fapl(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_elink_acc_flags(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_elink_acc_flags(long var0, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_copy_object(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_copy_object(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Pget_fapl_core(long var0, long[] var2, boolean[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_core(long var0, long var2, boolean var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fapl_direct(long var0, long[] var2) throws HDF5LibraryException;

    public static synchronized native int H5Pset_fapl_direct(long var0, long var2, long var4, long var6) throws HDF5LibraryException;

    public static synchronized native int H5Pget_fapl_family(long var0, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_family(long var0, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_hdfs(long var0, H5FD_hdfs_fapl_t var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5FD_hdfs_fapl_t H5Pget_fapl_hdfs(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pget_fapl_multi(long var0, int[] var2, long[] var3, String[] var4, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_fapl_multi(long var0, int[] var2, long[] var3, String[] var4, long[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_fapl_log(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_sec2(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_fapl_split(long var0, String var2, long var3, String var5, long var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_stdio(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_windows(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_ros3(long var0, H5FD_ros3_fapl_t var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5FD_ros3_fapl_t H5Pget_fapl_ros3(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5PLset_loading_state(int var0) throws HDF5LibraryException;

    public static synchronized native int H5PLget_loading_state() throws HDF5LibraryException;

    public static synchronized native void H5PLappend(String var0) throws HDF5LibraryException;

    public static synchronized native void H5PLprepend(String var0) throws HDF5LibraryException;

    public static synchronized native void H5PLreplace(String var0, int var1) throws HDF5LibraryException;

    public static synchronized native void H5PLinsert(String var0, int var1) throws HDF5LibraryException;

    public static synchronized native void H5PLremove(int var0) throws HDF5LibraryException;

    public static synchronized native String H5PLget(int var0) throws HDF5LibraryException;

    public static synchronized native int H5PLsize() throws HDF5LibraryException;

    private static synchronized native int H5Rcreate(byte[] var0, long var1, String var3, int var4, long var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized byte[] H5Rcreate(long l, String string, int n, long l2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int n2 = 8;
        if (n == HDF5Constants.H5R_DATASET_REGION) {
            n2 = 12;
        }
        byte[] byArray = new byte[n2];
        H5.H5Rcreate(byArray, l, string, n, l2);
        return byArray;
    }

    public static long H5Rdereference(long l, long l2, int n, byte[] byArray) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long l3 = H5._H5Rdereference(l, l2, n, byArray);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Rdereference add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Rdereference(long var0, long var2, int var4, byte[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Rget_name(long var0, int var2, byte[] var3, String[] var4, long var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Rget_name_string(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Rget_obj_type(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    private static synchronized native int H5Rget_obj_type2(long var0, int var2, byte[] var3, int[] var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Rget_region(long l, int n, byte[] byArray) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long l2 = H5._H5Rget_region(l, n, byArray);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Rget_region add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Rget_region(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native byte[] H5Rcreate_object(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native byte[] H5Rcreate_region(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native byte[] H5Rcreate_attr(long var0, String var2, String var3, long var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native void H5Rdestroy(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Rget_type(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native boolean H5Requal(byte[] var0, byte[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native byte[] H5Rcopy(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Ropen_object(byte[] byArray, long l, long l2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long l3 = H5._H5Ropen_object(byArray, l, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Ropen_object add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Ropen_object(byte[] var0, long var1, long var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Ropen_region(byte[] byArray, long l, long l2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long l3 = H5._H5Ropen_region(byArray, l, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Ropen_region add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Ropen_region(byte[] var0, long var1, long var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Ropen_attr(byte[] byArray, long l, long l2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long l3 = H5._H5Ropen_attr(byArray, l, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Ropen_attr add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Ropen_attr(byte[] var0, long var1, long var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Rget_obj_type3(byte[] var0, long var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Rget_file_name(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Rget_obj_name(byte[] var0, long var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Rget_attr_name(byte[] var0) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Screate(int n) throws HDF5LibraryException {
        long l = H5._H5Screate(n);
        if (l > 0L) {
            log.trace("OPEN_IDS: H5Screate add {}", (Object)l);
            OPEN_IDS.add(l);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l;
    }

    private static synchronized native long _H5Screate(int var0) throws HDF5LibraryException;

    public static long H5Screate_simple(int n, long[] lArray, long[] lArray2) throws HDF5Exception, NullPointerException {
        long l = H5._H5Screate_simple(n, lArray, lArray2);
        if (l > 0L) {
            log.trace("OPEN_IDS: H5Screate_simple add {}", (Object)l);
            OPEN_IDS.add(l);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l;
    }

    private static synchronized native long _H5Screate_simple(int var0, long[] var1, long[] var2) throws HDF5Exception, NullPointerException;

    public static synchronized native long H5Sset_extent_simple(long var0, int var2, long[] var3, long[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized long H5Sset_extent_simple(long l, int n, byte[] byArray, byte[] byArray2) throws HDF5LibraryException, NullPointerException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        long[] lArray = byteBuffer.asLongBuffer().array();
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        long[] lArray2 = byteBuffer2.asLongBuffer().array();
        return H5.H5Sset_extent_simple(l, n, lArray, lArray2);
    }

    public static long H5Scopy(long l) throws HDF5LibraryException {
        long l2 = H5._H5Scopy(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Scopy add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Scopy(long var0) throws HDF5LibraryException;

    public static int H5Sclose(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Sclose remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Sclose(l);
    }

    private static synchronized native int _H5Sclose(long var0) throws HDF5LibraryException;

    public static synchronized native byte[] H5Sencode(long var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Sdecode(byte[] var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Sget_simple_extent_npoints(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_ndims(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_dims(long var0, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Sis_simple(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_type(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sset_extent_none(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sextent_copy(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Sextent_equal(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_type(long var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_npoints(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Sselect_copy(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Sselect_valid(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Sselect_adjust(long var0, long[][] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_select_bounds(long var0, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Sselect_shape_same(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native boolean H5Sselect_intersect_block(long var0, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Soffset_simple(long var0, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Soffset_simple(long l, long[] lArray) throws HDF5Exception, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n = H5.H5Soffset_simple(l, byArray);
        byArray = null;
        hDFArray = null;
        return n;
    }

    public static synchronized native int H5Sselect_all(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sselect_none(long var0) throws HDF5LibraryException;

    private static synchronized native int H5Sselect_elements(long var0, int var2, int var3, byte[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sselect_elements(long l, int n, int n2, long[][] lArray) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        if (lArray == null) {
            return -1;
        }
        HDFArray hDFArray = new HDFArray(lArray);
        byte[] byArray = hDFArray.byteify();
        int n3 = H5.H5Sselect_elements(l, n, n2, byArray);
        byArray = null;
        hDFArray = null;
        return n3;
    }

    public static synchronized native long H5Sget_select_elem_npoints(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_elem_pointlist(long var0, long var2, long var4, long[] var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sselect_hyperslab(long l, int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        long[] lArray = byteBuffer.asLongBuffer().array();
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        long[] lArray2 = byteBuffer2.asLongBuffer().array();
        ByteBuffer byteBuffer3 = ByteBuffer.wrap(byArray3);
        long[] lArray3 = byteBuffer3.asLongBuffer().array();
        ByteBuffer byteBuffer4 = ByteBuffer.wrap(byArray4);
        long[] lArray4 = byteBuffer4.asLongBuffer().array();
        return H5.H5Sselect_hyperslab(l, n, lArray, lArray2, lArray3, lArray4);
    }

    public static synchronized native int H5Sselect_hyperslab(long var0, int var2, long[] var3, long[] var4, long[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Scombine_hyperslab(long var0, int var2, long[] var3, long[] var4, long[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native void H5Smodify_select(long var0, int var2, long var3) throws HDF5LibraryException;

    public static synchronized native long H5Scombine_select(long var0, int var2, long var3) throws HDF5LibraryException;

    public static synchronized native boolean H5Sis_regular_hyperslab(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Sget_regular_hyperslab(long var0, long[] var2, long[] var3, long[] var4, long[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Sget_select_hyper_nblocks(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_hyper_blocklist(long var0, long var2, long var4, long[] var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Sselect_project_intersection(long var0, long var2, long var4) throws HDF5LibraryException;

    public static long H5Tarray_create(long l, int n, long[] lArray) throws HDF5LibraryException, NullPointerException {
        long l2 = H5._H5Tarray_create2(l, n, lArray);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Tarray_create add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tarray_create2(long var0, int var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tclose(long l) throws HDF5LibraryException {
        if (l < 0L) {
            return 0;
        }
        log.trace("OPEN_IDS: H5Tclose remove {}", (Object)l);
        OPEN_IDS.remove(l);
        log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        return H5._H5Tclose(l);
    }

    private static synchronized native int _H5Tclose(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tcommit(long var0, String var2, long var3, long var5, long var7, long var9) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tcommit_anon(long var0, long var2, long var4, long var6) throws HDF5LibraryException;

    public static synchronized native boolean H5Tcommitted(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tcompiler_conv(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native void H5Tconvert(long var0, long var2, long var4, byte[] var6, byte[] var7, long var8) throws HDF5LibraryException, NullPointerException;

    public static long H5Tcopy(long l) throws HDF5LibraryException {
        long l2 = H5._H5Tcopy(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Tcopy add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tcopy(long var0) throws HDF5LibraryException;

    public static long H5Tcreate(int n, long l) throws HDF5LibraryException {
        long l2 = H5._H5Tcreate(n, l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Tcreate add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tcreate(int var0, long var1) throws HDF5LibraryException;

    public static long H5Tdecode(byte[] byArray) throws HDF5LibraryException, NullPointerException {
        long l = H5._H5Tdecode(byArray);
        if (l > 0L) {
            log.trace("OPEN_IDS: H5Tdecode add {}", (Object)l);
            OPEN_IDS.add(l);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l;
    }

    private static synchronized native long _H5Tdecode(byte[] var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tdetect_class(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tencode(long var0, byte[] var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static long H5Tenum_create(long l) throws HDF5LibraryException {
        long l2 = H5._H5Tenum_create(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Tenum_create add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tenum_create(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tenum_insert(long var0, String var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_insert(long l, String string, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_insert_int(l, string, nArray);
    }

    public static int H5Tenum_insert(long l, String string, int n) throws HDF5LibraryException, NullPointerException {
        int[] nArray = new int[]{n};
        return H5.H5Tenum_insert_int(l, string, nArray);
    }

    private static synchronized native int H5Tenum_insert_int(long var0, String var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Tenum_nameof(long var0, byte[] var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_nameof(long l, int[] nArray, String[] stringArray, int n) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_nameof_int(l, nArray, stringArray, n);
    }

    private static synchronized native int H5Tenum_nameof_int(long var0, int[] var2, String[] var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tenum_valueof(long var0, String var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_valueof(long l, String string, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_valueof_int(l, string, nArray);
    }

    private static synchronized native int H5Tenum_valueof_int(long var0, String var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tequal(long var0, long var2) throws HDF5LibraryException;

    public static int H5Tget_array_dims(long l, long[] lArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_array_dims2(l, lArray);
    }

    public static synchronized native int H5Tget_array_dims2(long var0, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tget_array_ndims(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_class(long var0) throws HDF5LibraryException;

    public static String H5Tget_class_name(long l) {
        String string = null;
        string = (long)HDF5Constants.H5T_INTEGER == l ? "H5T_INTEGER" : ((long)HDF5Constants.H5T_FLOAT == l ? "H5T_FLOAT" : ((long)HDF5Constants.H5T_TIME == l ? "H5T_TIME" : ((long)HDF5Constants.H5T_STRING == l ? "H5T_STRING" : ((long)HDF5Constants.H5T_BITFIELD == l ? "H5T_BITFIELD" : ((long)HDF5Constants.H5T_OPAQUE == l ? "H5T_OPAQUE" : ((long)HDF5Constants.H5T_COMPOUND == l ? "H5T_COMPOUND" : ((long)HDF5Constants.H5T_REFERENCE == l ? "H5T_REFERENCE" : ((long)HDF5Constants.H5T_ENUM == l ? "H5T_ENUM" : ((long)HDF5Constants.H5T_VLEN == l ? "H5T_VLEN" : ((long)HDF5Constants.H5T_ARRAY == l ? "H5T_ARRAY" : "H5T_NO_CLASS"))))))))));
        return string;
    }

    public static long H5Tget_create_plist(long l) throws HDF5LibraryException {
        long l2 = H5._H5Tget_create_plist(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: _H5Tget_create_plist add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tget_create_plist(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_cset(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_cset(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_ebias(long var0) throws HDF5LibraryException;

    public static int H5Tset_ebias(long l, int n) throws HDF5LibraryException {
        H5.H5Tset_ebias(l, (long)n);
        return 0;
    }

    public static synchronized native long H5Tget_ebias_long(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tset_ebias(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native void H5Tget_fields(long var0, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Tget_fields(long l, int[] nArray) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        return H5.H5Tget_fields_int(l, nArray);
    }

    private static synchronized native int H5Tget_fields_int(long var0, int[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native void H5Tset_fields(long var0, long var2, long var4, long var6, long var8, long var10) throws HDF5LibraryException;

    public static int H5Tset_fields(long l, int n, int n2, int n3, int n4, int n5) throws HDF5LibraryException {
        H5.H5Tset_fields(l, (long)n, (long)n2, (long)n3, (long)n4, (long)n5);
        return 0;
    }

    public static synchronized native int H5Tget_inpad(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_inpad(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_member_class(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_member_index(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native String H5Tget_member_name(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native long H5Tget_member_offset(long var0, int var2);

    public static long H5Tget_member_type(long l, int n) throws HDF5LibraryException {
        long l2 = H5._H5Tget_member_type(l, n);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Tget_member_type add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tget_member_type(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native void H5Tget_member_value(long var0, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tget_member_value(long l, int n, int[] nArray) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_member_value_int(l, n, nArray);
    }

    private static synchronized native int H5Tget_member_value_int(long var0, int var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized long H5Tget_native_type(long l) throws HDF5LibraryException {
        return H5.H5Tget_native_type(l, HDF5Constants.H5T_DIR_ASCEND);
    }

    public static long H5Tget_native_type(long l, int n) throws HDF5LibraryException {
        long l2 = H5._H5Tget_native_type(l, n);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Tget_native_type add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tget_native_type(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_nmembers(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_norm(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_norm(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_offset(long var0) throws HDF5LibraryException;

    public static int H5Tset_offset(long l, int n) throws HDF5LibraryException {
        H5.H5Tset_offset(l, (long)n);
        return 0;
    }

    public static synchronized native void H5Tset_offset(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_order(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_order(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_pad(long var0, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tset_pad(long var0, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native int H5Tget_precision(long var0) throws HDF5LibraryException;

    public static int H5Tset_precision(long l, int n) throws HDF5LibraryException {
        H5.H5Tset_precision(l, (long)n);
        return 0;
    }

    public static synchronized native long H5Tget_precision_long(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tset_precision(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_sign(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_sign(long var0, int var2) throws HDF5LibraryException;

    public static synchronized native long H5Tget_size(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_size(long var0, long var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_strpad(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_strpad(long var0, int var2) throws HDF5LibraryException;

    public static long H5Tget_super(long l) throws HDF5LibraryException {
        long l2 = H5._H5Tget_super(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Tget_super add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tget_super(long var0) throws HDF5LibraryException;

    public static synchronized native String H5Tget_tag(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_tag(long var0, String var2) throws HDF5LibraryException;

    public static synchronized native int H5Tinsert(long var0, String var2, long var3, long var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tis_variable_str(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Tlock(long var0) throws HDF5LibraryException;

    public static long H5Topen(long l, String string, long l2) throws HDF5LibraryException, NullPointerException {
        long l3 = H5._H5Topen2(l, string, l2);
        if (l3 > 0L) {
            log.trace("OPEN_IDS: H5Topen add {}", (Object)l3);
            OPEN_IDS.add(l3);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l3;
    }

    private static synchronized native long _H5Topen2(long var0, String var2, long var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tpack(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Treclaim(long var0, long var2, long var4, byte[] var6) throws HDF5LibraryException, NullPointerException;

    public static long H5Tvlen_create(long l) throws HDF5LibraryException {
        long l2 = H5._H5Tvlen_create(l);
        if (l2 > 0L) {
            log.trace("OPEN_IDS: H5Tvlen_create add {}", (Object)l2);
            OPEN_IDS.add(l2);
            log.trace("OPEN_IDS: {}", (Object)OPEN_IDS.size());
        }
        return l2;
    }

    private static synchronized native long _H5Tvlen_create(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Tflush(long var0) throws HDF5LibraryException;

    public static synchronized native void H5Trefresh(long var0) throws HDF5LibraryException;

    public static synchronized native long H5VLregister_connector_by_name(String var0, long var1) throws HDF5LibraryException;

    public static synchronized native long H5VLregister_connector_by_value(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native boolean H5VLis_connector_registered_by_name(String var0) throws HDF5LibraryException;

    public static synchronized native boolean H5VLis_connector_registered_by_value(int var0) throws HDF5LibraryException;

    public static synchronized native long H5VLget_connector_id(long var0) throws HDF5LibraryException;

    public static synchronized native long H5VLget_connector_id_by_name(String var0) throws HDF5LibraryException;

    public static synchronized native long H5VLget_connector_id_by_value(int var0) throws HDF5LibraryException;

    public static synchronized native String H5VLget_connector_name(long var0) throws HDF5LibraryException;

    public static synchronized native void H5VLclose(long var0) throws HDF5LibraryException;

    public static synchronized native void H5VLunregister_connector(long var0) throws HDF5LibraryException;

    public static synchronized native int H5Zfilter_avail(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Zget_filter_info(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Zunregister(int var0) throws HDF5LibraryException;

    static {
        isLibraryLoaded = false;
        OPEN_IDS = new LinkedHashSet();
        H5.loadH5Lib();
    }
}

