/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation, based on code taken and modified
 *     					   from org.eclipse.cdt.dsf.gdb.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui;

import java.util.HashSet;

import org.eclipse.cdt.dsf.iss.IssGdbPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class IssGdbUIPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.cdt.dsf.iss.ui"; //$NON-NLS-1$

	// The shared instance
	private static IssGdbUIPlugin plugin;
	private static BundleContext fgBundleContext;
	private static IPreferenceStore fCorePreferenceStore;

	/**
	 * The constructor
	 */
	public IssGdbUIPlugin() {
		super();
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		fgBundleContext = context;
		super.start(context);

		setDefaultLaunchDelegates();
		registerAdapters();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
		fgBundleContext = null;
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static IssGdbUIPlugin getDefault() {
		return plugin;
	}

	public static BundleContext getBundleContext() {
		return fgBundleContext;
	}

	private void setDefaultLaunchDelegates() {
		// Set the default launch delegates as early as possible, and do it only once
		// (Bug 312997)
		ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();

		HashSet<String> debugSet = new HashSet<String>();
		debugSet.add(ILaunchManager.DEBUG_MODE);

		ILaunchConfigurationType localCfg = launchMgr
				.getLaunchConfigurationType("org.eclipse.cdt.dsf.iss.IssGdbLocalCLaunchType");
		try {
			if (localCfg.getPreferredDelegate(debugSet) == null) {
				ILaunchDelegate[] delegates = localCfg.getDelegates(debugSet);
				for (ILaunchDelegate delegate : delegates) {
					if ("org.eclipse.cdt.debug.btrace.IssBTGdbLocalCLaunchDelegate".equals(delegate.getId())) {
						localCfg.setPreferredDelegate(debugSet, delegate);
						break;
					}
				}
			}
		} catch (CoreException e) {
		}

		ILaunchConfigurationType remoteCfg = launchMgr
				.getLaunchConfigurationType("org.eclipse.cdt.dsf.iss.IssGdbRemoteCLaunchType");
		try {
			if (remoteCfg.getPreferredDelegate(debugSet) == null) {
				ILaunchDelegate[] delegates = remoteCfg.getDelegates(debugSet);
				for (ILaunchDelegate delegate : delegates) {
					if ("org.eclipse.cdt.debug.btrace.IssBTGdbRemoteCLaunchDelegate".equals(delegate.getId())) {
						remoteCfg.setPreferredDelegate(debugSet, delegate);
						break;
					} else if ("org.eclipse.cdt.dsf.iss.IssGdbRemoteCLaunchDelegate".equals(delegate.getId())) {
						remoteCfg.setPreferredDelegate(debugSet, delegate);
						break;
					}
				}
			}
		} catch (CoreException e) {
		}

		ILaunchConfigurationType attachCfg = launchMgr
				.getLaunchConfigurationType("org.eclipse.cdt.dsf.iss.IssGdbAttachCLaunchType");
		try {
			if (attachCfg.getPreferredDelegate(debugSet) == null) {
				ILaunchDelegate[] delegates = attachCfg.getDelegates(debugSet);
				for (ILaunchDelegate delegate : delegates) {
					if ("org.eclipse.cdt.debug.btrace.IssBTGdbAttachCLaunchDelegate".equals(delegate.getId())) {
						attachCfg.setPreferredDelegate(debugSet, delegate);
						break;
					}
				}
			}
		} catch (CoreException e) {
		}
	}

	private void registerAdapters() {

	}

	/**
	 * Convenience method which returns the unique identifier of this plugin.
	 */
	public static String getUniqueIdentifier() {
		if (getDefault() == null) {
			// If the default instance is not yet initialized,
			// return a static identifier. This identifier must
			// match the plugin id defined in plugin.xml
			return PLUGIN_ID;
		}
		return getDefault().getBundle().getSymbolicName();
	}

	/**
	 * Logs the specified status with this plug-in's log.
	 * 
	 * @param status status to log
	 */
	public static void log(IStatus status) {
		getDefault().getLog().log(status);
	}

	/**
	 * Logs an internal error with the specified message.
	 * 
	 * @param message the error message to log
	 */
	public static void logErrorMessage(String message) {
		log(new Status(IStatus.ERROR, getUniqueIdentifier(), IStatus.ERROR, message, null));
	}

	/**
	 * Logs an internal error with the specified throwable
	 * 
	 * @param e the exception to be logged
	 */
	public static void log(Throwable e) {
		log(new Status(IStatus.ERROR, getUniqueIdentifier(), IStatus.ERROR, e.getMessage(), e));
	}

	/**
	 * Returns the preference store for this UI plug-in. It actually uses the
	 * preference store of the core plug-in.
	 */
	@Override
	public IPreferenceStore getPreferenceStore() {
		if (fCorePreferenceStore == null) {
			fCorePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, IssGdbPlugin.PLUGIN_ID);
		}
		return fCorePreferenceStore;
	}

	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

}
