/*******************************************************************************
 * Copyright (c) 2015 - 2020 Intel Corporation.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Implementation for Function Call History View
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.fch.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class PrevFCHRecordHandler extends FCHRecordHandler {

    private static final String PREV_FCH_RECORD_ID = "org.eclipse.cdt.dsf.iss.ui.fch.command.prevFCHRecord"; //$NON-NLS-1$

    private final static Class<IPrevFCHRecordHandler> cmdType = IPrevFCHRecordHandler.class;

    public PrevFCHRecordHandler() {
        super(PREV_FCH_RECORD_ID, cmdType);
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {

        // store the parameter in the gdb command handler class
        if (fTargetAdapter != null) {
            ((IPrevFCHRecordHandler) fTargetAdapter).triggerShowPrevEvent();
        }

        // execute the event
        return super.execute(event);
    }
}
