/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.runtime.builtin.IRubyObject;

public class Argv
extends AbstractVariable {
    private static final String VALID_NAME = "ARGV";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.equals(VALID_NAME)) {
            return new Argv(receiver2, name2, javaObject);
        }
        return null;
    }

    private Argv(RubyObject receiver2, String name2, Object ... javaObjects) {
        super(receiver2, name2, false);
        assert (javaObjects != null);
        this.javaObject = javaObjects[0];
        this.javaType = this.javaObject == null ? null : (javaObjects.length > 1 ? (Class)javaObjects[1] : this.javaObject.getClass());
    }

    Argv(RubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    @Override
    public BiVariable.Type getType() {
        return BiVariable.Type.Argv;
    }

    public static boolean isValidName(Object name2) {
        return Argv.isValidName(VALID_NAME, name2);
    }

    @Override
    public void inject() {
        Ruby runtime2 = this.getRuntime();
        RubyArray argv2 = RubyArray.newArray(runtime2);
        if (this.javaObject instanceof Collection) {
            argv2.addAll((Collection)this.javaObject);
        } else if (this.javaObject instanceof String[]) {
            for (String str : (String[])this.javaObject) {
                argv2.add(str);
            }
        }
        this.rubyObject = argv2;
        this.fromRuby = true;
        RubyModule rubyModule = Argv.getRubyClass(runtime2);
        if (rubyModule == null) {
            rubyModule = null;
        }
        if (rubyModule == null) {
            return;
        }
        rubyModule.storeConstant(this.name, argv2);
        runtime2.getConstantInvalidator(this.name).invalidate();
    }

    @Override
    public void remove() {
        this.javaObject = new ArrayList();
        this.inject();
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        Argv.updateARGV(receiver2, vars);
    }

    private static void updateARGV(IRubyObject receiver2, BiVariableMap vars) {
        String name2 = VALID_NAME;
        RubyObject topSelf = Argv.getTopSelf(receiver2);
        IRubyObject argv2 = topSelf.getMetaClass().getConstant(VALID_NAME);
        if (argv2 == null || argv2 instanceof RubyNil) {
            return;
        }
        if (vars.containsKey(VALID_NAME)) {
            BiVariable var = vars.getVariable(topSelf, VALID_NAME);
            var.setRubyObject(argv2);
        } else {
            vars.update(VALID_NAME, new Argv(topSelf, VALID_NAME, argv2));
        }
    }

    @Override
    protected void updateRubyObject(IRubyObject rubyObject) {
        if (rubyObject == null) {
            return;
        }
        this.rubyObject = rubyObject;
    }

    public static void retrieveByKey(RubyObject receiver2, BiVariableMap vars, String key2) {
        assert (key2.equals(VALID_NAME));
        Argv.updateARGV(receiver2, vars);
    }

    @Override
    public Object getJavaObject() {
        if (this.rubyObject == null || !this.fromRuby) {
            return this.javaObject;
        }
        RubyArray ary = (RubyArray)this.rubyObject;
        if (this.javaType == null) {
            this.javaObject = new ArrayList(ary);
            return this.javaObject;
        }
        if (this.javaType == String[].class) {
            String[] strArr = new String[ary.size()];
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                strArr[i2] = (String)ary.get(i2);
            }
            this.javaObject = strArr;
            return strArr;
        }
        if (this.javaObject instanceof List) {
            try {
                ((List)this.javaObject).clear();
                ((List)this.javaObject).addAll(ary);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return this.javaObject;
        }
        return null;
    }
}

