/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.tools.DataPoint;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Statistics {
    public static final double getChartDataMean(List<ChartData> DATA) {
        return Statistics.getMean(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getMean(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).sum() / (double)DATA.size();
    }

    public static final double getChartDataVariance(List<ChartData> DATA) {
        return Statistics.getVariance(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getVariance(List<Double> DATA) {
        double mean = Statistics.getMean(DATA);
        double temp = 0.0;
        for (double a : DATA) {
            temp += (a - mean) * (a - mean);
        }
        return temp / (double)DATA.size();
    }

    public static final double getChartDataStdDev(List<ChartData> DATA) {
        return Statistics.getStdDev(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getStdDev(List<Double> DATA) {
        return Math.sqrt(Statistics.getVariance(DATA));
    }

    public static final double getChartDataMedian(List<ChartData> DATA) {
        return Statistics.getMedian(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getMedian(List<Double> DATA) {
        int size = DATA.size();
        Collections.sort(DATA);
        return size % 2 == 0 ? (DATA.get(size / 2 - 1) + DATA.get(size / 2)) / 2.0 : DATA.get(size / 2);
    }

    public static final double getChartDataMin(List<ChartData> DATA) {
        return Statistics.getMin(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getMin(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).min().orElse(0.0);
    }

    public static final double getChartDataMax(List<ChartData> DATA) {
        return Statistics.getMax(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getMax(List<Double> DATA) {
        return DATA.stream().mapToDouble(v -> v).max().orElse(0.0);
    }

    public static final double getChartDataAverage(List<ChartData> DATA) {
        return Statistics.getAverage(DATA.stream().map(ChartData::getValue).collect(Collectors.toList()));
    }

    public static final double getAverage(List<Double> DATA) {
        return DATA.stream().mapToDouble(data -> data).average().orElse(-1.0);
    }

    public static final double percentile(List<Double> entries, double percentile) {
        Collections.sort(entries);
        int index = (int)Math.ceil(percentile / 100.0 * (double)entries.size());
        return entries.get(index - 1);
    }

    public static final Map<LocalTime, DataPoint> analyze(List<ChartData> entries) {
        if (entries.isEmpty()) {
            return new HashMap<LocalTime, DataPoint>();
        }
        HashMap<LocalTime, DataPoint> dataMap = new HashMap<LocalTime, DataPoint>();
        Instant now = Instant.now();
        for (int hour = 0; hour < 24; ++hour) {
            for (int bucket = 0; bucket < 60; bucket += 10) {
                int h2 = hour;
                int m3 = bucket;
                List bucketEntries = entries.stream().filter(entry -> entry.getTimestamp().atZone(ZoneOffset.systemDefault()).getHour() == h2 && entry.getTimestamp().atZone(ZoneOffset.systemDefault()).getMinute() <= m3).collect(Collectors.toList());
                double minBucketValue = bucketEntries.stream().min(Comparator.comparingDouble(ChartData::getValue)).get().getValue();
                double maxBucketValue = bucketEntries.stream().max(Comparator.comparingDouble(ChartData::getValue)).get().getValue();
                double avgBucketValue = minBucketValue + (maxBucketValue - minBucketValue) / 2.0;
                LocalTime key = LocalTime.of(h2, m3, 0);
                DataPoint value = new DataPoint(minBucketValue, maxBucketValue, avgBucketValue);
                dataMap.put(key, value);
            }
        }
        return dataMap;
    }
}

