/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.file.GetFile;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Filter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Listener;
import mediathek.tool.MessageBus;
import mediathek.tool.TextCopyPasteHandler;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.jdesktop.swingx.VerticalLayout;

public class PanelBlacklist
extends JPanel {
    public boolean ok;
    private final String name;
    private final Daten daten;
    private final JFrame parentComponent;
    private JCheckBox jCheckBoxZukunftNichtAnzeigen;
    private JCheckBox jCheckBoxGeo;
    private JSlider jSliderMinuten;
    private JTextField jTextFieldMinuten;
    private JTable jTableBlacklist;
    private JComboBox<String> jComboBoxSender;
    private JComboBox<String> jComboBoxThema;
    private JButton jButtonHinzufuegen;
    private JTextField jTextFieldTitel;
    private JTextField jTextFieldThemaTitel;
    private JButton jButtonAendern;
    private JRadioButton jRadioButtonBlacklist;
    private JRadioButton jRadioButtonWhitelist;
    private JButton jButtonHilfe;
    private JButton jButtonTabelleLoeschen;
    private JCheckBox jCheckBoxStart;
    private JCheckBox jCheckBoxBlacklistEingeschaltet;
    private JCheckBox jCheckBoxAbo;

    public PanelBlacklist(Daten d, JFrame parentComponent, String nname) {
        this.daten = d;
        this.parentComponent = parentComponent;
        this.initComponents();
        this.name = nname;
        this.jButtonHilfe.setIcon(IconFontSwing.buildIcon(FontAwesome.QUESTION_CIRCLE_O, 16.0f));
        this.jButtonTabelleLoeschen.setIcon(IconFontSwing.buildIcon(FontAwesome.TRASH_O, 16.0f));
        this.init_();
        this.init();
        MessageBus.getMessageBus().subscribe(this);
        Listener.addListener(new Listener(40, this.name){

            @Override
            public void ping() {
                PanelBlacklist.this.jCheckBoxStart.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON)));
            }
        });
        Listener.addListener(new Listener(27, this.name){

            @Override
            public void ping() {
                PanelBlacklist.this.init_();
            }
        });
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                PanelBlacklist.this.comboThemaLaden();
            }
        });
    }

    @Handler
    private void handleBlacklistChangedEvent(BlacklistChangedEvent e) {
        SwingUtilities.invokeLater(this::init_);
    }

    private void init_() {
        this.jCheckBoxAbo.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO)));
        this.jCheckBoxStart.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON)));
        this.jCheckBoxBlacklistEingeschaltet.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ON)));
        this.jCheckBoxZukunftNichtAnzeigen.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN)));
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.jCheckBoxGeo.setSelected(config.getBoolean("blacklist.show_geoblocked", false));
        this.jCheckBoxGeo.addActionListener(e -> {
            config.setProperty("blacklist.show_geoblocked", this.jCheckBoxGeo.isSelected());
            this.notifyBlacklistChanged();
        });
        try {
            this.jSliderMinuten.setValue(Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE)));
        }
        catch (Exception ex) {
            this.jSliderMinuten.setValue(0);
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, "0");
        }
        this.tabelleLaden();
    }

    private void init() {
        this.jTableBlacklist.addMouseListener(new BeobMausTabelle());
        this.jTableBlacklist.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.tableSelect();
            }
        });
        this.jRadioButtonWhitelist.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST)));
        this.jRadioButtonWhitelist.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST, Boolean.toString(this.jRadioButtonWhitelist.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jRadioButtonBlacklist.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_IST_WHITELIST, Boolean.toString(this.jRadioButtonWhitelist.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jCheckBoxZukunftNichtAnzeigen.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ZUKUNFT_NICHT_ANZEIGEN, Boolean.toString(this.jCheckBoxZukunftNichtAnzeigen.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jCheckBoxAbo.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO, Boolean.toString(this.jCheckBoxAbo.isSelected()));
            Listener.notify(27, this.name);
        });
        this.jCheckBoxStart.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_START_ON, Boolean.toString(this.jCheckBoxStart.isSelected()));
            Listener.notify(40, this.name);
        });
        this.jCheckBoxBlacklistEingeschaltet.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ON, Boolean.toString(this.jCheckBoxBlacklistEingeschaltet.isSelected()));
            this.notifyBlacklistChanged();
        });
        this.jButtonHinzufuegen.addActionListener(e -> {
            String se = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
            String th = Objects.requireNonNull(this.jComboBoxThema.getSelectedItem()).toString();
            String ti = this.jTextFieldTitel.getText().trim();
            String thti = this.jTextFieldThemaTitel.getText().trim();
            if (!(se.isEmpty() && th.isEmpty() && ti.isEmpty() && thti.isEmpty())) {
                this.daten.getListeBlacklist().add(new BlacklistRule(se, th, ti, thti));
                this.tabelleLaden();
            }
        });
        this.jButtonAendern.addActionListener(e -> {
            int selectedTableRow;
            String se = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
            String th = Objects.requireNonNull(this.jComboBoxThema.getSelectedItem()).toString();
            String ti = this.jTextFieldTitel.getText().trim();
            String thti = this.jTextFieldThemaTitel.getText().trim();
            if (!(se.isEmpty() && th.isEmpty() && ti.isEmpty() && thti.isEmpty() || (selectedTableRow = this.jTableBlacklist.getSelectedRow()) < 0)) {
                int row = this.jTableBlacklist.convertRowIndexToModel(selectedTableRow);
                String delNr = this.jTableBlacklist.getModel().getValueAt(row, 0).toString();
                BlacklistRule bl = this.daten.getListeBlacklist().getRuleByNr(delNr);
                bl.arr[1] = se;
                bl.arr[2] = th;
                bl.arr[3] = ti;
                bl.arr[4] = thti;
                this.tabelleLaden();
                this.jTableBlacklist.addRowSelectionInterval(row, row);
                this.notifyBlacklistChanged();
            }
        });
        this.jButtonHilfe.addActionListener(e -> new DialogHilfe(this.parentComponent, true, new GetFile().getHilfeSuchen("/mediathek/file/hilfetext_blacklist.txt")).setVisible(true));
        this.jButtonTabelleLoeschen.addActionListener(e -> {
            int ret = JOptionPane.showConfirmDialog(this.parentComponent, "Alle Eintr\u00e4ge werden gel\u00f6scht.", "L\u00f6schen?", 0);
            if (ret == 0) {
                this.daten.getListeBlacklist().clear();
                this.tabelleLaden();
            }
        });
        this.jComboBoxSender.addActionListener(e -> this.comboThemaLaden());
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                Filter.validatePatternInput(PanelBlacklist.this.jTextFieldThemaTitel);
                Filter.validatePatternInput(PanelBlacklist.this.jTextFieldTitel);
            }
        };
        this.jTextFieldTitel.getDocument().addDocumentListener(documentListener);
        this.jTextFieldThemaTitel.getDocument().addDocumentListener(documentListener);
        try {
            this.jSliderMinuten.setValue(Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE)));
        }
        catch (Exception ex) {
            this.jSliderMinuten.setValue(0);
            MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, "0");
        }
        this.jTextFieldMinuten.setText(String.valueOf(this.jSliderMinuten.getValue()));
        if (this.jSliderMinuten.getValue() == 0) {
            this.jTextFieldMinuten.setText("alles");
        }
        this.jSliderMinuten.addChangeListener(e -> {
            this.jTextFieldMinuten.setText(String.valueOf(this.jSliderMinuten.getValue()));
            if (this.jSliderMinuten.getValue() == 0) {
                this.jTextFieldMinuten.setText("alles");
            }
            if (!this.jSliderMinuten.getValueIsAdjusting()) {
                MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_FILMLAENGE, String.valueOf(this.jSliderMinuten.getValue()));
                this.notifyBlacklistChanged();
            }
        });
        this.jComboBoxSender.setModel(GuiFunktionen.getSenderListComboBoxModel(this.daten.getListeFilme()));
        this.comboThemaLaden();
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldThemaTitel);
        this.jTextFieldThemaTitel.setComponentPopupMenu(handler.getPopupMenu());
        handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldTitel);
        this.jTextFieldTitel.setComponentPopupMenu(handler.getPopupMenu());
    }

    private void notifyBlacklistChanged() {
        this.daten.getListeBlacklist().filterListe();
        MessageBus.getMessageBus().publishAsync(new BlacklistChangedEvent());
    }

    private void comboThemaLaden() {
        String filterSender = Objects.requireNonNull(this.jComboBoxSender.getSelectedItem()).toString();
        if (filterSender.isEmpty()) {
            filterSender = "";
        }
        List<String> lst = this.daten.getListeFilmeNachBlackList().getThemen(filterSender);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        for (String item : lst) {
            model.addElement(item);
        }
        this.jComboBoxThema.setModel(model);
        lst.clear();
    }

    private void tabelleLaden() {
        DefaultTableModel model = new DefaultTableModel(this.daten.getListeBlacklist().getObjectData(), BlacklistRule.COLUMN_NAMES);
        this.jTableBlacklist.setModel(model);
    }

    private void tableSelect() {
        BlacklistRule bl = null;
        int selectedTableRow = this.jTableBlacklist.getSelectedRow();
        if (selectedTableRow >= 0) {
            int del = this.jTableBlacklist.convertRowIndexToModel(selectedTableRow);
            String delNr = this.jTableBlacklist.getModel().getValueAt(del, 0).toString();
            bl = this.daten.getListeBlacklist().getRuleByNr(delNr);
        }
        if (bl != null) {
            this.jComboBoxSender.setSelectedItem(bl.arr[1]);
            this.jComboBoxThema.setSelectedItem(bl.arr[2]);
            this.jTextFieldTitel.setText(bl.arr[3]);
            this.jTextFieldThemaTitel.setText(bl.arr[4]);
        }
    }

    private void removeTableRow() {
        int selectedTableRow = this.jTableBlacklist.getSelectedRow();
        if (selectedTableRow >= 0) {
            int del = this.jTableBlacklist.convertRowIndexToModel(selectedTableRow);
            String delNr = this.jTableBlacklist.getModel().getValueAt(del, 0).toString();
            this.daten.getListeBlacklist().remove(Integer.parseInt(delNr));
            this.tabelleLaden();
        }
    }

    private void initComponents() {
        JTabbedPane jTabbedPaneBlacklist = new JTabbedPane();
        JPanel jPanel3 = new JPanel();
        this.jCheckBoxZukunftNichtAnzeigen = new JCheckBox();
        this.jCheckBoxGeo = new JCheckBox();
        JPanel jPanel6 = new JPanel();
        this.jSliderMinuten = new JSlider();
        JLabel jLabel1 = new JLabel();
        this.jTextFieldMinuten = new JTextField();
        JLabel jLabel13 = new JLabel();
        JPanel jPanel1 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTableBlacklist = new JTable();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel5 = new JLabel();
        this.jComboBoxSender = new JComboBox();
        JLabel jLabel6 = new JLabel();
        this.jComboBoxThema = new JComboBox();
        this.jButtonHinzufuegen = new JButton();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        this.jTextFieldTitel = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldThemaTitel = new JTextField();
        this.jButtonAendern = new JButton();
        this.jRadioButtonBlacklist = new JRadioButton();
        this.jRadioButtonWhitelist = new JRadioButton();
        this.jButtonHilfe = new JButton();
        JLabel jLabel10 = new JLabel();
        this.jButtonTabelleLoeschen = new JButton();
        JPanel jPanel8 = new JPanel();
        this.jCheckBoxStart = new JCheckBox();
        this.jCheckBoxBlacklistEingeschaltet = new JCheckBox();
        this.jCheckBoxAbo = new JCheckBox();
        jPanel3.setLayout(new VerticalLayout(5));
        this.jCheckBoxZukunftNichtAnzeigen.setText("Filme mit Datum in der Zukunft nicht anzeigen");
        jPanel3.add(this.jCheckBoxZukunftNichtAnzeigen);
        this.jCheckBoxGeo.setText("Filme, die per Geoblocking gesperrt sind, nicht anzeigen");
        this.jCheckBoxGeo.setToolTipText("<html>Geogeblockte Filme k\u00f6nnen im jeweiligen \"Ausland\" nicht abgerufen werden.<br>Dazu muss die eigene Position in den Einstellungen angegeben werden</html>");
        jPanel3.add(this.jCheckBoxGeo);
        jPanel6.setBorder(new EtchedBorder());
        this.jSliderMinuten.setValue(0);
        jLabel1.setText("Nur Filme anzeigen mit einer L\u00e4nge von mehr als [min]:");
        this.jTextFieldMinuten.setEditable(false);
        jLabel13.setText("Filme, die keine L\u00e4ngenangabe haben, werden immer angezeigt.");
        GroupLayout jPanel6Layout = new GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup().addComponent(this.jSliderMinuten, -1, -1, Short.MAX_VALUE).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup().addGroup(jPanel6Layout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldMinuten, -2, 81, -2)).addComponent(jLabel13)).addGap(0, 405, Short.MAX_VALUE))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jTextFieldMinuten, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSliderMinuten, -2, -1, -2).addContainerGap()));
        jPanel3.add(jPanel6);
        jTabbedPaneBlacklist.addTab("Blacklist allgemein", jPanel3);
        this.jTableBlacklist.setAutoCreateRowSorter(true);
        jScrollPane1.setViewportView(this.jTableBlacklist);
        jPanel4.setBorder(new EtchedBorder());
        jLabel5.setText("Sender:");
        this.jComboBoxSender.setModel(new DefaultComboBoxModel<String>(new String[0]));
        jLabel6.setText("Thema:");
        this.jComboBoxThema.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.jButtonHinzufuegen.setText("Hinzuf\u00fcgen");
        jLabel7.setText("Sender, Thema, Titel oder Thema/Titel:");
        jLabel8.setText("Titel:");
        jLabel2.setText("Thema oder Titel:");
        this.jButtonAendern.setText("\u00c4ndern");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addComponent(jLabel7).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addGap(68, 68, 68).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel6).addComponent(jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addComponent(this.jComboBoxSender).addComponent(this.jComboBoxThema))).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel2).addComponent(jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup().addComponent(this.jTextFieldTitel).addComponent(this.jTextFieldThemaTitel)))).addGap(12, 12, 12)))).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonAendern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHinzufuegen).addContainerGap()));
        jPanel4Layout.linkSize(0, this.jButtonAendern, this.jButtonHinzufuegen);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup().addGroup(jPanel4Layout.createSequentialGroup().addGap(23, 23, 23).addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.jComboBoxSender, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel6).addComponent(this.jComboBoxThema, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel8).addComponent(this.jTextFieldTitel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jTextFieldThemaTitel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHinzufuegen).addComponent(this.jButtonAendern)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jComboBoxSender, this.jComboBoxThema, this.jTextFieldThemaTitel, this.jTextFieldTitel);
        this.jRadioButtonBlacklist.setSelected(true);
        this.jRadioButtonBlacklist.setText("\"Sender / Thema / Titel\" werden nicht angezeigt (Blacklist)");
        this.jRadioButtonWhitelist.setText("nur diese \"Sender / Thema / Titel\" anzeigen (Whitelist)");
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        jLabel10.setText("Alle Eintr\u00e4ge l\u00f6schen:");
        this.jButtonTabelleLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-del.png")));
        this.jButtonTabelleLoeschen.setToolTipText("Alle Eintr\u00e4ge l\u00f6schen");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addComponent(jScrollPane1, GroupLayout.Alignment.TRAILING).addComponent(jPanel4, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup().addComponent(this.jRadioButtonWhitelist).addComponent(this.jRadioButtonBlacklist)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 373, Short.MAX_VALUE).addComponent(this.jButtonHilfe)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonTabelleLoeschen))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup().addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonBlacklist).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonWhitelist)).addComponent(this.jButtonHilfe)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 113, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel10).addComponent(this.jButtonTabelleLoeschen)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel4, -2, -1, -2).addContainerGap()));
        jTabbedPaneBlacklist.addTab("Sender-Thema-Titel", jPanel1);
        jPanel8.setBorder(new TitledBorder("Allgemeine Einstellungen"));
        jPanel8.setLayout(new GridLayout(3, 1));
        this.jCheckBoxStart.setText("Beim Programmstart einschalten");
        jPanel8.add(this.jCheckBoxStart);
        this.jCheckBoxBlacklistEingeschaltet.setText("Im Tab Filme einschalten");
        jPanel8.add(this.jCheckBoxBlacklistEingeschaltet);
        this.jCheckBoxAbo.setText("Bei der Suche nach Abos ber\u00fccksichtigen");
        this.jCheckBoxAbo.setToolTipText("<html>Die Blacklist beim Suchen nach Abos ber\u00fccksichtigen.<br/>Ansonsten wird die komplette Filmliste durchsucht.</html>");
        jPanel8.add(this.jCheckBoxAbo);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(jPanel8, -1, -1, Short.MAX_VALUE).addComponent(jTabbedPaneBlacklist)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel8, -2, 97, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jTabbedPaneBlacklist, -2, 510, -2).addContainerGap()));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonBlacklist);
        buttonGroup1.add(this.jRadioButtonWhitelist);
    }

    private class BeobMausTabelle
    extends MouseAdapter {
        private BeobMausTabelle() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            Point p = evt.getPoint();
            int nr = PanelBlacklist.this.jTableBlacklist.rowAtPoint(p);
            if (nr >= 0) {
                PanelBlacklist.this.jTableBlacklist.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Zeile l\u00f6schen");
            item.addActionListener(l -> PanelBlacklist.this.removeTableRow());
            jPopupMenu.add(item);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

