complete -c ruff -n "__fish_use_subcommand" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_use_subcommand" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_use_subcommand" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c ruff -n "__fish_use_subcommand" -f -a "check" -d 'Run Ruff on the given files or directories (default)'
complete -c ruff -n "__fish_use_subcommand" -f -a "rule" -d 'Explain a rule'
complete -c ruff -n "__fish_use_subcommand" -f -a "config" -d 'List or describe the available configuration options'
complete -c ruff -n "__fish_use_subcommand" -f -a "linter" -d 'List all supported upstream linters'
complete -c ruff -n "__fish_use_subcommand" -f -a "clean" -d 'Clear any caches in the current directory and any subdirectories'
complete -c ruff -n "__fish_use_subcommand" -f -a "generate-shell-completion" -d 'Generate shell completion'
complete -c ruff -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ruff -n "__fish_seen_subcommand_from check" -l format -d 'Output serialization format for violations' -r -f -a "{text	,json	,junit	,grouped	,github	,gitlab	,pylint	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l target-version -d 'The minimum Python version that should be supported' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l config -d 'Path to the `pyproject.toml` or `ruff.toml` file to use for configuration' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l select -d 'Comma-separated list of rule codes to enable (or ALL, to enable all rules)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA0	commented-out-code,ERA001	commented-out-code,ERA00	commented-out-code,YTT1	,YTT301	sys-version0-referenced,YTT2	,YTT20	,YTT202	six-py3-referenced,YTT201	sys-version-info0-eq3-referenced,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT203	sys-version-info1-cmp-int,YTT3	,YTT103	sys-version-cmp-str3,YTT10	,YTT30	,YTT303	sys-version-slice1-referenced,ANN2	,ANN201	missing-return-type-public-function,ANN206	missing-return-type-class-method,ANN002	missing-type-args,ANN4	any-type,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN40	any-type,ANN205	missing-return-type-static-method,ANN001	missing-type-function-argument,ANN102	missing-type-cls,ANN0	,ANN202	missing-return-type-private-function,ANN10	,ANN20	,ANN00	,ANN204	missing-return-type-special-method,ANN401	any-type,ANN1	,S61	logging-config-insecure-listen,S5	,S7	jinja2-autoescape-false,S501	request-with-no-cert-validation,S324	hashlib-insecure-hash-function,S70	jinja2-autoescape-false,S105	hardcoded-password-string,S10	,S32	hashlib-insecure-hash-function,S11	,S506	unsafe-yaml-load,S112	try-except-continue,S508	snmp-insecure-version,S106	hardcoded-password-func-arg,S108	hardcoded-temp-file,S107	hardcoded-password-default,S1	,S509	snmp-weak-cryptography,S103	bad-file-permissions,S113	request-without-timeout,S701	jinja2-autoescape-false,S608	hardcoded-sql-expression,S6	,S60	hardcoded-sql-expression,S104	hardcoded-bind-all-interfaces,S102	exec-builtin,S3	hashlib-insecure-hash-function,S50	,S612	logging-config-insecure-listen,S110	try-except-pass,S101	assert,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT0	,FBT002	boolean-default-value-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT001	boolean-positional-arg-in-function-definition,FBT00	,B905	zip-without-explicit-strict,B01	,B002	unary-prefix-increment,B013	redundant-tuple-in-exception-handler,B021	f-string-docstring,B014	duplicate-handler-exception,B025	duplicate-try-block-exception,B03	unintentional-type-annotation,B90	,B011	assert-false,B010	set-attr-with-constant,B004	unreliable-callable-check,B015	useless-comparison,B019	cached-instance-method,B00	,B023	function-uses-loop-variable,B02	,B018	useless-expression,B016	cannot-raise-literal,B003	assignment-to-os-environ,B008	function-call-argument-default,B026	star-arg-unpacking-after-keyword-arg,B007	unused-loop-control-variable,B029	except-with-empty-tuple,B904	raise-without-from-inside-except,B032	unintentional-type-annotation,B012	jump-statement-in-finally,B022	useless-contextlib-suppress,B005	strip-with-multi-characters,B009	get-attr-with-constant,B017	assert-raises-exception,B020	loop-variable-overrides-iterator,B0	,B006	mutable-argument-default,B024	abstract-base-class-without-abstract-method,B027	empty-method-without-abstract-decorator,B9	,A002	builtin-argument-shadowing,A001	builtin-variable-shadowing,A0	,A00	,A003	builtin-attribute-shadowing,COM81	,COM812	trailing-comma-missing,COM819	trailing-comma-prohibited,COM818	trailing-comma-on-bare-tuple-prohibited,COM8	,C408	unnecessary-collection-call,C40	,C414	unnecessary-double-cast-or-process,C41	,C402	unnecessary-generator-dict,C410	unnecessary-literal-within-list-call,C405	unnecessary-literal-set,C403	unnecessary-list-comprehension-set,C409	unnecessary-literal-within-tuple-call,C415	unnecessary-subscript-reversal,C400	unnecessary-generator-list,C411	unnecessary-list-call,C406	unnecessary-literal-dict,C413	unnecessary-call-around-sorted,C404	unnecessary-list-comprehension-dict,C416	unnecessary-comprehension,C401	unnecessary-generator-set,C417	unnecessary-map,DTZ007	call-datetime-strptime-without-zone,DTZ00	,DTZ002	call-datetime-today,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ003	call-datetime-utcnow,DTZ001	call-datetime-without-tzinfo,DTZ004	call-datetime-utcfromtimestamp,DTZ0	,DTZ01	,T100	debugger,DJ013	non-leading-receiver-decorator,DJ00	,DJ001	nullable-model-string-field,DJ01	non-leading-receiver-decorator,DJ008	model-without-dunder-str,DJ0	,EM101	raw-string-in-exception,EM10	,EM103	dot-format-in-exception,EM102	f-string-in-exception,EM1	,EXE003	shebang-python,EXE001	shebang-not-executable,EXE004	shebang-whitespace,EXE0	,EXE00	,EXE005	shebang-newline,EXE002	shebang-missing-executable-file,ISC0	,ISC002	multi-line-implicit-string-concatenation,ISC00	,ISC001	single-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN0	unconventional-import-alias,ICN00	unconventional-import-alias,ICN001	unconventional-import-alias,G001	logging-string-format,G101	logging-extra-attr-clash,G01	logging-warn,G010	logging-warn,G201	logging-exc-info,G1	logging-extra-attr-clash,G004	logging-f-string,G202	logging-redundant-exc-info,G003	logging-string-concat,G2	,G00	,G0	,G20	,G002	logging-percent-format,G10	logging-extra-attr-clash,INP0	implicit-namespace-package,INP001	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE7	,PIE807	prefer-list-builtin,PIE79	,PIE810	single-starts-ends-with,PIE790	unnecessary-pass,PIE81	single-starts-ends-with,PIE80	,PIE796	prefer-unique-enums,PIE794	dupe-class-field-definitions,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,T203	p-print-found,T201	print-found,PYI008	unrecognized-platform-name,PYI00	,PYI001	prefix-type-params,PYI007	unrecognized-platform-check,PYI0	,PT018	composite-assertion,PT02	,PT006	parametrize-names-wrong-type,PT017	assert-in-except,PT0	,PT023	incorrect-mark-parentheses-style,PT021	fixture-finalizer-callback,PT016	fail-without-message,PT00	,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT020	deprecated-yield-fixture,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT009	unittest-assertion,PT001	incorrect-fixture-parentheses-style,PT002	fixture-positional-args,PT013	incorrect-pytest-import,PT010	raises-without-exception,PT026	use-fixtures-without-parameters,PT003	extraneous-scope-function,PT015	assert-always-false,PT005	incorrect-fixture-name-underscore,PT024	unnecessary-asyncio-mark-on-fixture,PT022	useless-yield-fixture,PT025	erroneous-use-fixtures-on-fixture,PT01	,PT011	raises-too-broad,PT008	patch-with-lambda,Q00	,Q000	bad-quotes-inline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q001	bad-quotes-multiline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET504	unnecessary-assign,RET507	superfluous-else-continue,RET503	implicit-return,RET5	,RET506	superfluous-else-raise,RET50	,RET502	implicit-return-value,RET508	superfluous-else-break,RET505	superfluous-else-return,SLF0	private-member-access,SLF00	private-member-access,SLF001	private-member-access,SIM208	double-negation,SIM117	multiple-with-statements,SIM201	negate-equal-op,SIM110	reimplemented-builtin,SIM107	return-in-try-except-finally,SIM223	and-false,SIM40	dict-get-with-default,SIM2	,SIM401	dict-get-with-default,SIM10	,SIM109	compare-with-tuple,SIM20	,SIM202	negate-not-equal-op,SIM221	a-or-not-a,SIM220	a-and-not-a,SIM11	,SIM212	if-expr-with-twisted-arms,SIM3	yoda-conditions,SIM102	collapsible-if,SIM105	use-contextlib-suppress,SIM103	needless-bool,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM21	,SIM30	yoda-conditions,SIM300	yoda-conditions,SIM112	use-capital-environment-variables,SIM22	,SIM118	key-in-dict,SIM108	use-ternary-operator,SIM101	duplicate-isinstance-call,SIM4	dict-get-with-default,SIM1	,SIM222	or-true,SIM116	manual-dict-lookup,SIM211	if-expr-with-false-true,SIM210	if-expr-with-true-false,TID252	relative-imports,TID251	banned-api,TID2	,TID25	,TCH005	empty-type-checking-block,TCH002	typing-only-third-party-import,TCH00	,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH001	typing-only-first-party-import,ARG0	,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG00	,ARG004	unused-static-method-argument,ARG002	unused-method-argument,ARG005	unused-lambda-argument,PTH102	pathlib-mkdir,PTH106	pathlib-rmdir,PTH11	,PTH103	pathlib-makedirs,PTH100	pathlib-abspath,PTH110	pathlib-exists,PTH120	pathlib-dirname,PTH12	,PTH104	pathlib-rename,PTH114	pathlib-is-link,PTH113	pathlib-is-file,PTH10	,PTH105	pathlib-replace,PTH1	,PTH118	pathlib-join,PTH117	pathlib-is-abs,PTH119	pathlib-basename,PTH121	pathlib-samefile,PTH123	pathlib-open,PTH122	pathlib-splitext,PTH108	pathlib-unlink,PTH112	pathlib-is-dir,PTH111	pathlib-expanduser,PTH107	pathlib-remove,PTH101	pathlib-chmod,PTH109	pathlib-getcwd,PTH124	pathlib-py-path,PTH115	pathlib-readlink,PTH116	pathlib-stat,I002	missing-required-import,I0	,I00	,I001	unsorted-imports,C901	complex-structure,NPY002	numpy-legacy-random,NPY00	,NPY001	numpy-deprecated-type-alias,NPY0	,N816	mixed-case-variable-in-global-scope,N81	,N802	invalid-function-name,N803	invalid-argument-name,N813	camelcase-imported-as-lowercase,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N811	constant-imported-as-non-constant,N817	camelcase-imported-as-acronym,N804	invalid-first-argument-name-for-class-method,N818	error-suffix-on-exception-name,N8	,N99	invalid-module-name,N801	invalid-class-name,N999	invalid-module-name,N807	dunder-function-name,N9	invalid-module-name,N80	,N814	camelcase-imported-as-constant,PD012	use-of-dot-read-table,PD007	use-of-dot-ix,PD009	use-of-dot-iat,PD004	use-of-dot-not-null,PD9	df-is-a-bad-variable-name,PD008	use-of-dot-at,PD003	use-of-dot-is-null,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD015	use-of-pd-merge,PD00	,PD0	,PD01	,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD011	use-of-dot-values,PD90	df-is-a-bad-variable-name,W2	no-new-line-at-end-of-file,E99	syntax-error,W	,E101	mixed-spaces-and-tabs,E90	io-error,E741	ambiguous-variable-name,E999	syntax-error,E1	mixed-spaces-and-tabs,E7	,E721	type-comparison,W505	doc-line-too-long,E501	line-too-long,E401	multiple-imports-on-one-line,E73	lambda-assignment,W29	no-new-line-at-end-of-file,E902	io-error,E10	mixed-spaces-and-tabs,W50	doc-line-too-long,E72	,E731	lambda-assignment,E711	none-comparison,E402	module-import-not-at-top-of-file,E722	bare-except,E74	,E703	useless-semicolon,W292	no-new-line-at-end-of-file,W60	invalid-escape-sequence,E712	true-false-comparison,E743	ambiguous-function-name,E742	ambiguous-class-name,W605	invalid-escape-sequence,E5	line-too-long,E	,E4	,E70	,E702	multiple-statements-on-one-line-semicolon,E713	not-in-test,E714	not-is-test,E9	,E71	,W5	doc-line-too-long,W6	invalid-escape-sequence,E50	line-too-long,E40	,E701	multiple-statements-on-one-line-colon,D205	blank-line-after-summary,D301	escape-sequence-in-docstring,D203	one-blank-line-before-class,D209	new-line-after-last-paragraph,D212	multi-line-summary-first-line,D101	public-class,D214	section-not-over-indented,D400	ends-in-period,D411	blank-line-before-section,D105	magic-method,D403	first-line-capitalized,D412	no-blank-lines-between-header-and-content,D409	section-underline-matches-section-length,D202	no-blank-line-after-function,D407	dashed-underline-after-section,D413	blank-line-after-last-section,D415	ends-in-punctuation,D102	public-method,D204	one-blank-line-after-class,D207	no-under-indentation,D208	no-over-indentation,D405	capitalize-section-name,D417	undocumented-param,D418	overload-with-docstring,D210	no-surrounding-whitespace,D206	indent-with-spaces,D20	,D104	public-package,D410	blank-line-after-section,D213	multi-line-summary-second-line,D419	empty-docstring,D404	docstring-starts-with-this,D401	non-imperative-mood,D100	public-module,D211	no-blank-line-before-class,D10	,D106	public-nested-class,D1	,D2	,D201	no-blank-line-before-function,D416	section-name-ends-in-colon,D414	empty-docstring-section,D4	,D21	,D103	public-function,D40	,D408	section-underline-after-name,D41	,D215	section-underline-not-over-indented,D3	,D30	,D107	public-init,D402	no-signature,D200	fits-on-one-line,D406	new-line-after-section-name,D300	triple-single-quotes,F541	f-string-missing-placeholders,F504	percent-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F602	multi-value-repeated-key-variable,F404	late-future-import,F72	forward-annotation-syntax-error,F405	import-star-usage,F631	assert-tuple,F63	,F82	,F821	undefined-name,F403	import-star,F502	percent-format-expected-mapping,F505	percent-format-missing-argument,F706	return-outside-function,F54	f-string-missing-placeholders,F8	,F632	is-literal,F522	string-dot-format-extra-named-arguments,F823	undefined-local,F6	,F407	future-feature-not-defined,F81	redefined-while-unused,F701	break-outside-loop,F622	two-starred-expressions,F9	raise-not-implemented,F503	percent-format-expected-sequence,F621	expressions-in-star-assignment,F525	string-dot-format-mixing-automatic,F822	undefined-export,F601	multi-value-repeated-key-literal,F5	,F811	redefined-while-unused,F901	raise-not-implemented,F406	import-star-not-permitted,F508	percent-format-star-requires-sequence,F506	percent-format-mixed-positional-and-named,F524	string-dot-format-missing-arguments,F707	default-except-not-last,F704	yield-outside-function,F633	invalid-print-syntax,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F841	unused-variable,F507	percent-format-positional-count-mismatch,F634	if-tuple,F501	percent-format-invalid-format,F7	,F702	continue-outside-loop,F84	,F402	import-shadowed-by-loop-var,F4	,F401	unused-import,F70	,F722	forward-annotation-syntax-error,F50	,F40	,F52	,F62	,F60	,F842	unused-annotation,F90	raise-not-implemented,PGH001	no-eval,PGH004	blanket-noqa,PGH00	,PGH002	deprecated-log-warn,PGH0	,PGH003	blanket-type-ignore,PLC3	unnecessary-direct-lambda-call,PLR091	,PLR170	consider-merging-isinstance,PLE1205	logging-too-many-args,PLW0602	global-variable-not-assigned,PLR0912	too-many-branches,PLE25	bidirectional-unicode,PLR0206	property-with-parameters,PLR2	magic-value-comparison,PLW012	useless-else-on-loop,PLE06	,PLE250	bidirectional-unicode,PLR09	,PLE0605	invalid-all-format,PLR0133	comparison-of-constant,PLR040	consider-using-from-import,PLE11	await-outside-async,PLR2004	magic-value-comparison,PLR1701	consider-merging-isinstance,PLE114	await-outside-async,PLE13	,PLR0915	too-many-statements,PLE010	,PLR172	consider-using-sys-exit,PLE1307	bad-string-format-type,PLE01	,PLE1206	logging-too-few-args,PLC30	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE2502	bidirectional-unicode,PLR0911	too-many-return-statements,PLC04	useless-import-alias,PLR1	,PLW290	redefined-loop-name,PLE0101	return-in-init,PLE060	,PLW0120	useless-else-on-loop,PLE12	,PLW06	global-variable-not-assigned,PLE0604	invalid-all-object,PLR0402	consider-using-from-import,PLR013	comparison-of-constant,PLR01	comparison-of-constant,PLW	,PLE130	bad-string-format-type,PLR17	,PLW2901	redefined-loop-name,PLC3002	unnecessary-direct-lambda-call,PLC041	useless-import-alias,PLE0117	nonlocal-without-binding,PLE1142	await-outside-async,PLR0913	too-many-arguments,PLW060	global-variable-not-assigned,PLE	,PLE120	,PLR20	magic-value-comparison,PLE0118	used-prior-global-declaration,PLC0	useless-import-alias,PLE1310	bad-str-strip-call,PLC	,PLR04	consider-using-from-import,PLR0	,PLW01	useless-else-on-loop,PLE011	,PLE131	bad-str-strip-call,PLC300	unnecessary-direct-lambda-call,PLR020	property-with-parameters,PLW0	,PLE1	,PLC0414	useless-import-alias,PLR	,PLW2	redefined-loop-name,PLR1722	consider-using-sys-exit,PLE0	,PLW29	redefined-loop-name,PLR02	property-with-parameters,PLR200	magic-value-comparison,PLE2	bidirectional-unicode,UP007	typing-union,UP003	type-of-primitive,UP014	convert-named-tuple-functional-to-class,UP001	useless-metaclass-type,UP030	format-literals,UP015	redundant-open-modes,UP032	f-string,UP0	,UP012	unnecessary-encode-utf8,UP00	,UP008	super-call-with-parameters,UP017	datetime-timezone-utc,UP026	rewrite-mock-import,UP009	utf8-encoding-declaration,UP005	deprecated-unittest-alias,UP010	unnecessary-future-import,UP021	replace-universal-newlines,UP018	native-literals,UP036	outdated-version-block,UP020	open-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP019	typing-text-str-alias,UP034	extraneous-parentheses,UP024	os-error-alias,UP029	unnecessary-builtin-import,UP035	import-replacements,UP033	functools-cache,UP01	,UP011	lru-cache-without-parameters,UP023	rewrite-c-element-tree,UP02	,UP022	replace-stdout-stderr,UP006	deprecated-collection-type,UP028	rewrite-yield-from,UP037	quoted-annotation,UP025	rewrite-unicode-literal,UP03	,UP031	printf-string-formatting,UP027	rewrite-list-comprehension,RUF00	,RUF001	ambiguous-unicode-character-string,RUF004	keyword-argument-before-star-argument,RUF006	asyncio-dangling-task,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF100	unused-noqa,RUF10	unused-noqa,RUF003	ambiguous-unicode-character-comment,RUF002	ambiguous-unicode-character-docstring,RUF0	,RUF1	unused-noqa,TRY200	reraise-no-cause,TRY300	try-consider-else,TRY401	verbose-log-message,TRY00	,TRY40	,TRY2	,TRY0	,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY30	,TRY400	error-instead-of-exception,TRY3	,TRY4	,TRY003	raise-vanilla-args,TRY004	prefer-type-error,TRY301	raise-within-try,TRY20	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l ignore -d 'Comma-separated list of rule codes to disable' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA0	commented-out-code,ERA001	commented-out-code,ERA00	commented-out-code,YTT1	,YTT301	sys-version0-referenced,YTT2	,YTT20	,YTT202	six-py3-referenced,YTT201	sys-version-info0-eq3-referenced,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT203	sys-version-info1-cmp-int,YTT3	,YTT103	sys-version-cmp-str3,YTT10	,YTT30	,YTT303	sys-version-slice1-referenced,ANN2	,ANN201	missing-return-type-public-function,ANN206	missing-return-type-class-method,ANN002	missing-type-args,ANN4	any-type,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN40	any-type,ANN205	missing-return-type-static-method,ANN001	missing-type-function-argument,ANN102	missing-type-cls,ANN0	,ANN202	missing-return-type-private-function,ANN10	,ANN20	,ANN00	,ANN204	missing-return-type-special-method,ANN401	any-type,ANN1	,S61	logging-config-insecure-listen,S5	,S7	jinja2-autoescape-false,S501	request-with-no-cert-validation,S324	hashlib-insecure-hash-function,S70	jinja2-autoescape-false,S105	hardcoded-password-string,S10	,S32	hashlib-insecure-hash-function,S11	,S506	unsafe-yaml-load,S112	try-except-continue,S508	snmp-insecure-version,S106	hardcoded-password-func-arg,S108	hardcoded-temp-file,S107	hardcoded-password-default,S1	,S509	snmp-weak-cryptography,S103	bad-file-permissions,S113	request-without-timeout,S701	jinja2-autoescape-false,S608	hardcoded-sql-expression,S6	,S60	hardcoded-sql-expression,S104	hardcoded-bind-all-interfaces,S102	exec-builtin,S3	hashlib-insecure-hash-function,S50	,S612	logging-config-insecure-listen,S110	try-except-pass,S101	assert,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT0	,FBT002	boolean-default-value-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT001	boolean-positional-arg-in-function-definition,FBT00	,B905	zip-without-explicit-strict,B01	,B002	unary-prefix-increment,B013	redundant-tuple-in-exception-handler,B021	f-string-docstring,B014	duplicate-handler-exception,B025	duplicate-try-block-exception,B03	unintentional-type-annotation,B90	,B011	assert-false,B010	set-attr-with-constant,B004	unreliable-callable-check,B015	useless-comparison,B019	cached-instance-method,B00	,B023	function-uses-loop-variable,B02	,B018	useless-expression,B016	cannot-raise-literal,B003	assignment-to-os-environ,B008	function-call-argument-default,B026	star-arg-unpacking-after-keyword-arg,B007	unused-loop-control-variable,B029	except-with-empty-tuple,B904	raise-without-from-inside-except,B032	unintentional-type-annotation,B012	jump-statement-in-finally,B022	useless-contextlib-suppress,B005	strip-with-multi-characters,B009	get-attr-with-constant,B017	assert-raises-exception,B020	loop-variable-overrides-iterator,B0	,B006	mutable-argument-default,B024	abstract-base-class-without-abstract-method,B027	empty-method-without-abstract-decorator,B9	,A002	builtin-argument-shadowing,A001	builtin-variable-shadowing,A0	,A00	,A003	builtin-attribute-shadowing,COM81	,COM812	trailing-comma-missing,COM819	trailing-comma-prohibited,COM818	trailing-comma-on-bare-tuple-prohibited,COM8	,C408	unnecessary-collection-call,C40	,C414	unnecessary-double-cast-or-process,C41	,C402	unnecessary-generator-dict,C410	unnecessary-literal-within-list-call,C405	unnecessary-literal-set,C403	unnecessary-list-comprehension-set,C409	unnecessary-literal-within-tuple-call,C415	unnecessary-subscript-reversal,C400	unnecessary-generator-list,C411	unnecessary-list-call,C406	unnecessary-literal-dict,C413	unnecessary-call-around-sorted,C404	unnecessary-list-comprehension-dict,C416	unnecessary-comprehension,C401	unnecessary-generator-set,C417	unnecessary-map,DTZ007	call-datetime-strptime-without-zone,DTZ00	,DTZ002	call-datetime-today,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ003	call-datetime-utcnow,DTZ001	call-datetime-without-tzinfo,DTZ004	call-datetime-utcfromtimestamp,DTZ0	,DTZ01	,T100	debugger,DJ013	non-leading-receiver-decorator,DJ00	,DJ001	nullable-model-string-field,DJ01	non-leading-receiver-decorator,DJ008	model-without-dunder-str,DJ0	,EM101	raw-string-in-exception,EM10	,EM103	dot-format-in-exception,EM102	f-string-in-exception,EM1	,EXE003	shebang-python,EXE001	shebang-not-executable,EXE004	shebang-whitespace,EXE0	,EXE00	,EXE005	shebang-newline,EXE002	shebang-missing-executable-file,ISC0	,ISC002	multi-line-implicit-string-concatenation,ISC00	,ISC001	single-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN0	unconventional-import-alias,ICN00	unconventional-import-alias,ICN001	unconventional-import-alias,G001	logging-string-format,G101	logging-extra-attr-clash,G01	logging-warn,G010	logging-warn,G201	logging-exc-info,G1	logging-extra-attr-clash,G004	logging-f-string,G202	logging-redundant-exc-info,G003	logging-string-concat,G2	,G00	,G0	,G20	,G002	logging-percent-format,G10	logging-extra-attr-clash,INP0	implicit-namespace-package,INP001	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE7	,PIE807	prefer-list-builtin,PIE79	,PIE810	single-starts-ends-with,PIE790	unnecessary-pass,PIE81	single-starts-ends-with,PIE80	,PIE796	prefer-unique-enums,PIE794	dupe-class-field-definitions,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,T203	p-print-found,T201	print-found,PYI008	unrecognized-platform-name,PYI00	,PYI001	prefix-type-params,PYI007	unrecognized-platform-check,PYI0	,PT018	composite-assertion,PT02	,PT006	parametrize-names-wrong-type,PT017	assert-in-except,PT0	,PT023	incorrect-mark-parentheses-style,PT021	fixture-finalizer-callback,PT016	fail-without-message,PT00	,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT020	deprecated-yield-fixture,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT009	unittest-assertion,PT001	incorrect-fixture-parentheses-style,PT002	fixture-positional-args,PT013	incorrect-pytest-import,PT010	raises-without-exception,PT026	use-fixtures-without-parameters,PT003	extraneous-scope-function,PT015	assert-always-false,PT005	incorrect-fixture-name-underscore,PT024	unnecessary-asyncio-mark-on-fixture,PT022	useless-yield-fixture,PT025	erroneous-use-fixtures-on-fixture,PT01	,PT011	raises-too-broad,PT008	patch-with-lambda,Q00	,Q000	bad-quotes-inline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q001	bad-quotes-multiline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET504	unnecessary-assign,RET507	superfluous-else-continue,RET503	implicit-return,RET5	,RET506	superfluous-else-raise,RET50	,RET502	implicit-return-value,RET508	superfluous-else-break,RET505	superfluous-else-return,SLF0	private-member-access,SLF00	private-member-access,SLF001	private-member-access,SIM208	double-negation,SIM117	multiple-with-statements,SIM201	negate-equal-op,SIM110	reimplemented-builtin,SIM107	return-in-try-except-finally,SIM223	and-false,SIM40	dict-get-with-default,SIM2	,SIM401	dict-get-with-default,SIM10	,SIM109	compare-with-tuple,SIM20	,SIM202	negate-not-equal-op,SIM221	a-or-not-a,SIM220	a-and-not-a,SIM11	,SIM212	if-expr-with-twisted-arms,SIM3	yoda-conditions,SIM102	collapsible-if,SIM105	use-contextlib-suppress,SIM103	needless-bool,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM21	,SIM30	yoda-conditions,SIM300	yoda-conditions,SIM112	use-capital-environment-variables,SIM22	,SIM118	key-in-dict,SIM108	use-ternary-operator,SIM101	duplicate-isinstance-call,SIM4	dict-get-with-default,SIM1	,SIM222	or-true,SIM116	manual-dict-lookup,SIM211	if-expr-with-false-true,SIM210	if-expr-with-true-false,TID252	relative-imports,TID251	banned-api,TID2	,TID25	,TCH005	empty-type-checking-block,TCH002	typing-only-third-party-import,TCH00	,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH001	typing-only-first-party-import,ARG0	,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG00	,ARG004	unused-static-method-argument,ARG002	unused-method-argument,ARG005	unused-lambda-argument,PTH102	pathlib-mkdir,PTH106	pathlib-rmdir,PTH11	,PTH103	pathlib-makedirs,PTH100	pathlib-abspath,PTH110	pathlib-exists,PTH120	pathlib-dirname,PTH12	,PTH104	pathlib-rename,PTH114	pathlib-is-link,PTH113	pathlib-is-file,PTH10	,PTH105	pathlib-replace,PTH1	,PTH118	pathlib-join,PTH117	pathlib-is-abs,PTH119	pathlib-basename,PTH121	pathlib-samefile,PTH123	pathlib-open,PTH122	pathlib-splitext,PTH108	pathlib-unlink,PTH112	pathlib-is-dir,PTH111	pathlib-expanduser,PTH107	pathlib-remove,PTH101	pathlib-chmod,PTH109	pathlib-getcwd,PTH124	pathlib-py-path,PTH115	pathlib-readlink,PTH116	pathlib-stat,I002	missing-required-import,I0	,I00	,I001	unsorted-imports,C901	complex-structure,NPY002	numpy-legacy-random,NPY00	,NPY001	numpy-deprecated-type-alias,NPY0	,N816	mixed-case-variable-in-global-scope,N81	,N802	invalid-function-name,N803	invalid-argument-name,N813	camelcase-imported-as-lowercase,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N811	constant-imported-as-non-constant,N817	camelcase-imported-as-acronym,N804	invalid-first-argument-name-for-class-method,N818	error-suffix-on-exception-name,N8	,N99	invalid-module-name,N801	invalid-class-name,N999	invalid-module-name,N807	dunder-function-name,N9	invalid-module-name,N80	,N814	camelcase-imported-as-constant,PD012	use-of-dot-read-table,PD007	use-of-dot-ix,PD009	use-of-dot-iat,PD004	use-of-dot-not-null,PD9	df-is-a-bad-variable-name,PD008	use-of-dot-at,PD003	use-of-dot-is-null,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD015	use-of-pd-merge,PD00	,PD0	,PD01	,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD011	use-of-dot-values,PD90	df-is-a-bad-variable-name,W2	no-new-line-at-end-of-file,E99	syntax-error,W	,E101	mixed-spaces-and-tabs,E90	io-error,E741	ambiguous-variable-name,E999	syntax-error,E1	mixed-spaces-and-tabs,E7	,E721	type-comparison,W505	doc-line-too-long,E501	line-too-long,E401	multiple-imports-on-one-line,E73	lambda-assignment,W29	no-new-line-at-end-of-file,E902	io-error,E10	mixed-spaces-and-tabs,W50	doc-line-too-long,E72	,E731	lambda-assignment,E711	none-comparison,E402	module-import-not-at-top-of-file,E722	bare-except,E74	,E703	useless-semicolon,W292	no-new-line-at-end-of-file,W60	invalid-escape-sequence,E712	true-false-comparison,E743	ambiguous-function-name,E742	ambiguous-class-name,W605	invalid-escape-sequence,E5	line-too-long,E	,E4	,E70	,E702	multiple-statements-on-one-line-semicolon,E713	not-in-test,E714	not-is-test,E9	,E71	,W5	doc-line-too-long,W6	invalid-escape-sequence,E50	line-too-long,E40	,E701	multiple-statements-on-one-line-colon,D205	blank-line-after-summary,D301	escape-sequence-in-docstring,D203	one-blank-line-before-class,D209	new-line-after-last-paragraph,D212	multi-line-summary-first-line,D101	public-class,D214	section-not-over-indented,D400	ends-in-period,D411	blank-line-before-section,D105	magic-method,D403	first-line-capitalized,D412	no-blank-lines-between-header-and-content,D409	section-underline-matches-section-length,D202	no-blank-line-after-function,D407	dashed-underline-after-section,D413	blank-line-after-last-section,D415	ends-in-punctuation,D102	public-method,D204	one-blank-line-after-class,D207	no-under-indentation,D208	no-over-indentation,D405	capitalize-section-name,D417	undocumented-param,D418	overload-with-docstring,D210	no-surrounding-whitespace,D206	indent-with-spaces,D20	,D104	public-package,D410	blank-line-after-section,D213	multi-line-summary-second-line,D419	empty-docstring,D404	docstring-starts-with-this,D401	non-imperative-mood,D100	public-module,D211	no-blank-line-before-class,D10	,D106	public-nested-class,D1	,D2	,D201	no-blank-line-before-function,D416	section-name-ends-in-colon,D414	empty-docstring-section,D4	,D21	,D103	public-function,D40	,D408	section-underline-after-name,D41	,D215	section-underline-not-over-indented,D3	,D30	,D107	public-init,D402	no-signature,D200	fits-on-one-line,D406	new-line-after-section-name,D300	triple-single-quotes,F541	f-string-missing-placeholders,F504	percent-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F602	multi-value-repeated-key-variable,F404	late-future-import,F72	forward-annotation-syntax-error,F405	import-star-usage,F631	assert-tuple,F63	,F82	,F821	undefined-name,F403	import-star,F502	percent-format-expected-mapping,F505	percent-format-missing-argument,F706	return-outside-function,F54	f-string-missing-placeholders,F8	,F632	is-literal,F522	string-dot-format-extra-named-arguments,F823	undefined-local,F6	,F407	future-feature-not-defined,F81	redefined-while-unused,F701	break-outside-loop,F622	two-starred-expressions,F9	raise-not-implemented,F503	percent-format-expected-sequence,F621	expressions-in-star-assignment,F525	string-dot-format-mixing-automatic,F822	undefined-export,F601	multi-value-repeated-key-literal,F5	,F811	redefined-while-unused,F901	raise-not-implemented,F406	import-star-not-permitted,F508	percent-format-star-requires-sequence,F506	percent-format-mixed-positional-and-named,F524	string-dot-format-missing-arguments,F707	default-except-not-last,F704	yield-outside-function,F633	invalid-print-syntax,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F841	unused-variable,F507	percent-format-positional-count-mismatch,F634	if-tuple,F501	percent-format-invalid-format,F7	,F702	continue-outside-loop,F84	,F402	import-shadowed-by-loop-var,F4	,F401	unused-import,F70	,F722	forward-annotation-syntax-error,F50	,F40	,F52	,F62	,F60	,F842	unused-annotation,F90	raise-not-implemented,PGH001	no-eval,PGH004	blanket-noqa,PGH00	,PGH002	deprecated-log-warn,PGH0	,PGH003	blanket-type-ignore,PLC3	unnecessary-direct-lambda-call,PLR091	,PLR170	consider-merging-isinstance,PLE1205	logging-too-many-args,PLW0602	global-variable-not-assigned,PLR0912	too-many-branches,PLE25	bidirectional-unicode,PLR0206	property-with-parameters,PLR2	magic-value-comparison,PLW012	useless-else-on-loop,PLE06	,PLE250	bidirectional-unicode,PLR09	,PLE0605	invalid-all-format,PLR0133	comparison-of-constant,PLR040	consider-using-from-import,PLE11	await-outside-async,PLR2004	magic-value-comparison,PLR1701	consider-merging-isinstance,PLE114	await-outside-async,PLE13	,PLR0915	too-many-statements,PLE010	,PLR172	consider-using-sys-exit,PLE1307	bad-string-format-type,PLE01	,PLE1206	logging-too-few-args,PLC30	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE2502	bidirectional-unicode,PLR0911	too-many-return-statements,PLC04	useless-import-alias,PLR1	,PLW290	redefined-loop-name,PLE0101	return-in-init,PLE060	,PLW0120	useless-else-on-loop,PLE12	,PLW06	global-variable-not-assigned,PLE0604	invalid-all-object,PLR0402	consider-using-from-import,PLR013	comparison-of-constant,PLR01	comparison-of-constant,PLW	,PLE130	bad-string-format-type,PLR17	,PLW2901	redefined-loop-name,PLC3002	unnecessary-direct-lambda-call,PLC041	useless-import-alias,PLE0117	nonlocal-without-binding,PLE1142	await-outside-async,PLR0913	too-many-arguments,PLW060	global-variable-not-assigned,PLE	,PLE120	,PLR20	magic-value-comparison,PLE0118	used-prior-global-declaration,PLC0	useless-import-alias,PLE1310	bad-str-strip-call,PLC	,PLR04	consider-using-from-import,PLR0	,PLW01	useless-else-on-loop,PLE011	,PLE131	bad-str-strip-call,PLC300	unnecessary-direct-lambda-call,PLR020	property-with-parameters,PLW0	,PLE1	,PLC0414	useless-import-alias,PLR	,PLW2	redefined-loop-name,PLR1722	consider-using-sys-exit,PLE0	,PLW29	redefined-loop-name,PLR02	property-with-parameters,PLR200	magic-value-comparison,PLE2	bidirectional-unicode,UP007	typing-union,UP003	type-of-primitive,UP014	convert-named-tuple-functional-to-class,UP001	useless-metaclass-type,UP030	format-literals,UP015	redundant-open-modes,UP032	f-string,UP0	,UP012	unnecessary-encode-utf8,UP00	,UP008	super-call-with-parameters,UP017	datetime-timezone-utc,UP026	rewrite-mock-import,UP009	utf8-encoding-declaration,UP005	deprecated-unittest-alias,UP010	unnecessary-future-import,UP021	replace-universal-newlines,UP018	native-literals,UP036	outdated-version-block,UP020	open-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP019	typing-text-str-alias,UP034	extraneous-parentheses,UP024	os-error-alias,UP029	unnecessary-builtin-import,UP035	import-replacements,UP033	functools-cache,UP01	,UP011	lru-cache-without-parameters,UP023	rewrite-c-element-tree,UP02	,UP022	replace-stdout-stderr,UP006	deprecated-collection-type,UP028	rewrite-yield-from,UP037	quoted-annotation,UP025	rewrite-unicode-literal,UP03	,UP031	printf-string-formatting,UP027	rewrite-list-comprehension,RUF00	,RUF001	ambiguous-unicode-character-string,RUF004	keyword-argument-before-star-argument,RUF006	asyncio-dangling-task,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF100	unused-noqa,RUF10	unused-noqa,RUF003	ambiguous-unicode-character-comment,RUF002	ambiguous-unicode-character-docstring,RUF0	,RUF1	unused-noqa,TRY200	reraise-no-cause,TRY300	try-consider-else,TRY401	verbose-log-message,TRY00	,TRY40	,TRY2	,TRY0	,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY30	,TRY400	error-instead-of-exception,TRY3	,TRY4	,TRY003	raise-vanilla-args,TRY004	prefer-type-error,TRY301	raise-within-try,TRY20	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-select -d 'Like --select, but adds additional rule codes on top of the selected ones' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA0	commented-out-code,ERA001	commented-out-code,ERA00	commented-out-code,YTT1	,YTT301	sys-version0-referenced,YTT2	,YTT20	,YTT202	six-py3-referenced,YTT201	sys-version-info0-eq3-referenced,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT203	sys-version-info1-cmp-int,YTT3	,YTT103	sys-version-cmp-str3,YTT10	,YTT30	,YTT303	sys-version-slice1-referenced,ANN2	,ANN201	missing-return-type-public-function,ANN206	missing-return-type-class-method,ANN002	missing-type-args,ANN4	any-type,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN40	any-type,ANN205	missing-return-type-static-method,ANN001	missing-type-function-argument,ANN102	missing-type-cls,ANN0	,ANN202	missing-return-type-private-function,ANN10	,ANN20	,ANN00	,ANN204	missing-return-type-special-method,ANN401	any-type,ANN1	,S61	logging-config-insecure-listen,S5	,S7	jinja2-autoescape-false,S501	request-with-no-cert-validation,S324	hashlib-insecure-hash-function,S70	jinja2-autoescape-false,S105	hardcoded-password-string,S10	,S32	hashlib-insecure-hash-function,S11	,S506	unsafe-yaml-load,S112	try-except-continue,S508	snmp-insecure-version,S106	hardcoded-password-func-arg,S108	hardcoded-temp-file,S107	hardcoded-password-default,S1	,S509	snmp-weak-cryptography,S103	bad-file-permissions,S113	request-without-timeout,S701	jinja2-autoescape-false,S608	hardcoded-sql-expression,S6	,S60	hardcoded-sql-expression,S104	hardcoded-bind-all-interfaces,S102	exec-builtin,S3	hashlib-insecure-hash-function,S50	,S612	logging-config-insecure-listen,S110	try-except-pass,S101	assert,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT0	,FBT002	boolean-default-value-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT001	boolean-positional-arg-in-function-definition,FBT00	,B905	zip-without-explicit-strict,B01	,B002	unary-prefix-increment,B013	redundant-tuple-in-exception-handler,B021	f-string-docstring,B014	duplicate-handler-exception,B025	duplicate-try-block-exception,B03	unintentional-type-annotation,B90	,B011	assert-false,B010	set-attr-with-constant,B004	unreliable-callable-check,B015	useless-comparison,B019	cached-instance-method,B00	,B023	function-uses-loop-variable,B02	,B018	useless-expression,B016	cannot-raise-literal,B003	assignment-to-os-environ,B008	function-call-argument-default,B026	star-arg-unpacking-after-keyword-arg,B007	unused-loop-control-variable,B029	except-with-empty-tuple,B904	raise-without-from-inside-except,B032	unintentional-type-annotation,B012	jump-statement-in-finally,B022	useless-contextlib-suppress,B005	strip-with-multi-characters,B009	get-attr-with-constant,B017	assert-raises-exception,B020	loop-variable-overrides-iterator,B0	,B006	mutable-argument-default,B024	abstract-base-class-without-abstract-method,B027	empty-method-without-abstract-decorator,B9	,A002	builtin-argument-shadowing,A001	builtin-variable-shadowing,A0	,A00	,A003	builtin-attribute-shadowing,COM81	,COM812	trailing-comma-missing,COM819	trailing-comma-prohibited,COM818	trailing-comma-on-bare-tuple-prohibited,COM8	,C408	unnecessary-collection-call,C40	,C414	unnecessary-double-cast-or-process,C41	,C402	unnecessary-generator-dict,C410	unnecessary-literal-within-list-call,C405	unnecessary-literal-set,C403	unnecessary-list-comprehension-set,C409	unnecessary-literal-within-tuple-call,C415	unnecessary-subscript-reversal,C400	unnecessary-generator-list,C411	unnecessary-list-call,C406	unnecessary-literal-dict,C413	unnecessary-call-around-sorted,C404	unnecessary-list-comprehension-dict,C416	unnecessary-comprehension,C401	unnecessary-generator-set,C417	unnecessary-map,DTZ007	call-datetime-strptime-without-zone,DTZ00	,DTZ002	call-datetime-today,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ003	call-datetime-utcnow,DTZ001	call-datetime-without-tzinfo,DTZ004	call-datetime-utcfromtimestamp,DTZ0	,DTZ01	,T100	debugger,DJ013	non-leading-receiver-decorator,DJ00	,DJ001	nullable-model-string-field,DJ01	non-leading-receiver-decorator,DJ008	model-without-dunder-str,DJ0	,EM101	raw-string-in-exception,EM10	,EM103	dot-format-in-exception,EM102	f-string-in-exception,EM1	,EXE003	shebang-python,EXE001	shebang-not-executable,EXE004	shebang-whitespace,EXE0	,EXE00	,EXE005	shebang-newline,EXE002	shebang-missing-executable-file,ISC0	,ISC002	multi-line-implicit-string-concatenation,ISC00	,ISC001	single-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN0	unconventional-import-alias,ICN00	unconventional-import-alias,ICN001	unconventional-import-alias,G001	logging-string-format,G101	logging-extra-attr-clash,G01	logging-warn,G010	logging-warn,G201	logging-exc-info,G1	logging-extra-attr-clash,G004	logging-f-string,G202	logging-redundant-exc-info,G003	logging-string-concat,G2	,G00	,G0	,G20	,G002	logging-percent-format,G10	logging-extra-attr-clash,INP0	implicit-namespace-package,INP001	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE7	,PIE807	prefer-list-builtin,PIE79	,PIE810	single-starts-ends-with,PIE790	unnecessary-pass,PIE81	single-starts-ends-with,PIE80	,PIE796	prefer-unique-enums,PIE794	dupe-class-field-definitions,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,T203	p-print-found,T201	print-found,PYI008	unrecognized-platform-name,PYI00	,PYI001	prefix-type-params,PYI007	unrecognized-platform-check,PYI0	,PT018	composite-assertion,PT02	,PT006	parametrize-names-wrong-type,PT017	assert-in-except,PT0	,PT023	incorrect-mark-parentheses-style,PT021	fixture-finalizer-callback,PT016	fail-without-message,PT00	,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT020	deprecated-yield-fixture,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT009	unittest-assertion,PT001	incorrect-fixture-parentheses-style,PT002	fixture-positional-args,PT013	incorrect-pytest-import,PT010	raises-without-exception,PT026	use-fixtures-without-parameters,PT003	extraneous-scope-function,PT015	assert-always-false,PT005	incorrect-fixture-name-underscore,PT024	unnecessary-asyncio-mark-on-fixture,PT022	useless-yield-fixture,PT025	erroneous-use-fixtures-on-fixture,PT01	,PT011	raises-too-broad,PT008	patch-with-lambda,Q00	,Q000	bad-quotes-inline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q001	bad-quotes-multiline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET504	unnecessary-assign,RET507	superfluous-else-continue,RET503	implicit-return,RET5	,RET506	superfluous-else-raise,RET50	,RET502	implicit-return-value,RET508	superfluous-else-break,RET505	superfluous-else-return,SLF0	private-member-access,SLF00	private-member-access,SLF001	private-member-access,SIM208	double-negation,SIM117	multiple-with-statements,SIM201	negate-equal-op,SIM110	reimplemented-builtin,SIM107	return-in-try-except-finally,SIM223	and-false,SIM40	dict-get-with-default,SIM2	,SIM401	dict-get-with-default,SIM10	,SIM109	compare-with-tuple,SIM20	,SIM202	negate-not-equal-op,SIM221	a-or-not-a,SIM220	a-and-not-a,SIM11	,SIM212	if-expr-with-twisted-arms,SIM3	yoda-conditions,SIM102	collapsible-if,SIM105	use-contextlib-suppress,SIM103	needless-bool,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM21	,SIM30	yoda-conditions,SIM300	yoda-conditions,SIM112	use-capital-environment-variables,SIM22	,SIM118	key-in-dict,SIM108	use-ternary-operator,SIM101	duplicate-isinstance-call,SIM4	dict-get-with-default,SIM1	,SIM222	or-true,SIM116	manual-dict-lookup,SIM211	if-expr-with-false-true,SIM210	if-expr-with-true-false,TID252	relative-imports,TID251	banned-api,TID2	,TID25	,TCH005	empty-type-checking-block,TCH002	typing-only-third-party-import,TCH00	,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH001	typing-only-first-party-import,ARG0	,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG00	,ARG004	unused-static-method-argument,ARG002	unused-method-argument,ARG005	unused-lambda-argument,PTH102	pathlib-mkdir,PTH106	pathlib-rmdir,PTH11	,PTH103	pathlib-makedirs,PTH100	pathlib-abspath,PTH110	pathlib-exists,PTH120	pathlib-dirname,PTH12	,PTH104	pathlib-rename,PTH114	pathlib-is-link,PTH113	pathlib-is-file,PTH10	,PTH105	pathlib-replace,PTH1	,PTH118	pathlib-join,PTH117	pathlib-is-abs,PTH119	pathlib-basename,PTH121	pathlib-samefile,PTH123	pathlib-open,PTH122	pathlib-splitext,PTH108	pathlib-unlink,PTH112	pathlib-is-dir,PTH111	pathlib-expanduser,PTH107	pathlib-remove,PTH101	pathlib-chmod,PTH109	pathlib-getcwd,PTH124	pathlib-py-path,PTH115	pathlib-readlink,PTH116	pathlib-stat,I002	missing-required-import,I0	,I00	,I001	unsorted-imports,C901	complex-structure,NPY002	numpy-legacy-random,NPY00	,NPY001	numpy-deprecated-type-alias,NPY0	,N816	mixed-case-variable-in-global-scope,N81	,N802	invalid-function-name,N803	invalid-argument-name,N813	camelcase-imported-as-lowercase,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N811	constant-imported-as-non-constant,N817	camelcase-imported-as-acronym,N804	invalid-first-argument-name-for-class-method,N818	error-suffix-on-exception-name,N8	,N99	invalid-module-name,N801	invalid-class-name,N999	invalid-module-name,N807	dunder-function-name,N9	invalid-module-name,N80	,N814	camelcase-imported-as-constant,PD012	use-of-dot-read-table,PD007	use-of-dot-ix,PD009	use-of-dot-iat,PD004	use-of-dot-not-null,PD9	df-is-a-bad-variable-name,PD008	use-of-dot-at,PD003	use-of-dot-is-null,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD015	use-of-pd-merge,PD00	,PD0	,PD01	,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD011	use-of-dot-values,PD90	df-is-a-bad-variable-name,W2	no-new-line-at-end-of-file,E99	syntax-error,W	,E101	mixed-spaces-and-tabs,E90	io-error,E741	ambiguous-variable-name,E999	syntax-error,E1	mixed-spaces-and-tabs,E7	,E721	type-comparison,W505	doc-line-too-long,E501	line-too-long,E401	multiple-imports-on-one-line,E73	lambda-assignment,W29	no-new-line-at-end-of-file,E902	io-error,E10	mixed-spaces-and-tabs,W50	doc-line-too-long,E72	,E731	lambda-assignment,E711	none-comparison,E402	module-import-not-at-top-of-file,E722	bare-except,E74	,E703	useless-semicolon,W292	no-new-line-at-end-of-file,W60	invalid-escape-sequence,E712	true-false-comparison,E743	ambiguous-function-name,E742	ambiguous-class-name,W605	invalid-escape-sequence,E5	line-too-long,E	,E4	,E70	,E702	multiple-statements-on-one-line-semicolon,E713	not-in-test,E714	not-is-test,E9	,E71	,W5	doc-line-too-long,W6	invalid-escape-sequence,E50	line-too-long,E40	,E701	multiple-statements-on-one-line-colon,D205	blank-line-after-summary,D301	escape-sequence-in-docstring,D203	one-blank-line-before-class,D209	new-line-after-last-paragraph,D212	multi-line-summary-first-line,D101	public-class,D214	section-not-over-indented,D400	ends-in-period,D411	blank-line-before-section,D105	magic-method,D403	first-line-capitalized,D412	no-blank-lines-between-header-and-content,D409	section-underline-matches-section-length,D202	no-blank-line-after-function,D407	dashed-underline-after-section,D413	blank-line-after-last-section,D415	ends-in-punctuation,D102	public-method,D204	one-blank-line-after-class,D207	no-under-indentation,D208	no-over-indentation,D405	capitalize-section-name,D417	undocumented-param,D418	overload-with-docstring,D210	no-surrounding-whitespace,D206	indent-with-spaces,D20	,D104	public-package,D410	blank-line-after-section,D213	multi-line-summary-second-line,D419	empty-docstring,D404	docstring-starts-with-this,D401	non-imperative-mood,D100	public-module,D211	no-blank-line-before-class,D10	,D106	public-nested-class,D1	,D2	,D201	no-blank-line-before-function,D416	section-name-ends-in-colon,D414	empty-docstring-section,D4	,D21	,D103	public-function,D40	,D408	section-underline-after-name,D41	,D215	section-underline-not-over-indented,D3	,D30	,D107	public-init,D402	no-signature,D200	fits-on-one-line,D406	new-line-after-section-name,D300	triple-single-quotes,F541	f-string-missing-placeholders,F504	percent-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F602	multi-value-repeated-key-variable,F404	late-future-import,F72	forward-annotation-syntax-error,F405	import-star-usage,F631	assert-tuple,F63	,F82	,F821	undefined-name,F403	import-star,F502	percent-format-expected-mapping,F505	percent-format-missing-argument,F706	return-outside-function,F54	f-string-missing-placeholders,F8	,F632	is-literal,F522	string-dot-format-extra-named-arguments,F823	undefined-local,F6	,F407	future-feature-not-defined,F81	redefined-while-unused,F701	break-outside-loop,F622	two-starred-expressions,F9	raise-not-implemented,F503	percent-format-expected-sequence,F621	expressions-in-star-assignment,F525	string-dot-format-mixing-automatic,F822	undefined-export,F601	multi-value-repeated-key-literal,F5	,F811	redefined-while-unused,F901	raise-not-implemented,F406	import-star-not-permitted,F508	percent-format-star-requires-sequence,F506	percent-format-mixed-positional-and-named,F524	string-dot-format-missing-arguments,F707	default-except-not-last,F704	yield-outside-function,F633	invalid-print-syntax,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F841	unused-variable,F507	percent-format-positional-count-mismatch,F634	if-tuple,F501	percent-format-invalid-format,F7	,F702	continue-outside-loop,F84	,F402	import-shadowed-by-loop-var,F4	,F401	unused-import,F70	,F722	forward-annotation-syntax-error,F50	,F40	,F52	,F62	,F60	,F842	unused-annotation,F90	raise-not-implemented,PGH001	no-eval,PGH004	blanket-noqa,PGH00	,PGH002	deprecated-log-warn,PGH0	,PGH003	blanket-type-ignore,PLC3	unnecessary-direct-lambda-call,PLR091	,PLR170	consider-merging-isinstance,PLE1205	logging-too-many-args,PLW0602	global-variable-not-assigned,PLR0912	too-many-branches,PLE25	bidirectional-unicode,PLR0206	property-with-parameters,PLR2	magic-value-comparison,PLW012	useless-else-on-loop,PLE06	,PLE250	bidirectional-unicode,PLR09	,PLE0605	invalid-all-format,PLR0133	comparison-of-constant,PLR040	consider-using-from-import,PLE11	await-outside-async,PLR2004	magic-value-comparison,PLR1701	consider-merging-isinstance,PLE114	await-outside-async,PLE13	,PLR0915	too-many-statements,PLE010	,PLR172	consider-using-sys-exit,PLE1307	bad-string-format-type,PLE01	,PLE1206	logging-too-few-args,PLC30	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE2502	bidirectional-unicode,PLR0911	too-many-return-statements,PLC04	useless-import-alias,PLR1	,PLW290	redefined-loop-name,PLE0101	return-in-init,PLE060	,PLW0120	useless-else-on-loop,PLE12	,PLW06	global-variable-not-assigned,PLE0604	invalid-all-object,PLR0402	consider-using-from-import,PLR013	comparison-of-constant,PLR01	comparison-of-constant,PLW	,PLE130	bad-string-format-type,PLR17	,PLW2901	redefined-loop-name,PLC3002	unnecessary-direct-lambda-call,PLC041	useless-import-alias,PLE0117	nonlocal-without-binding,PLE1142	await-outside-async,PLR0913	too-many-arguments,PLW060	global-variable-not-assigned,PLE	,PLE120	,PLR20	magic-value-comparison,PLE0118	used-prior-global-declaration,PLC0	useless-import-alias,PLE1310	bad-str-strip-call,PLC	,PLR04	consider-using-from-import,PLR0	,PLW01	useless-else-on-loop,PLE011	,PLE131	bad-str-strip-call,PLC300	unnecessary-direct-lambda-call,PLR020	property-with-parameters,PLW0	,PLE1	,PLC0414	useless-import-alias,PLR	,PLW2	redefined-loop-name,PLR1722	consider-using-sys-exit,PLE0	,PLW29	redefined-loop-name,PLR02	property-with-parameters,PLR200	magic-value-comparison,PLE2	bidirectional-unicode,UP007	typing-union,UP003	type-of-primitive,UP014	convert-named-tuple-functional-to-class,UP001	useless-metaclass-type,UP030	format-literals,UP015	redundant-open-modes,UP032	f-string,UP0	,UP012	unnecessary-encode-utf8,UP00	,UP008	super-call-with-parameters,UP017	datetime-timezone-utc,UP026	rewrite-mock-import,UP009	utf8-encoding-declaration,UP005	deprecated-unittest-alias,UP010	unnecessary-future-import,UP021	replace-universal-newlines,UP018	native-literals,UP036	outdated-version-block,UP020	open-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP019	typing-text-str-alias,UP034	extraneous-parentheses,UP024	os-error-alias,UP029	unnecessary-builtin-import,UP035	import-replacements,UP033	functools-cache,UP01	,UP011	lru-cache-without-parameters,UP023	rewrite-c-element-tree,UP02	,UP022	replace-stdout-stderr,UP006	deprecated-collection-type,UP028	rewrite-yield-from,UP037	quoted-annotation,UP025	rewrite-unicode-literal,UP03	,UP031	printf-string-formatting,UP027	rewrite-list-comprehension,RUF00	,RUF001	ambiguous-unicode-character-string,RUF004	keyword-argument-before-star-argument,RUF006	asyncio-dangling-task,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF100	unused-noqa,RUF10	unused-noqa,RUF003	ambiguous-unicode-character-comment,RUF002	ambiguous-unicode-character-docstring,RUF0	,RUF1	unused-noqa,TRY200	reraise-no-cause,TRY300	try-consider-else,TRY401	verbose-log-message,TRY00	,TRY40	,TRY2	,TRY0	,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY30	,TRY400	error-instead-of-exception,TRY3	,TRY4	,TRY003	raise-vanilla-args,TRY004	prefer-type-error,TRY301	raise-within-try,TRY20	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-ignore -d 'Like --ignore. (Deprecated: You can just use --ignore instead.)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA0	commented-out-code,ERA001	commented-out-code,ERA00	commented-out-code,YTT1	,YTT301	sys-version0-referenced,YTT2	,YTT20	,YTT202	six-py3-referenced,YTT201	sys-version-info0-eq3-referenced,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT203	sys-version-info1-cmp-int,YTT3	,YTT103	sys-version-cmp-str3,YTT10	,YTT30	,YTT303	sys-version-slice1-referenced,ANN2	,ANN201	missing-return-type-public-function,ANN206	missing-return-type-class-method,ANN002	missing-type-args,ANN4	any-type,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN40	any-type,ANN205	missing-return-type-static-method,ANN001	missing-type-function-argument,ANN102	missing-type-cls,ANN0	,ANN202	missing-return-type-private-function,ANN10	,ANN20	,ANN00	,ANN204	missing-return-type-special-method,ANN401	any-type,ANN1	,S61	logging-config-insecure-listen,S5	,S7	jinja2-autoescape-false,S501	request-with-no-cert-validation,S324	hashlib-insecure-hash-function,S70	jinja2-autoescape-false,S105	hardcoded-password-string,S10	,S32	hashlib-insecure-hash-function,S11	,S506	unsafe-yaml-load,S112	try-except-continue,S508	snmp-insecure-version,S106	hardcoded-password-func-arg,S108	hardcoded-temp-file,S107	hardcoded-password-default,S1	,S509	snmp-weak-cryptography,S103	bad-file-permissions,S113	request-without-timeout,S701	jinja2-autoescape-false,S608	hardcoded-sql-expression,S6	,S60	hardcoded-sql-expression,S104	hardcoded-bind-all-interfaces,S102	exec-builtin,S3	hashlib-insecure-hash-function,S50	,S612	logging-config-insecure-listen,S110	try-except-pass,S101	assert,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT0	,FBT002	boolean-default-value-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT001	boolean-positional-arg-in-function-definition,FBT00	,B905	zip-without-explicit-strict,B01	,B002	unary-prefix-increment,B013	redundant-tuple-in-exception-handler,B021	f-string-docstring,B014	duplicate-handler-exception,B025	duplicate-try-block-exception,B03	unintentional-type-annotation,B90	,B011	assert-false,B010	set-attr-with-constant,B004	unreliable-callable-check,B015	useless-comparison,B019	cached-instance-method,B00	,B023	function-uses-loop-variable,B02	,B018	useless-expression,B016	cannot-raise-literal,B003	assignment-to-os-environ,B008	function-call-argument-default,B026	star-arg-unpacking-after-keyword-arg,B007	unused-loop-control-variable,B029	except-with-empty-tuple,B904	raise-without-from-inside-except,B032	unintentional-type-annotation,B012	jump-statement-in-finally,B022	useless-contextlib-suppress,B005	strip-with-multi-characters,B009	get-attr-with-constant,B017	assert-raises-exception,B020	loop-variable-overrides-iterator,B0	,B006	mutable-argument-default,B024	abstract-base-class-without-abstract-method,B027	empty-method-without-abstract-decorator,B9	,A002	builtin-argument-shadowing,A001	builtin-variable-shadowing,A0	,A00	,A003	builtin-attribute-shadowing,COM81	,COM812	trailing-comma-missing,COM819	trailing-comma-prohibited,COM818	trailing-comma-on-bare-tuple-prohibited,COM8	,C408	unnecessary-collection-call,C40	,C414	unnecessary-double-cast-or-process,C41	,C402	unnecessary-generator-dict,C410	unnecessary-literal-within-list-call,C405	unnecessary-literal-set,C403	unnecessary-list-comprehension-set,C409	unnecessary-literal-within-tuple-call,C415	unnecessary-subscript-reversal,C400	unnecessary-generator-list,C411	unnecessary-list-call,C406	unnecessary-literal-dict,C413	unnecessary-call-around-sorted,C404	unnecessary-list-comprehension-dict,C416	unnecessary-comprehension,C401	unnecessary-generator-set,C417	unnecessary-map,DTZ007	call-datetime-strptime-without-zone,DTZ00	,DTZ002	call-datetime-today,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ003	call-datetime-utcnow,DTZ001	call-datetime-without-tzinfo,DTZ004	call-datetime-utcfromtimestamp,DTZ0	,DTZ01	,T100	debugger,DJ013	non-leading-receiver-decorator,DJ00	,DJ001	nullable-model-string-field,DJ01	non-leading-receiver-decorator,DJ008	model-without-dunder-str,DJ0	,EM101	raw-string-in-exception,EM10	,EM103	dot-format-in-exception,EM102	f-string-in-exception,EM1	,EXE003	shebang-python,EXE001	shebang-not-executable,EXE004	shebang-whitespace,EXE0	,EXE00	,EXE005	shebang-newline,EXE002	shebang-missing-executable-file,ISC0	,ISC002	multi-line-implicit-string-concatenation,ISC00	,ISC001	single-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN0	unconventional-import-alias,ICN00	unconventional-import-alias,ICN001	unconventional-import-alias,G001	logging-string-format,G101	logging-extra-attr-clash,G01	logging-warn,G010	logging-warn,G201	logging-exc-info,G1	logging-extra-attr-clash,G004	logging-f-string,G202	logging-redundant-exc-info,G003	logging-string-concat,G2	,G00	,G0	,G20	,G002	logging-percent-format,G10	logging-extra-attr-clash,INP0	implicit-namespace-package,INP001	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE7	,PIE807	prefer-list-builtin,PIE79	,PIE810	single-starts-ends-with,PIE790	unnecessary-pass,PIE81	single-starts-ends-with,PIE80	,PIE796	prefer-unique-enums,PIE794	dupe-class-field-definitions,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,T203	p-print-found,T201	print-found,PYI008	unrecognized-platform-name,PYI00	,PYI001	prefix-type-params,PYI007	unrecognized-platform-check,PYI0	,PT018	composite-assertion,PT02	,PT006	parametrize-names-wrong-type,PT017	assert-in-except,PT0	,PT023	incorrect-mark-parentheses-style,PT021	fixture-finalizer-callback,PT016	fail-without-message,PT00	,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT020	deprecated-yield-fixture,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT009	unittest-assertion,PT001	incorrect-fixture-parentheses-style,PT002	fixture-positional-args,PT013	incorrect-pytest-import,PT010	raises-without-exception,PT026	use-fixtures-without-parameters,PT003	extraneous-scope-function,PT015	assert-always-false,PT005	incorrect-fixture-name-underscore,PT024	unnecessary-asyncio-mark-on-fixture,PT022	useless-yield-fixture,PT025	erroneous-use-fixtures-on-fixture,PT01	,PT011	raises-too-broad,PT008	patch-with-lambda,Q00	,Q000	bad-quotes-inline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q001	bad-quotes-multiline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET504	unnecessary-assign,RET507	superfluous-else-continue,RET503	implicit-return,RET5	,RET506	superfluous-else-raise,RET50	,RET502	implicit-return-value,RET508	superfluous-else-break,RET505	superfluous-else-return,SLF0	private-member-access,SLF00	private-member-access,SLF001	private-member-access,SIM208	double-negation,SIM117	multiple-with-statements,SIM201	negate-equal-op,SIM110	reimplemented-builtin,SIM107	return-in-try-except-finally,SIM223	and-false,SIM40	dict-get-with-default,SIM2	,SIM401	dict-get-with-default,SIM10	,SIM109	compare-with-tuple,SIM20	,SIM202	negate-not-equal-op,SIM221	a-or-not-a,SIM220	a-and-not-a,SIM11	,SIM212	if-expr-with-twisted-arms,SIM3	yoda-conditions,SIM102	collapsible-if,SIM105	use-contextlib-suppress,SIM103	needless-bool,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM21	,SIM30	yoda-conditions,SIM300	yoda-conditions,SIM112	use-capital-environment-variables,SIM22	,SIM118	key-in-dict,SIM108	use-ternary-operator,SIM101	duplicate-isinstance-call,SIM4	dict-get-with-default,SIM1	,SIM222	or-true,SIM116	manual-dict-lookup,SIM211	if-expr-with-false-true,SIM210	if-expr-with-true-false,TID252	relative-imports,TID251	banned-api,TID2	,TID25	,TCH005	empty-type-checking-block,TCH002	typing-only-third-party-import,TCH00	,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH001	typing-only-first-party-import,ARG0	,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG00	,ARG004	unused-static-method-argument,ARG002	unused-method-argument,ARG005	unused-lambda-argument,PTH102	pathlib-mkdir,PTH106	pathlib-rmdir,PTH11	,PTH103	pathlib-makedirs,PTH100	pathlib-abspath,PTH110	pathlib-exists,PTH120	pathlib-dirname,PTH12	,PTH104	pathlib-rename,PTH114	pathlib-is-link,PTH113	pathlib-is-file,PTH10	,PTH105	pathlib-replace,PTH1	,PTH118	pathlib-join,PTH117	pathlib-is-abs,PTH119	pathlib-basename,PTH121	pathlib-samefile,PTH123	pathlib-open,PTH122	pathlib-splitext,PTH108	pathlib-unlink,PTH112	pathlib-is-dir,PTH111	pathlib-expanduser,PTH107	pathlib-remove,PTH101	pathlib-chmod,PTH109	pathlib-getcwd,PTH124	pathlib-py-path,PTH115	pathlib-readlink,PTH116	pathlib-stat,I002	missing-required-import,I0	,I00	,I001	unsorted-imports,C901	complex-structure,NPY002	numpy-legacy-random,NPY00	,NPY001	numpy-deprecated-type-alias,NPY0	,N816	mixed-case-variable-in-global-scope,N81	,N802	invalid-function-name,N803	invalid-argument-name,N813	camelcase-imported-as-lowercase,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N811	constant-imported-as-non-constant,N817	camelcase-imported-as-acronym,N804	invalid-first-argument-name-for-class-method,N818	error-suffix-on-exception-name,N8	,N99	invalid-module-name,N801	invalid-class-name,N999	invalid-module-name,N807	dunder-function-name,N9	invalid-module-name,N80	,N814	camelcase-imported-as-constant,PD012	use-of-dot-read-table,PD007	use-of-dot-ix,PD009	use-of-dot-iat,PD004	use-of-dot-not-null,PD9	df-is-a-bad-variable-name,PD008	use-of-dot-at,PD003	use-of-dot-is-null,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD015	use-of-pd-merge,PD00	,PD0	,PD01	,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD011	use-of-dot-values,PD90	df-is-a-bad-variable-name,W2	no-new-line-at-end-of-file,E99	syntax-error,W	,E101	mixed-spaces-and-tabs,E90	io-error,E741	ambiguous-variable-name,E999	syntax-error,E1	mixed-spaces-and-tabs,E7	,E721	type-comparison,W505	doc-line-too-long,E501	line-too-long,E401	multiple-imports-on-one-line,E73	lambda-assignment,W29	no-new-line-at-end-of-file,E902	io-error,E10	mixed-spaces-and-tabs,W50	doc-line-too-long,E72	,E731	lambda-assignment,E711	none-comparison,E402	module-import-not-at-top-of-file,E722	bare-except,E74	,E703	useless-semicolon,W292	no-new-line-at-end-of-file,W60	invalid-escape-sequence,E712	true-false-comparison,E743	ambiguous-function-name,E742	ambiguous-class-name,W605	invalid-escape-sequence,E5	line-too-long,E	,E4	,E70	,E702	multiple-statements-on-one-line-semicolon,E713	not-in-test,E714	not-is-test,E9	,E71	,W5	doc-line-too-long,W6	invalid-escape-sequence,E50	line-too-long,E40	,E701	multiple-statements-on-one-line-colon,D205	blank-line-after-summary,D301	escape-sequence-in-docstring,D203	one-blank-line-before-class,D209	new-line-after-last-paragraph,D212	multi-line-summary-first-line,D101	public-class,D214	section-not-over-indented,D400	ends-in-period,D411	blank-line-before-section,D105	magic-method,D403	first-line-capitalized,D412	no-blank-lines-between-header-and-content,D409	section-underline-matches-section-length,D202	no-blank-line-after-function,D407	dashed-underline-after-section,D413	blank-line-after-last-section,D415	ends-in-punctuation,D102	public-method,D204	one-blank-line-after-class,D207	no-under-indentation,D208	no-over-indentation,D405	capitalize-section-name,D417	undocumented-param,D418	overload-with-docstring,D210	no-surrounding-whitespace,D206	indent-with-spaces,D20	,D104	public-package,D410	blank-line-after-section,D213	multi-line-summary-second-line,D419	empty-docstring,D404	docstring-starts-with-this,D401	non-imperative-mood,D100	public-module,D211	no-blank-line-before-class,D10	,D106	public-nested-class,D1	,D2	,D201	no-blank-line-before-function,D416	section-name-ends-in-colon,D414	empty-docstring-section,D4	,D21	,D103	public-function,D40	,D408	section-underline-after-name,D41	,D215	section-underline-not-over-indented,D3	,D30	,D107	public-init,D402	no-signature,D200	fits-on-one-line,D406	new-line-after-section-name,D300	triple-single-quotes,F541	f-string-missing-placeholders,F504	percent-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F602	multi-value-repeated-key-variable,F404	late-future-import,F72	forward-annotation-syntax-error,F405	import-star-usage,F631	assert-tuple,F63	,F82	,F821	undefined-name,F403	import-star,F502	percent-format-expected-mapping,F505	percent-format-missing-argument,F706	return-outside-function,F54	f-string-missing-placeholders,F8	,F632	is-literal,F522	string-dot-format-extra-named-arguments,F823	undefined-local,F6	,F407	future-feature-not-defined,F81	redefined-while-unused,F701	break-outside-loop,F622	two-starred-expressions,F9	raise-not-implemented,F503	percent-format-expected-sequence,F621	expressions-in-star-assignment,F525	string-dot-format-mixing-automatic,F822	undefined-export,F601	multi-value-repeated-key-literal,F5	,F811	redefined-while-unused,F901	raise-not-implemented,F406	import-star-not-permitted,F508	percent-format-star-requires-sequence,F506	percent-format-mixed-positional-and-named,F524	string-dot-format-missing-arguments,F707	default-except-not-last,F704	yield-outside-function,F633	invalid-print-syntax,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F841	unused-variable,F507	percent-format-positional-count-mismatch,F634	if-tuple,F501	percent-format-invalid-format,F7	,F702	continue-outside-loop,F84	,F402	import-shadowed-by-loop-var,F4	,F401	unused-import,F70	,F722	forward-annotation-syntax-error,F50	,F40	,F52	,F62	,F60	,F842	unused-annotation,F90	raise-not-implemented,PGH001	no-eval,PGH004	blanket-noqa,PGH00	,PGH002	deprecated-log-warn,PGH0	,PGH003	blanket-type-ignore,PLC3	unnecessary-direct-lambda-call,PLR091	,PLR170	consider-merging-isinstance,PLE1205	logging-too-many-args,PLW0602	global-variable-not-assigned,PLR0912	too-many-branches,PLE25	bidirectional-unicode,PLR0206	property-with-parameters,PLR2	magic-value-comparison,PLW012	useless-else-on-loop,PLE06	,PLE250	bidirectional-unicode,PLR09	,PLE0605	invalid-all-format,PLR0133	comparison-of-constant,PLR040	consider-using-from-import,PLE11	await-outside-async,PLR2004	magic-value-comparison,PLR1701	consider-merging-isinstance,PLE114	await-outside-async,PLE13	,PLR0915	too-many-statements,PLE010	,PLR172	consider-using-sys-exit,PLE1307	bad-string-format-type,PLE01	,PLE1206	logging-too-few-args,PLC30	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE2502	bidirectional-unicode,PLR0911	too-many-return-statements,PLC04	useless-import-alias,PLR1	,PLW290	redefined-loop-name,PLE0101	return-in-init,PLE060	,PLW0120	useless-else-on-loop,PLE12	,PLW06	global-variable-not-assigned,PLE0604	invalid-all-object,PLR0402	consider-using-from-import,PLR013	comparison-of-constant,PLR01	comparison-of-constant,PLW	,PLE130	bad-string-format-type,PLR17	,PLW2901	redefined-loop-name,PLC3002	unnecessary-direct-lambda-call,PLC041	useless-import-alias,PLE0117	nonlocal-without-binding,PLE1142	await-outside-async,PLR0913	too-many-arguments,PLW060	global-variable-not-assigned,PLE	,PLE120	,PLR20	magic-value-comparison,PLE0118	used-prior-global-declaration,PLC0	useless-import-alias,PLE1310	bad-str-strip-call,PLC	,PLR04	consider-using-from-import,PLR0	,PLW01	useless-else-on-loop,PLE011	,PLE131	bad-str-strip-call,PLC300	unnecessary-direct-lambda-call,PLR020	property-with-parameters,PLW0	,PLE1	,PLC0414	useless-import-alias,PLR	,PLW2	redefined-loop-name,PLR1722	consider-using-sys-exit,PLE0	,PLW29	redefined-loop-name,PLR02	property-with-parameters,PLR200	magic-value-comparison,PLE2	bidirectional-unicode,UP007	typing-union,UP003	type-of-primitive,UP014	convert-named-tuple-functional-to-class,UP001	useless-metaclass-type,UP030	format-literals,UP015	redundant-open-modes,UP032	f-string,UP0	,UP012	unnecessary-encode-utf8,UP00	,UP008	super-call-with-parameters,UP017	datetime-timezone-utc,UP026	rewrite-mock-import,UP009	utf8-encoding-declaration,UP005	deprecated-unittest-alias,UP010	unnecessary-future-import,UP021	replace-universal-newlines,UP018	native-literals,UP036	outdated-version-block,UP020	open-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP019	typing-text-str-alias,UP034	extraneous-parentheses,UP024	os-error-alias,UP029	unnecessary-builtin-import,UP035	import-replacements,UP033	functools-cache,UP01	,UP011	lru-cache-without-parameters,UP023	rewrite-c-element-tree,UP02	,UP022	replace-stdout-stderr,UP006	deprecated-collection-type,UP028	rewrite-yield-from,UP037	quoted-annotation,UP025	rewrite-unicode-literal,UP03	,UP031	printf-string-formatting,UP027	rewrite-list-comprehension,RUF00	,RUF001	ambiguous-unicode-character-string,RUF004	keyword-argument-before-star-argument,RUF006	asyncio-dangling-task,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF100	unused-noqa,RUF10	unused-noqa,RUF003	ambiguous-unicode-character-comment,RUF002	ambiguous-unicode-character-docstring,RUF0	,RUF1	unused-noqa,TRY200	reraise-no-cause,TRY300	try-consider-else,TRY401	verbose-log-message,TRY00	,TRY40	,TRY2	,TRY0	,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY30	,TRY400	error-instead-of-exception,TRY3	,TRY4	,TRY003	raise-vanilla-args,TRY004	prefer-type-error,TRY301	raise-within-try,TRY20	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l per-file-ignores -d 'List of mappings from file pattern to code to exclude' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l exclude -d 'List of paths, used to omit files and/or directories from analysis' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l extend-exclude -d 'Like --exclude, but adds additional files and directories on top of those already excluded' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l fixable -d 'List of rule codes to treat as eligible for autofix. Only applicable when autofix itself is enabled (e.g., via `--fix`)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA0	commented-out-code,ERA001	commented-out-code,ERA00	commented-out-code,YTT1	,YTT301	sys-version0-referenced,YTT2	,YTT20	,YTT202	six-py3-referenced,YTT201	sys-version-info0-eq3-referenced,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT203	sys-version-info1-cmp-int,YTT3	,YTT103	sys-version-cmp-str3,YTT10	,YTT30	,YTT303	sys-version-slice1-referenced,ANN2	,ANN201	missing-return-type-public-function,ANN206	missing-return-type-class-method,ANN002	missing-type-args,ANN4	any-type,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN40	any-type,ANN205	missing-return-type-static-method,ANN001	missing-type-function-argument,ANN102	missing-type-cls,ANN0	,ANN202	missing-return-type-private-function,ANN10	,ANN20	,ANN00	,ANN204	missing-return-type-special-method,ANN401	any-type,ANN1	,S61	logging-config-insecure-listen,S5	,S7	jinja2-autoescape-false,S501	request-with-no-cert-validation,S324	hashlib-insecure-hash-function,S70	jinja2-autoescape-false,S105	hardcoded-password-string,S10	,S32	hashlib-insecure-hash-function,S11	,S506	unsafe-yaml-load,S112	try-except-continue,S508	snmp-insecure-version,S106	hardcoded-password-func-arg,S108	hardcoded-temp-file,S107	hardcoded-password-default,S1	,S509	snmp-weak-cryptography,S103	bad-file-permissions,S113	request-without-timeout,S701	jinja2-autoescape-false,S608	hardcoded-sql-expression,S6	,S60	hardcoded-sql-expression,S104	hardcoded-bind-all-interfaces,S102	exec-builtin,S3	hashlib-insecure-hash-function,S50	,S612	logging-config-insecure-listen,S110	try-except-pass,S101	assert,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT0	,FBT002	boolean-default-value-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT001	boolean-positional-arg-in-function-definition,FBT00	,B905	zip-without-explicit-strict,B01	,B002	unary-prefix-increment,B013	redundant-tuple-in-exception-handler,B021	f-string-docstring,B014	duplicate-handler-exception,B025	duplicate-try-block-exception,B03	unintentional-type-annotation,B90	,B011	assert-false,B010	set-attr-with-constant,B004	unreliable-callable-check,B015	useless-comparison,B019	cached-instance-method,B00	,B023	function-uses-loop-variable,B02	,B018	useless-expression,B016	cannot-raise-literal,B003	assignment-to-os-environ,B008	function-call-argument-default,B026	star-arg-unpacking-after-keyword-arg,B007	unused-loop-control-variable,B029	except-with-empty-tuple,B904	raise-without-from-inside-except,B032	unintentional-type-annotation,B012	jump-statement-in-finally,B022	useless-contextlib-suppress,B005	strip-with-multi-characters,B009	get-attr-with-constant,B017	assert-raises-exception,B020	loop-variable-overrides-iterator,B0	,B006	mutable-argument-default,B024	abstract-base-class-without-abstract-method,B027	empty-method-without-abstract-decorator,B9	,A002	builtin-argument-shadowing,A001	builtin-variable-shadowing,A0	,A00	,A003	builtin-attribute-shadowing,COM81	,COM812	trailing-comma-missing,COM819	trailing-comma-prohibited,COM818	trailing-comma-on-bare-tuple-prohibited,COM8	,C408	unnecessary-collection-call,C40	,C414	unnecessary-double-cast-or-process,C41	,C402	unnecessary-generator-dict,C410	unnecessary-literal-within-list-call,C405	unnecessary-literal-set,C403	unnecessary-list-comprehension-set,C409	unnecessary-literal-within-tuple-call,C415	unnecessary-subscript-reversal,C400	unnecessary-generator-list,C411	unnecessary-list-call,C406	unnecessary-literal-dict,C413	unnecessary-call-around-sorted,C404	unnecessary-list-comprehension-dict,C416	unnecessary-comprehension,C401	unnecessary-generator-set,C417	unnecessary-map,DTZ007	call-datetime-strptime-without-zone,DTZ00	,DTZ002	call-datetime-today,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ003	call-datetime-utcnow,DTZ001	call-datetime-without-tzinfo,DTZ004	call-datetime-utcfromtimestamp,DTZ0	,DTZ01	,T100	debugger,DJ013	non-leading-receiver-decorator,DJ00	,DJ001	nullable-model-string-field,DJ01	non-leading-receiver-decorator,DJ008	model-without-dunder-str,DJ0	,EM101	raw-string-in-exception,EM10	,EM103	dot-format-in-exception,EM102	f-string-in-exception,EM1	,EXE003	shebang-python,EXE001	shebang-not-executable,EXE004	shebang-whitespace,EXE0	,EXE00	,EXE005	shebang-newline,EXE002	shebang-missing-executable-file,ISC0	,ISC002	multi-line-implicit-string-concatenation,ISC00	,ISC001	single-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN0	unconventional-import-alias,ICN00	unconventional-import-alias,ICN001	unconventional-import-alias,G001	logging-string-format,G101	logging-extra-attr-clash,G01	logging-warn,G010	logging-warn,G201	logging-exc-info,G1	logging-extra-attr-clash,G004	logging-f-string,G202	logging-redundant-exc-info,G003	logging-string-concat,G2	,G00	,G0	,G20	,G002	logging-percent-format,G10	logging-extra-attr-clash,INP0	implicit-namespace-package,INP001	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE7	,PIE807	prefer-list-builtin,PIE79	,PIE810	single-starts-ends-with,PIE790	unnecessary-pass,PIE81	single-starts-ends-with,PIE80	,PIE796	prefer-unique-enums,PIE794	dupe-class-field-definitions,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,T203	p-print-found,T201	print-found,PYI008	unrecognized-platform-name,PYI00	,PYI001	prefix-type-params,PYI007	unrecognized-platform-check,PYI0	,PT018	composite-assertion,PT02	,PT006	parametrize-names-wrong-type,PT017	assert-in-except,PT0	,PT023	incorrect-mark-parentheses-style,PT021	fixture-finalizer-callback,PT016	fail-without-message,PT00	,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT020	deprecated-yield-fixture,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT009	unittest-assertion,PT001	incorrect-fixture-parentheses-style,PT002	fixture-positional-args,PT013	incorrect-pytest-import,PT010	raises-without-exception,PT026	use-fixtures-without-parameters,PT003	extraneous-scope-function,PT015	assert-always-false,PT005	incorrect-fixture-name-underscore,PT024	unnecessary-asyncio-mark-on-fixture,PT022	useless-yield-fixture,PT025	erroneous-use-fixtures-on-fixture,PT01	,PT011	raises-too-broad,PT008	patch-with-lambda,Q00	,Q000	bad-quotes-inline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q001	bad-quotes-multiline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET504	unnecessary-assign,RET507	superfluous-else-continue,RET503	implicit-return,RET5	,RET506	superfluous-else-raise,RET50	,RET502	implicit-return-value,RET508	superfluous-else-break,RET505	superfluous-else-return,SLF0	private-member-access,SLF00	private-member-access,SLF001	private-member-access,SIM208	double-negation,SIM117	multiple-with-statements,SIM201	negate-equal-op,SIM110	reimplemented-builtin,SIM107	return-in-try-except-finally,SIM223	and-false,SIM40	dict-get-with-default,SIM2	,SIM401	dict-get-with-default,SIM10	,SIM109	compare-with-tuple,SIM20	,SIM202	negate-not-equal-op,SIM221	a-or-not-a,SIM220	a-and-not-a,SIM11	,SIM212	if-expr-with-twisted-arms,SIM3	yoda-conditions,SIM102	collapsible-if,SIM105	use-contextlib-suppress,SIM103	needless-bool,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM21	,SIM30	yoda-conditions,SIM300	yoda-conditions,SIM112	use-capital-environment-variables,SIM22	,SIM118	key-in-dict,SIM108	use-ternary-operator,SIM101	duplicate-isinstance-call,SIM4	dict-get-with-default,SIM1	,SIM222	or-true,SIM116	manual-dict-lookup,SIM211	if-expr-with-false-true,SIM210	if-expr-with-true-false,TID252	relative-imports,TID251	banned-api,TID2	,TID25	,TCH005	empty-type-checking-block,TCH002	typing-only-third-party-import,TCH00	,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH001	typing-only-first-party-import,ARG0	,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG00	,ARG004	unused-static-method-argument,ARG002	unused-method-argument,ARG005	unused-lambda-argument,PTH102	pathlib-mkdir,PTH106	pathlib-rmdir,PTH11	,PTH103	pathlib-makedirs,PTH100	pathlib-abspath,PTH110	pathlib-exists,PTH120	pathlib-dirname,PTH12	,PTH104	pathlib-rename,PTH114	pathlib-is-link,PTH113	pathlib-is-file,PTH10	,PTH105	pathlib-replace,PTH1	,PTH118	pathlib-join,PTH117	pathlib-is-abs,PTH119	pathlib-basename,PTH121	pathlib-samefile,PTH123	pathlib-open,PTH122	pathlib-splitext,PTH108	pathlib-unlink,PTH112	pathlib-is-dir,PTH111	pathlib-expanduser,PTH107	pathlib-remove,PTH101	pathlib-chmod,PTH109	pathlib-getcwd,PTH124	pathlib-py-path,PTH115	pathlib-readlink,PTH116	pathlib-stat,I002	missing-required-import,I0	,I00	,I001	unsorted-imports,C901	complex-structure,NPY002	numpy-legacy-random,NPY00	,NPY001	numpy-deprecated-type-alias,NPY0	,N816	mixed-case-variable-in-global-scope,N81	,N802	invalid-function-name,N803	invalid-argument-name,N813	camelcase-imported-as-lowercase,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N811	constant-imported-as-non-constant,N817	camelcase-imported-as-acronym,N804	invalid-first-argument-name-for-class-method,N818	error-suffix-on-exception-name,N8	,N99	invalid-module-name,N801	invalid-class-name,N999	invalid-module-name,N807	dunder-function-name,N9	invalid-module-name,N80	,N814	camelcase-imported-as-constant,PD012	use-of-dot-read-table,PD007	use-of-dot-ix,PD009	use-of-dot-iat,PD004	use-of-dot-not-null,PD9	df-is-a-bad-variable-name,PD008	use-of-dot-at,PD003	use-of-dot-is-null,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD015	use-of-pd-merge,PD00	,PD0	,PD01	,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD011	use-of-dot-values,PD90	df-is-a-bad-variable-name,W2	no-new-line-at-end-of-file,E99	syntax-error,W	,E101	mixed-spaces-and-tabs,E90	io-error,E741	ambiguous-variable-name,E999	syntax-error,E1	mixed-spaces-and-tabs,E7	,E721	type-comparison,W505	doc-line-too-long,E501	line-too-long,E401	multiple-imports-on-one-line,E73	lambda-assignment,W29	no-new-line-at-end-of-file,E902	io-error,E10	mixed-spaces-and-tabs,W50	doc-line-too-long,E72	,E731	lambda-assignment,E711	none-comparison,E402	module-import-not-at-top-of-file,E722	bare-except,E74	,E703	useless-semicolon,W292	no-new-line-at-end-of-file,W60	invalid-escape-sequence,E712	true-false-comparison,E743	ambiguous-function-name,E742	ambiguous-class-name,W605	invalid-escape-sequence,E5	line-too-long,E	,E4	,E70	,E702	multiple-statements-on-one-line-semicolon,E713	not-in-test,E714	not-is-test,E9	,E71	,W5	doc-line-too-long,W6	invalid-escape-sequence,E50	line-too-long,E40	,E701	multiple-statements-on-one-line-colon,D205	blank-line-after-summary,D301	escape-sequence-in-docstring,D203	one-blank-line-before-class,D209	new-line-after-last-paragraph,D212	multi-line-summary-first-line,D101	public-class,D214	section-not-over-indented,D400	ends-in-period,D411	blank-line-before-section,D105	magic-method,D403	first-line-capitalized,D412	no-blank-lines-between-header-and-content,D409	section-underline-matches-section-length,D202	no-blank-line-after-function,D407	dashed-underline-after-section,D413	blank-line-after-last-section,D415	ends-in-punctuation,D102	public-method,D204	one-blank-line-after-class,D207	no-under-indentation,D208	no-over-indentation,D405	capitalize-section-name,D417	undocumented-param,D418	overload-with-docstring,D210	no-surrounding-whitespace,D206	indent-with-spaces,D20	,D104	public-package,D410	blank-line-after-section,D213	multi-line-summary-second-line,D419	empty-docstring,D404	docstring-starts-with-this,D401	non-imperative-mood,D100	public-module,D211	no-blank-line-before-class,D10	,D106	public-nested-class,D1	,D2	,D201	no-blank-line-before-function,D416	section-name-ends-in-colon,D414	empty-docstring-section,D4	,D21	,D103	public-function,D40	,D408	section-underline-after-name,D41	,D215	section-underline-not-over-indented,D3	,D30	,D107	public-init,D402	no-signature,D200	fits-on-one-line,D406	new-line-after-section-name,D300	triple-single-quotes,F541	f-string-missing-placeholders,F504	percent-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F602	multi-value-repeated-key-variable,F404	late-future-import,F72	forward-annotation-syntax-error,F405	import-star-usage,F631	assert-tuple,F63	,F82	,F821	undefined-name,F403	import-star,F502	percent-format-expected-mapping,F505	percent-format-missing-argument,F706	return-outside-function,F54	f-string-missing-placeholders,F8	,F632	is-literal,F522	string-dot-format-extra-named-arguments,F823	undefined-local,F6	,F407	future-feature-not-defined,F81	redefined-while-unused,F701	break-outside-loop,F622	two-starred-expressions,F9	raise-not-implemented,F503	percent-format-expected-sequence,F621	expressions-in-star-assignment,F525	string-dot-format-mixing-automatic,F822	undefined-export,F601	multi-value-repeated-key-literal,F5	,F811	redefined-while-unused,F901	raise-not-implemented,F406	import-star-not-permitted,F508	percent-format-star-requires-sequence,F506	percent-format-mixed-positional-and-named,F524	string-dot-format-missing-arguments,F707	default-except-not-last,F704	yield-outside-function,F633	invalid-print-syntax,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F841	unused-variable,F507	percent-format-positional-count-mismatch,F634	if-tuple,F501	percent-format-invalid-format,F7	,F702	continue-outside-loop,F84	,F402	import-shadowed-by-loop-var,F4	,F401	unused-import,F70	,F722	forward-annotation-syntax-error,F50	,F40	,F52	,F62	,F60	,F842	unused-annotation,F90	raise-not-implemented,PGH001	no-eval,PGH004	blanket-noqa,PGH00	,PGH002	deprecated-log-warn,PGH0	,PGH003	blanket-type-ignore,PLC3	unnecessary-direct-lambda-call,PLR091	,PLR170	consider-merging-isinstance,PLE1205	logging-too-many-args,PLW0602	global-variable-not-assigned,PLR0912	too-many-branches,PLE25	bidirectional-unicode,PLR0206	property-with-parameters,PLR2	magic-value-comparison,PLW012	useless-else-on-loop,PLE06	,PLE250	bidirectional-unicode,PLR09	,PLE0605	invalid-all-format,PLR0133	comparison-of-constant,PLR040	consider-using-from-import,PLE11	await-outside-async,PLR2004	magic-value-comparison,PLR1701	consider-merging-isinstance,PLE114	await-outside-async,PLE13	,PLR0915	too-many-statements,PLE010	,PLR172	consider-using-sys-exit,PLE1307	bad-string-format-type,PLE01	,PLE1206	logging-too-few-args,PLC30	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE2502	bidirectional-unicode,PLR0911	too-many-return-statements,PLC04	useless-import-alias,PLR1	,PLW290	redefined-loop-name,PLE0101	return-in-init,PLE060	,PLW0120	useless-else-on-loop,PLE12	,PLW06	global-variable-not-assigned,PLE0604	invalid-all-object,PLR0402	consider-using-from-import,PLR013	comparison-of-constant,PLR01	comparison-of-constant,PLW	,PLE130	bad-string-format-type,PLR17	,PLW2901	redefined-loop-name,PLC3002	unnecessary-direct-lambda-call,PLC041	useless-import-alias,PLE0117	nonlocal-without-binding,PLE1142	await-outside-async,PLR0913	too-many-arguments,PLW060	global-variable-not-assigned,PLE	,PLE120	,PLR20	magic-value-comparison,PLE0118	used-prior-global-declaration,PLC0	useless-import-alias,PLE1310	bad-str-strip-call,PLC	,PLR04	consider-using-from-import,PLR0	,PLW01	useless-else-on-loop,PLE011	,PLE131	bad-str-strip-call,PLC300	unnecessary-direct-lambda-call,PLR020	property-with-parameters,PLW0	,PLE1	,PLC0414	useless-import-alias,PLR	,PLW2	redefined-loop-name,PLR1722	consider-using-sys-exit,PLE0	,PLW29	redefined-loop-name,PLR02	property-with-parameters,PLR200	magic-value-comparison,PLE2	bidirectional-unicode,UP007	typing-union,UP003	type-of-primitive,UP014	convert-named-tuple-functional-to-class,UP001	useless-metaclass-type,UP030	format-literals,UP015	redundant-open-modes,UP032	f-string,UP0	,UP012	unnecessary-encode-utf8,UP00	,UP008	super-call-with-parameters,UP017	datetime-timezone-utc,UP026	rewrite-mock-import,UP009	utf8-encoding-declaration,UP005	deprecated-unittest-alias,UP010	unnecessary-future-import,UP021	replace-universal-newlines,UP018	native-literals,UP036	outdated-version-block,UP020	open-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP019	typing-text-str-alias,UP034	extraneous-parentheses,UP024	os-error-alias,UP029	unnecessary-builtin-import,UP035	import-replacements,UP033	functools-cache,UP01	,UP011	lru-cache-without-parameters,UP023	rewrite-c-element-tree,UP02	,UP022	replace-stdout-stderr,UP006	deprecated-collection-type,UP028	rewrite-yield-from,UP037	quoted-annotation,UP025	rewrite-unicode-literal,UP03	,UP031	printf-string-formatting,UP027	rewrite-list-comprehension,RUF00	,RUF001	ambiguous-unicode-character-string,RUF004	keyword-argument-before-star-argument,RUF006	asyncio-dangling-task,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF100	unused-noqa,RUF10	unused-noqa,RUF003	ambiguous-unicode-character-comment,RUF002	ambiguous-unicode-character-docstring,RUF0	,RUF1	unused-noqa,TRY200	reraise-no-cause,TRY300	try-consider-else,TRY401	verbose-log-message,TRY00	,TRY40	,TRY2	,TRY0	,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY30	,TRY400	error-instead-of-exception,TRY3	,TRY4	,TRY003	raise-vanilla-args,TRY004	prefer-type-error,TRY301	raise-within-try,TRY20	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l unfixable -d 'List of rule codes to treat as ineligible for autofix. Only applicable when autofix itself is enabled (e.g., via `--fix`)' -r -f -a "{ALL	all rules,F	Pyflakes,C90	mccabe,I	isort,N	pep8-naming,D	pydocstyle,UP	pyupgrade,YTT	flake8-2020,ANN	flake8-annotations,S	flake8-bandit,BLE	flake8-blind-except,FBT	flake8-boolean-trap,B	flake8-bugbear,A	flake8-builtins,COM	flake8-commas,C4	flake8-comprehensions,DTZ	flake8-datetimez,T10	flake8-debugger,DJ	flake8-django,EM	flake8-errmsg,EXE	flake8-executable,ISC	flake8-implicit-str-concat,ICN	flake8-import-conventions,G	flake8-logging-format,INP	flake8-no-pep420,PIE	flake8-pie,T20	flake8-print,PYI	flake8-pyi,PT	flake8-pytest-style,Q	flake8-quotes,RSE	flake8-raise,RET	flake8-return,SLF	flake8-self,SIM	flake8-simplify,TID	flake8-tidy-imports,TCH	flake8-type-checking,ARG	flake8-unused-arguments,PTH	flake8-use-pathlib,ERA	eradicate,PD	pandas-vet,PGH	pygrep-hooks,PL	Pylint,TRY	tryceratops,NPY	NumPy-specific rules,RUF	Ruff-specific rules,ERA0	commented-out-code,ERA001	commented-out-code,ERA00	commented-out-code,YTT1	,YTT301	sys-version0-referenced,YTT2	,YTT20	,YTT202	six-py3-referenced,YTT201	sys-version-info0-eq3-referenced,YTT102	sys-version2-referenced,YTT101	sys-version-slice3-referenced,YTT302	sys-version-cmp-str10,YTT204	sys-version-info-minor-cmp-int,YTT203	sys-version-info1-cmp-int,YTT3	,YTT103	sys-version-cmp-str3,YTT10	,YTT30	,YTT303	sys-version-slice1-referenced,ANN2	,ANN201	missing-return-type-public-function,ANN206	missing-return-type-class-method,ANN002	missing-type-args,ANN4	any-type,ANN003	missing-type-kwargs,ANN101	missing-type-self,ANN40	any-type,ANN205	missing-return-type-static-method,ANN001	missing-type-function-argument,ANN102	missing-type-cls,ANN0	,ANN202	missing-return-type-private-function,ANN10	,ANN20	,ANN00	,ANN204	missing-return-type-special-method,ANN401	any-type,ANN1	,S61	logging-config-insecure-listen,S5	,S7	jinja2-autoescape-false,S501	request-with-no-cert-validation,S324	hashlib-insecure-hash-function,S70	jinja2-autoescape-false,S105	hardcoded-password-string,S10	,S32	hashlib-insecure-hash-function,S11	,S506	unsafe-yaml-load,S112	try-except-continue,S508	snmp-insecure-version,S106	hardcoded-password-func-arg,S108	hardcoded-temp-file,S107	hardcoded-password-default,S1	,S509	snmp-weak-cryptography,S103	bad-file-permissions,S113	request-without-timeout,S701	jinja2-autoescape-false,S608	hardcoded-sql-expression,S6	,S60	hardcoded-sql-expression,S104	hardcoded-bind-all-interfaces,S102	exec-builtin,S3	hashlib-insecure-hash-function,S50	,S612	logging-config-insecure-listen,S110	try-except-pass,S101	assert,BLE0	blind-except,BLE001	blind-except,BLE00	blind-except,FBT0	,FBT002	boolean-default-value-in-function-definition,FBT003	boolean-positional-value-in-function-call,FBT001	boolean-positional-arg-in-function-definition,FBT00	,B905	zip-without-explicit-strict,B01	,B002	unary-prefix-increment,B013	redundant-tuple-in-exception-handler,B021	f-string-docstring,B014	duplicate-handler-exception,B025	duplicate-try-block-exception,B03	unintentional-type-annotation,B90	,B011	assert-false,B010	set-attr-with-constant,B004	unreliable-callable-check,B015	useless-comparison,B019	cached-instance-method,B00	,B023	function-uses-loop-variable,B02	,B018	useless-expression,B016	cannot-raise-literal,B003	assignment-to-os-environ,B008	function-call-argument-default,B026	star-arg-unpacking-after-keyword-arg,B007	unused-loop-control-variable,B029	except-with-empty-tuple,B904	raise-without-from-inside-except,B032	unintentional-type-annotation,B012	jump-statement-in-finally,B022	useless-contextlib-suppress,B005	strip-with-multi-characters,B009	get-attr-with-constant,B017	assert-raises-exception,B020	loop-variable-overrides-iterator,B0	,B006	mutable-argument-default,B024	abstract-base-class-without-abstract-method,B027	empty-method-without-abstract-decorator,B9	,A002	builtin-argument-shadowing,A001	builtin-variable-shadowing,A0	,A00	,A003	builtin-attribute-shadowing,COM81	,COM812	trailing-comma-missing,COM819	trailing-comma-prohibited,COM818	trailing-comma-on-bare-tuple-prohibited,COM8	,C408	unnecessary-collection-call,C40	,C414	unnecessary-double-cast-or-process,C41	,C402	unnecessary-generator-dict,C410	unnecessary-literal-within-list-call,C405	unnecessary-literal-set,C403	unnecessary-list-comprehension-set,C409	unnecessary-literal-within-tuple-call,C415	unnecessary-subscript-reversal,C400	unnecessary-generator-list,C411	unnecessary-list-call,C406	unnecessary-literal-dict,C413	unnecessary-call-around-sorted,C404	unnecessary-list-comprehension-dict,C416	unnecessary-comprehension,C401	unnecessary-generator-set,C417	unnecessary-map,DTZ007	call-datetime-strptime-without-zone,DTZ00	,DTZ002	call-datetime-today,DTZ011	call-date-today,DTZ012	call-date-fromtimestamp,DTZ005	call-datetime-now-without-tzinfo,DTZ006	call-datetime-fromtimestamp,DTZ003	call-datetime-utcnow,DTZ001	call-datetime-without-tzinfo,DTZ004	call-datetime-utcfromtimestamp,DTZ0	,DTZ01	,T100	debugger,DJ013	non-leading-receiver-decorator,DJ00	,DJ001	nullable-model-string-field,DJ01	non-leading-receiver-decorator,DJ008	model-without-dunder-str,DJ0	,EM101	raw-string-in-exception,EM10	,EM103	dot-format-in-exception,EM102	f-string-in-exception,EM1	,EXE003	shebang-python,EXE001	shebang-not-executable,EXE004	shebang-whitespace,EXE0	,EXE00	,EXE005	shebang-newline,EXE002	shebang-missing-executable-file,ISC0	,ISC002	multi-line-implicit-string-concatenation,ISC00	,ISC001	single-line-implicit-string-concatenation,ISC003	explicit-string-concatenation,ICN0	unconventional-import-alias,ICN00	unconventional-import-alias,ICN001	unconventional-import-alias,G001	logging-string-format,G101	logging-extra-attr-clash,G01	logging-warn,G010	logging-warn,G201	logging-exc-info,G1	logging-extra-attr-clash,G004	logging-f-string,G202	logging-redundant-exc-info,G003	logging-string-concat,G2	,G00	,G0	,G20	,G002	logging-percent-format,G10	logging-extra-attr-clash,INP0	implicit-namespace-package,INP001	implicit-namespace-package,INP00	implicit-namespace-package,PIE8	,PIE7	,PIE807	prefer-list-builtin,PIE79	,PIE810	single-starts-ends-with,PIE790	unnecessary-pass,PIE81	single-starts-ends-with,PIE80	,PIE796	prefer-unique-enums,PIE794	dupe-class-field-definitions,PIE800	unnecessary-spread,PIE804	unnecessary-dict-kwargs,T203	p-print-found,T201	print-found,PYI008	unrecognized-platform-name,PYI00	,PYI001	prefix-type-params,PYI007	unrecognized-platform-check,PYI0	,PT018	composite-assertion,PT02	,PT006	parametrize-names-wrong-type,PT017	assert-in-except,PT0	,PT023	incorrect-mark-parentheses-style,PT021	fixture-finalizer-callback,PT016	fail-without-message,PT00	,PT004	missing-fixture-name-underscore,PT019	fixture-param-without-value,PT020	deprecated-yield-fixture,PT007	parametrize-values-wrong-type,PT012	raises-with-multiple-statements,PT009	unittest-assertion,PT001	incorrect-fixture-parentheses-style,PT002	fixture-positional-args,PT013	incorrect-pytest-import,PT010	raises-without-exception,PT026	use-fixtures-without-parameters,PT003	extraneous-scope-function,PT015	assert-always-false,PT005	incorrect-fixture-name-underscore,PT024	unnecessary-asyncio-mark-on-fixture,PT022	useless-yield-fixture,PT025	erroneous-use-fixtures-on-fixture,PT01	,PT011	raises-too-broad,PT008	patch-with-lambda,Q00	,Q000	bad-quotes-inline-string,Q002	bad-quotes-docstring,Q003	avoidable-escaped-quote,Q0	,Q001	bad-quotes-multiline-string,RSE102	unnecessary-paren-on-raise-exception,RSE1	unnecessary-paren-on-raise-exception,RSE10	unnecessary-paren-on-raise-exception,RET501	unnecessary-return-none,RET504	unnecessary-assign,RET507	superfluous-else-continue,RET503	implicit-return,RET5	,RET506	superfluous-else-raise,RET50	,RET502	implicit-return-value,RET508	superfluous-else-break,RET505	superfluous-else-return,SLF0	private-member-access,SLF00	private-member-access,SLF001	private-member-access,SIM208	double-negation,SIM117	multiple-with-statements,SIM201	negate-equal-op,SIM110	reimplemented-builtin,SIM107	return-in-try-except-finally,SIM223	and-false,SIM40	dict-get-with-default,SIM2	,SIM401	dict-get-with-default,SIM10	,SIM109	compare-with-tuple,SIM20	,SIM202	negate-not-equal-op,SIM221	a-or-not-a,SIM220	a-and-not-a,SIM11	,SIM212	if-expr-with-twisted-arms,SIM3	yoda-conditions,SIM102	collapsible-if,SIM105	use-contextlib-suppress,SIM103	needless-bool,SIM114	if-with-same-arms,SIM115	open-file-with-context-handler,SIM21	,SIM30	yoda-conditions,SIM300	yoda-conditions,SIM112	use-capital-environment-variables,SIM22	,SIM118	key-in-dict,SIM108	use-ternary-operator,SIM101	duplicate-isinstance-call,SIM4	dict-get-with-default,SIM1	,SIM222	or-true,SIM116	manual-dict-lookup,SIM211	if-expr-with-false-true,SIM210	if-expr-with-true-false,TID252	relative-imports,TID251	banned-api,TID2	,TID25	,TCH005	empty-type-checking-block,TCH002	typing-only-third-party-import,TCH00	,TCH0	,TCH003	typing-only-standard-library-import,TCH004	runtime-import-in-type-checking-block,TCH001	typing-only-first-party-import,ARG0	,ARG001	unused-function-argument,ARG003	unused-class-method-argument,ARG00	,ARG004	unused-static-method-argument,ARG002	unused-method-argument,ARG005	unused-lambda-argument,PTH102	pathlib-mkdir,PTH106	pathlib-rmdir,PTH11	,PTH103	pathlib-makedirs,PTH100	pathlib-abspath,PTH110	pathlib-exists,PTH120	pathlib-dirname,PTH12	,PTH104	pathlib-rename,PTH114	pathlib-is-link,PTH113	pathlib-is-file,PTH10	,PTH105	pathlib-replace,PTH1	,PTH118	pathlib-join,PTH117	pathlib-is-abs,PTH119	pathlib-basename,PTH121	pathlib-samefile,PTH123	pathlib-open,PTH122	pathlib-splitext,PTH108	pathlib-unlink,PTH112	pathlib-is-dir,PTH111	pathlib-expanduser,PTH107	pathlib-remove,PTH101	pathlib-chmod,PTH109	pathlib-getcwd,PTH124	pathlib-py-path,PTH115	pathlib-readlink,PTH116	pathlib-stat,I002	missing-required-import,I0	,I00	,I001	unsorted-imports,C901	complex-structure,NPY002	numpy-legacy-random,NPY00	,NPY001	numpy-deprecated-type-alias,NPY0	,N816	mixed-case-variable-in-global-scope,N81	,N802	invalid-function-name,N803	invalid-argument-name,N813	camelcase-imported-as-lowercase,N812	lowercase-imported-as-non-lowercase,N815	mixed-case-variable-in-class-scope,N805	invalid-first-argument-name-for-method,N806	non-lowercase-variable-in-function,N811	constant-imported-as-non-constant,N817	camelcase-imported-as-acronym,N804	invalid-first-argument-name-for-class-method,N818	error-suffix-on-exception-name,N8	,N99	invalid-module-name,N801	invalid-class-name,N999	invalid-module-name,N807	dunder-function-name,N9	invalid-module-name,N80	,N814	camelcase-imported-as-constant,PD012	use-of-dot-read-table,PD007	use-of-dot-ix,PD009	use-of-dot-iat,PD004	use-of-dot-not-null,PD9	df-is-a-bad-variable-name,PD008	use-of-dot-at,PD003	use-of-dot-is-null,PD002	use-of-inplace-argument,PD010	use-of-dot-pivot-or-unstack,PD015	use-of-pd-merge,PD00	,PD0	,PD01	,PD013	use-of-dot-stack,PD901	df-is-a-bad-variable-name,PD011	use-of-dot-values,PD90	df-is-a-bad-variable-name,W2	no-new-line-at-end-of-file,E99	syntax-error,W	,E101	mixed-spaces-and-tabs,E90	io-error,E741	ambiguous-variable-name,E999	syntax-error,E1	mixed-spaces-and-tabs,E7	,E721	type-comparison,W505	doc-line-too-long,E501	line-too-long,E401	multiple-imports-on-one-line,E73	lambda-assignment,W29	no-new-line-at-end-of-file,E902	io-error,E10	mixed-spaces-and-tabs,W50	doc-line-too-long,E72	,E731	lambda-assignment,E711	none-comparison,E402	module-import-not-at-top-of-file,E722	bare-except,E74	,E703	useless-semicolon,W292	no-new-line-at-end-of-file,W60	invalid-escape-sequence,E712	true-false-comparison,E743	ambiguous-function-name,E742	ambiguous-class-name,W605	invalid-escape-sequence,E5	line-too-long,E	,E4	,E70	,E702	multiple-statements-on-one-line-semicolon,E713	not-in-test,E714	not-is-test,E9	,E71	,W5	doc-line-too-long,W6	invalid-escape-sequence,E50	line-too-long,E40	,E701	multiple-statements-on-one-line-colon,D205	blank-line-after-summary,D301	escape-sequence-in-docstring,D203	one-blank-line-before-class,D209	new-line-after-last-paragraph,D212	multi-line-summary-first-line,D101	public-class,D214	section-not-over-indented,D400	ends-in-period,D411	blank-line-before-section,D105	magic-method,D403	first-line-capitalized,D412	no-blank-lines-between-header-and-content,D409	section-underline-matches-section-length,D202	no-blank-line-after-function,D407	dashed-underline-after-section,D413	blank-line-after-last-section,D415	ends-in-punctuation,D102	public-method,D204	one-blank-line-after-class,D207	no-under-indentation,D208	no-over-indentation,D405	capitalize-section-name,D417	undocumented-param,D418	overload-with-docstring,D210	no-surrounding-whitespace,D206	indent-with-spaces,D20	,D104	public-package,D410	blank-line-after-section,D213	multi-line-summary-second-line,D419	empty-docstring,D404	docstring-starts-with-this,D401	non-imperative-mood,D100	public-module,D211	no-blank-line-before-class,D10	,D106	public-nested-class,D1	,D2	,D201	no-blank-line-before-function,D416	section-name-ends-in-colon,D414	empty-docstring-section,D4	,D21	,D103	public-function,D40	,D408	section-underline-after-name,D41	,D215	section-underline-not-over-indented,D3	,D30	,D107	public-init,D402	no-signature,D200	fits-on-one-line,D406	new-line-after-section-name,D300	triple-single-quotes,F541	f-string-missing-placeholders,F504	percent-format-extra-named-arguments,F523	string-dot-format-extra-positional-arguments,F602	multi-value-repeated-key-variable,F404	late-future-import,F72	forward-annotation-syntax-error,F405	import-star-usage,F631	assert-tuple,F63	,F82	,F821	undefined-name,F403	import-star,F502	percent-format-expected-mapping,F505	percent-format-missing-argument,F706	return-outside-function,F54	f-string-missing-placeholders,F8	,F632	is-literal,F522	string-dot-format-extra-named-arguments,F823	undefined-local,F6	,F407	future-feature-not-defined,F81	redefined-while-unused,F701	break-outside-loop,F622	two-starred-expressions,F9	raise-not-implemented,F503	percent-format-expected-sequence,F621	expressions-in-star-assignment,F525	string-dot-format-mixing-automatic,F822	undefined-export,F601	multi-value-repeated-key-literal,F5	,F811	redefined-while-unused,F901	raise-not-implemented,F406	import-star-not-permitted,F508	percent-format-star-requires-sequence,F506	percent-format-mixed-positional-and-named,F524	string-dot-format-missing-arguments,F707	default-except-not-last,F704	yield-outside-function,F633	invalid-print-syntax,F509	percent-format-unsupported-format-character,F521	string-dot-format-invalid-format,F841	unused-variable,F507	percent-format-positional-count-mismatch,F634	if-tuple,F501	percent-format-invalid-format,F7	,F702	continue-outside-loop,F84	,F402	import-shadowed-by-loop-var,F4	,F401	unused-import,F70	,F722	forward-annotation-syntax-error,F50	,F40	,F52	,F62	,F60	,F842	unused-annotation,F90	raise-not-implemented,PGH001	no-eval,PGH004	blanket-noqa,PGH00	,PGH002	deprecated-log-warn,PGH0	,PGH003	blanket-type-ignore,PLC3	unnecessary-direct-lambda-call,PLR091	,PLR170	consider-merging-isinstance,PLE1205	logging-too-many-args,PLW0602	global-variable-not-assigned,PLR0912	too-many-branches,PLE25	bidirectional-unicode,PLR0206	property-with-parameters,PLR2	magic-value-comparison,PLW012	useless-else-on-loop,PLE06	,PLE250	bidirectional-unicode,PLR09	,PLE0605	invalid-all-format,PLR0133	comparison-of-constant,PLR040	consider-using-from-import,PLE11	await-outside-async,PLR2004	magic-value-comparison,PLR1701	consider-merging-isinstance,PLE114	await-outside-async,PLE13	,PLR0915	too-many-statements,PLE010	,PLR172	consider-using-sys-exit,PLE1307	bad-string-format-type,PLE01	,PLE1206	logging-too-few-args,PLC30	unnecessary-direct-lambda-call,PLE0100	yield-in-init,PLE2502	bidirectional-unicode,PLR0911	too-many-return-statements,PLC04	useless-import-alias,PLR1	,PLW290	redefined-loop-name,PLE0101	return-in-init,PLE060	,PLW0120	useless-else-on-loop,PLE12	,PLW06	global-variable-not-assigned,PLE0604	invalid-all-object,PLR0402	consider-using-from-import,PLR013	comparison-of-constant,PLR01	comparison-of-constant,PLW	,PLE130	bad-string-format-type,PLR17	,PLW2901	redefined-loop-name,PLC3002	unnecessary-direct-lambda-call,PLC041	useless-import-alias,PLE0117	nonlocal-without-binding,PLE1142	await-outside-async,PLR0913	too-many-arguments,PLW060	global-variable-not-assigned,PLE	,PLE120	,PLR20	magic-value-comparison,PLE0118	used-prior-global-declaration,PLC0	useless-import-alias,PLE1310	bad-str-strip-call,PLC	,PLR04	consider-using-from-import,PLR0	,PLW01	useless-else-on-loop,PLE011	,PLE131	bad-str-strip-call,PLC300	unnecessary-direct-lambda-call,PLR020	property-with-parameters,PLW0	,PLE1	,PLC0414	useless-import-alias,PLR	,PLW2	redefined-loop-name,PLR1722	consider-using-sys-exit,PLE0	,PLW29	redefined-loop-name,PLR02	property-with-parameters,PLR200	magic-value-comparison,PLE2	bidirectional-unicode,UP007	typing-union,UP003	type-of-primitive,UP014	convert-named-tuple-functional-to-class,UP001	useless-metaclass-type,UP030	format-literals,UP015	redundant-open-modes,UP032	f-string,UP0	,UP012	unnecessary-encode-utf8,UP00	,UP008	super-call-with-parameters,UP017	datetime-timezone-utc,UP026	rewrite-mock-import,UP009	utf8-encoding-declaration,UP005	deprecated-unittest-alias,UP010	unnecessary-future-import,UP021	replace-universal-newlines,UP018	native-literals,UP036	outdated-version-block,UP020	open-alias,UP004	useless-object-inheritance,UP013	convert-typed-dict-functional-to-class,UP019	typing-text-str-alias,UP034	extraneous-parentheses,UP024	os-error-alias,UP029	unnecessary-builtin-import,UP035	import-replacements,UP033	functools-cache,UP01	,UP011	lru-cache-without-parameters,UP023	rewrite-c-element-tree,UP02	,UP022	replace-stdout-stderr,UP006	deprecated-collection-type,UP028	rewrite-yield-from,UP037	quoted-annotation,UP025	rewrite-unicode-literal,UP03	,UP031	printf-string-formatting,UP027	rewrite-list-comprehension,RUF00	,RUF001	ambiguous-unicode-character-string,RUF004	keyword-argument-before-star-argument,RUF006	asyncio-dangling-task,RUF005	unpack-instead-of-concatenating-to-collection-literal,RUF100	unused-noqa,RUF10	unused-noqa,RUF003	ambiguous-unicode-character-comment,RUF002	ambiguous-unicode-character-docstring,RUF0	,RUF1	unused-noqa,TRY200	reraise-no-cause,TRY300	try-consider-else,TRY401	verbose-log-message,TRY00	,TRY40	,TRY2	,TRY0	,TRY201	verbose-raise,TRY002	raise-vanilla-class,TRY30	,TRY400	error-instead-of-exception,TRY3	,TRY4	,TRY003	raise-vanilla-args,TRY004	prefer-type-error,TRY301	raise-within-try,TRY20	}"
complete -c ruff -n "__fish_seen_subcommand_from check" -l line-length -d 'Set the line-length for length-associated rules and automatic formatting' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l dummy-variable-rgx -d 'Regular expression matching the name of dummy variables' -r
complete -c ruff -n "__fish_seen_subcommand_from check" -l cache-dir -d 'Path to the cache directory' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l stdin-filename -d 'The name of the file when passing it through stdin' -r -F
complete -c ruff -n "__fish_seen_subcommand_from check" -l fix -d 'Attempt to automatically fix lint violations'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-fix
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-source -d 'Show violations with source code'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-show-source
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-fixes -d 'Show an enumeration of all autofixed lint violations'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-show-fixes
complete -c ruff -n "__fish_seen_subcommand_from check" -l diff -d 'Avoid writing any fixed files back; instead, output a diff for each changed file to stdout'
complete -c ruff -n "__fish_seen_subcommand_from check" -s w -l watch -d 'Run in watch mode by re-running whenever files change'
complete -c ruff -n "__fish_seen_subcommand_from check" -l fix-only -d 'Fix any fixable lint violations, but don\'t report on leftover violations. Implies `--fix`'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-fix-only
complete -c ruff -n "__fish_seen_subcommand_from check" -l respect-gitignore -d 'Respect file exclusions via `.gitignore` and other standard ignore files'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-respect-gitignore
complete -c ruff -n "__fish_seen_subcommand_from check" -l force-exclude -d 'Enforce exclusions, even for paths passed to Ruff directly on the command-line'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-force-exclude
complete -c ruff -n "__fish_seen_subcommand_from check" -s n -l no-cache -d 'Disable cache reads'
complete -c ruff -n "__fish_seen_subcommand_from check" -l isolated -d 'Ignore all configuration files'
complete -c ruff -n "__fish_seen_subcommand_from check" -s e -l exit-zero -d 'Exit with status code "0", even upon detecting lint violations'
complete -c ruff -n "__fish_seen_subcommand_from check" -l exit-non-zero-on-fix -d 'Exit with a non-zero status code if any files were modified via autofix, even if no lint violations remain'
complete -c ruff -n "__fish_seen_subcommand_from check" -l update-check -d 'Does nothing and will be removed in the future'
complete -c ruff -n "__fish_seen_subcommand_from check" -l no-update-check
complete -c ruff -n "__fish_seen_subcommand_from check" -l statistics -d 'Show counts for every rule with at least one violation'
complete -c ruff -n "__fish_seen_subcommand_from check" -l add-noqa -d 'Enable automatic additions of `noqa` directives to failing lines'
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-files -d 'See the files Ruff will be run against with the current settings'
complete -c ruff -n "__fish_seen_subcommand_from check" -l show-settings -d 'See the settings Ruff will use to lint a given Python file'
complete -c ruff -n "__fish_seen_subcommand_from check" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from check" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from check" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from check" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from rule" -l format -d 'Output format' -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from rule" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from rule" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from config" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from config" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from config" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from config" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from linter" -l format -d 'Output format' -r -f -a "{text	,json	}"
complete -c ruff -n "__fish_seen_subcommand_from linter" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from linter" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from clean" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s v -l verbose -d 'Enable verbose logging'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s q -l quiet -d 'Print lint violations, but nothing else'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s s -l silent -d 'Disable all logging (but still exit with status code "1" upon detecting lint violations)'
complete -c ruff -n "__fish_seen_subcommand_from generate-shell-completion" -s h -l help -d 'Print help'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "check" -d 'Run Ruff on the given files or directories (default)'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "rule" -d 'Explain a rule'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "config" -d 'List or describe the available configuration options'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "linter" -d 'List all supported upstream linters'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "clean" -d 'Clear any caches in the current directory and any subdirectories'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "generate-shell-completion" -d 'Generate shell completion'
complete -c ruff -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from rule; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from linter; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from generate-shell-completion; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
