/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.ZipFile;
import javax.lang.model.SourceVersion;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJep247;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJep247Jdk12;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJmod;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJrt;
import org.eclipse.jdt.internal.compiler.batch.ClasspathMultiReleaseJar;
import org.eclipse.jdt.internal.compiler.batch.ClasspathSourceJar;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.ModuleFinder;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FileSystem
implements IModuleAwareNameEnvironment,
SuffixConstants {
    public static ArrayList<Classpath> EMPTY_CLASSPATH = new ArrayList();
    protected Classpath[] classpaths;
    protected IModule module;
    Set<String> knownFileNames;
    protected boolean annotationsFromClasspath;
    private static HashMap<File, Classpath> JRT_CLASSPATH_CACHE = null;
    protected Map<String, Classpath> moduleLocations = new HashMap<String, Classpath>();
    Map<String, IUpdatableModule.UpdatesByKind> moduleUpdates = new HashMap<String, IUpdatableModule.UpdatesByKind>();
    static boolean isJRE12Plus = false;
    private boolean hasLimitModules = false;

    public FileSystem(String[] stringArray, String[] stringArray2, String string) {
        this(stringArray, stringArray2, string, null, null);
    }

    public FileSystem(String[] stringArray, String[] stringArray2, String string, String string2) {
        this(stringArray, stringArray2, string, null, string2);
    }

    protected FileSystem(String[] stringArray, String[] stringArray2, String string, Collection<String> collection) {
        this(stringArray, stringArray2, string, collection, null);
    }

    protected FileSystem(String[] stringArray, String[] stringArray2, String string, Collection<String> collection, String string2) {
        int n = stringArray.length;
        this.classpaths = new Classpath[n];
        int n2 = 0;
        this.hasLimitModules = collection != null && !collection.isEmpty();
        for (int i = 0; i < n; ++i) {
            Classpath classpath = FileSystem.getClasspath(stringArray[i], string, null, null, string2);
            try {
                classpath.initialize();
                for (String string3 : classpath.getModuleNames(collection)) {
                    this.moduleLocations.put(string3, classpath);
                }
                this.classpaths[n2++] = classpath;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (n2 != n) {
            this.classpaths = new Classpath[n2];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, n2);
        }
        this.initializeKnownFileNames(stringArray2);
    }

    protected FileSystem(Classpath[] classpathArray, String[] stringArray, boolean bl, Set<String> set) {
        int n = classpathArray.length;
        int n2 = 0;
        this.classpaths = new Classpath[n];
        this.hasLimitModules = set != null && !set.isEmpty();
        for (int i = 0; i < n; ++i) {
            Classpath classpath = classpathArray[i];
            try {
                classpath.initialize();
                for (String string : classpath.getModuleNames(set)) {
                    this.moduleLocations.put(string, classpath);
                }
                this.classpaths[n2++] = classpath;
                continue;
            }
            catch (IOException | InvalidPathException exception) {
                // empty catch block
            }
        }
        if (n2 != n) {
            this.classpaths = new Classpath[n2];
            System.arraycopy(this.classpaths, 0, this.classpaths, 0, n2);
        }
        this.initializeModuleLocations(set);
        this.initializeKnownFileNames(stringArray);
        this.annotationsFromClasspath = bl;
    }

    private void initializeModuleLocations(Set<String> set) {
        if (set == null) {
            for (Classpath classpath : this.classpaths) {
                for (String string2 : classpath.getModuleNames(null)) {
                    this.moduleLocations.put(string2, classpath);
                }
            }
        } else {
            HashMap<String, Classpath> hashMap = new HashMap<String, Classpath>();
            for (Classpath classpath : this.classpaths) {
                for (String string3 : classpath.getModuleNames(null)) {
                    hashMap.put(string3, classpath);
                }
            }
            for (Classpath classpath : this.classpaths) {
                for (String string3 : classpath.getModuleNames(set, string -> this.getModuleFromEnvironment(string.toCharArray()))) {
                    Classpath classpath2 = (Classpath)hashMap.get(string3);
                    this.moduleLocations.put(string3, classpath2);
                }
            }
        }
    }

    protected FileSystem(Classpath[] classpathArray, String[] stringArray, boolean bl) {
        this(classpathArray, stringArray, bl, null);
    }

    public static Classpath getClasspath(String string, String string2, AccessRuleSet accessRuleSet) {
        return FileSystem.getClasspath(string, string2, false, accessRuleSet, null, null, null);
    }

    public static Classpath getClasspath(String string, String string2, AccessRuleSet accessRuleSet, Map<String, String> map, String string3) {
        return FileSystem.getClasspath(string, string2, false, accessRuleSet, null, map, string3);
    }

    public static Classpath getJrtClasspath(String string, String string2, AccessRuleSet accessRuleSet, Map<String, String> map) {
        return new ClasspathJrt(new File(FileSystem.convertPathSeparators(string)), true, accessRuleSet, null);
    }

    public static Classpath getOlderSystemRelease(String string, String string2, AccessRuleSet accessRuleSet) {
        return isJRE12Plus ? new ClasspathJep247Jdk12(new File(FileSystem.convertPathSeparators(string)), string2, accessRuleSet) : new ClasspathJep247(new File(FileSystem.convertPathSeparators(string)), string2, accessRuleSet);
    }

    public static Classpath getClasspath(String string, String string2, boolean bl, AccessRuleSet accessRuleSet, String string3, Map<String, String> map, String string4) {
        Classpath classpath = null;
        File file = new File(FileSystem.convertPathSeparators(string));
        if (file.isDirectory()) {
            if (file.exists()) {
                classpath = new ClasspathDirectory(file, string2, bl ? 1 : 3, accessRuleSet, string3 == null || string3 == "none" ? string3 : FileSystem.convertPathSeparators(string3), map);
            }
        } else {
            int n = Util.archiveFormat(string);
            if (n == 0) {
                if (bl) {
                    classpath = new ClasspathSourceJar(file, true, accessRuleSet, string2, string3 == null || string3 == "none" ? string3 : FileSystem.convertPathSeparators(string3));
                } else if (string3 == null) {
                    if (string.endsWith("jrt-fs.jar")) {
                        if (JRT_CLASSPATH_CACHE == null) {
                            JRT_CLASSPATH_CACHE = new HashMap();
                        } else {
                            classpath = JRT_CLASSPATH_CACHE.get(file);
                        }
                        if (classpath == null) {
                            classpath = new ClasspathJrt(file, true, accessRuleSet, null);
                            try {
                                classpath.initialize();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            JRT_CLASSPATH_CACHE.put(file, classpath);
                        }
                    } else {
                        classpath = string4 == null ? new ClasspathJar(file, true, accessRuleSet, null) : new ClasspathMultiReleaseJar(file, true, accessRuleSet, string3, string4);
                    }
                }
            } else if (n == 1) {
                return new ClasspathJmod(file, true, accessRuleSet, null);
            }
        }
        return classpath;
    }

    private void initializeKnownFileNames(String[] stringArray) {
        if (stringArray == null) {
            this.knownFileNames = new HashSet<String>(0);
            return;
        }
        this.knownFileNames = new HashSet<String>(stringArray.length * 2);
        int n = stringArray.length;
        while (--n >= 0) {
            File file = new File(stringArray[n]);
            char[] cArray = null;
            try {
                cArray = file.getCanonicalPath().toCharArray();
            }
            catch (IOException iOException) {
                continue;
            }
            char[] cArray2 = null;
            int n2 = CharOperation.lastIndexOf('.', cArray);
            if (n2 != -1) {
                cArray = CharOperation.subarray(cArray, 0, n2);
            }
            CharOperation.replace(cArray, '\\', '/');
            boolean bl = false;
            for (Classpath classpath : this.classpaths) {
                char[] cArray3 = classpath.normalizedPath();
                boolean bl2 = false;
                if (!(classpath instanceof ClasspathDirectory) || !CharOperation.prefixEquals(cArray3, cArray)) continue;
                bl2 = true;
                if (cArray2 == null) {
                    cArray2 = cArray3;
                } else if (bl2) {
                    if (cArray3.length > cArray2.length) {
                        cArray2 = cArray3;
                    }
                } else if (!bl && cArray3.length < cArray2.length) {
                    cArray2 = cArray3;
                }
                if (!bl2) continue;
                bl = true;
            }
            if (cArray2 == null) {
                this.knownFileNames.add(new String(cArray));
            } else {
                this.knownFileNames.add(new String(CharOperation.subarray(cArray, cArray2.length, cArray.length)));
            }
            cArray2 = null;
        }
    }

    public void scanForModules(Parser parser) {
        int n = this.classpaths.length;
        for (int i = 0; i < n; ++i) {
            File file = new File(this.classpaths[i].getPath());
            IModule iModule = ModuleFinder.scanForModule(this.classpaths[i], file, parser, false, null);
            if (iModule == null) continue;
            this.moduleLocations.put(String.valueOf(iModule.name()), this.classpaths[i]);
        }
    }

    @Override
    public void cleanup() {
        int n = this.classpaths.length;
        for (int i = 0; i < n; ++i) {
            this.classpaths[i].reset();
        }
    }

    private static String convertPathSeparators(String string) {
        return File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameEnvironmentAnswer findClass(String string, char[] cArray, boolean bl, char[] cArray2) {
        NameEnvironmentAnswer nameEnvironmentAnswer = this.internalFindClass(string, cArray, bl, cArray2);
        if (this.annotationsFromClasspath && nameEnvironmentAnswer != null && nameEnvironmentAnswer.getBinaryType() instanceof ClassFileReader) {
            for (Classpath classpath : this.classpaths) {
                if (!classpath.hasAnnotationFileFor(string)) continue;
                ZipFile zipFile = classpath instanceof ClasspathJar ? ((ClasspathJar)classpath).zipFile : null;
                boolean bl2 = false;
                try {
                    if (zipFile == null) {
                        zipFile = ExternalAnnotationDecorator.getAnnotationZipFile(classpath.getPath(), null);
                        bl2 = true;
                    }
                    nameEnvironmentAnswer.setBinaryType(ExternalAnnotationDecorator.create(nameEnvironmentAnswer.getBinaryType(), classpath.getPath(), string, zipFile));
                    NameEnvironmentAnswer nameEnvironmentAnswer2 = nameEnvironmentAnswer;
                    return nameEnvironmentAnswer2;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (bl2 && zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            nameEnvironmentAnswer.setBinaryType(new ExternalAnnotationDecorator(nameEnvironmentAnswer.getBinaryType(), null));
        }
        return nameEnvironmentAnswer;
    }

    private NameEnvironmentAnswer internalFindClass(String string, char[] cArray, boolean bl, char[] cArray2) {
        if (this.knownFileNames.contains(string)) {
            return null;
        }
        String string2 = string + ".class";
        String string3 = string.length() == cArray.length ? Util.EMPTY_STRING : string2.substring(0, string.length() - cArray.length - 1);
        IModuleAwareNameEnvironment.LookupStrategy lookupStrategy = IModuleAwareNameEnvironment.LookupStrategy.get(cArray2);
        if (lookupStrategy == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            String string4;
            Classpath classpath;
            if (this.moduleLocations != null && (classpath = this.moduleLocations.get(string4 = String.valueOf(cArray2))) != null) {
                return classpath.findClass(cArray, string3, string4, string2);
            }
            return null;
        }
        String string5 = File.separatorChar == '/' ? string3 : string3.replace('/', File.separatorChar);
        NameEnvironmentAnswer nameEnvironmentAnswer = null;
        if (string3 == string5) {
            int n = this.classpaths.length;
            for (int i = 0; i < n; ++i) {
                NameEnvironmentAnswer nameEnvironmentAnswer2;
                if (!lookupStrategy.matches(this.classpaths[i], Classpath::hasModule) || (nameEnvironmentAnswer2 = this.classpaths[i].findClass(cArray, string3, null, string2, bl)) == null || nameEnvironmentAnswer2.moduleName() != null && !this.moduleLocations.containsKey(String.valueOf(nameEnvironmentAnswer2.moduleName()))) continue;
                if (!nameEnvironmentAnswer2.ignoreIfBetter()) {
                    if (!nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) continue;
                    return nameEnvironmentAnswer2;
                }
                if (!nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) continue;
                nameEnvironmentAnswer = nameEnvironmentAnswer2;
            }
        } else {
            String string6 = string2.replace('/', File.separatorChar);
            for (Classpath classpath : this.classpaths) {
                NameEnvironmentAnswer nameEnvironmentAnswer3;
                if (!lookupStrategy.matches(classpath, Classpath::hasModule)) continue;
                NameEnvironmentAnswer nameEnvironmentAnswer4 = nameEnvironmentAnswer3 = !(classpath instanceof ClasspathDirectory) ? classpath.findClass(cArray, string3, null, string2, bl) : classpath.findClass(cArray, string5, null, string6, bl);
                if (nameEnvironmentAnswer3 == null || nameEnvironmentAnswer3.moduleName() != null && !this.moduleLocations.containsKey(String.valueOf(nameEnvironmentAnswer3.moduleName()))) continue;
                if (!nameEnvironmentAnswer3.ignoreIfBetter()) {
                    if (!nameEnvironmentAnswer3.isBetter(nameEnvironmentAnswer)) continue;
                    return nameEnvironmentAnswer3;
                }
                if (!nameEnvironmentAnswer3.isBetter(nameEnvironmentAnswer)) continue;
                nameEnvironmentAnswer = nameEnvironmentAnswer3;
            }
        }
        return nameEnvironmentAnswer;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] cArray, char[] cArray2) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray, '/')), cArray[cArray.length - 1], false, cArray2);
        }
        return null;
    }

    public char[][][] findTypeNames(char[][] cArray) {
        Object object;
        block6: {
            String string;
            object = null;
            if (cArray == null) break block6;
            String string2 = new String(CharOperation.concatWith(cArray, '/'));
            String string3 = string = File.separatorChar == '/' ? string2 : string2.replace('/', File.separatorChar);
            if (string2 == string) {
                int n = this.classpaths.length;
                for (int i = 0; i < n; ++i) {
                    char[][][] cArray2 = this.classpaths[i].findTypeNames(string2, null);
                    if (cArray2 == null) continue;
                    if (object == null) {
                        object = cArray2;
                        continue;
                    }
                    int n2 = ((char[][][])object).length;
                    int n3 = cArray2.length;
                    char[][][] cArray3 = object;
                    char[][][] cArrayArray = new char[n3 + n2][][];
                    object = cArrayArray;
                    System.arraycopy(cArray3, 0, cArrayArray, 0, n2);
                    System.arraycopy(cArray2, 0, object, n2, n3);
                }
            } else {
                for (Classpath classpath : this.classpaths) {
                    char[][][] cArray4;
                    char[][][] cArray5 = cArray4 = !(classpath instanceof ClasspathDirectory) ? classpath.findTypeNames(string2, null) : classpath.findTypeNames(string, null);
                    if (cArray4 == null) continue;
                    if (object == null) {
                        object = cArray4;
                        continue;
                    }
                    int n = ((char[][][])object).length;
                    int n4 = cArray4.length;
                    char[][][] cArray6 = object;
                    char[][][] cArrayArray = new char[n4 + n][][];
                    object = cArrayArray;
                    System.arraycopy(cArray6, 0, cArrayArray, 0, n);
                    System.arraycopy(cArray4, 0, object, n, n4);
                }
            }
        }
        return object;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2, char[] cArray3) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray2, cArray, '/')), cArray, false, cArray3);
        }
        return null;
    }

    @Override
    public char[][] getModulesDeclaringPackage(char[][] cArray, char[] cArray2) {
        String string = new String(CharOperation.concatWith(cArray, '/'));
        String string2 = String.valueOf(cArray2);
        IModuleAwareNameEnvironment.LookupStrategy lookupStrategy = IModuleAwareNameEnvironment.LookupStrategy.get(cArray2);
        if (lookupStrategy == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            Classpath classpath;
            if (this.moduleLocations != null && (classpath = this.moduleLocations.get(string2)) != null && classpath.isPackage(string, string2)) {
                return new char[][]{cArray2};
            }
            return null;
        }
        char[][] cArray3 = null;
        boolean bl = false;
        for (Classpath classpath : this.classpaths) {
            if (!lookupStrategy.matches(classpath, Classpath::hasModule)) continue;
            if (lookupStrategy == IModuleAwareNameEnvironment.LookupStrategy.Unnamed) {
                if (!classpath.isPackage(string, string2)) continue;
                return new char[][]{ModuleBinding.UNNAMED};
            }
            char[][] cArray4 = classpath.getModulesDeclaringPackage(string, null);
            if (cArray4 == null) continue;
            if (classpath instanceof ClasspathJrt && this.hasLimitModules) {
                bl |= (cArray4 = this.filterModules(cArray4)) == null;
            }
            cArray3 = cArray3 == null ? cArray4 : CharOperation.arrayConcat(cArray3, cArray4);
        }
        if (cArray3 == null && bl) {
            return new char[][]{ModuleBinding.UNOBSERVABLE};
        }
        return cArray3;
    }

    private char[][] filterModules(char[][] cArray2) {
        char[][] cArray3 = (char[][])Arrays.stream(cArray2).filter(cArray -> this.moduleLocations.containsKey(new String((char[])cArray))).toArray(n -> new char[n][]);
        if (cArray3.length == 0) {
            return null;
        }
        return cArray3;
    }

    private Parser getParser() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("org.eclipse.jdt.core.compiler.source", "9");
        return new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.exitOnFirstError(), new CompilerOptions(hashMap), new DefaultProblemFactory(Locale.getDefault())), false);
    }

    @Override
    public boolean hasCompilationUnit(char[][] cArray, char[] cArray2, boolean bl) {
        String string = String.valueOf(CharOperation.concatWith(cArray, '/'));
        String string2 = String.valueOf(cArray2);
        IModuleAwareNameEnvironment.LookupStrategy lookupStrategy = IModuleAwareNameEnvironment.LookupStrategy.get(cArray2);
        Parser parser = bl ? this.getParser() : null;
        Function<CompilationUnit, String> function = compilationUnit -> {
            String string = null;
            CompilationResult compilationResult = new CompilationResult((ICompilationUnit)compilationUnit, 0, 0, 1);
            char[][] cArray = parser.parsePackageDeclaration(compilationUnit.getContents(), compilationResult);
            if (cArray != null) {
                string = CharOperation.toString(cArray);
            }
            return string;
        };
        switch (lookupStrategy) {
            case Named: {
                Classpath classpath;
                if (this.moduleLocations != null && (classpath = this.moduleLocations.get(string2)) != null) {
                    return bl ? classpath.hasCUDeclaringPackage(string, function) : classpath.hasCompilationUnit(string, string2);
                }
                return false;
            }
        }
        for (int i = 0; i < this.classpaths.length; ++i) {
            Classpath classpath = this.classpaths[i];
            if (!lookupStrategy.matches(classpath, Classpath::hasModule) || !classpath.hasCompilationUnit(string, string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IModule getModule(char[] cArray) {
        if (this.module != null && CharOperation.equals(cArray, this.module.name())) {
            return this.module;
        }
        if (this.moduleLocations.containsKey(new String(cArray))) {
            for (Classpath classpath : this.classpaths) {
                IModule iModule = classpath.getModule(cArray);
                if (iModule == null) continue;
                return iModule;
            }
        }
        return null;
    }

    public IModule getModuleFromEnvironment(char[] cArray) {
        if (this.module != null && CharOperation.equals(cArray, this.module.name())) {
            return this.module;
        }
        for (Classpath classpath : this.classpaths) {
            IModule iModule = classpath.getModule(cArray);
            if (iModule == null) continue;
            return iModule;
        }
        return null;
    }

    @Override
    public char[][] getAllAutomaticModules() {
        HashSet<char[]> hashSet = new HashSet<char[]>();
        int n = this.classpaths.length;
        for (int i = 0; i < n; ++i) {
            if (!this.classpaths[i].isAutomaticModule()) continue;
            hashSet.add(this.classpaths[i].getModule().name());
        }
        return (char[][])hashSet.toArray((T[])new char[hashSet.size()][]);
    }

    @Override
    public char[][] listPackages(char[] cArray) {
        switch (IModuleAwareNameEnvironment.LookupStrategy.get(cArray)) {
            case Named: {
                Classpath classpath = this.moduleLocations.get(new String(cArray));
                if (classpath != null) {
                    return classpath.listPackages();
                }
                return CharOperation.NO_CHAR_CHAR;
            }
        }
        throw new UnsupportedOperationException("can list packages only of a named module");
    }

    void addModuleUpdate(String string, Consumer<IUpdatableModule> consumer, IUpdatableModule.UpdateKind updateKind) {
        IUpdatableModule.UpdatesByKind updatesByKind = this.moduleUpdates.get(string);
        if (updatesByKind == null) {
            updatesByKind = new IUpdatableModule.UpdatesByKind();
            this.moduleUpdates.put(string, updatesByKind);
        }
        updatesByKind.getList(updateKind, true).add(consumer);
    }

    @Override
    public void applyModuleUpdates(IUpdatableModule iUpdatableModule, IUpdatableModule.UpdateKind updateKind) {
        IUpdatableModule.UpdatesByKind updatesByKind;
        char[] cArray = iUpdatableModule.name();
        if (cArray != ModuleBinding.UNNAMED && (updatesByKind = this.moduleUpdates.get(String.valueOf(cArray))) != null) {
            for (Consumer<IUpdatableModule> consumer : updatesByKind.getList(updateKind, false)) {
                consumer.accept(iUpdatableModule);
            }
        }
    }

    static {
        try {
            isJRE12Plus = SourceVersion.valueOf("RELEASE_12") != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class ClasspathNormalizer {
        public static ArrayList<Classpath> normalize(ArrayList<Classpath> arrayList) {
            ArrayList<Classpath> arrayList2 = new ArrayList<Classpath>();
            HashSet<Classpath> hashSet = new HashSet<Classpath>();
            for (Classpath classpath : arrayList) {
                if (hashSet.contains(classpath)) continue;
                arrayList2.add(classpath);
                hashSet.add(classpath);
            }
            return arrayList2;
        }
    }

    public static interface ClasspathSectionProblemReporter {
        public void invalidClasspathSection(String var1);

        public void multipleClasspathSections(String var1);
    }

    public static interface Classpath
    extends IModulePathEntry {
        public char[][][] findTypeNames(String var1, String var2);

        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3, String var4);

        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3, String var4, boolean var5);

        public boolean isPackage(String var1, String var2);

        default public boolean hasModule() {
            return this.getModule() != null;
        }

        default public boolean hasCUDeclaringPackage(String string, Function<CompilationUnit, String> function) {
            return this.hasCompilationUnit(string, null);
        }

        public List<Classpath> fetchLinkedJars(ClasspathSectionProblemReporter var1);

        public void reset();

        public char[] normalizedPath();

        public String getPath();

        public void initialize() throws IOException;

        public boolean hasAnnotationFileFor(String var1);

        public void acceptModule(IModule var1);

        public String getDestinationPath();

        public Collection<String> getModuleNames(Collection<String> var1);

        public Collection<String> getModuleNames(Collection<String> var1, Function<String, IModule> var2);
    }
}

