/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.Rules;

public class RulesBase
implements Rules {
    protected HashMap<String, List<Rule>> cache = new HashMap();
    protected Digester digester = null;
    @Deprecated
    protected String namespaceURI = null;
    protected ArrayList<Rule> rules = new ArrayList();

    @Override
    public Digester getDigester() {
        return this.digester;
    }

    @Override
    public void setDigester(Digester digester) {
        this.digester = digester;
        for (Rule rule : this.rules) {
            rule.setDigester(digester);
        }
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public void setNamespaceURI(String string) {
        this.namespaceURI = string;
    }

    @Override
    public void add(String string, Rule rule) {
        List<Rule> list;
        int n = string.length();
        if (n > 1 && string.endsWith("/")) {
            string = string.substring(0, n - 1);
        }
        if ((list = this.cache.get(string)) == null) {
            list = new ArrayList<Rule>();
            this.cache.put(string, list);
        }
        list.add(rule);
        this.rules.add(rule);
        if (this.digester != null) {
            rule.setDigester(this.digester);
        }
        if (this.namespaceURI != null) {
            rule.setNamespaceURI(this.namespaceURI);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.rules.clear();
    }

    @Override
    public List<Rule> match(String string, String string2) {
        List<Rule> list = this.lookup(string, string2);
        if (list == null || list.size() < 1) {
            String string3 = "";
            for (String string4 : this.cache.keySet()) {
                if (!string4.startsWith("*/") || !string2.equals(string4.substring(2)) && !string2.endsWith(string4.substring(1)) || string4.length() <= string3.length()) continue;
                list = this.lookup(string, string4);
                string3 = string4;
            }
        }
        if (list == null) {
            list = new ArrayList<Rule>();
        }
        return list;
    }

    @Override
    public List<Rule> rules() {
        return this.rules;
    }

    protected List<Rule> lookup(String string, String string2) {
        List<Rule> list = this.cache.get(string2);
        if (list == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return list;
        }
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (Rule rule : list) {
            if (!string.equals(rule.getNamespaceURI()) && rule.getNamespaceURI() != null) continue;
            arrayList.add(rule);
        }
        return arrayList;
    }
}

