### Copyright  (C) 2019 Intel Corporation. All rights reserved.
###
### The information and source code contained herein is the exclusive
### property of Intel Corporation and may not be disclosed, examined
### or reproduced in whole or in part without explicit written authorization
### from the company.
###
### 3/2019  Update Fortran-specific files

# Definition file for
#   host:    Windows
#   target:  Windows

include(def_util)
def_init_install_subsets()

#compiler header files common for 64/32 bit targets
if (DO_COPY_EFI2_TARGET_FILES OR DO_COPY_IA32_TARGET_FILES)
  set( compiler_header_files
        aio.h
        aiostream.h
        bfp754_conf.h
        bfp754_functionnames.h
        bfp754.h
        bfp754_macros.h
        bfp754_types.h
        complex.h
        dvec.h
        fenv.h
        float.h
        fvec.h
        hvec.h
        istrconv.h
        ivec.h
        math_common_define.h
        math_common_undefine.h
        math.h
        mathimf.h
        omp.h
        omp_lib.h
        sse2mmx.h
        tbk_traceback.h
        vec_complex.h
        xmm_func.h
        xmm_utils.h )

  if(BUILD_FORT)
    list(APPEND compiler_header_files
        ISO_Fortran_binding.h
        advapi32.f90
        comctl32.f90
        comdlg32.f90
        dfauto.f90
        dfcom.f90
        dflib.f90
        dflogm.f90
        dfmt.f90
        dfnls.f90
        dfopngl.f90
        dfopnglt.f90
        dfport.f90
        dfwbase.f90
        dfwin.f90
        dfwinty.f90
        dialogm.f90
        fgraph.fd
        fgraph.fi
        flib.fd
        flib.fi
        for_fpclass.for
        for_fpclass.h
        for_fpeflags.for
        for_fpeflags.h
        for_iosdef.for
        for_iosdef.h
        fordef.for
        fordef.h
        foriosdef.f90
        forreent.for
        forreent.h
        fullapi.f90
        gdi32.f90
        ieee_arithmetic.f90
        ieee_exceptions.f90
        ieee_features.f90
        ifauto.f90
        ifcom.f90
        ifcommonalloc.f90
        ifcore.f90
        ifestablish.f90
        iflogm.f90
        iflport.f90
        iflposix.f90
        ifmt.f90
        ifnls.f90
        ifopngl.f90
        ifopnglt.f90
        ifport.f90
        ifposix.f90
        ifqwin.f90
        ifwbase.f90
        ifwin.f90
        ifwinty.f90
        imt.f90
        iso_c_binding.f90
        iso_fortran_env.f90
        kernel32.f90
        lz32.f90
        mpr.f90
        msflib.f90
        msfnls.f90
        msfwin.f90
        msfwinty.f90
        mt.f90
        mt.fd
        mt.fi
        nls.f90
        ole32.f90
        oleaut32.f90
        omp_lib.f90
        opengl.f90
        openglty.f90
        portlib.f90
        psapi.f90
        scrnsave.f90
        shell32.f90
        user32.f90
        version.f90
        winmm.f90
        winspool.f90
        ws2_32.f90
        wsock32.f90
    )
  endif()

  def_add_install_subset( cmplr_headers INC
       SRCDIR "efi2/nt_test/include"
       INSTDIR "compiler/include"
       DESTDIR "include"
       ${compiler_header_files} )

  if (BUILD_FORT)
     set( fortran_mod_files
           advapi32.mod
           comctl32.mod
           comdlg32.mod
           dfauto.mod
           dfcom.mod
           dfcomty.mod
           dflib.mod
           dflogm.mod
           dflogmt.mod
           dfmt.mod
           dfnls.mod
           dfopngl.mod
           dfopnglt.mod
           dfport.mod
           dfwbase.mod
           dfwin.mod
           dfwina.mod
           dfwinty.mod
           dialogm.mod
           dialogt.mod
           foriosdef.mod
           gdi32.mod
           ifauto.mod
           ifcom.mod
           ifcommonalloc.mod
           ifcomty.mod
           ifcore.mod
           ifestablish.mod
           iflnls.mod
           iflogm.mod
           iflogmt.mod
           iflport.mod
           iflposix.mod
           ifmt.mod
           ifnls.mod
           ifopngl.mod
           ifopnglt.mod
           ifport.mod
           ifport_types.mod
           ifposix.mod
           ifqwin.mod
           ifwbase.mod
           ifwin.mod
           ifwina.mod
           ifwinty.mod
           imt.mod
           kernel32.mod
           lz32.mod
           mpr.mod
           msflib.mod
           msfnls.mod
           msfwin.mod
           msfwina.mod
           msfwinty.mod
           mt.mod
           ole32.mod
           oleaut32.mod
           omp_lib.mod
           omp_lib_kinds.mod
           opengl.mod
           openglty.mod
           portlib.mod
           psapi.mod
           scrnsave.mod
           shell32.mod
           user32.mod
           version.mod
           winmm.mod
           winspool.mod
           ws2_32.mod
           wsock32.mod
           ieee_arithmetic.modintr
           ieee_exceptions.modintr
           ieee_features.modintr
           iso_c_binding.modintr
           iso_fortran_env.modintr )

      def_add_install_subset( cmplr_mod64 INC
            SRCDIR "efi2/nt_test/include"
            INSTDIR "compiler/include/intel64"
            DESTDIR "include/intel64"
            ${fortran_mod_files} )

   endif ()  # Fortran mod files

  set( perf_headers_files
        ippvalarray
        valarray )

  def_add_install_subset( perf_headers INC
        SRCDIR "efi2/nt_test/include/perf_headers/c++"
        INSTDIR "compiler/perf_headers/c++"
        DESTDIR "include/perf_headers/c++"
        ${perf_headers_files} )

endif() # (DO_COPY_EFI2_TARGET_FILES OR DO_COPY_IA32_TARGET_FILES)

if (DO_COPY_EFI2_TARGET_FILES)

  set( lib64_files
        libbfp754.lib
        libdecimal.lib
        libicaio.lib
        libiomp5md.lib
        libiompstubs5md.lib
        libipgo.lib
        libirc.lib
        libircmt.lib
        libistrconv.lib
        libmatmul.lib
        libm.lib
        libmmdd.lib
        libmmd.lib
        libmmds.lib
        libmmt.lib
        svml_disp.lib
        svml_dispmd.lib
        svml_dispmt.lib )

  if(BUILD_FORT)
    list(APPEND lib64_files
      ifauto.lib
      ifcom.lib
      ifconsol.lib
      iflogm.lib
      ifmodintr.lib
      ifqwin.lib
      ifqw_mdi.lib
      ifqw_sdi.lib
      ifwin.lib
      libicaf.lib
      libifcore.lib
      libifcoremdd.lib
      libifcoremd.lib
      libifcoremt.lib
      libifcorertd.lib
      libifcorert.lib
      libifport.lib
      libifportmd.lib
      )
  endif()

  set( redist_lib64_files
        libiomp5md.dll
        libiomp5md.pdb
        libiompstubs5md.dll
        libmmd.dll
        libmmdd.dll
        libmmd.pdb
        libmmdd.pdb
        svml_dispmd.dll
        svml_dispmd.pdb )

  if(BUILD_FORT)
    list(APPEND redist_lib64_files
      ifdlg100.dll
      libicaf.dll
      libifcoremdd.dll
      libifcoremd.dll
      libifcorertd.dll
      libifcorert.dll
      libifportmd.dll
      )
  endif()

  set( redist_lib64_loc1033_files
        irc_msg.dll
        libmUI.dll )

  if(BUILD_FORT)
    list(APPEND redist_lib64_loc1033_files
      ifcore_msg.dll
      )
  endif()

  def_add_install_subset( lib_intel64 LIB
        SRCDIR "efi2/nt_test/lib_win"
        INSTDIR "compiler/lib/intel64_win"
        DESTDIR "lib"
        ${lib64_files} )

  def_add_install_subset( lib_intel64redist LIB
        SRCDIR "efi2/nt_test/lib_win"
        INSTDIR "redist/intel64_win/compiler"
        ${redist_lib64_files} )

  def_add_install_subset( lib_intel64redist_loc1033 LIB
        SRCDIR "efi2/nt_test/lib_win"
        INSTDIR "redist/intel64_win/compiler/1033"
        ${redist_lib64_loc1033_files} )

endif (DO_COPY_EFI2_TARGET_FILES)

if (DO_COPY_IA32_TARGET_FILES)

  set( lib32_files
        libbfp754.lib
        libdecimal.lib
        libicaio.lib
        libiomp5md.lib
        libiompstubs5md.lib
        libipgo.lib
        libirc.lib
        libircmt.lib
        libistrconv.lib
        libmatmul.lib
        libm.lib
        libmmdd.lib
        libmmd.lib
        libmmds.lib
        libmmt.lib
        svml_disp.lib
        svml_dispmd.lib
        svml_dispmt.lib )

  if(BUILD_FORT)
    list(APPEND lib32_files
      ifauto.lib
      ifcom.lib
      ifconsol.lib
      iflogm.lib
      ifmodintr.lib
      ifqwin.lib
      ifqw_mdi.lib
      ifqw_sdi.lib
      ifwin.lib
      libicaf.lib
      libifcore.lib
      libifcoremdd.lib
      libifcoremd.lib
      libifcoremt.lib
      libifcorertd.lib
      libifcorert.lib
      libifport.lib
      libifportmd.lib )
  endif ()

  def_add_install_subset( lib_x86 LIB
        SRCDIR "ia32/nt_test/lib_win"
        INSTDIR "compiler/lib/ia32_win"
        DESTDIR "lib32"
        ${lib32_files} )

  def_add_install_subset( cmplr_stdarg_headers INC
        SRCDIR "ia32/nt_test/include"
        INSTDIR "compiler/include/ia32"
        DESTDIR "include/ia32"
        stdarg.h )

  set( redist_lib32_files
        libiomp5md.dll
        libiomp5md.pdb
        libiompstubs5md.dll
        libmmdd.dll
        libmmd.dll
        libmmdd.pdb
        libmmd.pdb
        svml_dispmd.dll
        svml_dispmd.pdb
        )

  if(BUILD_FORT)
    list(APPEND redist_lib32_files
        ifdlg100.dll
        libicaf.dll
        libifcoremdd.dll
        libifcoremd.dll
        libifcorertd.dll
        libifcorert.dll
        libifportmd.dll )
  endif()

  set( redist_lib32_loc1033_files
        irc_msg.dll
        libmUI.dll )

  if(BUILD_FORT)
    list(APPEND redist_lib32_loc1033_files
        ifcore_msg.dll
        )
  endif()

  def_add_install_subset( lib_ia32redist LIB
        SRCDIR "ia32/nt_test/lib_win"
        INSTDIR "redist/ia32_win/compiler"
        ${redist_lib32_files} )

  def_add_install_subset( lib_ia32redist_loc1033 LIB
        SRCDIR "ia32/nt_test/lib_win"
        INSTDIR "redist/ia32_win/compiler/1033"
        ${redist_lib32_loc1033_files} )

  if (BUILD_FORT)
      def_add_install_subset( cmplr_mod32 INC
            SRCDIR "ia32/nt_test/include"
            INSTDIR "compiler/include/ia32"
            DESTDIR "include/ia32"
            ${fortran_mod_files} )
  endif ()

endif(DO_COPY_IA32_TARGET_FILES)

def_add_install_targets()
