/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation, based on code taken and modified
 *     					   from org.eclipse.cdt.dsf.gdb. and org.eclipse.cdt.launch
 *                         .remote.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.launching;

import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CDebuggerTab;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.cdt.launch.remote.tabs.RemoteCDSFDebuggerTab;
import org.eclipse.cdt.launch.remote.tabs.RemoteDSFGDBDebuggerPage;

@SuppressWarnings("restriction")

public class RemoteAppCDebuggerTab extends RemoteCDSFDebuggerTab {
	public static final String TAB_ID = "org.eclipse.cdt.dsf.iss.ui.remoteApplicationLaunch.debuggerTab"; //$NON-NLS-1$

	public RemoteAppCDebuggerTab() {
		super();
	}
	@Override
	protected void loadDynamicDebugArea()
	{
		Composite dynamicTabHolder = getDynamicTabHolder();
		// Dispose of any current child widgets in the tab holder area
		for (Control child: dynamicTabHolder.getChildren()) {
			child.dispose();
		}
		setDynamicTab(new ISSRemoteDSFGDBDebuggerPage());
		ICDebuggerPage debuggerPage = getDynamicTab();
		if (debuggerPage == null) {
			setErrorMessage("Warnign: DSFGDBDebuggerPage is NULL");
			return;
		}
		// Ask the dynamic UI to create its Control
		debuggerPage.setLaunchConfigurationDialog(getLaunchConfigurationDialog());
		debuggerPage.createControl(dynamicTabHolder);
		debuggerPage.getControl().setVisible(true);
		dynamicTabHolder.layout(true);
		contentsChanged();
	}
	@Override
	public String getId() {
		return TAB_ID;
	}
}

