/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.http_action.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.config.PluginSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;

public class PerformanceAnalyzerConfigAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerConfigAction.class);
    private static PerformanceAnalyzerConfigAction instance = null;
    private final PerformanceAnalyzerController performanceAnalyzerController;
    public static final String ENABLED = "enabled";
    public static final String SHARDS_PER_COLLECTION = "shardsPerCollection";
    public static final String PA_ENABLED = "performanceAnalyzerEnabled";
    public static final String RCA_ENABLED = "rcaEnabled";
    public static final String PA_LOGGING_ENABLED = "loggingEnabled";
    public static final String BATCH_METRICS_ENABLED = "batchMetricsEnabled";
    public static final String THREAD_CONTENTION_MONITORING_ENABLED = "threadContentionMonitoringEnabled";
    public static final String BATCH_METRICS_RETENTION_PERIOD_MINUTES = "batchMetricsRetentionPeriodMinutes";
    public static final String PERFORMANCE_ANALYZER_CONFIG_ACTION = "PerformanceAnalyzer_Config_Action";
    public static final String RCA_CONFIG_PATH = "/_plugins/_performanceanalyzer/rca/config";
    public static final String PA_CONFIG_PATH = "/_plugins/_performanceanalyzer/config";
    public static final String LOGGING_CONFIG_PATH = "/_plugins/_performanceanalyzer/logging/config";
    public static final String BATCH_METRICS_CONFIG_PATH = "/_plugins/_performanceanalyzer/batch/config";
    public static final String THREAD_CONTENTION_MONITORING_CONFIG_PATH = "/_plugins/_performanceanalyzer/threadContentionMonitoring/config";
    public static final String LEGACY_RCA_CONFIG_PATH = "/_opendistro/_performanceanalyzer/rca/config";
    public static final String LEGACY_PA_CONFIG_PATH = "/_opendistro/_performanceanalyzer/config";
    public static final String LEGACY_LOGGING_CONFIG_PATH = "/_opendistro/_performanceanalyzer/logging/config";
    public static final String LEGACY_BATCH_METRICS_CONFIG_PATH = "/_opendistro/_performanceanalyzer/batch/config";
    private static final List<RestHandler.Route> ROUTES = Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/threadContentionMonitoring/config"), new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/threadContentionMonitoring/config")));
    private static final List<RestHandler.ReplacedRoute> REPLACED_ROUTES = Collections.unmodifiableList(Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/config"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/rca/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/rca/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/rca/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/rca/config"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/logging/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/logging/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/logging/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/logging/config"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/_performanceanalyzer/batch/config", RestRequest.Method.GET, "/_opendistro/_performanceanalyzer/batch/config"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_performanceanalyzer/batch/config", RestRequest.Method.POST, "/_opendistro/_performanceanalyzer/batch/config")));

    public static PerformanceAnalyzerConfigAction getInstance() {
        return instance;
    }

    public static void setInstance(PerformanceAnalyzerConfigAction performanceanalyzerConfigAction) {
        instance = performanceanalyzerConfigAction;
    }

    public List<RestHandler.Route> routes() {
        return ROUTES;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return REPLACED_ROUTES;
    }

    @Inject
    public PerformanceAnalyzerConfigAction(RestController controller, PerformanceAnalyzerController performanceAnalyzerController) {
        this.performanceAnalyzerController = performanceAnalyzerController;
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = performanceAnalyzerController::isPerformanceAnalyzerEnabled;
        LOG.info("PerformanceAnalyzer Enabled: {}", supplierArray);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method() == RestRequest.Method.POST && request.content().length() > 0) {
            Object shardPerCollectionValue;
            Map map = (Map)XContentHelper.convertToMap((BytesReference)request.content(), (boolean)false).v2();
            Object value = map.get(ENABLED);
            LOG.debug("PerformanceAnalyzer:Value (Object) Received as Part of Request: {} current value: {}", value, (Object)this.performanceAnalyzerController.isPerformanceAnalyzerEnabled());
            if (value instanceof Boolean) {
                boolean shouldEnable = (Boolean)value;
                if (request.path().contains(RCA_CONFIG_PATH) || request.path().contains(LEGACY_RCA_CONFIG_PATH)) {
                    if (shouldEnable && !this.performanceAnalyzerController.isPerformanceAnalyzerEnabled()) {
                        return this.getChannelConsumerWithError("Error: PA not enabled. Enable PA before turning RCA on");
                    }
                    this.performanceAnalyzerController.updateRcaState(shouldEnable);
                } else if (request.path().contains(LOGGING_CONFIG_PATH) || request.path().contains(LEGACY_LOGGING_CONFIG_PATH)) {
                    if (shouldEnable && !this.performanceAnalyzerController.isPerformanceAnalyzerEnabled()) {
                        return this.getChannelConsumerWithError("Error: PA not enabled. Enable PA before turning Logging on");
                    }
                    this.performanceAnalyzerController.updateLoggingState(shouldEnable);
                } else if (request.path().contains(BATCH_METRICS_CONFIG_PATH) || request.path().contains(LEGACY_BATCH_METRICS_CONFIG_PATH)) {
                    if (shouldEnable && !this.performanceAnalyzerController.isPerformanceAnalyzerEnabled()) {
                        return this.getChannelConsumerWithError("Error: PA not enabled. Enable PA before turning Batch Metrics on");
                    }
                    this.performanceAnalyzerController.updateBatchMetricsState(shouldEnable);
                } else if (request.path().contains(THREAD_CONTENTION_MONITORING_CONFIG_PATH)) {
                    if (shouldEnable && !this.performanceAnalyzerController.isPerformanceAnalyzerEnabled()) {
                        return this.getChannelConsumerWithError("Error: PA not enabled. Enable PA before turning thread contention monitoring on");
                    }
                    this.performanceAnalyzerController.updateThreadContentionMonitoringState(shouldEnable);
                } else {
                    if (!shouldEnable) {
                        this.performanceAnalyzerController.updateRcaState(false);
                        this.performanceAnalyzerController.updateLoggingState(false);
                        this.performanceAnalyzerController.updateBatchMetricsState(false);
                        this.performanceAnalyzerController.updateThreadContentionMonitoringState(false);
                    }
                    this.performanceAnalyzerController.updatePerformanceAnalyzerState(shouldEnable);
                }
            }
            if (map.containsKey(SHARDS_PER_COLLECTION) && (shardPerCollectionValue = map.get(SHARDS_PER_COLLECTION)) instanceof Integer) {
                this.performanceAnalyzerController.updateNodeStatsShardsPerCollection((Integer)shardPerCollectionValue);
            }
        }
        return channel -> {
            try {
                XContentBuilder builder = channel.newBuilder();
                builder.startObject();
                builder.field(PA_ENABLED, this.performanceAnalyzerController.isPerformanceAnalyzerEnabled());
                builder.field(RCA_ENABLED, this.performanceAnalyzerController.isRcaEnabled());
                builder.field(PA_LOGGING_ENABLED, this.performanceAnalyzerController.isLoggingEnabled());
                builder.field(SHARDS_PER_COLLECTION, this.performanceAnalyzerController.getNodeStatsShardsPerCollection());
                builder.field(BATCH_METRICS_ENABLED, this.performanceAnalyzerController.isBatchMetricsEnabled());
                builder.field(THREAD_CONTENTION_MONITORING_ENABLED, this.performanceAnalyzerController.isThreadContentionMonitoringEnabled());
                builder.field(BATCH_METRICS_RETENTION_PERIOD_MINUTES, PluginSettings.instance().getBatchMetricsRetentionPeriodMinutes());
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
            catch (IOException ioe) {
                LOG.error("Error sending response", (Throwable)ioe);
            }
        };
    }

    public String getName() {
        return PERFORMANCE_ANALYZER_CONFIG_ACTION;
    }

    private BaseRestHandler.RestChannelConsumer getChannelConsumerWithError(String error) {
        return restChannel -> {
            XContentBuilder builder = restChannel.newErrorBuilder();
            builder.startObject();
            builder.field(error);
            builder.endObject();
            restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
        };
    }
}

