"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageAuthorChanged = exports.getPeerDependencies = exports.defaultPrefix = exports.patch = exports.newest = exports.minor = exports.latest = exports.greatest = exports.distTag = exports.list = void 0;
const fast_memoize_1 = __importDefault(require("fast-memoize"));
const find_up_1 = __importDefault(require("find-up"));
const promises_1 = __importDefault(require("fs/promises"));
const ini_1 = __importDefault(require("ini"));
const path_1 = __importDefault(require("path"));
const spawn_please_1 = __importDefault(require("spawn-please"));
const keyValueBy_1 = __importDefault(require("../lib/keyValueBy"));
const logging_1 = require("../lib/logging");
const npm_1 = require("./npm");
/** Reads the npmrc config file from the pnpm-workspace.yaml directory. */
const npmConfigFromPnpmWorkspace = (0, fast_memoize_1.default)(async (options) => {
    const pnpmWorkspacePath = await (0, find_up_1.default)('pnpm-workspace.yaml');
    if (!pnpmWorkspacePath)
        return {};
    const pnpmWorkspaceDir = path_1.default.dirname(pnpmWorkspacePath);
    const pnpmWorkspaceConfigPath = path_1.default.join(pnpmWorkspaceDir, '.npmrc');
    let pnpmWorkspaceConfig;
    try {
        pnpmWorkspaceConfig = await promises_1.default.readFile(pnpmWorkspaceConfigPath, 'utf-8');
    }
    catch (e) {
        return {};
    }
    (0, logging_1.print)(options, `\nUsing pnpm workspace config at ${pnpmWorkspaceConfigPath}:`, 'verbose');
    const config = (0, npm_1.normalizeNpmConfig)(ini_1.default.parse(pnpmWorkspaceConfig), pnpmWorkspaceDir);
    (0, logging_1.print)(options, config, 'verbose');
    return config;
});
/** Fetches the list of all installed packages. */
const list = async (options = {}) => {
    // use npm for local ls
    if (!options.global)
        return (0, npm_1.list)(options);
    const cmd = process.platform === 'win32' ? 'pnpm.cmd' : 'pnpm';
    const result = JSON.parse(await (0, spawn_please_1.default)(cmd, ['ls', '-g', '--json']));
    const list = (0, keyValueBy_1.default)(result[0].dependencies || {}, (name, { version }) => ({
        [name]: version,
    }));
    return list;
};
exports.list = list;
/** Wraps a GetVersion function and passes the npmrc located next to the pnpm-workspace.yaml if it exists. */
const withNpmWorkspaceConfig = (getVersion) => async (packageName, currentVersion, options = {}) => getVersion(packageName, currentVersion, options, {}, await npmConfigFromPnpmWorkspace(options));
exports.distTag = withNpmWorkspaceConfig(npm_1.distTag);
exports.greatest = withNpmWorkspaceConfig(npm_1.greatest);
exports.latest = withNpmWorkspaceConfig(npm_1.latest);
exports.minor = withNpmWorkspaceConfig(npm_1.minor);
exports.newest = withNpmWorkspaceConfig(npm_1.newest);
exports.patch = withNpmWorkspaceConfig(npm_1.patch);
var npm_2 = require("./npm");
Object.defineProperty(exports, "defaultPrefix", { enumerable: true, get: function () { return npm_2.defaultPrefix; } });
Object.defineProperty(exports, "getPeerDependencies", { enumerable: true, get: function () { return npm_2.getPeerDependencies; } });
Object.defineProperty(exports, "packageAuthorChanged", { enumerable: true, get: function () { return npm_2.packageAuthorChanged; } });
//# sourceMappingURL=pnpm.js.map