/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.index;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.persistent.AllocatedPersistentTask;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.replication.ReplicationSettings;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.ReplicationOverallState;
import org.opensearch.replication.metadata.state.ReplicationStateMetadataKt;
import org.opensearch.replication.task.index.IndexReplicationParams;
import org.opensearch.replication.task.index.IndexReplicationTask;
import org.opensearch.replication.task.index.InitialState;
import org.opensearch.replication.util.InjectablesKt;
import org.opensearch.tasks.TaskId;
import org.opensearch.threadpool.ThreadPool;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011JL\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010!H\u0014J\u0016\u0010\"\u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0014J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00022\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J\u0018\u0010)\u001a\u00020$2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/opensearch/replication/task/index/IndexReplicationExecutor;", "Lorg/opensearch/persistent/PersistentTasksExecutor;", "Lorg/opensearch/replication/task/index/IndexReplicationParams;", "executor", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "client", "Lorg/opensearch/client/Client;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "settingsModule", "Lorg/opensearch/common/settings/SettingsModule;", "(Ljava/lang/String;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/client/Client;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;Lorg/opensearch/replication/ReplicationSettings;Lorg/opensearch/common/settings/SettingsModule;)V", "getSettingsModule", "()Lorg/opensearch/common/settings/SettingsModule;", "setSettingsModule", "(Lorg/opensearch/common/settings/SettingsModule;)V", "createTask", "Lorg/opensearch/persistent/AllocatedPersistentTask;", "id", "", "type", "action", "parentTaskId", "Lorg/opensearch/tasks/TaskId;", "taskInProgress", "Lorg/opensearch/persistent/PersistentTasksCustomMetadata$PersistentTask;", "headers", "", "getDescription", "nodeOperation", "", "task", "params", "state", "Lorg/opensearch/persistent/PersistentTaskState;", "validate", "clusterState", "Lorg/opensearch/cluster/ClusterState;", "Companion", "opensearch-cross-cluster-replication"})
public final class IndexReplicationExecutor
extends PersistentTasksExecutor<IndexReplicationParams> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final Client client;
    @NotNull
    private final ReplicationMetadataManager replicationMetadataManager;
    @NotNull
    private final ReplicationSettings replicationSettings;
    @NotNull
    private SettingsModule settingsModule;
    @NotNull
    public static final String TASK_NAME = "cluster:indices/admin/replication";
    @NotNull
    private static final InitialState INITIAL_STATE = InitialState.INSTANCE;
    private static final Logger log = LogManager.getLogger(IndexReplicationExecutor.class);

    public IndexReplicationExecutor(@NotNull String executor, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull Client client, @NotNull ReplicationMetadataManager replicationMetadataManager, @NotNull ReplicationSettings replicationSettings, @NotNull SettingsModule settingsModule) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        Intrinsics.checkNotNullParameter((Object)replicationSettings, (String)"replicationSettings");
        Intrinsics.checkNotNullParameter((Object)settingsModule, (String)"settingsModule");
        super(TASK_NAME, executor);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.replicationMetadataManager = replicationMetadataManager;
        this.replicationSettings = replicationSettings;
        this.settingsModule = settingsModule;
    }

    @NotNull
    public final SettingsModule getSettingsModule() {
        return this.settingsModule;
    }

    public final void setSettingsModule(@NotNull SettingsModule settingsModule) {
        Intrinsics.checkNotNullParameter((Object)settingsModule, (String)"<set-?>");
        this.settingsModule = settingsModule;
    }

    public void validate(@NotNull IndexReplicationParams params, @NotNull ClusterState clusterState) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        Map<String, String> map = ReplicationStateMetadataKt.getReplicationStateParamsForIndex(this.clusterService, params.getFollowerIndexName());
        if (map == null) {
            throw new IllegalStateException("Index task started without replication state in cluster metadata");
        }
        Map<String, String> replicationStateParams = map;
        if (!Intrinsics.areEqual((Object)replicationStateParams.get("REPLICATION_LAST_KNOWN_OVERALL_STATE"), (Object)ReplicationOverallState.RUNNING.name())) {
            throw new IllegalArgumentException("Replication state for index:" + params.getFollowerIndexName() + " should be RUNNING, but was:" + replicationStateParams.get("REPLICATION_LAST_KNOWN_OVERALL_STATE"));
        }
    }

    protected void nodeOperation(@NotNull AllocatedPersistentTask task, @NotNull IndexReplicationParams params, @Nullable PersistentTaskState state) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (task instanceof IndexReplicationTask) {
            IndexReplicationTask indexReplicationTask = (IndexReplicationTask)task;
            PersistentTaskState persistentTaskState = state;
            if (persistentTaskState == null) {
                persistentTaskState = INITIAL_STATE;
            }
            indexReplicationTask.run(persistentTaskState);
        } else {
            task.markAsFailed((Exception)new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown task class ", task.getClass())));
        }
    }

    @NotNull
    protected AllocatedPersistentTask createTask(long id, @NotNull String type, @NotNull String action, @NotNull TaskId parentTaskId, @NotNull PersistentTasksCustomMetadata.PersistentTask<IndexReplicationParams> taskInProgress, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)parentTaskId, (String)"parentTaskId");
        Intrinsics.checkNotNullParameter(taskInProgress, (String)"taskInProgress");
        ClusterStateObserver cso = new ClusterStateObserver(this.clusterService, log, this.threadPool.getThreadContext());
        String string = this.getDescription(taskInProgress);
        String string2 = this.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"executor");
        PersistentTaskParams persistentTaskParams = taskInProgress.getParams();
        if (persistentTaskParams == null) {
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
        return new IndexReplicationTask(id, type, action, string, parentTaskId, string2, this.clusterService, this.threadPool, this.client, (IndexReplicationParams)persistentTaskParams, InjectablesKt.getPersistentTasksService(), this.replicationMetadataManager, this.replicationSettings, this.settingsModule, cso);
    }

    @NotNull
    protected String getDescription(@NotNull PersistentTasksCustomMetadata.PersistentTask<IndexReplicationParams> taskInProgress) {
        Intrinsics.checkNotNullParameter(taskInProgress, (String)"taskInProgress");
        PersistentTaskParams persistentTaskParams = taskInProgress.getParams();
        if (persistentTaskParams == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        IndexReplicationParams params = (IndexReplicationParams)persistentTaskParams;
        return "replication:" + params.getLeaderAlias() + ':' + params.getLeaderIndex() + " -> " + params.getFollowerIndexName();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/replication/task/index/IndexReplicationExecutor$Companion;", "", "()V", "INITIAL_STATE", "Lorg/opensearch/replication/task/index/InitialState;", "getINITIAL_STATE", "()Lorg/opensearch/replication/task/index/InitialState;", "TASK_NAME", "", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/logging/log4j/Logger;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InitialState getINITIAL_STATE() {
            return INITIAL_STATE;
        }

        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

