"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenSearchObservabilityPlugin = OpenSearchObservabilityPlugin;

var _shared = require("../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function OpenSearchObservabilityPlugin(Client, config, components) {
  const clientAction = components.clientAction.factory;
  Client.prototype.observability = components.clientAction.namespaceFactory();
  const observability = Client.prototype.observability.prototype; // Get Object

  observability.getObject = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT,
      params: {
        objectId: {
          type: "string"
        },
        objectIdList: {
          type: "string"
        },
        objectType: {
          type: "string"
        },
        sortField: {
          type: "string"
        },
        sortOrder: {
          type: "string"
        },
        fromIndex: {
          type: "number"
        },
        maxItems: {
          type: "number"
        },
        name: {
          type: "string"
        },
        lastUpdatedTimeMs: {
          type: "string"
        },
        createdTimeMs: {
          type: "string"
        }
      }
    },
    method: "GET"
  }); // Get Object by Id

  observability.getObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  }); // Create new Object

  observability.createObject = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT
    },
    method: "POST",
    needBody: true
  }); // Update Object by Id

  observability.updateObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: "string",
          required: true
        }
      }
    },
    method: "PUT",
    needBody: true
  }); // Delete Object by Id

  observability.deleteObjectById = clientAction({
    url: {
      fmt: `${_shared.OPENSEARCH_PANELS_API.OBJECT}/<%=objectId%>`,
      req: {
        objectId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  }); // Delete Object by Id List

  observability.deleteObjectByIdList = clientAction({
    url: {
      fmt: _shared.OPENSEARCH_PANELS_API.OBJECT,
      params: {
        objectIdList: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9wZW5zZWFyY2hfb2JzZXJ2YWJpbGl0eV9wbHVnaW4udHMiXSwibmFtZXMiOlsiT3BlblNlYXJjaE9ic2VydmFiaWxpdHlQbHVnaW4iLCJDbGllbnQiLCJjb25maWciLCJjb21wb25lbnRzIiwiY2xpZW50QWN0aW9uIiwiZmFjdG9yeSIsInByb3RvdHlwZSIsIm9ic2VydmFiaWxpdHkiLCJuYW1lc3BhY2VGYWN0b3J5IiwiZ2V0T2JqZWN0IiwidXJsIiwiZm10IiwiT1BFTlNFQVJDSF9QQU5FTFNfQVBJIiwiT0JKRUNUIiwicGFyYW1zIiwib2JqZWN0SWQiLCJ0eXBlIiwib2JqZWN0SWRMaXN0Iiwib2JqZWN0VHlwZSIsInNvcnRGaWVsZCIsInNvcnRPcmRlciIsImZyb21JbmRleCIsIm1heEl0ZW1zIiwibmFtZSIsImxhc3RVcGRhdGVkVGltZU1zIiwiY3JlYXRlZFRpbWVNcyIsIm1ldGhvZCIsImdldE9iamVjdEJ5SWQiLCJyZXEiLCJyZXF1aXJlZCIsImNyZWF0ZU9iamVjdCIsIm5lZWRCb2R5IiwidXBkYXRlT2JqZWN0QnlJZCIsImRlbGV0ZU9iamVjdEJ5SWQiLCJkZWxldGVPYmplY3RCeUlkTGlzdCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQUxBO0FBQ0E7QUFDQTtBQUNBO0FBSU8sU0FBU0EsNkJBQVQsQ0FDTEMsTUFESyxFQUVMQyxNQUZLLEVBR0xDLFVBSEssRUFJTDtBQUNBLFFBQU1DLFlBQVksR0FBR0QsVUFBVSxDQUFDQyxZQUFYLENBQXdCQyxPQUE3QztBQUVBSixFQUFBQSxNQUFNLENBQUNLLFNBQVAsQ0FBaUJDLGFBQWpCLEdBQWlDSixVQUFVLENBQUNDLFlBQVgsQ0FBd0JJLGdCQUF4QixFQUFqQztBQUNBLFFBQU1ELGFBQWEsR0FBR04sTUFBTSxDQUFDSyxTQUFQLENBQWlCQyxhQUFqQixDQUErQkQsU0FBckQsQ0FKQSxDQU1BOztBQUNBQyxFQUFBQSxhQUFhLENBQUNFLFNBQWQsR0FBMEJMLFlBQVksQ0FBQztBQUNyQ00sSUFBQUEsR0FBRyxFQUFFO0FBQ0hDLE1BQUFBLEdBQUcsRUFBRUMsOEJBQXNCQyxNQUR4QjtBQUVIQyxNQUFBQSxNQUFNLEVBQUU7QUFDTkMsUUFBQUEsUUFBUSxFQUFFO0FBQ1JDLFVBQUFBLElBQUksRUFBRTtBQURFLFNBREo7QUFJTkMsUUFBQUEsWUFBWSxFQUFFO0FBQ1pELFVBQUFBLElBQUksRUFBRTtBQURNLFNBSlI7QUFPTkUsUUFBQUEsVUFBVSxFQUFFO0FBQ1ZGLFVBQUFBLElBQUksRUFBRTtBQURJLFNBUE47QUFVTkcsUUFBQUEsU0FBUyxFQUFFO0FBQ1RILFVBQUFBLElBQUksRUFBRTtBQURHLFNBVkw7QUFhTkksUUFBQUEsU0FBUyxFQUFFO0FBQ1RKLFVBQUFBLElBQUksRUFBRTtBQURHLFNBYkw7QUFnQk5LLFFBQUFBLFNBQVMsRUFBRTtBQUNUTCxVQUFBQSxJQUFJLEVBQUU7QUFERyxTQWhCTDtBQW1CTk0sUUFBQUEsUUFBUSxFQUFFO0FBQ1JOLFVBQUFBLElBQUksRUFBRTtBQURFLFNBbkJKO0FBc0JOTyxRQUFBQSxJQUFJLEVBQUU7QUFDSlAsVUFBQUEsSUFBSSxFQUFFO0FBREYsU0F0QkE7QUF5Qk5RLFFBQUFBLGlCQUFpQixFQUFFO0FBQ2pCUixVQUFBQSxJQUFJLEVBQUU7QUFEVyxTQXpCYjtBQTRCTlMsUUFBQUEsYUFBYSxFQUFFO0FBQ2JULFVBQUFBLElBQUksRUFBRTtBQURPO0FBNUJUO0FBRkwsS0FEZ0M7QUFvQ3JDVSxJQUFBQSxNQUFNLEVBQUU7QUFwQzZCLEdBQUQsQ0FBdEMsQ0FQQSxDQThDQTs7QUFDQW5CLEVBQUFBLGFBQWEsQ0FBQ29CLGFBQWQsR0FBOEJ2QixZQUFZLENBQUM7QUFDekNNLElBQUFBLEdBQUcsRUFBRTtBQUNIQyxNQUFBQSxHQUFHLEVBQUcsR0FBRUMsOEJBQXNCQyxNQUFPLGdCQURsQztBQUVIZSxNQUFBQSxHQUFHLEVBQUU7QUFDSGIsUUFBQUEsUUFBUSxFQUFFO0FBQ1JDLFVBQUFBLElBQUksRUFBRSxRQURFO0FBRVJhLFVBQUFBLFFBQVEsRUFBRTtBQUZGO0FBRFA7QUFGRixLQURvQztBQVV6Q0gsSUFBQUEsTUFBTSxFQUFFO0FBVmlDLEdBQUQsQ0FBMUMsQ0EvQ0EsQ0E0REE7O0FBQ0FuQixFQUFBQSxhQUFhLENBQUN1QixZQUFkLEdBQTZCMUIsWUFBWSxDQUFDO0FBQ3hDTSxJQUFBQSxHQUFHLEVBQUU7QUFDSEMsTUFBQUEsR0FBRyxFQUFFQyw4QkFBc0JDO0FBRHhCLEtBRG1DO0FBSXhDYSxJQUFBQSxNQUFNLEVBQUUsTUFKZ0M7QUFLeENLLElBQUFBLFFBQVEsRUFBRTtBQUw4QixHQUFELENBQXpDLENBN0RBLENBcUVBOztBQUNBeEIsRUFBQUEsYUFBYSxDQUFDeUIsZ0JBQWQsR0FBaUM1QixZQUFZLENBQUM7QUFDNUNNLElBQUFBLEdBQUcsRUFBRTtBQUNIQyxNQUFBQSxHQUFHLEVBQUcsR0FBRUMsOEJBQXNCQyxNQUFPLGdCQURsQztBQUVIZSxNQUFBQSxHQUFHLEVBQUU7QUFDSGIsUUFBQUEsUUFBUSxFQUFFO0FBQ1JDLFVBQUFBLElBQUksRUFBRSxRQURFO0FBRVJhLFVBQUFBLFFBQVEsRUFBRTtBQUZGO0FBRFA7QUFGRixLQUR1QztBQVU1Q0gsSUFBQUEsTUFBTSxFQUFFLEtBVm9DO0FBVzVDSyxJQUFBQSxRQUFRLEVBQUU7QUFYa0MsR0FBRCxDQUE3QyxDQXRFQSxDQW9GQTs7QUFDQXhCLEVBQUFBLGFBQWEsQ0FBQzBCLGdCQUFkLEdBQWlDN0IsWUFBWSxDQUFDO0FBQzVDTSxJQUFBQSxHQUFHLEVBQUU7QUFDSEMsTUFBQUEsR0FBRyxFQUFHLEdBQUVDLDhCQUFzQkMsTUFBTyxnQkFEbEM7QUFFSGUsTUFBQUEsR0FBRyxFQUFFO0FBQ0hiLFFBQUFBLFFBQVEsRUFBRTtBQUNSQyxVQUFBQSxJQUFJLEVBQUUsUUFERTtBQUVSYSxVQUFBQSxRQUFRLEVBQUU7QUFGRjtBQURQO0FBRkYsS0FEdUM7QUFVNUNILElBQUFBLE1BQU0sRUFBRTtBQVZvQyxHQUFELENBQTdDLENBckZBLENBa0dBOztBQUNBbkIsRUFBQUEsYUFBYSxDQUFDMkIsb0JBQWQsR0FBcUM5QixZQUFZLENBQUM7QUFDaERNLElBQUFBLEdBQUcsRUFBRTtBQUNIQyxNQUFBQSxHQUFHLEVBQUVDLDhCQUFzQkMsTUFEeEI7QUFFSEMsTUFBQUEsTUFBTSxFQUFFO0FBQ05HLFFBQUFBLFlBQVksRUFBRTtBQUNaRCxVQUFBQSxJQUFJLEVBQUUsUUFETTtBQUVaYSxVQUFBQSxRQUFRLEVBQUU7QUFGRTtBQURSO0FBRkwsS0FEMkM7QUFVaERILElBQUFBLE1BQU0sRUFBRTtBQVZ3QyxHQUFELENBQWpEO0FBWUQiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IE9QRU5TRUFSQ0hfUEFORUxTX0FQSSB9IGZyb20gXCIuLi8uLi9jb21tb24vY29uc3RhbnRzL3NoYXJlZFwiO1xuXG5leHBvcnQgZnVuY3Rpb24gT3BlblNlYXJjaE9ic2VydmFiaWxpdHlQbHVnaW4oXG4gIENsaWVudDogYW55LFxuICBjb25maWc6IGFueSxcbiAgY29tcG9uZW50czogYW55XG4pIHtcbiAgY29uc3QgY2xpZW50QWN0aW9uID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24uZmFjdG9yeTtcblxuICBDbGllbnQucHJvdG90eXBlLm9ic2VydmFiaWxpdHkgPSBjb21wb25lbnRzLmNsaWVudEFjdGlvbi5uYW1lc3BhY2VGYWN0b3J5KCk7XG4gIGNvbnN0IG9ic2VydmFiaWxpdHkgPSBDbGllbnQucHJvdG90eXBlLm9ic2VydmFiaWxpdHkucHJvdG90eXBlO1xuXG4gIC8vIEdldCBPYmplY3RcbiAgb2JzZXJ2YWJpbGl0eS5nZXRPYmplY3QgPSBjbGllbnRBY3Rpb24oe1xuICAgIHVybDoge1xuICAgICAgZm10OiBPUEVOU0VBUkNIX1BBTkVMU19BUEkuT0JKRUNULFxuICAgICAgcGFyYW1zOiB7XG4gICAgICAgIG9iamVjdElkOiB7XG4gICAgICAgICAgdHlwZTogXCJzdHJpbmdcIixcbiAgICAgICAgfSxcbiAgICAgICAgb2JqZWN0SWRMaXN0OiB7XG4gICAgICAgICAgdHlwZTogXCJzdHJpbmdcIixcbiAgICAgICAgfSxcbiAgICAgICAgb2JqZWN0VHlwZToge1xuICAgICAgICAgIHR5cGU6IFwic3RyaW5nXCIsXG4gICAgICAgIH0sXG4gICAgICAgIHNvcnRGaWVsZDoge1xuICAgICAgICAgIHR5cGU6IFwic3RyaW5nXCIsXG4gICAgICAgIH0sXG4gICAgICAgIHNvcnRPcmRlcjoge1xuICAgICAgICAgIHR5cGU6IFwic3RyaW5nXCIsXG4gICAgICAgIH0sXG4gICAgICAgIGZyb21JbmRleDoge1xuICAgICAgICAgIHR5cGU6IFwibnVtYmVyXCIsXG4gICAgICAgIH0sXG4gICAgICAgIG1heEl0ZW1zOiB7XG4gICAgICAgICAgdHlwZTogXCJudW1iZXJcIixcbiAgICAgICAgfSxcbiAgICAgICAgbmFtZToge1xuICAgICAgICAgIHR5cGU6IFwic3RyaW5nXCIsXG4gICAgICAgIH0sXG4gICAgICAgIGxhc3RVcGRhdGVkVGltZU1zOiB7XG4gICAgICAgICAgdHlwZTogXCJzdHJpbmdcIixcbiAgICAgICAgfSxcbiAgICAgICAgY3JlYXRlZFRpbWVNczoge1xuICAgICAgICAgIHR5cGU6IFwic3RyaW5nXCIsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gICAgbWV0aG9kOiBcIkdFVFwiLFxuICB9KTtcblxuICAvLyBHZXQgT2JqZWN0IGJ5IElkXG4gIG9ic2VydmFiaWxpdHkuZ2V0T2JqZWN0QnlJZCA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke09QRU5TRUFSQ0hfUEFORUxTX0FQSS5PQkpFQ1R9LzwlPW9iamVjdElkJT5gLFxuICAgICAgcmVxOiB7XG4gICAgICAgIG9iamVjdElkOiB7XG4gICAgICAgICAgdHlwZTogXCJzdHJpbmdcIixcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBtZXRob2Q6IFwiR0VUXCIsXG4gIH0pO1xuXG4gIC8vIENyZWF0ZSBuZXcgT2JqZWN0XG4gIG9ic2VydmFiaWxpdHkuY3JlYXRlT2JqZWN0ID0gY2xpZW50QWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogT1BFTlNFQVJDSF9QQU5FTFNfQVBJLk9CSkVDVCxcbiAgICB9LFxuICAgIG1ldGhvZDogXCJQT1NUXCIsXG4gICAgbmVlZEJvZHk6IHRydWUsXG4gIH0pO1xuXG4gIC8vIFVwZGF0ZSBPYmplY3QgYnkgSWRcbiAgb2JzZXJ2YWJpbGl0eS51cGRhdGVPYmplY3RCeUlkID0gY2xpZW50QWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogYCR7T1BFTlNFQVJDSF9QQU5FTFNfQVBJLk9CSkVDVH0vPCU9b2JqZWN0SWQlPmAsXG4gICAgICByZXE6IHtcbiAgICAgICAgb2JqZWN0SWQ6IHtcbiAgICAgICAgICB0eXBlOiBcInN0cmluZ1wiLFxuICAgICAgICAgIHJlcXVpcmVkOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICAgIG1ldGhvZDogXCJQVVRcIixcbiAgICBuZWVkQm9keTogdHJ1ZSxcbiAgfSk7XG5cbiAgLy8gRGVsZXRlIE9iamVjdCBieSBJZFxuICBvYnNlcnZhYmlsaXR5LmRlbGV0ZU9iamVjdEJ5SWQgPSBjbGllbnRBY3Rpb24oe1xuICAgIHVybDoge1xuICAgICAgZm10OiBgJHtPUEVOU0VBUkNIX1BBTkVMU19BUEkuT0JKRUNUfS88JT1vYmplY3RJZCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBvYmplY3RJZDoge1xuICAgICAgICAgIHR5cGU6IFwic3RyaW5nXCIsXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gICAgbWV0aG9kOiBcIkRFTEVURVwiLFxuICB9KTtcblxuICAvLyBEZWxldGUgT2JqZWN0IGJ5IElkIExpc3RcbiAgb2JzZXJ2YWJpbGl0eS5kZWxldGVPYmplY3RCeUlkTGlzdCA9IGNsaWVudEFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IE9QRU5TRUFSQ0hfUEFORUxTX0FQSS5PQkpFQ1QsXG4gICAgICBwYXJhbXM6IHtcbiAgICAgICAgb2JqZWN0SWRMaXN0OiB7XG4gICAgICAgICAgdHlwZTogXCJzdHJpbmdcIixcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBtZXRob2Q6IFwiREVMRVRFXCIsXG4gIH0pO1xufVxuIl19