/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Map;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.geo.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.opensearch.geo.search.aggregations.metrics.GeoGridAggregatorSupplier;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexGridAggregatorFactory;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexHelper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;

public class GeoHexGridAggregationBuilder
extends GeoGridAggregationBuilder {
    public static final String NAME = "geohex_grid";
    public static final ValuesSourceRegistry.RegistryKey<GeoGridAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("geohex_grid", GeoGridAggregatorSupplier.class);
    public static final ObjectParser<GeoHexGridAggregationBuilder, String> PARSER = GeoHexGridAggregationBuilder.createParser((String)"geohex_grid", GeoHexGridAggregationBuilder::parsePrecision, GeoHexGridAggregationBuilder::new);
    private static final int DEFAULT_MAX_NUM_CELLS = 10000;
    private static final int DEFAULT_PRECISION = 5;
    private static final int DEFAULT_SHARD_SIZE = -1;

    public GeoHexGridAggregationBuilder(String name) {
        super(name);
        this.precision(5);
        this.size(10000);
        this.shardSize = -1;
    }

    public GeoHexGridAggregationBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public String getType() {
        return NAME;
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        GeoHexGridAggregatorFactory.registerAggregators(builder);
    }

    public GeoGridAggregationBuilder precision(int precision) {
        GeoHexHelper.checkPrecisionRange(precision);
        this.precision = precision;
        return this;
    }

    protected GeoHexGridAggregationBuilder(GeoGridAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
    }

    protected ValuesSourceAggregatorFactory createFactory(String name, ValuesSourceConfig config, int precision, int requiredSize, int shardSize, GeoBoundingBox geoBoundingBox, QueryShardContext queryShardContext, AggregatorFactory aggregatorFactory, AggregatorFactories.Builder builder, Map<String, Object> metadata) throws IOException {
        return new GeoHexGridAggregatorFactory(name, config, precision, requiredSize, shardSize, geoBoundingBox, queryShardContext, aggregatorFactory, builder, metadata);
    }

    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder builder, Map<String, Object> metadata) {
        return new GeoHexGridAggregationBuilder(this, builder, metadata);
    }

    private static int parsePrecision(XContentParser parser) throws IOException, OpenSearchParseException {
        XContentParser.Token token = parser.currentToken();
        if (token.equals((Object)XContentParser.Token.VALUE_NUMBER)) {
            return XContentMapValues.nodeIntegerValue((Object)parser.intValue());
        }
        String precision = parser.text();
        return XContentMapValues.nodeIntegerValue((Object)precision);
    }
}

