/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.function.FunctionProperties;

public final class DateTimeUtils {
    public static long roundFloor(long utcMillis, long unitMillis) {
        return utcMillis - utcMillis % unitMillis;
    }

    public static long roundWeek(long utcMillis, int interval) {
        return DateTimeUtils.roundFloor(utcMillis + 259200000L, 604800000L * (long)interval) - 259200000L;
    }

    public static long roundMonth(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC"));
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneId.of("UTC")).plusMonths(interval);
        long monthDiff = (long)(zonedDateTime.getYear() - initDateTime.getYear()) * 12L + (long)zonedDateTime.getMonthValue() - (long)initDateTime.getMonthValue();
        long monthToAdd = (monthDiff / (long)interval - 1L) * (long)interval;
        return initDateTime.plusMonths(monthToAdd).toInstant().toEpochMilli();
    }

    public static long roundQuarter(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC"));
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneId.of("UTC")).plusMonths((long)interval * 3L);
        long monthDiff = (long)(zonedDateTime.getYear() - initDateTime.getYear()) * 12L + (long)zonedDateTime.getMonthValue() - (long)initDateTime.getMonthValue();
        long monthToAdd = (monthDiff / ((long)interval * 3L) - 1L) * (long)interval * 3L;
        return initDateTime.plusMonths(monthToAdd).toInstant().toEpochMilli();
    }

    public static long roundYear(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC"));
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneId.of("UTC"));
        int yearDiff = zonedDateTime.getYear() - initDateTime.getYear();
        int yearToAdd = yearDiff / interval * interval;
        return initDateTime.plusYears(yearToAdd).toInstant().toEpochMilli();
    }

    public static long getWindowStartTime(long timestamp, long size) {
        return timestamp - timestamp % size;
    }

    public static Boolean isValidMySqlTimeZoneId(ZoneId zone) {
        String timeZoneMax = "+14:00";
        String timeZoneMin = "-13:59";
        String timeZoneZero = "+00:00";
        ZoneId maxTz = ZoneId.of(timeZoneMax);
        ZoneId minTz = ZoneId.of(timeZoneMin);
        ZoneId defaultTz = ZoneId.of(timeZoneZero);
        ZonedDateTime defaultDateTime = LocalDateTime.of(2000, 1, 2, 12, 0).atZone(defaultTz);
        ZonedDateTime maxTzValidator = defaultDateTime.withZoneSameInstant(maxTz).withZoneSameLocal(defaultTz);
        ZonedDateTime minTzValidator = defaultDateTime.withZoneSameInstant(minTz).withZoneSameLocal(defaultTz);
        ZonedDateTime passedTzValidator = defaultDateTime.withZoneSameInstant(zone).withZoneSameLocal(defaultTz);
        return !(!passedTzValidator.isBefore(maxTzValidator) && !passedTzValidator.isEqual(maxTzValidator) || !passedTzValidator.isAfter(minTzValidator) && !passedTzValidator.isEqual(minTzValidator));
    }

    public static LocalDateTime extractDateTime(ExprValue value, FunctionProperties functionProperties) {
        return value instanceof ExprTimeValue ? ((ExprTimeValue)value).datetimeValue(functionProperties) : value.datetimeValue();
    }

    public static LocalDate extractDate(ExprValue value, FunctionProperties functionProperties) {
        return value instanceof ExprTimeValue ? ((ExprTimeValue)value).dateValue(functionProperties) : value.dateValue();
    }

    @Generated
    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

