/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.standard.tag.common.sql.DataSourceWrapper;

public class DriverTag
extends TagSupport {
    private static final String DRIVER_CLASS_NAME = "jakarta.servlet.jsp.jstl.sql.driver";
    private static final String JDBC_URL = "jakarta.servlet.jsp.jstl.sql.jdbcURL";
    private static final String USER_NAME = "jakarta.servlet.jsp.jstl.sql.userName";
    private static final String PASSWORD = "jakarta.servlet.jsp.jstl.sql.password";
    private String driverClassName;
    private String jdbcURL;
    private int scope = 1;
    private String userName;
    private String var;

    public void setDriver(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public void setScope(String scopeName) {
        if ("page".equals(scopeName)) {
            this.scope = 1;
        } else if ("request".equals(scopeName)) {
            this.scope = 2;
        } else if ("session".equals(scopeName)) {
            this.scope = 3;
        } else if ("application".equals(scopeName)) {
            this.scope = 4;
        }
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setVar(String var) {
        this.var = var;
    }

    @Override
    public int doStartTag() throws JspException {
        DataSourceWrapper ds = new DataSourceWrapper();
        try {
            ds.setDriverClassName(this.getDriverClassName());
        }
        catch (Exception e) {
            throw new JspTagException("Invalid driver class name: " + e.toString(), e);
        }
        ds.setJdbcURL(this.getJdbcURL());
        ds.setUserName(this.getUserName());
        ds.setPassword(this.getPassword());
        this.pageContext.setAttribute(this.var, ds, this.scope);
        return 0;
    }

    private String getDriverClassName() {
        if (this.driverClassName != null) {
            return this.driverClassName;
        }
        ServletContext application = this.pageContext.getServletContext();
        return application.getInitParameter(DRIVER_CLASS_NAME);
    }

    private String getJdbcURL() {
        if (this.jdbcURL != null) {
            return this.jdbcURL;
        }
        ServletContext application = this.pageContext.getServletContext();
        return application.getInitParameter(JDBC_URL);
    }

    private String getUserName() {
        if (this.userName != null) {
            return this.userName;
        }
        ServletContext application = this.pageContext.getServletContext();
        return application.getInitParameter(USER_NAME);
    }

    private String getPassword() {
        ServletContext application = this.pageContext.getServletContext();
        return application.getInitParameter(PASSWORD);
    }
}

