# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
IGESData module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_igesdata.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _IGESData
else:
    import _IGESData

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IGESData.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _IGESData.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _IGESData.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _IGESData.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _IGESData.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _IGESData.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _IGESData.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _IGESData.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _IGESData.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _IGESData.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _IGESData.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _IGESData.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _IGESData.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _IGESData.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _IGESData.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _IGESData.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _IGESData.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _IGESData:
_IGESData.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _IGESData.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Interface
import OCC.Core.TCollection
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.MoniTool
import OCC.Core.TopoDS
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp

from enum import IntEnum
from OCC.Core.Exception import *

IGESData_ReadDir = _IGESData.IGESData_ReadDir
IGESData_ReadOwn = _IGESData.IGESData_ReadOwn
IGESData_ReadAssocs = _IGESData.IGESData_ReadAssocs
IGESData_ReadProps = _IGESData.IGESData_ReadProps
IGESData_ReadEnd = _IGESData.IGESData_ReadEnd
IGESData_DefNone = _IGESData.IGESData_DefNone
IGESData_DefOne = _IGESData.IGESData_DefOne
IGESData_DefSeveral = _IGESData.IGESData_DefSeveral
IGESData_ErrorOne = _IGESData.IGESData_ErrorOne
IGESData_ErrorSeveral = _IGESData.IGESData_ErrorSeveral
IGESData_EntityOK = _IGESData.IGESData_EntityOK
IGESData_EntityError = _IGESData.IGESData_EntityError
IGESData_ReferenceError = _IGESData.IGESData_ReferenceError
IGESData_TypeError = _IGESData.IGESData_TypeError
IGESData_DefVoid = _IGESData.IGESData_DefVoid
IGESData_DefValue = _IGESData.IGESData_DefValue
IGESData_DefReference = _IGESData.IGESData_DefReference
IGESData_DefAny = _IGESData.IGESData_DefAny
IGESData_ErrorVal = _IGESData.IGESData_ErrorVal
IGESData_ErrorRef = _IGESData.IGESData_ErrorRef


class IGESData_ReadStage(IntEnum):
	IGESData_ReadDir = 0
	IGESData_ReadOwn = 1
	IGESData_ReadAssocs = 2
	IGESData_ReadProps = 3
	IGESData_ReadEnd = 4
IGESData_ReadDir = IGESData_ReadStage.IGESData_ReadDir
IGESData_ReadOwn = IGESData_ReadStage.IGESData_ReadOwn
IGESData_ReadAssocs = IGESData_ReadStage.IGESData_ReadAssocs
IGESData_ReadProps = IGESData_ReadStage.IGESData_ReadProps
IGESData_ReadEnd = IGESData_ReadStage.IGESData_ReadEnd

class IGESData_DefList(IntEnum):
	IGESData_DefNone = 0
	IGESData_DefOne = 1
	IGESData_DefSeveral = 2
	IGESData_ErrorOne = 3
	IGESData_ErrorSeveral = 4
IGESData_DefNone = IGESData_DefList.IGESData_DefNone
IGESData_DefOne = IGESData_DefList.IGESData_DefOne
IGESData_DefSeveral = IGESData_DefList.IGESData_DefSeveral
IGESData_ErrorOne = IGESData_DefList.IGESData_ErrorOne
IGESData_ErrorSeveral = IGESData_DefList.IGESData_ErrorSeveral

class IGESData_Status(IntEnum):
	IGESData_EntityOK = 0
	IGESData_EntityError = 1
	IGESData_ReferenceError = 2
	IGESData_TypeError = 3
IGESData_EntityOK = IGESData_Status.IGESData_EntityOK
IGESData_EntityError = IGESData_Status.IGESData_EntityError
IGESData_ReferenceError = IGESData_Status.IGESData_ReferenceError
IGESData_TypeError = IGESData_Status.IGESData_TypeError

class IGESData_DefType(IntEnum):
	IGESData_DefVoid = 0
	IGESData_DefValue = 1
	IGESData_DefReference = 2
	IGESData_DefAny = 3
	IGESData_ErrorVal = 4
	IGESData_ErrorRef = 5
IGESData_DefVoid = IGESData_DefType.IGESData_DefVoid
IGESData_DefValue = IGESData_DefType.IGESData_DefValue
IGESData_DefReference = IGESData_DefType.IGESData_DefReference
IGESData_DefAny = IGESData_DefType.IGESData_DefAny
IGESData_ErrorVal = IGESData_DefType.IGESData_ErrorVal
IGESData_ErrorRef = IGESData_DefType.IGESData_ErrorRef


def Handle_IGESData_FileRecognizer_Create() -> "opencascade::handle< IGESData_FileRecognizer >":
    return _IGESData.Handle_IGESData_FileRecognizer_Create()

def Handle_IGESData_FileRecognizer_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_FileRecognizer >":
    return _IGESData.Handle_IGESData_FileRecognizer_DownCast(t)

def Handle_IGESData_FileRecognizer_IsNull(t: "opencascade::handle< IGESData_FileRecognizer > const &") -> "bool":
    return _IGESData.Handle_IGESData_FileRecognizer_IsNull(t)

def Handle_IGESData_GeneralModule_Create() -> "opencascade::handle< IGESData_GeneralModule >":
    return _IGESData.Handle_IGESData_GeneralModule_Create()

def Handle_IGESData_GeneralModule_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_GeneralModule >":
    return _IGESData.Handle_IGESData_GeneralModule_DownCast(t)

def Handle_IGESData_GeneralModule_IsNull(t: "opencascade::handle< IGESData_GeneralModule > const &") -> "bool":
    return _IGESData.Handle_IGESData_GeneralModule_IsNull(t)

def Handle_IGESData_GlobalNodeOfSpecificLib_Create() -> "opencascade::handle< IGESData_GlobalNodeOfSpecificLib >":
    return _IGESData.Handle_IGESData_GlobalNodeOfSpecificLib_Create()

def Handle_IGESData_GlobalNodeOfSpecificLib_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_GlobalNodeOfSpecificLib >":
    return _IGESData.Handle_IGESData_GlobalNodeOfSpecificLib_DownCast(t)

def Handle_IGESData_GlobalNodeOfSpecificLib_IsNull(t: "opencascade::handle< IGESData_GlobalNodeOfSpecificLib > const &") -> "bool":
    return _IGESData.Handle_IGESData_GlobalNodeOfSpecificLib_IsNull(t)

def Handle_IGESData_GlobalNodeOfWriterLib_Create() -> "opencascade::handle< IGESData_GlobalNodeOfWriterLib >":
    return _IGESData.Handle_IGESData_GlobalNodeOfWriterLib_Create()

def Handle_IGESData_GlobalNodeOfWriterLib_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_GlobalNodeOfWriterLib >":
    return _IGESData.Handle_IGESData_GlobalNodeOfWriterLib_DownCast(t)

def Handle_IGESData_GlobalNodeOfWriterLib_IsNull(t: "opencascade::handle< IGESData_GlobalNodeOfWriterLib > const &") -> "bool":
    return _IGESData.Handle_IGESData_GlobalNodeOfWriterLib_IsNull(t)

def Handle_IGESData_IGESEntity_Create() -> "opencascade::handle< IGESData_IGESEntity >":
    return _IGESData.Handle_IGESData_IGESEntity_Create()

def Handle_IGESData_IGESEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_IGESEntity >":
    return _IGESData.Handle_IGESData_IGESEntity_DownCast(t)

def Handle_IGESData_IGESEntity_IsNull(t: "opencascade::handle< IGESData_IGESEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_IGESEntity_IsNull(t)

def Handle_IGESData_IGESModel_Create() -> "opencascade::handle< IGESData_IGESModel >":
    return _IGESData.Handle_IGESData_IGESModel_Create()

def Handle_IGESData_IGESModel_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_IGESModel >":
    return _IGESData.Handle_IGESData_IGESModel_DownCast(t)

def Handle_IGESData_IGESModel_IsNull(t: "opencascade::handle< IGESData_IGESModel > const &") -> "bool":
    return _IGESData.Handle_IGESData_IGESModel_IsNull(t)

def Handle_IGESData_IGESReaderData_Create() -> "opencascade::handle< IGESData_IGESReaderData >":
    return _IGESData.Handle_IGESData_IGESReaderData_Create()

def Handle_IGESData_IGESReaderData_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_IGESReaderData >":
    return _IGESData.Handle_IGESData_IGESReaderData_DownCast(t)

def Handle_IGESData_IGESReaderData_IsNull(t: "opencascade::handle< IGESData_IGESReaderData > const &") -> "bool":
    return _IGESData.Handle_IGESData_IGESReaderData_IsNull(t)

def Handle_IGESData_NodeOfSpecificLib_Create() -> "opencascade::handle< IGESData_NodeOfSpecificLib >":
    return _IGESData.Handle_IGESData_NodeOfSpecificLib_Create()

def Handle_IGESData_NodeOfSpecificLib_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_NodeOfSpecificLib >":
    return _IGESData.Handle_IGESData_NodeOfSpecificLib_DownCast(t)

def Handle_IGESData_NodeOfSpecificLib_IsNull(t: "opencascade::handle< IGESData_NodeOfSpecificLib > const &") -> "bool":
    return _IGESData.Handle_IGESData_NodeOfSpecificLib_IsNull(t)

def Handle_IGESData_NodeOfWriterLib_Create() -> "opencascade::handle< IGESData_NodeOfWriterLib >":
    return _IGESData.Handle_IGESData_NodeOfWriterLib_Create()

def Handle_IGESData_NodeOfWriterLib_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_NodeOfWriterLib >":
    return _IGESData.Handle_IGESData_NodeOfWriterLib_DownCast(t)

def Handle_IGESData_NodeOfWriterLib_IsNull(t: "opencascade::handle< IGESData_NodeOfWriterLib > const &") -> "bool":
    return _IGESData.Handle_IGESData_NodeOfWriterLib_IsNull(t)

def Handle_IGESData_Protocol_Create() -> "opencascade::handle< IGESData_Protocol >":
    return _IGESData.Handle_IGESData_Protocol_Create()

def Handle_IGESData_Protocol_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_Protocol >":
    return _IGESData.Handle_IGESData_Protocol_DownCast(t)

def Handle_IGESData_Protocol_IsNull(t: "opencascade::handle< IGESData_Protocol > const &") -> "bool":
    return _IGESData.Handle_IGESData_Protocol_IsNull(t)

def Handle_IGESData_ReadWriteModule_Create() -> "opencascade::handle< IGESData_ReadWriteModule >":
    return _IGESData.Handle_IGESData_ReadWriteModule_Create()

def Handle_IGESData_ReadWriteModule_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_ReadWriteModule >":
    return _IGESData.Handle_IGESData_ReadWriteModule_DownCast(t)

def Handle_IGESData_ReadWriteModule_IsNull(t: "opencascade::handle< IGESData_ReadWriteModule > const &") -> "bool":
    return _IGESData.Handle_IGESData_ReadWriteModule_IsNull(t)

def Handle_IGESData_SpecificModule_Create() -> "opencascade::handle< IGESData_SpecificModule >":
    return _IGESData.Handle_IGESData_SpecificModule_Create()

def Handle_IGESData_SpecificModule_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_SpecificModule >":
    return _IGESData.Handle_IGESData_SpecificModule_DownCast(t)

def Handle_IGESData_SpecificModule_IsNull(t: "opencascade::handle< IGESData_SpecificModule > const &") -> "bool":
    return _IGESData.Handle_IGESData_SpecificModule_IsNull(t)

def Handle_IGESData_ToolLocation_Create() -> "opencascade::handle< IGESData_ToolLocation >":
    return _IGESData.Handle_IGESData_ToolLocation_Create()

def Handle_IGESData_ToolLocation_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_ToolLocation >":
    return _IGESData.Handle_IGESData_ToolLocation_DownCast(t)

def Handle_IGESData_ToolLocation_IsNull(t: "opencascade::handle< IGESData_ToolLocation > const &") -> "bool":
    return _IGESData.Handle_IGESData_ToolLocation_IsNull(t)

def Handle_IGESData_ColorEntity_Create() -> "opencascade::handle< IGESData_ColorEntity >":
    return _IGESData.Handle_IGESData_ColorEntity_Create()

def Handle_IGESData_ColorEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_ColorEntity >":
    return _IGESData.Handle_IGESData_ColorEntity_DownCast(t)

def Handle_IGESData_ColorEntity_IsNull(t: "opencascade::handle< IGESData_ColorEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_ColorEntity_IsNull(t)

def Handle_IGESData_DefaultGeneral_Create() -> "opencascade::handle< IGESData_DefaultGeneral >":
    return _IGESData.Handle_IGESData_DefaultGeneral_Create()

def Handle_IGESData_DefaultGeneral_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_DefaultGeneral >":
    return _IGESData.Handle_IGESData_DefaultGeneral_DownCast(t)

def Handle_IGESData_DefaultGeneral_IsNull(t: "opencascade::handle< IGESData_DefaultGeneral > const &") -> "bool":
    return _IGESData.Handle_IGESData_DefaultGeneral_IsNull(t)

def Handle_IGESData_DefaultSpecific_Create() -> "opencascade::handle< IGESData_DefaultSpecific >":
    return _IGESData.Handle_IGESData_DefaultSpecific_Create()

def Handle_IGESData_DefaultSpecific_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_DefaultSpecific >":
    return _IGESData.Handle_IGESData_DefaultSpecific_DownCast(t)

def Handle_IGESData_DefaultSpecific_IsNull(t: "opencascade::handle< IGESData_DefaultSpecific > const &") -> "bool":
    return _IGESData.Handle_IGESData_DefaultSpecific_IsNull(t)

def Handle_IGESData_FileProtocol_Create() -> "opencascade::handle< IGESData_FileProtocol >":
    return _IGESData.Handle_IGESData_FileProtocol_Create()

def Handle_IGESData_FileProtocol_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_FileProtocol >":
    return _IGESData.Handle_IGESData_FileProtocol_DownCast(t)

def Handle_IGESData_FileProtocol_IsNull(t: "opencascade::handle< IGESData_FileProtocol > const &") -> "bool":
    return _IGESData.Handle_IGESData_FileProtocol_IsNull(t)

def Handle_IGESData_LabelDisplayEntity_Create() -> "opencascade::handle< IGESData_LabelDisplayEntity >":
    return _IGESData.Handle_IGESData_LabelDisplayEntity_Create()

def Handle_IGESData_LabelDisplayEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_LabelDisplayEntity >":
    return _IGESData.Handle_IGESData_LabelDisplayEntity_DownCast(t)

def Handle_IGESData_LabelDisplayEntity_IsNull(t: "opencascade::handle< IGESData_LabelDisplayEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_LabelDisplayEntity_IsNull(t)

def Handle_IGESData_LevelListEntity_Create() -> "opencascade::handle< IGESData_LevelListEntity >":
    return _IGESData.Handle_IGESData_LevelListEntity_Create()

def Handle_IGESData_LevelListEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_LevelListEntity >":
    return _IGESData.Handle_IGESData_LevelListEntity_DownCast(t)

def Handle_IGESData_LevelListEntity_IsNull(t: "opencascade::handle< IGESData_LevelListEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_LevelListEntity_IsNull(t)

def Handle_IGESData_LineFontEntity_Create() -> "opencascade::handle< IGESData_LineFontEntity >":
    return _IGESData.Handle_IGESData_LineFontEntity_Create()

def Handle_IGESData_LineFontEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_LineFontEntity >":
    return _IGESData.Handle_IGESData_LineFontEntity_DownCast(t)

def Handle_IGESData_LineFontEntity_IsNull(t: "opencascade::handle< IGESData_LineFontEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_LineFontEntity_IsNull(t)

def Handle_IGESData_NameEntity_Create() -> "opencascade::handle< IGESData_NameEntity >":
    return _IGESData.Handle_IGESData_NameEntity_Create()

def Handle_IGESData_NameEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_NameEntity >":
    return _IGESData.Handle_IGESData_NameEntity_DownCast(t)

def Handle_IGESData_NameEntity_IsNull(t: "opencascade::handle< IGESData_NameEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_NameEntity_IsNull(t)

def Handle_IGESData_SingleParentEntity_Create() -> "opencascade::handle< IGESData_SingleParentEntity >":
    return _IGESData.Handle_IGESData_SingleParentEntity_Create()

def Handle_IGESData_SingleParentEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_SingleParentEntity >":
    return _IGESData.Handle_IGESData_SingleParentEntity_DownCast(t)

def Handle_IGESData_SingleParentEntity_IsNull(t: "opencascade::handle< IGESData_SingleParentEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_SingleParentEntity_IsNull(t)

def Handle_IGESData_TransfEntity_Create() -> "opencascade::handle< IGESData_TransfEntity >":
    return _IGESData.Handle_IGESData_TransfEntity_Create()

def Handle_IGESData_TransfEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_TransfEntity >":
    return _IGESData.Handle_IGESData_TransfEntity_DownCast(t)

def Handle_IGESData_TransfEntity_IsNull(t: "opencascade::handle< IGESData_TransfEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_TransfEntity_IsNull(t)

def Handle_IGESData_UndefinedEntity_Create() -> "opencascade::handle< IGESData_UndefinedEntity >":
    return _IGESData.Handle_IGESData_UndefinedEntity_Create()

def Handle_IGESData_UndefinedEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_UndefinedEntity >":
    return _IGESData.Handle_IGESData_UndefinedEntity_DownCast(t)

def Handle_IGESData_UndefinedEntity_IsNull(t: "opencascade::handle< IGESData_UndefinedEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_UndefinedEntity_IsNull(t)

def Handle_IGESData_ViewKindEntity_Create() -> "opencascade::handle< IGESData_ViewKindEntity >":
    return _IGESData.Handle_IGESData_ViewKindEntity_Create()

def Handle_IGESData_ViewKindEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_ViewKindEntity >":
    return _IGESData.Handle_IGESData_ViewKindEntity_DownCast(t)

def Handle_IGESData_ViewKindEntity_IsNull(t: "opencascade::handle< IGESData_ViewKindEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_ViewKindEntity_IsNull(t)

def Handle_IGESData_FreeFormatEntity_Create() -> "opencascade::handle< IGESData_FreeFormatEntity >":
    return _IGESData.Handle_IGESData_FreeFormatEntity_Create()

def Handle_IGESData_FreeFormatEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_FreeFormatEntity >":
    return _IGESData.Handle_IGESData_FreeFormatEntity_DownCast(t)

def Handle_IGESData_FreeFormatEntity_IsNull(t: "opencascade::handle< IGESData_FreeFormatEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_FreeFormatEntity_IsNull(t)

def Handle_IGESData_HArray1OfIGESEntity_Create() -> "opencascade::handle< IGESData_HArray1OfIGESEntity >":
    return _IGESData.Handle_IGESData_HArray1OfIGESEntity_Create()

def Handle_IGESData_HArray1OfIGESEntity_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< IGESData_HArray1OfIGESEntity >":
    return _IGESData.Handle_IGESData_HArray1OfIGESEntity_DownCast(t)

def Handle_IGESData_HArray1OfIGESEntity_IsNull(t: "opencascade::handle< IGESData_HArray1OfIGESEntity > const &") -> "bool":
    return _IGESData.Handle_IGESData_HArray1OfIGESEntity_IsNull(t)
class IGESData_Array1OfDirPart(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Array1< IGESData_DirPart >::iterator":
        return _IGESData.IGESData_Array1OfDirPart_begin(self)

    def end(self) -> "NCollection_Array1< IGESData_DirPart >::iterator":
        return _IGESData.IGESData_Array1OfDirPart_end(self)

    def cbegin(self) -> "NCollection_Array1< IGESData_DirPart >::const_iterator":
        return _IGESData.IGESData_Array1OfDirPart_cbegin(self)

    def cend(self) -> "NCollection_Array1< IGESData_DirPart >::const_iterator":
        return _IGESData.IGESData_Array1OfDirPart_cend(self)

    def __init__(self, *args):
        _IGESData.IGESData_Array1OfDirPart_swiginit(self, _IGESData.new_IGESData_Array1OfDirPart(*args))

    def Init(self, theValue: "IGESData_DirPart") -> "void":
        return _IGESData.IGESData_Array1OfDirPart_Init(self, theValue)

    def Size(self) -> "Standard_Integer":
        return _IGESData.IGESData_Array1OfDirPart_Size(self)

    def Length(self) -> "Standard_Integer":
        return _IGESData.IGESData_Array1OfDirPart_Length(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _IGESData.IGESData_Array1OfDirPart_IsEmpty(self)

    def Lower(self) -> "Standard_Integer":
        return _IGESData.IGESData_Array1OfDirPart_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _IGESData.IGESData_Array1OfDirPart_Upper(self)

    def IsDeletable(self) -> "Standard_Boolean":
        return _IGESData.IGESData_Array1OfDirPart_IsDeletable(self)

    def IsAllocated(self) -> "Standard_Boolean":
        return _IGESData.IGESData_Array1OfDirPart_IsAllocated(self)

    def Assign(self, theOther: "IGESData_Array1OfDirPart") -> "NCollection_Array1< IGESData_DirPart > &":
        return _IGESData.IGESData_Array1OfDirPart_Assign(self, theOther)

    def Move(self, theOther: "IGESData_Array1OfDirPart") -> "NCollection_Array1< IGESData_DirPart > &":
        return _IGESData.IGESData_Array1OfDirPart_Move(self, theOther)

    def Set(self, *args) -> "NCollection_Array1< IGESData_DirPart > &":
        return _IGESData.IGESData_Array1OfDirPart_Set(self, *args)

    def First(self) -> "IGESData_DirPart const &":
        return _IGESData.IGESData_Array1OfDirPart_First(self)

    def ChangeFirst(self) -> "IGESData_DirPart &":
        return _IGESData.IGESData_Array1OfDirPart_ChangeFirst(self)

    def Last(self) -> "IGESData_DirPart const &":
        return _IGESData.IGESData_Array1OfDirPart_Last(self)

    def ChangeLast(self) -> "IGESData_DirPart &":
        return _IGESData.IGESData_Array1OfDirPart_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "IGESData_DirPart const &":
        return _IGESData.IGESData_Array1OfDirPart_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "IGESData_DirPart &":
        return _IGESData.IGESData_Array1OfDirPart_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "IGESData_DirPart &":
        return _IGESData.IGESData_Array1OfDirPart___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "IGESData_DirPart") -> "void":
        return _IGESData.IGESData_Array1OfDirPart_SetValue(self, theIndex, theItem)

    def Resize(self, theLower: "Standard_Integer const", theUpper: "Standard_Integer const", theToCopyData: "Standard_Boolean const") -> "void":
        return _IGESData.IGESData_Array1OfDirPart_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _IGESData.delete_IGESData_Array1OfDirPart

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register IGESData_Array1OfDirPart in _IGESData:
_IGESData.IGESData_Array1OfDirPart_swigregister(IGESData_Array1OfDirPart)

class IGESData_Array1OfIGESEntity(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Array1< opencascade::handle< IGESData_IGESEntity > >::iterator":
        return _IGESData.IGESData_Array1OfIGESEntity_begin(self)

    def end(self) -> "NCollection_Array1< opencascade::handle< IGESData_IGESEntity > >::iterator":
        return _IGESData.IGESData_Array1OfIGESEntity_end(self)

    def cbegin(self) -> "NCollection_Array1< opencascade::handle< IGESData_IGESEntity > >::const_iterator":
        return _IGESData.IGESData_Array1OfIGESEntity_cbegin(self)

    def cend(self) -> "NCollection_Array1< opencascade::handle< IGESData_IGESEntity > >::const_iterator":
        return _IGESData.IGESData_Array1OfIGESEntity_cend(self)

    def __init__(self, *args):
        _IGESData.IGESData_Array1OfIGESEntity_swiginit(self, _IGESData.new_IGESData_Array1OfIGESEntity(*args))

    def Init(self, theValue: "opencascade::handle< IGESData_IGESEntity > const &") -> "void":
        return _IGESData.IGESData_Array1OfIGESEntity_Init(self, theValue)

    def Size(self) -> "Standard_Integer":
        return _IGESData.IGESData_Array1OfIGESEntity_Size(self)

    def Length(self) -> "Standard_Integer":
        return _IGESData.IGESData_Array1OfIGESEntity_Length(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _IGESData.IGESData_Array1OfIGESEntity_IsEmpty(self)

    def Lower(self) -> "Standard_Integer":
        return _IGESData.IGESData_Array1OfIGESEntity_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _IGESData.IGESData_Array1OfIGESEntity_Upper(self)

    def IsDeletable(self) -> "Standard_Boolean":
        return _IGESData.IGESData_Array1OfIGESEntity_IsDeletable(self)

    def IsAllocated(self) -> "Standard_Boolean":
        return _IGESData.IGESData_Array1OfIGESEntity_IsAllocated(self)

    def Assign(self, theOther: "IGESData_Array1OfIGESEntity") -> "NCollection_Array1< opencascade::handle< IGESData_IGESEntity > > &":
        return _IGESData.IGESData_Array1OfIGESEntity_Assign(self, theOther)

    def Move(self, theOther: "IGESData_Array1OfIGESEntity") -> "NCollection_Array1< opencascade::handle< IGESData_IGESEntity > > &":
        return _IGESData.IGESData_Array1OfIGESEntity_Move(self, theOther)

    def Set(self, *args) -> "NCollection_Array1< opencascade::handle< IGESData_IGESEntity > > &":
        return _IGESData.IGESData_Array1OfIGESEntity_Set(self, *args)

    def First(self) -> "opencascade::handle< IGESData_IGESEntity > const &":
        return _IGESData.IGESData_Array1OfIGESEntity_First(self)

    def ChangeFirst(self) -> "opencascade::handle< IGESData_IGESEntity > &":
        return _IGESData.IGESData_Array1OfIGESEntity_ChangeFirst(self)

    def Last(self) -> "opencascade::handle< IGESData_IGESEntity > const &":
        return _IGESData.IGESData_Array1OfIGESEntity_Last(self)

    def ChangeLast(self) -> "opencascade::handle< IGESData_IGESEntity > &":
        return _IGESData.IGESData_Array1OfIGESEntity_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "opencascade::handle< IGESData_IGESEntity > const &":
        return _IGESData.IGESData_Array1OfIGESEntity_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "opencascade::handle< IGESData_IGESEntity > &":
        return _IGESData.IGESData_Array1OfIGESEntity_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "opencascade::handle< IGESData_IGESEntity > &":
        return _IGESData.IGESData_Array1OfIGESEntity___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "opencascade::handle< IGESData_IGESEntity > const &") -> "void":
        return _IGESData.IGESData_Array1OfIGESEntity_SetValue(self, theIndex, theItem)

    def Resize(self, theLower: "Standard_Integer const", theUpper: "Standard_Integer const", theToCopyData: "Standard_Boolean const") -> "void":
        return _IGESData.IGESData_Array1OfIGESEntity_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _IGESData.delete_IGESData_Array1OfIGESEntity

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register IGESData_Array1OfIGESEntity in _IGESData:
_IGESData.IGESData_Array1OfIGESEntity_swigregister(IGESData_Array1OfIGESEntity)

class igesdata(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Init(*args) -> "void":
        r"""
        Prepares general dynamic data used for igesdata specifically : protocol and modules, which treat undefinedentity.

        Returns
        -------
        None

        """
        return _IGESData.igesdata_Init(*args)

    @staticmethod
    def Protocol(*args) -> "opencascade::handle< IGESData_Protocol >":
        r"""
        Returns a protocol from igesdata (avoids to create it).

        Returns
        -------
        opencascade::handle<IGESData_Protocol>

        """
        return _IGESData.igesdata_Protocol(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _IGESData.igesdata_swiginit(self, _IGESData.new_igesdata())
    __swig_destroy__ = _IGESData.delete_igesdata

# Register igesdata in _IGESData:
_IGESData.igesdata_swigregister(igesdata)

def igesdata_Init(*args) -> "void":
    r"""
    Prepares general dynamic data used for igesdata specifically : protocol and modules, which treat undefinedentity.

    Returns
    -------
    None

    """
    return _IGESData.igesdata_Init(*args)

def igesdata_Protocol(*args) -> "opencascade::handle< IGESData_Protocol >":
    r"""
    Returns a protocol from igesdata (avoids to create it).

    Returns
    -------
    opencascade::handle<IGESData_Protocol>

    """
    return _IGESData.igesdata_Protocol(*args)

class IGESData_BasicEditor(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty basic editor which should be initialized via init() method.

        Returns
        -------
        None
        Creates a basic editor, with a new igesmodel, ready to run.

        Parameters
        ----------
        protocol: IGESData_Protocol

        Returns
        -------
        None
        Creates a basic editor for iges data, ready to run.

        Parameters
        ----------
        model: IGESData_IGESModel
        protocol: IGESData_Protocol

        Returns
        -------
        None

        """
        _IGESData.IGESData_BasicEditor_swiginit(self, _IGESData.new_IGESData_BasicEditor(*args))

    def ApplyUnit(self, *args) -> "void":
        r"""
        Applies unit value to convert header data : resolution, maxcoord, maxlineweight applies unit only once after setunit... has been called, if <enforce> is given as true. it can be called just before writing the model to a file, i.e. when definitive values are finally known.

        Parameters
        ----------
        enforce: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _IGESData.IGESData_BasicEditor_ApplyUnit(self, *args)

    def AutoCorrect(self, *args) -> "Standard_Boolean":
        r"""
        Performs auto-correction on an igesentity returns true if something has changed, false if nothing done. //! works with the specific iges services : dirchecker which allows to correct data in 'directory part' of entities (such as required values for status, or references to be null), and the specific iges service owncorrect, which is specialised for each type of entity.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_BasicEditor_AutoCorrect(self, *args)

    def AutoCorrectModel(self, *args) -> "Standard_Integer":
        r"""
        Performs auto-correction on the whole model returns the count of modified entities.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_BasicEditor_AutoCorrectModel(self, *args)

    def ComputeStatus(self, *args) -> "void":
        r"""
        Performs the re-computation of status on the whole model (subordinate status and use flag of each iges entity), which can have required values according the way they are referenced (see definitions of logical use, physical use, etc...).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_BasicEditor_ComputeStatus(self, *args)

    @staticmethod
    def DraftingMax(*args) -> "Standard_Integer":
        r"""
        Returns the maximum allowed value for drafting flag.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_BasicEditor_DraftingMax(*args)

    @staticmethod
    def DraftingName(*args) -> "char const *":
        r"""
        From the flag of drafting standard, returns name, '' if incorrect.

        Parameters
        ----------
        flag: int

        Returns
        -------
        char *

        """
        return _IGESData.IGESData_BasicEditor_DraftingName(*args)

    @staticmethod
    def IGESVersionMax(*args) -> "Standard_Integer":
        r"""
        Returns the maximum allowed value for igesversion flag.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_BasicEditor_IGESVersionMax(*args)

    @staticmethod
    def IGESVersionName(*args) -> "char const *":
        r"""
        From the flag of iges version, returns name, '' if incorrect.

        Parameters
        ----------
        flag: int

        Returns
        -------
        char *

        """
        return _IGESData.IGESData_BasicEditor_IGESVersionName(*args)

    def Init(self, *args) -> "void":
        r"""
        Initialize a basic editor, with a new igesmodel, ready to run.

        Parameters
        ----------
        protocol: IGESData_Protocol

        Returns
        -------
        None
        Initialize a basic editor for iges data, ready to run.

        Parameters
        ----------
        model: IGESData_IGESModel
        protocol: IGESData_Protocol

        Returns
        -------
        None

        """
        return _IGESData.IGESData_BasicEditor_Init(self, *args)

    def Model(self, *args) -> "opencascade::handle< IGESData_IGESModel >":
        r"""
        Returns the designated model.

        Returns
        -------
        opencascade::handle<IGESData_IGESModel>

        """
        return _IGESData.IGESData_BasicEditor_Model(self, *args)

    def SetUnitFlag(self, *args) -> "Standard_Boolean":
        r"""
        Sets a new unit from its flag (param 14 of global section) returns true if done, false if <flag> is incorrect.

        Parameters
        ----------
        flag: int

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_BasicEditor_SetUnitFlag(self, *args)

    def SetUnitName(self, *args) -> "Standard_Boolean":
        r"""
        Sets a new unit from its name (param 15 of global section) returns true if done, false if <name> is incorrect remark : if <flag> has been set to 3 (user defined), <name> is then free.

        Parameters
        ----------
        name: char *

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_BasicEditor_SetUnitName(self, *args)

    def SetUnitValue(self, *args) -> "Standard_Boolean":
        r"""
        Sets a new unit from its value in meters (rounded to the closest one, max gap 1%) returns true if done, false if <val> is too far from a suitable value.

        Parameters
        ----------
        val: float

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_BasicEditor_SetUnitValue(self, *args)

    @staticmethod
    def UnitFlagName(*args) -> "char const *":
        r"""
        From the flag of unit, determines its name, '' if incorrect.

        Parameters
        ----------
        flag: int

        Returns
        -------
        char *

        """
        return _IGESData.IGESData_BasicEditor_UnitFlagName(*args)

    @staticmethod
    def UnitFlagValue(*args) -> "Standard_Real":
        r"""
        From the flag of unit, determines value in mm, 0 if incorrect.

        Parameters
        ----------
        flag: int

        Returns
        -------
        float

        """
        return _IGESData.IGESData_BasicEditor_UnitFlagValue(*args)

    @staticmethod
    def UnitNameFlag(*args) -> "Standard_Integer":
        r"""
        From the name of unit, computes flag number, 0 if incorrect (in this case, user defined entity remains possible).

        Parameters
        ----------
        name: char *

        Returns
        -------
        int

        """
        return _IGESData.IGESData_BasicEditor_UnitNameFlag(*args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_BasicEditor

# Register IGESData_BasicEditor in _IGESData:
_IGESData.IGESData_BasicEditor_swigregister(IGESData_BasicEditor)

def IGESData_BasicEditor_DraftingMax(*args) -> "Standard_Integer":
    r"""
    Returns the maximum allowed value for drafting flag.

    Returns
    -------
    int

    """
    return _IGESData.IGESData_BasicEditor_DraftingMax(*args)

def IGESData_BasicEditor_DraftingName(*args) -> "char const *":
    r"""
    From the flag of drafting standard, returns name, '' if incorrect.

    Parameters
    ----------
    flag: int

    Returns
    -------
    char *

    """
    return _IGESData.IGESData_BasicEditor_DraftingName(*args)

def IGESData_BasicEditor_IGESVersionMax(*args) -> "Standard_Integer":
    r"""
    Returns the maximum allowed value for igesversion flag.

    Returns
    -------
    int

    """
    return _IGESData.IGESData_BasicEditor_IGESVersionMax(*args)

def IGESData_BasicEditor_IGESVersionName(*args) -> "char const *":
    r"""
    From the flag of iges version, returns name, '' if incorrect.

    Parameters
    ----------
    flag: int

    Returns
    -------
    char *

    """
    return _IGESData.IGESData_BasicEditor_IGESVersionName(*args)

def IGESData_BasicEditor_UnitFlagName(*args) -> "char const *":
    r"""
    From the flag of unit, determines its name, '' if incorrect.

    Parameters
    ----------
    flag: int

    Returns
    -------
    char *

    """
    return _IGESData.IGESData_BasicEditor_UnitFlagName(*args)

def IGESData_BasicEditor_UnitFlagValue(*args) -> "Standard_Real":
    r"""
    From the flag of unit, determines value in mm, 0 if incorrect.

    Parameters
    ----------
    flag: int

    Returns
    -------
    float

    """
    return _IGESData.IGESData_BasicEditor_UnitFlagValue(*args)

def IGESData_BasicEditor_UnitNameFlag(*args) -> "Standard_Integer":
    r"""
    From the name of unit, computes flag number, 0 if incorrect (in this case, user defined entity remains possible).

    Parameters
    ----------
    name: char *

    Returns
    -------
    int

    """
    return _IGESData.IGESData_BasicEditor_UnitNameFlag(*args)

class IGESData_DefSwitch(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a defswitch as void.

        Returns
        -------
        None

        """
        _IGESData.IGESData_DefSwitch_swiginit(self, _IGESData.new_IGESData_DefSwitch(*args))

    def DefType(self, *args) -> "IGESData_DefType":
        r"""
        Returns deftype status (void,reference,rank).

        Returns
        -------
        IGESData_DefType

        """
        return _IGESData.IGESData_DefSwitch_DefType(self, *args)

    def SetRank(self, *args) -> "void":
        r"""
        Sets defswitch to 'rank' with a value (in file : integer > 0).

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DefSwitch_SetRank(self, *args)

    def SetReference(self, *args) -> "void":
        r"""
        Sets defswitch to 'reference' status (in file : integer < 0).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DefSwitch_SetReference(self, *args)

    def SetVoid(self, *args) -> "void":
        r"""
        Sets defswitch to 'void' status (in file : integer = 0).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DefSwitch_SetVoid(self, *args)

    def Value(self, *args) -> "Standard_Integer":
        r"""
        Returns value as integer (sensefull for a rank).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_DefSwitch_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DefSwitch

# Register IGESData_DefSwitch in _IGESData:
_IGESData.IGESData_DefSwitch_swigregister(IGESData_DefSwitch)

class IGESData_DirChecker(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns a dirchecker, with no criterium at all to be checked.

        Returns
        -------
        None
        Returns a dirchecker, with no criterium except required type.

        Parameters
        ----------
        atype: int

        Returns
        -------
        None
        Returns a dirchecker, with no criterium except required values for type and form numbers.

        Parameters
        ----------
        atype: int
        aform: int

        Returns
        -------
        None
        Returns a dirchecker, with no criterium except required values for type number (atype), and required range for form number (which must be between aform1 and aform2 included).

        Parameters
        ----------
        atype: int
        aform1: int
        aform2: int

        Returns
        -------
        None

        """
        _IGESData.IGESData_DirChecker_swiginit(self, _IGESData.new_IGESData_DirChecker(*args))

    def BlankStatusIgnored(self, *args) -> "void":
        r"""
        Sets blank status to be ignored (should not be defined, or its value should be 0).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_BlankStatusIgnored(self, *args)

    def BlankStatusRequired(self, *args) -> "void":
        r"""
        Sets blank status to be required at a given value.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_BlankStatusRequired(self, *args)

    def Check(self, *args) -> "void":
        r"""
        Performs the checks on an igesentity, according to the recorded criteria in addition, does minimal checks, such as admitted range for status, or presence of error status in some data (color, ...).

        Parameters
        ----------
        ach: Interface_Check
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_Check(self, *args)

    def CheckTypeAndForm(self, *args) -> "void":
        r"""
        Performs a check only on values of type number and form number this allows to do a check on an entity not yet completely filled but of which type and form number have been already set.

        Parameters
        ----------
        ach: Interface_Check
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_CheckTypeAndForm(self, *args)

    def Color(self, *args) -> "void":
        r"""
        Sets color criterium if crit is defvoid, ignored : should not be defined if crit is defany, required : must be defined (value or ref) other values are not taken in account.

        Parameters
        ----------
        crit: IGESData_DefType

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_Color(self, *args)

    def Correct(self, *args) -> "Standard_Boolean":
        r"""
        Corrects the directory entry of an iges entity as far as it is possible according recorded criteria without any ambiguity : - if a numeric status is required a given value, this value is enforced - if an item is required to be void, or if it recorded as erroneous, it is cleared (set to void) - type number is enforced - finally form number is enforced only if one and only value is admitted (no range, see constructors of dirchecker).

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_DirChecker_Correct(self, *args)

    def GraphicsIgnored(self, *args) -> "void":
        r"""
        Sets graphics data (linefont, lineweight, color, level, view) to be ignored according value of hierarchy status : if hierarchy is not given, they are ignored any way (that is, they should not be defined) if hierarchy is given, graphics are ignored if the hierarchy status has the value given in argument 'hierarchy'.

        Parameters
        ----------
        hierarchy: int,optional
        	default value is -1

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_GraphicsIgnored(self, *args)

    def HierarchyStatusIgnored(self, *args) -> "void":
        r"""
        Sets hierarchy status to be ignored (should not be defined, or its value should be 0).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_HierarchyStatusIgnored(self, *args)

    def HierarchyStatusRequired(self, *args) -> "void":
        r"""
        Sets hierarchy status to be required at a given value.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_HierarchyStatusRequired(self, *args)

    def IsSet(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if at least one criterium has already been set allows user to store a dirchecker (static variable) then ask if it has been set before setting it.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_DirChecker_IsSet(self, *args)

    def LineFont(self, *args) -> "void":
        r"""
        Sets linefont criterium if crit is defvoid, ignored : should not be defined if crit is defany, required : must be defined (value or ref) if crit is defvalue, required as a value (error if reference) other values are not taken in account.

        Parameters
        ----------
        crit: IGESData_DefType

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_LineFont(self, *args)

    def LineWeight(self, *args) -> "void":
        r"""
        Sets lineweight criterium if crit is defvoid, ignored : should not be defined if crit is defvalue, required other values are not taken in account.

        Parameters
        ----------
        crit: IGESData_DefType

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_LineWeight(self, *args)

    def SetDefault(self, *args) -> "void":
        r"""
        Sets a dirchecker with most current criteria, that is : structure ignored ( worths call structure(crit = defvoid) ).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_SetDefault(self, *args)

    def Structure(self, *args) -> "void":
        r"""
        Sets structure criterium. if crit is defvoid, ignored : should not be defined if crit is defreference, required : must be defined other values are not taken in account.

        Parameters
        ----------
        crit: IGESData_DefType

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_Structure(self, *args)

    def SubordinateStatusIgnored(self, *args) -> "void":
        r"""
        Sets subordinate status to be ignored (should not be defined, or its value should be 0).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_SubordinateStatusIgnored(self, *args)

    def SubordinateStatusRequired(self, *args) -> "void":
        r"""
        Sets subordinate status to be required at a given value.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_SubordinateStatusRequired(self, *args)

    def UseFlagIgnored(self, *args) -> "void":
        r"""
        Sets blank status to be ignored (should not be defined, or its value should be 0).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_UseFlagIgnored(self, *args)

    def UseFlagRequired(self, *args) -> "void":
        r"""
        Sets blank status to be required at a given value give -1 to demand useflag not zero (but no precise value req.).

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirChecker_UseFlagRequired(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DirChecker

# Register IGESData_DirChecker in _IGESData:
_IGESData.IGESData_DirChecker_swigregister(IGESData_DirChecker)

class IGESData_DirPart(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty dirpart, ready to be filled by init.

        Returns
        -------
        None

        """
        _IGESData.IGESData_DirPart_swiginit(self, _IGESData.new_IGESData_DirPart(*args))

    def Init(self, *args) -> "void":
        r"""
        Fills dirpart with consistent data read from file.

        Parameters
        ----------
        i1: int
        i2: int
        i3: int
        i4: int
        i5: int
        i6: int
        i7: int
        i8: int
        i9: int
        i19: int
        i11: int
        i12: int
        i13: int
        i14: int
        i15: int
        i16: int
        i17: int
        res1: char *
        res2: char *
        label: char *
        subscript: char *

        Returns
        -------
        None

        """
        return _IGESData.IGESData_DirPart_Init(self, *args)

    def Type(self, *args) -> "IGESData_IGESType":
        r"""
        Returns 'type' and 'form' info, used to recognize the entity.

        Returns
        -------
        IGESData_IGESType

        """
        return _IGESData.IGESData_DirPart_Type(self, *args)

    def Values(self, *args) -> "void":
        r"""
        Returns values recorded in dirpart (content of cstrings are modified).

        Parameters
        ----------
        res1: char *
        res2: char *
        label: char *
        subscript: char *

        Returns
        -------
        i1: int
        i2: int
        i3: int
        i4: int
        i5: int
        i6: int
        i7: int
        i8: int
        i9: int
        i19: int
        i11: int
        i12: int
        i13: int
        i14: int
        i15: int
        i16: int
        i17: int

        """
        return _IGESData.IGESData_DirPart_Values(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DirPart

# Register IGESData_DirPart in _IGESData:
_IGESData.IGESData_DirPart_swigregister(IGESData_DirPart)

class IGESData_FileRecognizer(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Add(self, *args) -> "void":
        r"""
        Adds a new recognizer to the compound, at the end several calls to add work by adding in the order of calls : hence, when eval has failed to recognize, evaluate will call evaluate from the first added recognizer if there is one, and to the second if there is still no result, and so on.

        Parameters
        ----------
        reco: IGESData_FileRecognizer

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FileRecognizer_Add(self, *args)

    def Evaluate(self, *args) -> "Standard_Boolean":
        r"""
        Evaluates if recognition has a result, returns it if yes in case of success, returns true and puts result in 'res' in case of failure, simply returns false works by calling deferred method eval, and in case of failure, looks for added recognizers to work.

        Parameters
        ----------
        akey: IGESData_IGESType
        res: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_FileRecognizer_Evaluate(self, *args)

    def Result(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns result of last recognition (call of evaluate).

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_FileRecognizer_Result(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_FileRecognizer_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_FileRecognizer

# Register IGESData_FileRecognizer in _IGESData:
_IGESData.IGESData_FileRecognizer_swigregister(IGESData_FileRecognizer)

class IGESData_GeneralModule(OCC.Core.Interface.Interface_GeneralModule):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def DirChecker(self, *args) -> "IGESData_DirChecker":
        r"""
        Returns a dirchecker, specific for each type of entity (identified by its case number) : this dirchecker defines constraints which must be respected by the directorypart.

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity

        Returns
        -------
        IGESData_DirChecker

        """
        return _IGESData.IGESData_GeneralModule_DirChecker(self, *args)

    def OwnCheckCase(self, *args) -> "void":
        r"""
        Performs specific semantic check for each type of entity.

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        shares: Interface_ShareTool
        ach: Interface_Check

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GeneralModule_OwnCheckCase(self, *args)

    def OwnCopyCase(self, *args) -> "void":
        r"""
        Copies parameters which are specific of each type of entity.

        Parameters
        ----------
        CN: int
        entfrom: IGESData_IGESEntity
        entto: IGESData_IGESEntity
        TC: Interface_CopyTool

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GeneralModule_OwnCopyCase(self, *args)

    def OwnDeleteCase(self, *args) -> "void":
        r"""
        Specific preparation for delete, acts on own parameters default does nothing, to be redefined as required.

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GeneralModule_OwnDeleteCase(self, *args)

    def OwnImpliedCase(self, *args) -> "void":
        r"""
        Specific list of entities implied by a given igesentity <ent> (in addition to associativities). by default, there are none, but this method can be redefined as required.

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        iter: Interface_EntityIterator

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GeneralModule_OwnImpliedCase(self, *args)

    def OwnRenewCase(self, *args) -> "void":
        r"""
        Renews parameters which are specific of each type of entity : the provided default does nothing, but this method may be redefined as required.

        Parameters
        ----------
        CN: int
        entfrom: IGESData_IGESEntity
        entto: IGESData_IGESEntity
        TC: Interface_CopyTool

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GeneralModule_OwnRenewCase(self, *args)

    def OwnSharedCase(self, *args) -> "void":
        r"""
        Lists the entities shared by a given igesentity <ent>, from its specific parameters : specific for each type.

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        iter: Interface_EntityIterator

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GeneralModule_OwnSharedCase(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_GeneralModule_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_GeneralModule

# Register IGESData_GeneralModule in _IGESData:
_IGESData.IGESData_GeneralModule_swigregister(IGESData_GeneralModule)

class IGESData_GlobalNodeOfSpecificLib(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty globalnode, with no next.

        Returns
        -------
        None

        """
        _IGESData.IGESData_GlobalNodeOfSpecificLib_swiginit(self, _IGESData.new_IGESData_GlobalNodeOfSpecificLib(*args))

    def Add(self, *args) -> "void":
        r"""
        Adds a module bound with a protocol to the list : does nothing if already in the list, that is, same type (exact match) and same state (that is, isequal is not required) once added, stores its attached protocol in correspondence.

        Parameters
        ----------
        amodule: IGESData_SpecificModule
        aprotocol: IGESData_Protocol

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalNodeOfSpecificLib_Add(self, *args)

    def Module(self, *args) -> "opencascade::handle< IGESData_SpecificModule > const &":
        r"""
        Returns the module stored in a given globalnode.

        Returns
        -------
        opencascade::handle<IGESData_SpecificModule>

        """
        return _IGESData.IGESData_GlobalNodeOfSpecificLib_Module(self, *args)

    def Next(self, *args) -> "opencascade::handle< IGESData_GlobalNodeOfSpecificLib > const &":
        r"""
        Returns the next globalnode. if none is defined, returned value is a null handle.

        Returns
        -------
        opencascade::handle<IGESData_GlobalNodeOfSpecificLib>

        """
        return _IGESData.IGESData_GlobalNodeOfSpecificLib_Next(self, *args)

    def Protocol(self, *args) -> "opencascade::handle< IGESData_Protocol > const &":
        r"""
        Returns the attached protocol stored in a given globalnode.

        Returns
        -------
        opencascade::handle<IGESData_Protocol>

        """
        return _IGESData.IGESData_GlobalNodeOfSpecificLib_Protocol(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_GlobalNodeOfSpecificLib_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_GlobalNodeOfSpecificLib

# Register IGESData_GlobalNodeOfSpecificLib in _IGESData:
_IGESData.IGESData_GlobalNodeOfSpecificLib_swigregister(IGESData_GlobalNodeOfSpecificLib)

class IGESData_GlobalNodeOfWriterLib(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty globalnode, with no next.

        Returns
        -------
        None

        """
        _IGESData.IGESData_GlobalNodeOfWriterLib_swiginit(self, _IGESData.new_IGESData_GlobalNodeOfWriterLib(*args))

    def Add(self, *args) -> "void":
        r"""
        Adds a module bound with a protocol to the list: does nothing if already in the list, that is, same type (exact match) and same state (that is, isequal is not required). once added, stores its attached protocol in correspondence.

        Parameters
        ----------
        amodule: IGESData_ReadWriteModule
        aprotocol: IGESData_Protocol

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalNodeOfWriterLib_Add(self, *args)

    def Module(self, *args) -> "opencascade::handle< IGESData_ReadWriteModule > const &":
        r"""
        Returns the module stored in a given globalnode.

        Returns
        -------
        opencascade::handle<IGESData_ReadWriteModule>

        """
        return _IGESData.IGESData_GlobalNodeOfWriterLib_Module(self, *args)

    def Next(self, *args) -> "opencascade::handle< IGESData_GlobalNodeOfWriterLib > const &":
        r"""
        Returns the next globalnode. if none is defined, returned value is a null handle.

        Returns
        -------
        opencascade::handle<IGESData_GlobalNodeOfWriterLib>

        """
        return _IGESData.IGESData_GlobalNodeOfWriterLib_Next(self, *args)

    def Protocol(self, *args) -> "opencascade::handle< IGESData_Protocol > const &":
        r"""
        Returns the attached protocol stored in a given globalnode.

        Returns
        -------
        opencascade::handle<IGESData_Protocol>

        """
        return _IGESData.IGESData_GlobalNodeOfWriterLib_Protocol(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_GlobalNodeOfWriterLib_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_GlobalNodeOfWriterLib

# Register IGESData_GlobalNodeOfWriterLib in _IGESData:
_IGESData.IGESData_GlobalNodeOfWriterLib_swigregister(IGESData_GlobalNodeOfWriterLib)

class IGESData_GlobalSection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty globalsection, ready to be filled, warning : no default value is provided.

        Returns
        -------
        None

        """
        _IGESData.IGESData_GlobalSection_swiginit(self, _IGESData.new_IGESData_GlobalSection(*args))

    def ApplicationProtocol(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_ApplicationProtocol(self, *args)

    def AuthorName(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the name of the iges file author.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_AuthorName(self, *args)

    def CascadeUnit(self, *args) -> "Standard_Real":
        r"""
        Returns the system length unit.

        Returns
        -------
        float

        """
        return _IGESData.IGESData_GlobalSection_CascadeUnit(self, *args)

    def CompanyName(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the name of the company where the iges file was written.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_CompanyName(self, *args)

    def CopyRefs(self, *args) -> "void":
        r"""
        Copies data referenced by handle (that is, strings) useful to 'isolate' a globalsection after copy by '=' (from a model to another model for instance).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_CopyRefs(self, *args)

    def Date(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the iges file creation date.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_Date(self, *args)

    def DraftingStandard(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_DraftingStandard(self, *args)

    def EndMark(self, *args) -> "Standard_Character":
        r"""
        Returns the record delimiter character.

        Returns
        -------
        Standard_Character

        """
        return _IGESData.IGESData_GlobalSection_EndMark(self, *args)

    def FileName(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the name of the iges file.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_FileName(self, *args)

    def HasApplicationProtocol(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_GlobalSection_HasApplicationProtocol(self, *args)

    def HasLastChangeDate(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the date and time when the model was created or last modified are specified, i.e. not defaulted to null.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_GlobalSection_HasLastChangeDate(self, *args)

    def HasMaxCoord(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the approximate maximum coordinate value found in the model is greater than 0.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_GlobalSection_HasMaxCoord(self, *args)

    def IGESVersion(self, *args) -> "Standard_Integer":
        r"""
        Returns the iges version that the iges file was written in.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_IGESVersion(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Fills globalsection from a paramset (i.e. taken from file) undefined parameters do not change default values when defined fills check about corrections or fails.

        Parameters
        ----------
        params: Interface_ParamSet
        ach: Interface_Check

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_Init(self, *args)

    def IntegerBits(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of binary bits for integer representations.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_IntegerBits(self, *args)

    def InterfaceVersion(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the name of the pre-processor used to write the iges file.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_InterfaceVersion(self, *args)

    def LastChangeDate(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the date and time when the model was created or last modified (for iges 5.1 and later).

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_LastChangeDate(self, *args)

    def LineWeightGrad(self, *args) -> "Standard_Integer":
        r"""
        Returns the maximum number of line weight gradations.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_LineWeightGrad(self, *args)

    def MaxCoord(self, *args) -> "Standard_Real":
        r"""
        Returns the approximate maximum coordinate value found in the model.

        Returns
        -------
        float

        """
        return _IGESData.IGESData_GlobalSection_MaxCoord(self, *args)

    def MaxDigitsDouble(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_MaxDigitsDouble(self, *args)

    def MaxDigitsSingle(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_MaxDigitsSingle(self, *args)

    def MaxLineWeight(self, *args) -> "Standard_Real":
        r"""
        Returns the of maximum line weight width in iges file units.

        Returns
        -------
        float

        """
        return _IGESData.IGESData_GlobalSection_MaxLineWeight(self, *args)

    def MaxMaxCoord(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: float,optional
        	default value is 0.0

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_MaxMaxCoord(self, *args)

    def MaxMaxCoords(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        xyz: gp_XYZ

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_MaxMaxCoords(self, *args)

    def MaxPower10Double(self, *args) -> "Standard_Integer":
        r"""
        Returns the maximum power of a decimal representation of a double-precision floating point number in the sending system.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_MaxPower10Double(self, *args)

    def MaxPower10Single(self, *args) -> "Standard_Integer":
        r"""
        Returns the maximum power of a decimal representation of a single-precision floating point number in the sending system.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_MaxPower10Single(self, *args)

    @staticmethod
    def NewDateString(*args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns a string built from year, month, day, hour, minute and second values. the form of the resulting string is defined as follows: - -1: yymmdd.hhnnss, - 0: yyyymmdd.hhnnss, - 1: yyyy-mm-dd:hh-nn-ss, where: - yyyy or yy is 4 or 2 digit year, - hh is hour (00-23), - mm is month (01-12), - nn is minute (00-59) - dd is day (01-31), - ss is second (00-59).

        Parameters
        ----------
        year: int
        month: int
        day: int
        hour: int
        minut: int
        second: int
        mode: int,optional
        	default value is -1

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>
        Converts the string given in the form yymmdd.hhnnss or yyyymmdd.hhnnss to either yymmdd.hhnnss, yyyymmdd.hhnnss or yyyy-mm-dd:hh-nn-ss.

        Parameters
        ----------
        date: TCollection_HAsciiString
        mode: int,optional
        	default value is 1

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_NewDateString(*args)

    def Params(self, *args) -> "opencascade::handle< Interface_ParamSet >":
        r"""
        Returns all contained data in the form of a paramset remark : strings are given under hollerith form.

        Returns
        -------
        opencascade::handle<Interface_ParamSet>

        """
        return _IGESData.IGESData_GlobalSection_Params(self, *args)

    def ReceiveName(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the name of the receiving system.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_ReceiveName(self, *args)

    def Resolution(self, *args) -> "Standard_Real":
        r"""
        Returns the resolution used in the iges file.

        Returns
        -------
        float

        """
        return _IGESData.IGESData_GlobalSection_Resolution(self, *args)

    def Scale(self, *args) -> "Standard_Real":
        r"""
        Returns the scale used in the iges file.

        Returns
        -------
        float

        """
        return _IGESData.IGESData_GlobalSection_Scale(self, *args)

    def SendName(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the name of the sending system.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_SendName(self, *args)

    def Separator(self, *args) -> "Standard_Character":
        r"""
        Returns the parameter delimiter character.

        Returns
        -------
        Standard_Character

        """
        return _IGESData.IGESData_GlobalSection_Separator(self, *args)

    def SetApplicationProtocol(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetApplicationProtocol(self, *args)

    def SetAuthorName(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetAuthorName(self, *args)

    def SetCascadeUnit(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theUnit: float

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetCascadeUnit(self, *args)

    def SetCompanyName(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetCompanyName(self, *args)

    def SetDate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetDate(self, *args)

    def SetDraftingStandard(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetDraftingStandard(self, *args)

    def SetEndMark(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: Standard_Character

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetEndMark(self, *args)

    def SetFileName(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetFileName(self, *args)

    def SetIGESVersion(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetIGESVersion(self, *args)

    def SetIntegerBits(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetIntegerBits(self, *args)

    def SetInterfaceVersion(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetInterfaceVersion(self, *args)

    def SetLastChangeDate(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetLastChangeDate(self, *args)

    def SetLineWeightGrad(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetLineWeightGrad(self, *args)

    def SetMaxCoord(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: float,optional
        	default value is 0.0

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetMaxCoord(self, *args)

    def SetMaxDigitsDouble(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetMaxDigitsDouble(self, *args)

    def SetMaxDigitsSingle(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetMaxDigitsSingle(self, *args)

    def SetMaxLineWeight(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: float

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetMaxLineWeight(self, *args)

    def SetMaxPower10Double(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetMaxPower10Double(self, *args)

    def SetMaxPower10Single(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetMaxPower10Single(self, *args)

    def SetReceiveName(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetReceiveName(self, *args)

    def SetResolution(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: float

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetResolution(self, *args)

    def SetScale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: float

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetScale(self, *args)

    def SetSendName(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetSendName(self, *args)

    def SetSeparator(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: Standard_Character

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetSeparator(self, *args)

    def SetSystemId(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetSystemId(self, *args)

    def SetUnitFlag(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetUnitFlag(self, *args)

    def SetUnitName(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_GlobalSection_SetUnitName(self, *args)

    def SystemId(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the native system id of the system that created the iges file.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_SystemId(self, *args)

    def TranslatedFromHollerith(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns a string withpout its hollerith marks (nnnh ahead). remark : all strings stored in globalsection are expurged from hollerith information (without nnnh) if <astr> is not hollerith form, it is simply copied.

        Parameters
        ----------
        astr: TCollection_HAsciiString

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_TranslatedFromHollerith(self, *args)

    def UnitFlag(self, *args) -> "Standard_Integer":
        r"""
        Returns the unit flag that was used to write the iges file.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_GlobalSection_UnitFlag(self, *args)

    def UnitName(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the name of the unit the iges file was written in.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_GlobalSection_UnitName(self, *args)

    def UnitValue(self, *args) -> "Standard_Real":
        r"""
        Returns the unit value (in meters) that the iges file was written in.

        Returns
        -------
        float

        """
        return _IGESData.IGESData_GlobalSection_UnitValue(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_GlobalSection

# Register IGESData_GlobalSection in _IGESData:
_IGESData.IGESData_GlobalSection_swigregister(IGESData_GlobalSection)

def IGESData_GlobalSection_NewDateString(*args) -> "opencascade::handle< TCollection_HAsciiString >":
    r"""
    Returns a string built from year, month, day, hour, minute and second values. the form of the resulting string is defined as follows: - -1: yymmdd.hhnnss, - 0: yyyymmdd.hhnnss, - 1: yyyy-mm-dd:hh-nn-ss, where: - yyyy or yy is 4 or 2 digit year, - hh is hour (00-23), - mm is month (01-12), - nn is minute (00-59) - dd is day (01-31), - ss is second (00-59).

    Parameters
    ----------
    year: int
    month: int
    day: int
    hour: int
    minut: int
    second: int
    mode: int,optional
    	default value is -1

    Returns
    -------
    opencascade::handle<TCollection_HAsciiString>
    Converts the string given in the form yymmdd.hhnnss or yyyymmdd.hhnnss to either yymmdd.hhnnss, yyyymmdd.hhnnss or yyyy-mm-dd:hh-nn-ss.

    Parameters
    ----------
    date: TCollection_HAsciiString
    mode: int,optional
    	default value is 1

    Returns
    -------
    opencascade::handle<TCollection_HAsciiString>

    """
    return _IGESData.IGESData_GlobalSection_NewDateString(*args)

class IGESData_IGESDumper(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an igesdumper ready to work. the igesmodel provides the numbering of entities: as for any interfacemodel, it gives each entity a number; but for igesentities, the 'number of directory entry' according to the definition of iges files, is also useful.

        Parameters
        ----------
        model: IGESData_IGESModel
        protocol: IGESData_Protocol

        Returns
        -------
        None

        """
        _IGESData.IGESData_IGESDumper_swiginit(self, _IGESData.new_IGESData_IGESDumper(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESDumper

# Register IGESData_IGESDumper in _IGESData:
_IGESData.IGESData_IGESDumper_swigregister(IGESData_IGESDumper)

class IGESData_IGESEntity(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AddProperty(self, *args) -> "void":
        r"""
        Adds a property in the list.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_AddProperty(self, *args)

    def ArePresentAssociativities(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the entity is defined with an associativity list, even empty (that is, file contains its length 0) else, the file contained no idencation at all about this list.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_ArePresentAssociativities(self, *args)

    def ArePresentProperties(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the entity is defined with a property list, even empty (that is, file contains its length 0) else, the file contained no idencation at all about this list.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_ArePresentProperties(self, *args)

    def Associate(self, *args) -> "void":
        r"""
        Sets 'me' in the associativity list of another entity.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_Associate(self, *args)

    def Associativities(self, *args) -> "Interface_EntityIterator":
        r"""
        Returns the associativity list under the form of an entityiterator.

        Returns
        -------
        Interface_EntityIterator

        """
        return _IGESData.IGESData_IGESEntity_Associativities(self, *args)

    def BlankStatus(self, *args) -> "Standard_Integer":
        r"""
        Gives blank status (0 visible, 1 blanked).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_BlankStatus(self, *args)

    def CResValues(self, *args) -> "Standard_Boolean":
        r"""
        Returns 'reserved' alphanumeric values res1 and res2 res1 and res2 have to be reserved as character[9 at least] (remark : their content is changed) returned values are ended by null character in 9th returned boolean is false if res1 and res2 are blank, true else.

        Parameters
        ----------
        res1: char *
        res2: char *

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_CResValues(self, *args)

    def Color(self, *args) -> "opencascade::handle< IGESData_ColorEntity >":
        r"""
        Returns the iges entity which describes the color of the entity. returns a null handle if this entity was defined as an integer.

        Returns
        -------
        opencascade::handle<IGESData_ColorEntity>

        """
        return _IGESData.IGESData_IGESEntity_Color(self, *args)

    def CompoundLocation(self, *args) -> "gp_GTrsf":
        r"""
        Returns location by taking in account a parent which has its own location : that one will be combined to that of <self> the parent is considered only if hasoneparent is true, else it is ignored and compoundlocation = location.

        Returns
        -------
        gp_GTrsf

        """
        return _IGESData.IGESData_IGESEntity_CompoundLocation(self, *args)

    def DefColor(self, *args) -> "IGESData_DefType":
        r"""
        Returns the definition status of color.

        Returns
        -------
        IGESData_DefType

        """
        return _IGESData.IGESData_IGESEntity_DefColor(self, *args)

    def DefLevel(self, *args) -> "IGESData_DefList":
        r"""
        Returns the definition status of level.

        Returns
        -------
        IGESData_DefList

        """
        return _IGESData.IGESData_IGESEntity_DefLevel(self, *args)

    def DefLineFont(self, *args) -> "IGESData_DefType":
        r"""
        Returns the definition status of linefont.

        Returns
        -------
        IGESData_DefType

        """
        return _IGESData.IGESData_IGESEntity_DefLineFont(self, *args)

    def DefView(self, *args) -> "IGESData_DefList":
        r"""
        Returns the definition status of the view. this can be: none, one or several.

        Returns
        -------
        IGESData_DefList

        """
        return _IGESData.IGESData_IGESEntity_DefView(self, *args)

    def DirFieldEntity(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns the entity which has been recorded for a given field number, i.e. without any cast. maps with : 3 : structure 4 : linefont 5 : levellist 6 : view 7 : transf(ormation matrix) 8 : labeldisplay 13 : color. other values give a null handle it can then be of any kind, while specific items have a type.

        Parameters
        ----------
        fieldnum: int

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_IGESEntity_DirFieldEntity(self, *args)

    def Dissociate(self, *args) -> "void":
        r"""
        Resets 'me' from the associativity list of another entity.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_Dissociate(self, *args)

    def FormNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns the form number for that type of an iges entity. the default form number is 0.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_FormNumber(self, *args)

    def HasLabelDisplay(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if a labeldisplay mode is defined for this entity.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_HasLabelDisplay(self, *args)

    def HasName(self, *args) -> "Standard_Boolean":
        r"""
        Says if a name is defined, as short label or as name property (property is looked first, else shortlabel is considered).

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_HasName(self, *args)

    def HasOneParent(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if an entity has one and only one parent, defined by a singleparententity type associativity (explicit sharing). thus, implicit sharing remains defined at model level (see class toollocation).

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_HasOneParent(self, *args)

    def HasShortLabel(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if a short label is defined. a short label is a non-blank 8-character string.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_HasShortLabel(self, *args)

    def HasStructure(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if an igesentity is defined with a structure (it is normally reserved for certain classes, such as macros).

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_HasStructure(self, *args)

    def HasSubScriptNumber(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if a subscript number is defined. a subscript number is an integer used to identify a label.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_HasSubScriptNumber(self, *args)

    def HasTransf(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if a transformation matrix is defined.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESEntity_HasTransf(self, *args)

    def HierarchyStatus(self, *args) -> "Standard_Integer":
        r"""
        Gives hierarchy status (0-1-2).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_HierarchyStatus(self, *args)

    def IGESType(self, *args) -> "IGESData_IGESType":
        r"""
        Gives iges typing info (includes 'type' and 'form' data).

        Returns
        -------
        IGESData_IGESType

        """
        return _IGESData.IGESData_IGESEntity_IGESType(self, *args)

    def InitColor(self, *args) -> "void":
        r"""
        Initializes color data : if <ent> is not null, it gives color, else <rank> gives or erases (if zero) rankcolor.

        Parameters
        ----------
        ent: IGESData_ColorEntity
        rank: int,optional
        	default value is 0

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_InitColor(self, *args)

    def InitDirFieldEntity(self, *args) -> "void":
        r"""
        Initializes a directory field as an entiy of any kind see dirfieldentity for more details.

        Parameters
        ----------
        fieldnum: int
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_InitDirFieldEntity(self, *args)

    def InitLevel(self, *args) -> "void":
        r"""
        Initializes level : if <ent> is not null, it gives levellist, else <val> gives or erases (if zero) unique level.

        Parameters
        ----------
        ent: IGESData_LevelListEntity
        val: int,optional
        	default value is 0

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_InitLevel(self, *args)

    def InitLineFont(self, *args) -> "void":
        r"""
        Initializes linefont : if <ent> is not null, it gives linefont, else <rank> gives or erases (if zero) ranklinefont.

        Parameters
        ----------
        ent: IGESData_LineFontEntity
        rank: int,optional
        	default value is 0

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_InitLineFont(self, *args)

    def InitMisc(self, *args) -> "void":
        r"""
        Initializes various data (those not yet seen above), or erases them if they are given as null (zero for <weightnum>) : <str> for structure, <lab> for labeldisplay, and <weightnum> for weightnumber.

        Parameters
        ----------
        str: IGESData_IGESEntity
        lab: IGESData_LabelDisplayEntity
        weightnum: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_InitMisc(self, *args)

    def InitStatus(self, *args) -> "void":
        r"""
        Initializes the status of directory part.

        Parameters
        ----------
        blank: int
        subordinate: int
        useflag: int
        hierarchy: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_InitStatus(self, *args)

    def InitTransf(self, *args) -> "void":
        r"""
        Initializes transf, or erases it if <ent> is given null.

        Parameters
        ----------
        ent: IGESData_TransfEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_InitTransf(self, *args)

    def InitView(self, *args) -> "void":
        r"""
        Initializes view, or erases it if <ent> is given null.

        Parameters
        ----------
        ent: IGESData_ViewKindEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_InitView(self, *args)

    def LabelDisplay(self, *args) -> "opencascade::handle< IGESData_LabelDisplayEntity >":
        r"""
        Returns the label display associativity entity if there is one. returns a null handle if there is none.

        Returns
        -------
        opencascade::handle<IGESData_LabelDisplayEntity>

        """
        return _IGESData.IGESData_IGESEntity_LabelDisplay(self, *args)

    def Level(self, *args) -> "Standard_Integer":
        r"""
        Returns the level the entity belongs to. returns -1 if the entity belongs to more than one level.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_Level(self, *args)

    def LevelList(self, *args) -> "opencascade::handle< IGESData_LevelListEntity >":
        r"""
        Returns levellist if level is defined as a list. returns a null handle if deflevel is not defseveral.

        Returns
        -------
        opencascade::handle<IGESData_LevelListEntity>

        """
        return _IGESData.IGESData_IGESEntity_LevelList(self, *args)

    def LineFont(self, *args) -> "opencascade::handle< IGESData_LineFontEntity >":
        r"""
        Returns linefont as an entity (if defined as reference) returns a null handle if deflinefont is not 'defreference'.

        Returns
        -------
        opencascade::handle<IGESData_LineFontEntity>

        """
        return _IGESData.IGESData_IGESEntity_LineFont(self, *args)

    def LineWeight(self, *args) -> "Standard_Real":
        r"""
        Returns the true line weight, computed from lineweightnumber and global parameter in the model by call to setlineweight.

        Returns
        -------
        float

        """
        return _IGESData.IGESData_IGESEntity_LineWeight(self, *args)

    def LineWeightNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns the lineweight number (0 not defined), see also lineweight.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_LineWeightNumber(self, *args)

    def Location(self, *args) -> "gp_GTrsf":
        r"""
        Returns location given by transf in directory part (see above) it must be considered for local definition : if the entity is set in a 'parent', that one can add its one location, but this is not taken in account here : see compoundlocation for that. if no transf is defined, returns identity if transf is itself compound, gives the final result.

        Returns
        -------
        gp_GTrsf

        """
        return _IGESData.IGESData_IGESEntity_Location(self, *args)

    def NameValue(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns name value as a string (property name or shortlabel) if subnumber is defined, it is concatenated after shortlabel as follows label(number). ignored with a property name.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_IGESEntity_NameValue(self, *args)

    def NbAssociativities(self, *args) -> "Standard_Integer":
        r"""
        Gives number of recorded associativities (0 no list defined).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_NbAssociativities(self, *args)

    def NbProperties(self, *args) -> "Standard_Integer":
        r"""
        Gives number of recorded properties (0 no list defined).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_NbProperties(self, *args)

    def NbTypedAssociativities(self, *args) -> "Standard_Integer":
        r"""
        Gives how many associativities have a given type.

        Parameters
        ----------
        atype: Standard_Type

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_NbTypedAssociativities(self, *args)

    def NbTypedProperties(self, *args) -> "Standard_Integer":
        r"""
        Gives how many properties have a given type.

        Parameters
        ----------
        atype: Standard_Type

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_NbTypedProperties(self, *args)

    def Properties(self, *args) -> "Interface_EntityIterator":
        r"""
        Returns property list under the form of an entityiterator.

        Returns
        -------
        Interface_EntityIterator

        """
        return _IGESData.IGESData_IGESEntity_Properties(self, *args)

    def RankColor(self, *args) -> "Standard_Integer":
        r"""
        Returns the color definition as an integer value if the color was defined as a rank. warning a negative value is returned if the color was defined as an entity.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_RankColor(self, *args)

    def RankLineFont(self, *args) -> "Standard_Integer":
        r"""
        Returns linefont definition as an integer (if defined as rank) if linefont is defined as an entity, returns a negative value.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_RankLineFont(self, *args)

    def RemoveProperty(self, *args) -> "void":
        r"""
        Removes a property from the list.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_RemoveProperty(self, *args)

    def SetLabel(self, *args) -> "void":
        r"""
        Sets a new label to an iges entity if <sub> is given, it sets value of subscriptnumber else, subscriptnumber is erased.

        Parameters
        ----------
        label: TCollection_HAsciiString
        sub: int,optional
        	default value is -1

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_SetLabel(self, *args)

    def SetLineWeight(self, *args) -> "void":
        r"""
        Computes and sets 'true' line weight according iges rules from global data maxlineweight (maxv) and lineweightgrad (gradw), or sets it to defw (default) if lineweightnumber is null.

        Parameters
        ----------
        defw: float
        maxw: float
        gradw: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESEntity_SetLineWeight(self, *args)

    def ShortLabel(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns the label value for this iges entity as a string. warning if the label is blank, this string is null.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_IGESEntity_ShortLabel(self, *args)

    def SingleView(self, *args) -> "opencascade::handle< IGESData_ViewKindEntity >":
        r"""
        Returns the view as a single view if it was defined as such and not as a list of views. warning a null handle is returned if defview does not have the value defone.

        Returns
        -------
        opencascade::handle<IGESData_ViewKindEntity>

        """
        return _IGESData.IGESData_IGESEntity_SingleView(self, *args)

    def Structure(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns structure (used by some types of iges entities only) returns a null handle if structure is not defined.

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_IGESEntity_Structure(self, *args)

    def SubScriptNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns the integer subscript number used to identify this iges entity. warning 0 is returned if no subscript number is defined for this iges entity.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_SubScriptNumber(self, *args)

    def SubordinateStatus(self, *args) -> "Standard_Integer":
        r"""
        Gives subordinate switch (0-1-2-3).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_SubordinateStatus(self, *args)

    def Transf(self, *args) -> "opencascade::handle< IGESData_TransfEntity >":
        r"""
        Returns the transformation matrix (under iges definition) returns a null handle if there is none for a more complete use, see location & compoundlocation.

        Returns
        -------
        opencascade::handle<IGESData_TransfEntity>

        """
        return _IGESData.IGESData_IGESEntity_Transf(self, *args)

    def TypeNumber(self, *args) -> "Standard_Integer":
        r"""
        Gives iges type number (often coupled with form number).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_TypeNumber(self, *args)

    def TypedAssociativity(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns the associativity of a given type (if only one exists) error if none or more than one.

        Parameters
        ----------
        atype: Standard_Type

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_IGESEntity_TypedAssociativity(self, *args)

    def TypedProperty(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns the property of a given type error if none or more than one.

        Parameters
        ----------
        atype: Standard_Type
        anum: int,optional
        	default value is 0

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_IGESEntity_TypedProperty(self, *args)

    def UniqueParent(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns the unique parent (in the sense given by hasoneparent) error if there is none or several.

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_IGESEntity_UniqueParent(self, *args)

    def UseFlag(self, *args) -> "Standard_Integer":
        r"""
        Gives entity's use flag (0 to 5).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESEntity_UseFlag(self, *args)

    def VectorLocation(self, *args) -> "gp_GTrsf":
        r"""
        Returns location considered for vectors, i.e. without its translation part. as location, it gives local definition.

        Returns
        -------
        gp_GTrsf

        """
        return _IGESData.IGESData_IGESEntity_VectorLocation(self, *args)

    def View(self, *args) -> "opencascade::handle< IGESData_ViewKindEntity >":
        r"""
        Returns the view of this iges entity. this view can be a single view or a list of views. warning a null handle is returned if the view is not defined.

        Returns
        -------
        opencascade::handle<IGESData_ViewKindEntity>

        """
        return _IGESData.IGESData_IGESEntity_View(self, *args)

    def ViewList(self, *args) -> "opencascade::handle< IGESData_ViewKindEntity >":
        r"""
        Returns the view of this iges entity as a list. warning a null handle is returned if the definition status does not have the value defseveral.

        Returns
        -------
        opencascade::handle<IGESData_ViewKindEntity>

        """
        return _IGESData.IGESData_IGESEntity_ViewList(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_IGESEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESEntity

# Register IGESData_IGESEntity in _IGESData:
_IGESData.IGESData_IGESEntity_swigregister(IGESData_IGESEntity)

class IGESData_IGESModel(OCC.Core.Interface.Interface_InterfaceModel):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _IGESData.IGESData_IGESModel_swiginit(self, _IGESData.new_IGESData_IGESModel(*args))

    def AddStartLine(self, *args) -> "void":
        r"""
        Adds a new string to the existing start section at the end if atnum is 0 or not given, or before atnumth line.

        Parameters
        ----------
        line: char *
        atnum: int,optional
        	default value is 0

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESModel_AddStartLine(self, *args)

    def ApplyStatic(self, *args) -> "Standard_Boolean":
        r"""
        Sets some of the global section parameters with the values defined by the translation parameters. param may be: - receiver (value read in xstep.iges.header.receiver), - author (value read in xstep.iges.header.author), - company (value read in xstep.iges.header.company). the default value for param is an empty string. returns true when done and if param is given, false if param is unknown or empty. note: set the unit in the iges file global section via igesdata_basiceditor class.

        Parameters
        ----------
        param: char *,optional
        	default value is 

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESModel_ApplyStatic(self, *args)

    def ChangeGlobalSection(self, *args) -> "IGESData_GlobalSection &":
        r"""
        Returns the global section of the iges file.

        Returns
        -------
        IGESData_GlobalSection

        """
        return _IGESData.IGESData_IGESModel_ChangeGlobalSection(self, *args)

    def ClearStartSection(self, *args) -> "void":
        r"""
        Clears the iges file start section.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESModel_ClearStartSection(self, *args)

    def DNum(self, *args) -> "Standard_Integer":
        r"""
        Returns the equivalent de number for an entity, i.e. 2*number(ent)-1 , or 0 if <ent> is unknown from <self> this de number is used for file writing for instance.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESModel_DNum(self, *args)

    def Entity(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns an iges entity given by its rank number.

        Parameters
        ----------
        num: int

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_IGESModel_Entity(self, *args)

    def GlobalSection(self, *args) -> "IGESData_GlobalSection const &":
        r"""
        Returns the global section of the iges file.

        Returns
        -------
        IGESData_GlobalSection

        """
        return _IGESData.IGESData_IGESModel_GlobalSection(self, *args)

    def NbStartLines(self, *args) -> "Standard_Integer":
        r"""
        Returns the count of recorded start lines.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESModel_NbStartLines(self, *args)

    def SetGlobalSection(self, *args) -> "void":
        r"""
        Sets the global section of the iges file.

        Parameters
        ----------
        header: IGESData_GlobalSection

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESModel_SetGlobalSection(self, *args)

    def SetLineWeights(self, *args) -> "void":
        r"""
        Sets lineweights of contained entities according header data (maxlineweight and lineweightgrad) or to a default value for undefined weights.

        Parameters
        ----------
        defw: float

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESModel_SetLineWeights(self, *args)

    def SetStartSection(self, *args) -> "void":
        r"""
        Sets a new start section from a list of strings. if copy is false, the start section will be shared. any modifications made to the strings later on, will have an effect on the start section. if copy is true (default value), an independent copy of the strings is created and used as the start section. any modifications made to the strings later on, will have no effect on the start section.

        Parameters
        ----------
        list: TColStd_HSequenceOfHAsciiString
        copy: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESModel_SetStartSection(self, *args)

    def StartLine(self, *args) -> "char const *":
        r"""
        Returns a line from the iges file start section by specifying its number. an empty string is returned if the number given is out of range, the range being from 1 to nbstartlines.

        Parameters
        ----------
        num: int

        Returns
        -------
        char *

        """
        return _IGESData.IGESData_IGESModel_StartLine(self, *args)

    def StartSection(self, *args) -> "opencascade::handle< TColStd_HSequenceOfHAsciiString >":
        r"""
        Returns model's start section (list of comment lines).

        Returns
        -------
        opencascade::handle<TColStd_HSequenceOfHAsciiString>

        """
        return _IGESData.IGESData_IGESModel_StartSection(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_IGESModel_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESModel

# Register IGESData_IGESModel in _IGESData:
_IGESData.IGESData_IGESModel_swigregister(IGESData_IGESModel)

class IGESData_IGESReaderData(OCC.Core.Interface.Interface_FileReaderData):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates igesreaderdata correctly dimensionned (for arrays) <nbe> count of entities, that is, half nb of directory lines <nbp> : count of parameters.

        Parameters
        ----------
        nbe: int
        nbp: int

        Returns
        -------
        None

        """
        _IGESData.IGESData_IGESReaderData_swiginit(self, _IGESData.new_IGESData_IGESReaderData(*args))

    def AddGlobal(self, *args) -> "void":
        r"""
        Adds a parameter to global section's parameter list.

        Parameters
        ----------
        atype: Interface_ParamType
        aval: char *

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderData_AddGlobal(self, *args)

    def AddStartLine(self, *args) -> "void":
        r"""
        Adds a start line to start section.

        Parameters
        ----------
        aval: char *

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderData_AddStartLine(self, *args)

    def DefaultLineWeight(self, *args) -> "Standard_Real":
        r"""
        Returns the recorded default line weight, if there is (else, returns 0).

        Returns
        -------
        float

        """
        return _IGESData.IGESData_IGESReaderData_DefaultLineWeight(self, *args)

    def DirPart(self, *args) -> "IGESData_DirPart const &":
        r"""
        Returns dirpart identified by record no (half dsect number).

        Parameters
        ----------
        num: int

        Returns
        -------
        IGESData_DirPart

        """
        return _IGESData.IGESData_IGESReaderData_DirPart(self, *args)

    def DirType(self, *args) -> "IGESData_IGESType":
        r"""
        Returns 'type' and 'form' info from a directory part.

        Parameters
        ----------
        num: int

        Returns
        -------
        IGESData_IGESType

        """
        return _IGESData.IGESData_IGESReaderData_DirType(self, *args)

    def DirValues(self, *args) -> "void":
        r"""
        Returns values recorded in directory part n0 <num>.

        Parameters
        ----------
        num: int
        res1: char *
        res2: char *
        label: char *
        subs: char *

        Returns
        -------
        i1: int
        i2: int
        i3: int
        i4: int
        i5: int
        i6: int
        i7: int
        i8: int
        i9: int
        i10: int
        i11: int
        i12: int
        i13: int
        i14: int
        i15: int
        i16: int
        i17: int

        """
        return _IGESData.IGESData_IGESReaderData_DirValues(self, *args)

    def GlobalCheck(self, *args) -> "opencascade::handle< Interface_Check >":
        r"""
        Returns the recorded global check.

        Returns
        -------
        opencascade::handle<Interface_Check>

        """
        return _IGESData.IGESData_IGESReaderData_GlobalCheck(self, *args)

    def GlobalSection(self, *args) -> "IGESData_GlobalSection const &":
        r"""
        Returns header as globalsection.

        Returns
        -------
        IGESData_GlobalSection

        """
        return _IGESData.IGESData_IGESReaderData_GlobalSection(self, *args)

    def SetDefaultLineWeight(self, *args) -> "void":
        r"""
        Allows to set a default line weight, will be later applied at load time, on entities which have no specified line weight.

        Parameters
        ----------
        defw: float

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderData_SetDefaultLineWeight(self, *args)

    def SetDirPart(self, *args) -> "void":
        r"""
        Fills a dirpart, designated by its rank (that is, (n+1)/2 if n is its first number in section d).

        Parameters
        ----------
        num: int
        i1: int
        i2: int
        i3: int
        i4: int
        i5: int
        i6: int
        i7: int
        i8: int
        i9: int
        i10: int
        i11: int
        i12: int
        i13: int
        i14: int
        i15: int
        i16: int
        i17: int
        res1: char *
        res2: char *
        label: char *
        subs: char *

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderData_SetDirPart(self, *args)

    def SetEntityNumbers(self, *args) -> "void":
        r"""
        Determines reference numbers in entitynumber fields (called by setentities from igesreadertool) works on 'integer' type parameters, because iges does not distinguish integer and entity refs : every integer which is odd and less than twice nbrecords can be an entity ref ... (ref number is then (n+1)/2 if n is the integer value).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderData_SetEntityNumbers(self, *args)

    def SetGlobalSection(self, *args) -> "void":
        r"""
        Reads header (as globalsection) content from the paramset after it has been filled by successive calls to addglobal.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderData_SetGlobalSection(self, *args)

    def StartSection(self, *args) -> "opencascade::handle< TColStd_HSequenceOfHAsciiString >":
        r"""
        Returns the start section in once.

        Returns
        -------
        opencascade::handle<TColStd_HSequenceOfHAsciiString>

        """
        return _IGESData.IGESData_IGESReaderData_StartSection(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_IGESReaderData_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESReaderData

# Register IGESData_IGESReaderData in _IGESData:
_IGESData.IGESData_IGESReaderData_swigregister(IGESData_IGESReaderData)

class IGESData_IGESReaderTool(OCC.Core.Interface.Interface_FileReaderTool):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates igesreadertool to work with an igesreaderdata and an iges protocol. actually, no lib is used.

        Parameters
        ----------
        reader: IGESData_IGESReaderData
        protocol: IGESData_Protocol

        Returns
        -------
        None

        """
        _IGESData.IGESData_IGESReaderTool_swiginit(self, _IGESData.new_IGESData_IGESReaderTool(*args))

    def Prepare(self, *args) -> "void":
        r"""
        Binds empty entities to records, works with the protocol (from igesdata) stored and later used rq : actually, sets dnum into iges entities also loads the list of parameters for paramreader.

        Parameters
        ----------
        reco: IGESData_FileRecognizer

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderTool_Prepare(self, *args)

    def ReadAssocs(self, *args) -> "void":
        r"""
        Reads associativity list, if there is (if not, does nothing) criterium is : current parameter of pr remains inside params list, and stage is 'own' same conditions as above; in addition, no parameter must be let after the list once read note that 'associated' entities are not declared 'shared'.

        Parameters
        ----------
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderTool_ReadAssocs(self, *args)

    def ReadDir(self, *args) -> "void":
        r"""
        Reads directory part components from file; dp is the literal directory part, ir detains entities referenced by dp.

        Parameters
        ----------
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        DP: IGESData_DirPart
        ach: Interface_Check

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderTool_ReadDir(self, *args)

    def ReadOwnParams(self, *args) -> "void":
        r"""
        Performs reading of own parameters for each igesentity works with the readerlib loaded with readwritemodules for iges in case of failure, tries undefinedentity from iges.

        Parameters
        ----------
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderTool_ReadOwnParams(self, *args)

    def ReadProps(self, *args) -> "void":
        r"""
        Reads property list, if there is (if not, does nothing) criterium is : current parameter of pr remains inside params list, and stage is 'own' current parameter must be a positive integer, which value gives the length of the list; else, a fail is produced (into check of pr) and reading process is stopped.

        Parameters
        ----------
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESReaderTool_ReadProps(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESReaderTool

# Register IGESData_IGESReaderTool in _IGESData:
_IGESData.IGESData_IGESReaderTool_swigregister(IGESData_IGESReaderTool)

class IGESData_IGESType(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        atype: int
        aform: int

        Returns
        -------
        None

        """
        _IGESData.IGESData_IGESType_swiginit(self, _IGESData.new_IGESData_IGESType(*args))

    def Form(self, *args) -> "Standard_Integer":
        r"""
        Returns 'form' data.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESType_Form(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Compares two igestypes, avoiding comparing their fields.

        Parameters
        ----------
        another: IGESData_IGESType

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_IGESType_IsEqual(self, *args)

    def Nullify(self, *args) -> "void":
        r"""
        Resets fields (useful when an igestype is stored as mask).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESType_Nullify(self, *args)

    def Type(self, *args) -> "Standard_Integer":
        r"""
        Returns 'type' data.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_IGESType_Type(self, *args)

    def __eq_wrapper__(self, other: "IGESData_IGESType") -> "bool":
        return _IGESData.IGESData_IGESType___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_IGESType

# Register IGESData_IGESType in _IGESData:
_IGESData.IGESData_IGESType_swigregister(IGESData_IGESType)

class IGESData_IGESWriter(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an igeswriter, empty ready to work (see the methods sendmodel and print).

        Parameters
        ----------
        amodel: IGESData_IGESModel

        Returns
        -------
        None
        Default constructor (not used) to satisfy the compiler.

        Returns
        -------
        None
        Constructor by copy (not used) to satisfy the compiler.

        Parameters
        ----------
        other: IGESData_IGESWriter

        Returns
        -------
        None

        """
        _IGESData.IGESData_IGESWriter_swiginit(self, _IGESData.new_IGESData_IGESWriter(*args))

    def Associativities(self, *args) -> "void":
        r"""
        Sends associativity list, as complement of parameters list error if not in sections dp or stage not 'associativity'.

        Parameters
        ----------
        anent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_Associativities(self, *args)

    def DirPart(self, *args) -> "void":
        r"""
        Translates directory part of an entity into a literal dirpart some infos are computed after sending parameters error if not in sections dp or stage not 'dir'.

        Parameters
        ----------
        anent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_DirPart(self, *args)

    def EndEntity(self, *args) -> "void":
        r"""
        Declares end of sending an entity (ends param list by ';').

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_EndEntity(self, *args)

    def FloatWriter(self, *args) -> "Interface_FloatWriter &":
        r"""
        Returns the embedded floatwriter, which controls sending reals use this method to access floatwriter in order to consult or change its options (mainformat, formatforrange,zerosuppress), because it is returned as the address of its field.

        Returns
        -------
        Interface_FloatWriter

        """
        return _IGESData.IGESData_IGESWriter_FloatWriter(self, *args)

    def OwnParams(self, *args) -> "void":
        r"""
        Sends own parameters of the entity, by sending firstly its type, then calling specific method writeownparams error if not in sections dp or stage not 'own'.

        Parameters
        ----------
        anent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_OwnParams(self, *args)

    def PrintToString(self) -> "std::string":
        r"""PrintToString(IGESData_IGESWriter self) -> std::string"""
        return _IGESData.IGESData_IGESWriter_PrintToString(self)

    def Properties(self, *args) -> "void":
        r"""
        Sends property list, as complement of parameters list error if not in sections dp or stage not 'property'.

        Parameters
        ----------
        anent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_Properties(self, *args)

    def SectionG(self, *args) -> "void":
        r"""
        Prepares sending of header, from a globalsection (stores it) error if sections was not called just before takes in account special characters (separator, endmark).

        Parameters
        ----------
        header: IGESData_GlobalSection

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SectionG(self, *args)

    def SectionS(self, *args) -> "void":
        r"""
        Declares sending of s section (only a declaration) error if state is not initial.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SectionS(self, *args)

    def SectionStrings(self, *args) -> "opencascade::handle< TColStd_HSequenceOfHAsciiString >":
        r"""
        Returns the list of strings for a section given its rank 1 : start (if not empty) 2 : global 3 or 4 : parameters rq: no string list for directory section an empty section gives a null handle.

        Parameters
        ----------
        numsec: int

        Returns
        -------
        opencascade::handle<TColStd_HSequenceOfHAsciiString>

        """
        return _IGESData.IGESData_IGESWriter_SectionStrings(self, *args)

    def SectionT(self, *args) -> "void":
        r"""
        Declares sending of t section (only a declaration) error if does not follow entities sending.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SectionT(self, *args)

    def SectionsDP(self, *args) -> "void":
        r"""
        Prepares sending of list of entities, as sections d (directory list) and p (parameters lists, one per entity) entities will be then processed, one after the other error if sectiong has not be called just before.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SectionsDP(self, *args)

    def SendBoolean(self, *args) -> "void":
        r"""
        Sends a boolean parameter as an integer value 0(false)/1(true).

        Parameters
        ----------
        val: bool

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SendBoolean(self, *args)

    def SendModel(self, *args) -> "void":
        r"""
        Sends the complete igesmodel (global section, entities as directory entries & parameter lists, etc...) i.e. fills a list of texts. once filled, it can be sent by method print.

        Parameters
        ----------
        protocol: IGESData_Protocol

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SendModel(self, *args)

    def SendStartLine(self, *args) -> "void":
        r"""
        Sends an additional starting line : this is the way used to send comments in an iges file (at beginning of the file). if the line is more than 72 char.s long, it is splited into as many lines as required to send it completely.

        Parameters
        ----------
        startline: char *

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SendStartLine(self, *args)

    def SendString(self, *args) -> "void":
        r"""
        Sends a parameter under its exact form given as a string.

        Parameters
        ----------
        val: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SendString(self, *args)

    def SendVoid(self, *args) -> "void":
        r"""
        Sends a void parameter, that is null text.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_IGESWriter_SendVoid(self, *args)

    def GetWriteMode(self) -> "Standard_Integer":
        r"""GetWriteMode(IGESData_IGESWriter self) -> Standard_Integer"""
        return _IGESData.IGESData_IGESWriter_GetWriteMode(self)

    def SetWriteMode(self, value: "Standard_Integer") -> "void":
        r"""SetWriteMode(IGESData_IGESWriter self, Standard_Integer value)"""
        return _IGESData.IGESData_IGESWriter_SetWriteMode(self, value)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Send(self):
    	pass

    __swig_destroy__ = _IGESData.delete_IGESData_IGESWriter

# Register IGESData_IGESWriter in _IGESData:
_IGESData.IGESData_IGESWriter_swigregister(IGESData_IGESWriter)

class IGESData_NodeOfSpecificLib(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty node, with no next.

        Returns
        -------
        None

        """
        _IGESData.IGESData_NodeOfSpecificLib_swiginit(self, _IGESData.new_IGESData_NodeOfSpecificLib(*args))

    def AddNode(self, *args) -> "void":
        r"""
        Adds a couple (module,protocol), that is, stores it into itself if not yet done, else creates a next node to do it.

        Parameters
        ----------
        anode: IGESData_GlobalNodeOfSpecificLib

        Returns
        -------
        None

        """
        return _IGESData.IGESData_NodeOfSpecificLib_AddNode(self, *args)

    def Module(self, *args) -> "opencascade::handle< IGESData_SpecificModule > const &":
        r"""
        Returns the module designated by a precise node.

        Returns
        -------
        opencascade::handle<IGESData_SpecificModule>

        """
        return _IGESData.IGESData_NodeOfSpecificLib_Module(self, *args)

    def Next(self, *args) -> "opencascade::handle< IGESData_NodeOfSpecificLib > const &":
        r"""
        Returns the next node. if none was defined, returned value is a null handle.

        Returns
        -------
        opencascade::handle<IGESData_NodeOfSpecificLib>

        """
        return _IGESData.IGESData_NodeOfSpecificLib_Next(self, *args)

    def Protocol(self, *args) -> "opencascade::handle< IGESData_Protocol > const &":
        r"""
        Returns the protocol designated by a precise node.

        Returns
        -------
        opencascade::handle<IGESData_Protocol>

        """
        return _IGESData.IGESData_NodeOfSpecificLib_Protocol(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_NodeOfSpecificLib_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_NodeOfSpecificLib

# Register IGESData_NodeOfSpecificLib in _IGESData:
_IGESData.IGESData_NodeOfSpecificLib_swigregister(IGESData_NodeOfSpecificLib)

class IGESData_NodeOfWriterLib(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty node, with no next.

        Returns
        -------
        None

        """
        _IGESData.IGESData_NodeOfWriterLib_swiginit(self, _IGESData.new_IGESData_NodeOfWriterLib(*args))

    def AddNode(self, *args) -> "void":
        r"""
        Adds a couple (module,protocol), that is, stores it into itself if not yet done, else creates a next node to do it.

        Parameters
        ----------
        anode: IGESData_GlobalNodeOfWriterLib

        Returns
        -------
        None

        """
        return _IGESData.IGESData_NodeOfWriterLib_AddNode(self, *args)

    def Module(self, *args) -> "opencascade::handle< IGESData_ReadWriteModule > const &":
        r"""
        Returns the module designated by a precise node.

        Returns
        -------
        opencascade::handle<IGESData_ReadWriteModule>

        """
        return _IGESData.IGESData_NodeOfWriterLib_Module(self, *args)

    def Next(self, *args) -> "opencascade::handle< IGESData_NodeOfWriterLib > const &":
        r"""
        Returns the next node. if none was defined, returned value is a null handle.

        Returns
        -------
        opencascade::handle<IGESData_NodeOfWriterLib>

        """
        return _IGESData.IGESData_NodeOfWriterLib_Next(self, *args)

    def Protocol(self, *args) -> "opencascade::handle< IGESData_Protocol > const &":
        r"""
        Returns the protocol designated by a precise node.

        Returns
        -------
        opencascade::handle<IGESData_Protocol>

        """
        return _IGESData.IGESData_NodeOfWriterLib_Protocol(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_NodeOfWriterLib_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_NodeOfWriterLib

# Register IGESData_NodeOfWriterLib in _IGESData:
_IGESData.IGESData_NodeOfWriterLib_swigregister(IGESData_NodeOfWriterLib)

class IGESData_ParamCursor(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a cursor to read a precise parameter of paramreader, identified by its number, then set current number to 'num + 1' (this constructor allows to simply give a number to a method read... from paramreader, which will be translated into a paramcursor by compiler).

        Parameters
        ----------
        num: int

        Returns
        -------
        None
        Creates a cursor to read a list of parameters (count 'nb') starting from a precise one (number 'num') included, then set current number of paramnumber to the first following one ('num + nb') if size is given, it means that each parameter is made of more than one term. one term is the normal (default) case : for instance, a parameter comprises one integer, or one entity ... size gives the complete size of each item if it is complex. to be used only if it is constant.

        Parameters
        ----------
        num: int
        nb: int
        size: int,optional
        	default value is 1

        Returns
        -------
        None

        """
        _IGESData.IGESData_ParamCursor_swiginit(self, _IGESData.new_IGESData_ParamCursor(*args))

    def Advance(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if advance command has been set.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamCursor_Advance(self, *args)

    def Count(self, *args) -> "Standard_Integer":
        r"""
        Returns required count of items to be read.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamCursor_Count(self, *args)

    def ItemSize(self, *args) -> "Standard_Integer":
        r"""
        Returns length of item (count of parameters per item).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamCursor_ItemSize(self, *args)

    def Limit(self, *args) -> "Standard_Integer":
        r"""
        Returns (excluded) upper limit number for reading parameters.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamCursor_Limit(self, *args)

    def Offset(self, *args) -> "Standard_Integer":
        r"""
        Returns offset from which current term must be read in item.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamCursor_Offset(self, *args)

    def SetAdvance(self, *args) -> "void":
        r"""
        Changes command to advance current cursor after reading parameters. if 'advance' true, sets advance, if 'false', resets it. paramcursor is created by default with true.

        Parameters
        ----------
        advance: bool

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamCursor_SetAdvance(self, *args)

    def SetOne(self, *args) -> "void":
        r"""
        Defines a term of one parameter (very current case).

        Parameters
        ----------
        autoadv: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamCursor_SetOne(self, *args)

    def SetTerm(self, *args) -> "void":
        r"""
        Defines the size of a term to read in the item : this commands paramreader to read 'size' parameters for each item, then skip the remainder of the item to the same term of next item (that is, skip 'item size' - 'term size') //! in addition, offset from beginning of item is managed : after being created, and for the first call to setterm, the part of item to be read begins exactly as the item begins but after a setterm, the next read will add an offset which is the size of former term. //! autoadv commands advance management. if it is true (default), the last setterm (item size has been covered) calls setadvance if it is false, setadvance must be called directly if necessary //! error if a setterm overpasses the size of the item.

        Parameters
        ----------
        size: int
        autoadv: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamCursor_SetTerm(self, *args)

    def SetXY(self, *args) -> "void":
        r"""
        Defines a term of two parameters for a xy (current case).

        Parameters
        ----------
        autoadv: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamCursor_SetXY(self, *args)

    def SetXYZ(self, *args) -> "void":
        r"""
        Defines a term of three parameters for xyz (current case).

        Parameters
        ----------
        autoadv: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamCursor_SetXYZ(self, *args)

    def Start(self, *args) -> "Standard_Integer":
        r"""
        Returns (included) starting number for reading parameters.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamCursor_Start(self, *args)

    def TermSize(self, *args) -> "Standard_Integer":
        r"""
        Returns length of current term (count of parameters) in item.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamCursor_TermSize(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_ParamCursor

# Register IGESData_ParamCursor in _IGESData:
_IGESData.IGESData_ParamCursor_swigregister(IGESData_ParamCursor)

class IGESData_ParamReader(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Prepares a paramreader, stage 'own', current param = 1 it considers a part of the list, from <base> (excluded) for <nbpar> parameters; <nbpar> = 0 commands to take list length. default is (1 to skip type).

        Parameters
        ----------
        list: Interface_ParamList
        ach: Interface_Check
        base: int,optional
        	default value is 1
        nbpar: int,optional
        	default value is 0
        num: int,optional
        	default value is 0

        Returns
        -------
        None

        """
        _IGESData.IGESData_ParamReader_swiginit(self, _IGESData.new_IGESData_ParamReader(*args))

    def AddFail(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        afail: char *
        bfail: char *,optional
        	default value is 

        Returns
        -------
        None
        Feeds the check with a new fail (as a string or as a cstring).

        Parameters
        ----------
        af: TCollection_HAsciiString
        bf: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_AddFail(self, *args)

    def AddWarning(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        awarn: char *
        bwarn: char *,optional
        	default value is 

        Returns
        -------
        None
        Feeds the check with a new warning message.

        Parameters
        ----------
        aw: TCollection_HAsciiString
        bw: TCollection_HAsciiString

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_AddWarning(self, *args)

    def CCheck(self, *args) -> "opencascade::handle< Interface_Check > &":
        r"""
        Returns the check in a way which allows to work on it directly (i.e. messages added to the check are added to paramreader too).

        Returns
        -------
        opencascade::handle<Interface_Check>

        """
        return _IGESData.IGESData_ParamReader_CCheck(self, *args)

    def Check(self, *args) -> "opencascade::handle< Interface_Check > const &":
        r"""
        Returns the check note that any error signaled above is also recorded into it.

        Returns
        -------
        opencascade::handle<Interface_Check>

        """
        return _IGESData.IGESData_ParamReader_Check(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Resets state (stage, current param number, check with no fail).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_Clear(self, *args)

    def Current(self, *args) -> "IGESData_ParamCursor":
        r"""
        Creates a paramcursor from the current number, to read one parameter, and to advance current number after reading.

        Returns
        -------
        IGESData_ParamCursor

        """
        return _IGESData.IGESData_ParamReader_Current(self, *args)

    def CurrentList(self, *args) -> "IGESData_ParamCursor":
        r"""
        Creates a paramcursor from the current number, to read a list of 'nb' items, and to advance current number after reading by default, each item is made of one parameter if size is given, it precises the number of params per item.

        Parameters
        ----------
        nb: int
        size: int,optional
        	default value is 1

        Returns
        -------
        IGESData_ParamCursor

        """
        return _IGESData.IGESData_ParamReader_CurrentList(self, *args)

    def CurrentNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns the current parameter number this notion is involved by the organisation of an iges list of parameter : it can be ended by two lists (associativities and properties), which can be empty, or even absent. hence, it is necessary to know, at the end of specific reading, how many parameters have been read : the optional lists follow.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamReader_CurrentNumber(self, *args)

    def DefinedElseSkip(self, *args) -> "Standard_Boolean":
        r"""
        Allows to simply process a parameter which can be defaulted. waits on the current number a defined parameter or skips it : if the parameter <num> is defined, changes nothing and returns true hence, the next reading with current cursor will concern <num> if it is void, advances current position by one, and returns false the next reading will concern <num+1> (except if <num> = nbparams) //! this allows to process default values as follows (c++) : if (pr.definedelseskip()) { .. pr.read... (current parameter); } else { <current parameter> = default value .. nothing else to do with paramreader } for message.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_DefinedElseSkip(self, *args)

    def EndAll(self, *args) -> "void":
        r"""
        Passes directly to the end of reading process.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_EndAll(self, *args)

    def EntityNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns the entity number in the file.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamReader_EntityNumber(self, *args)

    def HasFailed(self, *args) -> "Standard_Boolean":
        r"""
        Says if fails have been recorded into the check.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_HasFailed(self, *args)

    def IsCheckEmpty(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the check is empty else, it has to be recorded with the read entity.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_IsCheckEmpty(self, *args)

    def IsParamDefined(self, *args) -> "Standard_Boolean":
        r"""
        Says if a parameter is defined (not void) see also definedelseskip.

        Parameters
        ----------
        num: int

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_IsParamDefined(self, *args)

    def IsParamEntity(self, *args) -> "Standard_Boolean":
        r"""
        Says if a parameter can be regarded as an entity reference (see prepare from igesreaderdata for more explanation) note that such a parameter can seen as be a plain integer too.

        Parameters
        ----------
        num: int

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_IsParamEntity(self, *args)

    def Mend(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        pref: char *,optional
        	default value is 

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_Mend(self, *args)

    def NbParams(self, *args) -> "Standard_Integer":
        r"""
        Returns number of parameters (minus the first one) following method skip the first parameter (1 gives the 2nd).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamReader_NbParams(self, *args)

    def NextStage(self, *args) -> "void":
        r"""
        Passes to next stage (must be linked with setting current).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_NextStage(self, *args)

    def ParamEntity(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Directly returns entity referenced by a parameter.

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        num: int

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_ParamReader_ParamEntity(self, *args)

    def ParamNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns entity number corresponding to a parameter if there is otherwise zero (according criterium isparamentity).

        Parameters
        ----------
        num: int

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ParamReader_ParamNumber(self, *args)

    def ParamType(self, *args) -> "Interface_ParamType":
        r"""
        Returns type of parameter; note that 'ident' or 'sub' cannot be encountered, they correspond to 'integer', see also below.

        Parameters
        ----------
        num: int

        Returns
        -------
        Interface_ParamType

        """
        return _IGESData.IGESData_ParamReader_ParamType(self, *args)

    def ParamValue(self, *args) -> "char const *":
        r"""
        Returns literal value of a parameter, as it was in file.

        Parameters
        ----------
        num: int

        Returns
        -------
        char *

        """
        return _IGESData.IGESData_ParamReader_ParamValue(self, *args)

    def ReadBoolean(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        exact: bool,optional
        	default value is Standard_True

        Returns
        -------
        val: bool
        Reads a boolean value from parameter 'num' a boolean is given as an integer value 0 (false) or 1 (true) anyway, an integer is demanded (else, check is filled) if exact is given true, those precise values are demanded else, correction is done, as false for 0 or <0, true for >0 (with a warning error message, and return is true) in case of error (not an integer, or not 0/1 and exact true), check is filled with a fail (using mess) and return is false.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *
        exact: bool,optional
        	default value is Standard_True

        Returns
        -------
        val: bool

        """
        return _IGESData.IGESData_ParamReader_ReadBoolean(self, *args)

    def ReadEntList(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: Interface_EntityList
        ord: bool,optional
        	default value is Standard_True

        Returns
        -------
        bool
        Reads a list of entities defined by pc same conditions as for readents, for pc the list is given as an entitylist (index has no meaning; the entitylist starts from clear) if 'ord' is given true (default), entities will be added to the list in their original order remark : negative or null pointers are ignored else ('ord' false), order is not guaranteed (faster mode) if all params cannot be read as entities, same as above warning give 'ord' to false only if order is not significant.

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PC: IGESData_ParamCursor
        mess: char *
        val: Interface_EntityList
        ord: bool,optional
        	default value is Standard_True

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_ReadEntList(self, *args)

    def ReadEnts(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: IGESData_HArray1OfIGESEntity
        index: int,optional
        	default value is 1

        Returns
        -------
        bool
        Reads a list of entities defined by pc same conditions as for readints, for pc and index the list is given as a harray1, numered from 'index' if all params cannot be read as entities, check is filled (using mess) and return value is false remark : null references are accepted, they are ignored (negative pointers too : they provoke a warning message) if the caller wants to check them, a loop on readentity should be used.

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PC: IGESData_ParamCursor
        mess: char *
        val: IGESData_HArray1OfIGESEntity
        index: int,optional
        	default value is 1

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_ReadEnts(self, *args)

    def ReadInteger(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor

        Returns
        -------
        val: int
        Reads an integer value designated by pc the method current designates the current parameter and advances the current number by one after reading note that if a count (not 1) is given, it is ignored if it is not an integer, fills check with a fail (using mess) and returns false.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *

        Returns
        -------
        val: int

        """
        return _IGESData.IGESData_ParamReader_ReadInteger(self, *args)

    def ReadInts(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: TColStd_HArray1OfInteger
        index: int,optional
        	default value is 1

        Returns
        -------
        bool
        Reads a list of integer values, defined by pc (with a count of parameters). pc can start from current number and command it to advance after reading (use method currentlist to do this) the list is given as a harray1, numered from 'index' if all params are not integer, check is filled (using mess) and return value is false.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *
        val: TColStd_HArray1OfInteger
        index: int,optional
        	default value is 1

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_ReadInts(self, *args)

    def ReadReal(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor

        Returns
        -------
        val: float
        Reads a real value from parameter 'num' an integer is accepted (check is filled with a warning message) and causes return to be true (as normal case) in other cases, check is filled with a fail and return is false.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *

        Returns
        -------
        val: float

        """
        return _IGESData.IGESData_ParamReader_ReadReal(self, *args)

    def ReadReals(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: TColStd_HArray1OfReal
        index: int,optional
        	default value is 1

        Returns
        -------
        bool
        Reads a list of real values defined by pc same conditions as for readints, for pc and index an integer parameter is accepted, if at least one parameter is integer, check is filled with a 'warning' message if all params are neither real nor integer, check is filled (using mess) and return value is false.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *
        val: TColStd_HArray1OfReal
        index: int,optional
        	default value is 1

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_ReadReals(self, *args)

    def ReadText(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: TCollection_HAsciiString

        Returns
        -------
        bool
        Reads a text value from parameter 'num', as a string from collection, that is, hollerith text without leading 'nnnh' if it is not a string, fills check with a fail (using mess) and returns false.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *
        val: TCollection_HAsciiString

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_ReadText(self, *args)

    def ReadTexts(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: Interface_HArray1OfHAsciiString
        index: int,optional
        	default value is 1

        Returns
        -------
        bool
        Reads a list of hollerith texts, defined by pc texts are read as hollerith texts without leading 'nnnh' same conditions as for readints, for pc and index if all params are not text, check is filled (using mess) and return value is false.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *
        val: Interface_HArray1OfHAsciiString
        index: int,optional
        	default value is 1

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_ReadTexts(self, *args)

    def ReadXY(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: gp_XY

        Returns
        -------
        bool
        Reads a couple of real values (x,y) from parameter 'num' integers are accepted (check is filled with a warning message) and cause return to be true (as normal case) in other cases, check is filled with a fail and return is false.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *
        val: gp_XY

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_ReadXY(self, *args)

    def ReadXYZ(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        amsg: Message_Msg
        val: gp_XYZ

        Returns
        -------
        bool
        Reads a triplet of real values (x,y,z) from parameter 'num' integers are accepted (check is filled with a warning message) and cause return to be true (as normal case) in other cases, check is filled with a fail and return is false for message.

        Parameters
        ----------
        PC: IGESData_ParamCursor
        mess: char *
        val: gp_XYZ

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ParamReader_ReadXYZ(self, *args)

    def ReadingEntityNumber(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        num: int

        Returns
        -------
        val: int
        Routine which reads an entity number (which allows to read the entity in the igesreaderdata by boundentity), given its number in the list of parameters same conditions as readentity for mess, val, and return value in particular, returns true and val to zero means null entity, and val not zero means entity read by boundentity.

        Parameters
        ----------
        num: int
        mess: char *

        Returns
        -------
        val: int

        """
        return _IGESData.IGESData_ParamReader_ReadingEntityNumber(self, *args)

    def ReadingReal(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        num: int

        Returns
        -------
        val: float
        Routine which reads a real parameter, given its number same conditions as readreal for mess, val, and return value.

        Parameters
        ----------
        num: int
        mess: char *

        Returns
        -------
        val: float

        """
        return _IGESData.IGESData_ParamReader_ReadingReal(self, *args)

    def SendFail(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        amsg: Message_Msg

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_SendFail(self, *args)

    def SendWarning(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        amsg: Message_Msg

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_SendWarning(self, *args)

    def SetCurrentNumber(self, *args) -> "void":
        r"""
        Sets current parameter number to a new value must be done at end of each step : set on first parameter following last read one; is done by some read... methods (must be done directly if these method are not used) num greater than nbparams means that following lists are empty if current num is not managed, it remains at 1, which probably will cause error when successive steps of reading are made.

        Parameters
        ----------
        num: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ParamReader_SetCurrentNumber(self, *args)

    def Stage(self, *args) -> "IGESData_ReadStage":
        r"""
        Gives current stage (own-props-assocs-end, begins at own).

        Returns
        -------
        IGESData_ReadStage

        """
        return _IGESData.IGESData_ParamReader_Stage(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def ReadEntity(self):
    	pass

    __swig_destroy__ = _IGESData.delete_IGESData_ParamReader

# Register IGESData_ParamReader in _IGESData:
_IGESData.IGESData_ParamReader_swigregister(IGESData_ParamReader)

class IGESData_Protocol(OCC.Core.Interface.Interface_Protocol):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _IGESData.IGESData_Protocol_swiginit(self, _IGESData.new_IGESData_Protocol(*args))


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_Protocol_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_Protocol

# Register IGESData_Protocol in _IGESData:
_IGESData.IGESData_Protocol_swigregister(IGESData_Protocol)

class IGESData_ReadWriteModule(OCC.Core.Interface.Interface_ReaderModule):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def CaseIGES(self, *args) -> "Standard_Integer":
        r"""
        Defines case numbers corresponding to the entity types taken into account by a sub-class of readwritemodule (hence, each sub-class of readwritemodule has to redefine this method) called by casenum. its result will then be used to call read, etc ...

        Parameters
        ----------
        typenum: int
        formnum: int

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ReadWriteModule_CaseIGES(self, *args)

    def ReadOwnParams(self, *args) -> "void":
        r"""
        Reads own parameters from file for an entity; <pr> gives access to them, <ir> detains parameter types and values for each class, there must be a specific action provided note that properties and associativities lists are read by specific methods (see below), they are called under control of reading process (only one call) according stage recorded in paramreader.

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ReadWriteModule_ReadOwnParams(self, *args)

    def WriteOwnParams(self, *args) -> "void":
        r"""
        Writes own parameters to igeswriter; defined for each class (to be redefined for other iges readwritemodules) warning : properties and associativities are directly managed by writeiges, must not be sent by this method.

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity
        IW: IGESData_IGESWriter

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ReadWriteModule_WriteOwnParams(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_ReadWriteModule_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_ReadWriteModule

# Register IGESData_ReadWriteModule in _IGESData:
_IGESData.IGESData_ReadWriteModule_swigregister(IGESData_ReadWriteModule)

class IGESData_SpecificLib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a library which complies with a protocol, that is : same class (criterium isinstance) this creation gets the modules from the global set, those which are bound to the given protocol and its resources.

        Parameters
        ----------
        aprotocol: IGESData_Protocol

        Returns
        -------
        None
        Creates an empty library : it will later by filled by method addprotocol.

        Returns
        -------
        None

        """
        _IGESData.IGESData_SpecificLib_swiginit(self, _IGESData.new_IGESData_SpecificLib(*args))

    def AddProtocol(self, *args) -> "void":
        r"""
        Adds a couple (module-protocol) to the library, given the class of a protocol. takes resources into account. (if <aprotocol> is not of type theprotocol, it is not added).

        Parameters
        ----------
        aprotocol: Standard_Transient

        Returns
        -------
        None

        """
        return _IGESData.IGESData_SpecificLib_AddProtocol(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears the list of modules of a library (can be used to redefine the order of modules before action : clear then refill the library by calls to addprotocol).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_SpecificLib_Clear(self, *args)

    def Module(self, *args) -> "opencascade::handle< IGESData_SpecificModule > const &":
        r"""
        Returns the current module in the iteration.

        Returns
        -------
        opencascade::handle<IGESData_SpecificModule>

        """
        return _IGESData.IGESData_SpecificLib_Module(self, *args)

    def More(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if there are more modules to iterate on.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_SpecificLib_More(self, *args)

    def Next(self, *args) -> "void":
        r"""
        Iterates by getting the next module in the list if there is none, the exception will be raised by value.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_SpecificLib_Next(self, *args)

    def Protocol(self, *args) -> "opencascade::handle< IGESData_Protocol > const &":
        r"""
        Returns the current protocol in the iteration.

        Returns
        -------
        opencascade::handle<IGESData_Protocol>

        """
        return _IGESData.IGESData_SpecificLib_Protocol(self, *args)

    def Select(self, *args) -> "Standard_Boolean":
        r"""
        Selects a module from the library, given an object. returns true if select has succeeded, false else. also returns (as arguments) the selected module and the case number determined by the associated protocol. if select has failed, <module> is null handle and cn is zero. (select can work on any criterium, such as object dynamictype).

        Parameters
        ----------
        obj: IGESData_IGESEntity
        module: IGESData_SpecificModule

        Returns
        -------
        CN: int

        """
        return _IGESData.IGESData_SpecificLib_Select(self, *args)

    def SetComplete(self, *args) -> "void":
        r"""
        Sets a library to be defined with the complete global list (all the couples protocol/modules recorded in it).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_SpecificLib_SetComplete(self, *args)

    @staticmethod
    def SetGlobal(*args) -> "void":
        r"""
        Adds a couple (module-protocol) into the global definition set for this class of library.

        Parameters
        ----------
        amodule: IGESData_SpecificModule
        aprotocol: IGESData_Protocol

        Returns
        -------
        None

        """
        return _IGESData.IGESData_SpecificLib_SetGlobal(*args)

    def Start(self, *args) -> "void":
        r"""
        Starts iteration on the modules (sets it on the first one).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_SpecificLib_Start(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_SpecificLib

# Register IGESData_SpecificLib in _IGESData:
_IGESData.IGESData_SpecificLib_swigregister(IGESData_SpecificLib)

def IGESData_SpecificLib_SetGlobal(*args) -> "void":
    r"""
    Adds a couple (module-protocol) into the global definition set for this class of library.

    Parameters
    ----------
    amodule: IGESData_SpecificModule
    aprotocol: IGESData_Protocol

    Returns
    -------
    None

    """
    return _IGESData.IGESData_SpecificLib_SetGlobal(*args)

class IGESData_SpecificModule(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def OwnCorrect(self, *args) -> "Standard_Boolean":
        r"""
        Specific automatic correction on own parameters of an entity. it works by setting in accordance redundant data, if there are when there is no ambiguity (else, it does nothing). remark that classic corrections on directory entry (to set void data) are taken into account alsewhere. //! for instance, many 'associativity entities' have a number of properties which must have a fixed value. or, a conicalarc has its form number which records the kind of conic, also determined from its coefficients but, a circulararc of which distances (center-start) and (center-end) are not equal cannot be corrected ... //! returns true if something has been corrected in <ent> by default, does nothing. if at least one of the types processed by a sub-class of specificmodule has a correct procedure attached, this method can be redefined.

        Parameters
        ----------
        CN: int
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_SpecificModule_OwnCorrect(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_SpecificModule_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_SpecificModule

# Register IGESData_SpecificModule in _IGESData:
_IGESData.IGESData_SpecificModule_swigregister(IGESData_SpecificModule)

class IGESData_ToolLocation(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a toollocation on a given model, filled with the help of a protocol (which allows to known entities referenced by other ones).

        Parameters
        ----------
        amodel: IGESData_IGESModel
        protocol: IGESData_Protocol

        Returns
        -------
        None

        """
        _IGESData.IGESData_ToolLocation_swiginit(self, _IGESData.new_IGESData_ToolLocation(*args))

    def AnalyseLocation(self, *args) -> "Standard_Boolean":
        r"""
        Analysis a location given as a gtrsf, by trying to convert it to a trsf (i.e. to a true location of which effect is described by an isometry or a similarity) works with the precision given by default or by setprecision calls convertlocation (see below).

        Parameters
        ----------
        loc: gp_GTrsf
        result: gp_Trsf

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ToolLocation_AnalyseLocation(self, *args)

    @staticmethod
    def ConvertLocation(*args) -> "Standard_Boolean":
        r"""
        Conversion of a location, from gtrsf form to trsf form works with a precision given as argument. returns true if the conversion is possible, (hence, <result> contains the converted location), false else <unit>, if given, indicates the unit in which <loc> is defined in meters. it concerns the translation part (to be converted. //! as a class method, it can be called separately.

        Parameters
        ----------
        prec: float
        loc: gp_GTrsf
        result: gp_Trsf
        uni: float,optional
        	default value is 1

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ToolLocation_ConvertLocation(*args)

    def EffectiveLocation(self, *args) -> "gp_GTrsf":
        r"""
        Returns the effective location of an entity, i.e. the composition of its proper transformation matrix (returned by transf) and its parent's location (returned by parentlocation).

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        gp_GTrsf

        """
        return _IGESData.IGESData_ToolLocation_EffectiveLocation(self, *args)

    def ExplicitLocation(self, *args) -> "gp_GTrsf":
        r"""
        Returns the explicit location defined by the transformation matrix of <ent>. identity if there is none.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        gp_GTrsf

        """
        return _IGESData.IGESData_ToolLocation_ExplicitLocation(self, *args)

    def HasParent(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <ent> is dependent from one and only one other entity, either by reference or by associativity.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ToolLocation_HasParent(self, *args)

    def HasParentByAssociativity(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the parent, if there is one, is defined by a singleparententity associativity else, if hasparent is true, it is by reference.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ToolLocation_HasParentByAssociativity(self, *args)

    def HasTransf(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <ent> has a transformation matrix in proper (referenced from its directory part).

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ToolLocation_HasTransf(self, *args)

    def IsAmbiguous(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if more than one parent has been determined for <ent>, by adding direct references and associativities.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ToolLocation_IsAmbiguous(self, *args)

    def IsAssociativity(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <ent> is an associativity (iges type 402). then, location does not apply.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ToolLocation_IsAssociativity(self, *args)

    def IsTransf(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <ent> is kind of transfentity. then, it has no location, while it can be used to define a location).

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ToolLocation_IsTransf(self, *args)

    def Load(self, *args) -> "void":
        r"""
        Does the effective work of determining locations of entities.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ToolLocation_Load(self, *args)

    def Parent(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns the unique parent recorded for <ent>. returns a null handle if there is none.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_ToolLocation_Parent(self, *args)

    def ParentLocation(self, *args) -> "gp_GTrsf":
        r"""
        Returns the effective location of the parent of <ent>, if there is one : this location is itself given as compound according dependences on the parent, if there are some. returns an identity transformation if no parent is recorded.

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        gp_GTrsf

        """
        return _IGESData.IGESData_ToolLocation_ParentLocation(self, *args)

    def ResetDependences(self, *args) -> "void":
        r"""
        Resets all information about dependences for <child>.

        Parameters
        ----------
        child: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ToolLocation_ResetDependences(self, *args)

    def SetOwnAsDependent(self, *args) -> "void":
        r"""
        Unitary action which defines entities referenced by <ent> (except those in directory part and associativities list) as dependent (their locations are related to that of <ent>).

        Parameters
        ----------
        ent: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ToolLocation_SetOwnAsDependent(self, *args)

    def SetParentAssoc(self, *args) -> "void":
        r"""
        Sets the 'associativity' information for <child> as being <parent> (it must be the parent itself, not the associativity).

        Parameters
        ----------
        parent: IGESData_IGESEntity
        child: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ToolLocation_SetParentAssoc(self, *args)

    def SetPrecision(self, *args) -> "void":
        r"""
        Sets a precision for the analysis of locations (default by constructor is 1.e-05).

        Parameters
        ----------
        prec: float

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ToolLocation_SetPrecision(self, *args)

    def SetReference(self, *args) -> "void":
        r"""
        Sets the 'reference' information for <child> as being <parent> sets an error status if already set (see method isambiguous).

        Parameters
        ----------
        parent: IGESData_IGESEntity
        child: IGESData_IGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_ToolLocation_SetReference(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_ToolLocation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_ToolLocation

# Register IGESData_ToolLocation in _IGESData:
_IGESData.IGESData_ToolLocation_swigregister(IGESData_ToolLocation)

def IGESData_ToolLocation_ConvertLocation(*args) -> "Standard_Boolean":
    r"""
    Conversion of a location, from gtrsf form to trsf form works with a precision given as argument. returns true if the conversion is possible, (hence, <result> contains the converted location), false else <unit>, if given, indicates the unit in which <loc> is defined in meters. it concerns the translation part (to be converted. //! as a class method, it can be called separately.

    Parameters
    ----------
    prec: float
    loc: gp_GTrsf
    result: gp_Trsf
    uni: float,optional
    	default value is 1

    Returns
    -------
    bool

    """
    return _IGESData.IGESData_ToolLocation_ConvertLocation(*args)

class IGESData_WriterLib(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a library which complies with a protocol, that is : same class (criterium isinstance) this creation gets the modules from the global set, those which are bound to the given protocol and its resources.

        Parameters
        ----------
        aprotocol: IGESData_Protocol

        Returns
        -------
        None
        Creates an empty library : it will later by filled by method addprotocol.

        Returns
        -------
        None

        """
        _IGESData.IGESData_WriterLib_swiginit(self, _IGESData.new_IGESData_WriterLib(*args))

    def AddProtocol(self, *args) -> "void":
        r"""
        Adds a couple (module-protocol) to the library, given the class of a protocol. takes resources into account. (if <aprotocol> is not of type theprotocol, it is not added).

        Parameters
        ----------
        aprotocol: Standard_Transient

        Returns
        -------
        None

        """
        return _IGESData.IGESData_WriterLib_AddProtocol(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears the list of modules of a library (can be used to redefine the order of modules before action : clear then refill the library by calls to addprotocol).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_WriterLib_Clear(self, *args)

    def Module(self, *args) -> "opencascade::handle< IGESData_ReadWriteModule > const &":
        r"""
        Returns the current module in the iteration.

        Returns
        -------
        opencascade::handle<IGESData_ReadWriteModule>

        """
        return _IGESData.IGESData_WriterLib_Module(self, *args)

    def More(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if there are more modules to iterate on.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_WriterLib_More(self, *args)

    def Next(self, *args) -> "void":
        r"""
        Iterates by getting the next module in the list if there is none, the exception will be raised by value.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_WriterLib_Next(self, *args)

    def Protocol(self, *args) -> "opencascade::handle< IGESData_Protocol > const &":
        r"""
        Returns the current protocol in the iteration.

        Returns
        -------
        opencascade::handle<IGESData_Protocol>

        """
        return _IGESData.IGESData_WriterLib_Protocol(self, *args)

    def Select(self, *args) -> "Standard_Boolean":
        r"""
        Selects a module from the library, given an object. returns true if select has succeeded, false else. also returns (as arguments) the selected module and the case number determined by the associated protocol. if select has failed, <module> is null handle and cn is zero. (select can work on any criterium, such as object dynamictype).

        Parameters
        ----------
        obj: IGESData_IGESEntity
        module: IGESData_ReadWriteModule

        Returns
        -------
        CN: int

        """
        return _IGESData.IGESData_WriterLib_Select(self, *args)

    def SetComplete(self, *args) -> "void":
        r"""
        Sets a library to be defined with the complete global list (all the couples protocol/modules recorded in it).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_WriterLib_SetComplete(self, *args)

    @staticmethod
    def SetGlobal(*args) -> "void":
        r"""
        Adds a couple (module-protocol) into the global definition set for this class of library.

        Parameters
        ----------
        amodule: IGESData_ReadWriteModule
        aprotocol: IGESData_Protocol

        Returns
        -------
        None

        """
        return _IGESData.IGESData_WriterLib_SetGlobal(*args)

    def Start(self, *args) -> "void":
        r"""
        Starts iteration on the modules (sets it on the first one).

        Returns
        -------
        None

        """
        return _IGESData.IGESData_WriterLib_Start(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_WriterLib

# Register IGESData_WriterLib in _IGESData:
_IGESData.IGESData_WriterLib_swigregister(IGESData_WriterLib)

def IGESData_WriterLib_SetGlobal(*args) -> "void":
    r"""
    Adds a couple (module-protocol) into the global definition set for this class of library.

    Parameters
    ----------
    amodule: IGESData_ReadWriteModule
    aprotocol: IGESData_Protocol

    Returns
    -------
    None

    """
    return _IGESData.IGESData_WriterLib_SetGlobal(*args)

class IGESData_ColorEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_ColorEntity_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _IGESData.IGESData_ColorEntity_swiginit(self, _IGESData.new_IGESData_ColorEntity())
    __swig_destroy__ = _IGESData.delete_IGESData_ColorEntity

# Register IGESData_ColorEntity in _IGESData:
_IGESData.IGESData_ColorEntity_swigregister(IGESData_ColorEntity)

class IGESData_DefaultGeneral(IGESData_GeneralModule):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a defaultgeneral and puts it into generallib, bound with a protocol from igesdata.

        Returns
        -------
        None

        """
        _IGESData.IGESData_DefaultGeneral_swiginit(self, _IGESData.new_IGESData_DefaultGeneral(*args))


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_DefaultGeneral_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DefaultGeneral

# Register IGESData_DefaultGeneral in _IGESData:
_IGESData.IGESData_DefaultGeneral_swigregister(IGESData_DefaultGeneral)

class IGESData_DefaultSpecific(IGESData_SpecificModule):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a defaultspecific and puts it into specificlib.

        Returns
        -------
        None

        """
        _IGESData.IGESData_DefaultSpecific_swiginit(self, _IGESData.new_IGESData_DefaultSpecific(*args))


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_DefaultSpecific_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_DefaultSpecific

# Register IGESData_DefaultSpecific in _IGESData:
_IGESData.IGESData_DefaultSpecific_swigregister(IGESData_DefaultSpecific)

class IGESData_FileProtocol(IGESData_Protocol):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty fileprotocol.

        Returns
        -------
        None

        """
        _IGESData.IGESData_FileProtocol_swiginit(self, _IGESData.new_IGESData_FileProtocol(*args))

    def Add(self, *args) -> "void":
        r"""
        Adds a resource.

        Parameters
        ----------
        protocol: IGESData_Protocol

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FileProtocol_Add(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_FileProtocol_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_FileProtocol

# Register IGESData_FileProtocol in _IGESData:
_IGESData.IGESData_FileProtocol_swigregister(IGESData_FileProtocol)

class IGESData_LabelDisplayEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_LabelDisplayEntity_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _IGESData.IGESData_LabelDisplayEntity_swiginit(self, _IGESData.new_IGESData_LabelDisplayEntity())
    __swig_destroy__ = _IGESData.delete_IGESData_LabelDisplayEntity

# Register IGESData_LabelDisplayEntity in _IGESData:
_IGESData.IGESData_LabelDisplayEntity_swigregister(IGESData_LabelDisplayEntity)

class IGESData_LevelListEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def HasLevelNumber(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <level> is in the list.

        Parameters
        ----------
        level: int

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_LevelListEntity_HasLevelNumber(self, *args)

    def LevelNumber(self, *args) -> "Standard_Integer":
        r"""
        Returns the level number of <self>, indicated by <num> raises an exception if num is out of range.

        Parameters
        ----------
        num: int

        Returns
        -------
        int

        """
        return _IGESData.IGESData_LevelListEntity_LevelNumber(self, *args)

    def NbLevelNumbers(self, *args) -> "Standard_Integer":
        r"""
        Must return the count of levels.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_LevelListEntity_NbLevelNumbers(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_LevelListEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_LevelListEntity

# Register IGESData_LevelListEntity in _IGESData:
_IGESData.IGESData_LevelListEntity_swigregister(IGESData_LevelListEntity)

class IGESData_LineFontEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_LineFontEntity_DownCast(t)


    __repr__ = _dumps_object


    def __init__(self):
        _IGESData.IGESData_LineFontEntity_swiginit(self, _IGESData.new_IGESData_LineFontEntity())
    __swig_destroy__ = _IGESData.delete_IGESData_LineFontEntity

# Register IGESData_LineFontEntity in _IGESData:
_IGESData.IGESData_LineFontEntity_swigregister(IGESData_LineFontEntity)

class IGESData_NameEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Value(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Retyrns the alphanumeric value of the name, to be defined.

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_NameEntity_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_NameEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_NameEntity

# Register IGESData_NameEntity in _IGESData:
_IGESData.IGESData_NameEntity_swigregister(IGESData_NameEntity)

class IGESData_SingleParentEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Child(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns a child given its rank.

        Parameters
        ----------
        num: int

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_SingleParentEntity_Child(self, *args)

    def NbChildren(self, *args) -> "Standard_Integer":
        r"""
        Returns the count of entities designated as children.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_SingleParentEntity_NbChildren(self, *args)

    def SingleParent(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns the parent designated by the entity, if only one !.

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_SingleParentEntity_SingleParent(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_SingleParentEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_SingleParentEntity

# Register IGESData_SingleParentEntity in _IGESData:
_IGESData.IGESData_SingleParentEntity_swigregister(IGESData_SingleParentEntity)

class IGESData_TransfEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Value(self, *args) -> "gp_GTrsf":
        r"""
        Gives value of the transformation, as a gtrsf to be defined by an effective class of transformation entity warning : must take in account composition : if a transfentity has in its directory part, a transf, this means that it is compound, value must return the global result.

        Returns
        -------
        gp_GTrsf

        """
        return _IGESData.IGESData_TransfEntity_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_TransfEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_TransfEntity

# Register IGESData_TransfEntity in _IGESData:
_IGESData.IGESData_TransfEntity_swigregister(IGESData_TransfEntity)

class IGESData_UndefinedEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an unknown entity.

        Returns
        -------
        None

        """
        _IGESData.IGESData_UndefinedEntity_swiginit(self, _IGESData.new_IGESData_UndefinedEntity(*args))

    def ChangeableContent(self, *args) -> "opencascade::handle< Interface_UndefinedContent >":
        r"""
        Returns own data as an undefinedcontent, in order to touch it.

        Returns
        -------
        opencascade::handle<Interface_UndefinedContent>

        """
        return _IGESData.IGESData_UndefinedEntity_ChangeableContent(self, *args)

    def DirStatus(self, *args) -> "Standard_Integer":
        r"""
        Returns directory error status (used for copy).

        Returns
        -------
        int

        """
        return _IGESData.IGESData_UndefinedEntity_DirStatus(self, *args)

    def IsOKDirPart(self, *args) -> "Standard_Boolean":
        r"""
        Says if dirpart is ok or not (if not, it is erroneous) note that if it is not, def* methods can return error status.

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_UndefinedEntity_IsOKDirPart(self, *args)

    def ReadDir(self, *args) -> "Standard_Boolean":
        r"""
        Computes the directory error status, to be called before standard readdir from igesreadertool returns true if ok (hence, directory can be loaded), else returns false and the dirpart <dp> is modified (hence, directory error status is non null; and standard read will work with an acceptable directorypart).

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        DP: IGESData_DirPart
        ach: Interface_Check

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_UndefinedEntity_ReadDir(self, *args)

    def ReadOwnParams(self, *args) -> "void":
        r"""
        Reads own parameters from file; pr gives access to them, ir detains parameter types and values here, reads all parameters, integers are considered as entity reference unless they cannot be; no list interpretation no property or associativity list is managed.

        Parameters
        ----------
        IR: IGESData_IGESReaderData
        PR: IGESData_ParamReader

        Returns
        -------
        None

        """
        return _IGESData.IGESData_UndefinedEntity_ReadOwnParams(self, *args)

    def SetNewContent(self, *args) -> "void":
        r"""
        Redefines a completely new undefinedcontent used by a copy which begins by shallowcopy, for instance.

        Parameters
        ----------
        cont: Interface_UndefinedContent

        Returns
        -------
        None

        """
        return _IGESData.IGESData_UndefinedEntity_SetNewContent(self, *args)

    def SetOKDirPart(self, *args) -> "void":
        r"""
        Erases the directory error status warning : be sure that data are consistent to call this method ...

        Returns
        -------
        None

        """
        return _IGESData.IGESData_UndefinedEntity_SetOKDirPart(self, *args)

    def UndefinedContent(self, *args) -> "opencascade::handle< Interface_UndefinedContent >":
        r"""
        Returns own data as an undefinedcontent.

        Returns
        -------
        opencascade::handle<Interface_UndefinedContent>

        """
        return _IGESData.IGESData_UndefinedEntity_UndefinedContent(self, *args)

    def WriteOwnParams(self, *args) -> "void":
        r"""
        Writes parameters to igeswriter, taken from undefinedcontent.

        Parameters
        ----------
        IW: IGESData_IGESWriter

        Returns
        -------
        None

        """
        return _IGESData.IGESData_UndefinedEntity_WriteOwnParams(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_UndefinedEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_UndefinedEntity

# Register IGESData_UndefinedEntity in _IGESData:
_IGESData.IGESData_UndefinedEntity_swigregister(IGESData_UndefinedEntity)

class IGESData_ViewKindEntity(IGESData_IGESEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def IsSingle(self, *args) -> "Standard_Boolean":
        r"""
        Says if 'me' is a single view (true) or a list of views (false).

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_ViewKindEntity_IsSingle(self, *args)

    def NbViews(self, *args) -> "Standard_Integer":
        r"""
        Returns the count of views for a list of views. for a single view, may return simply 1.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_ViewKindEntity_NbViews(self, *args)

    def ViewItem(self, *args) -> "opencascade::handle< IGESData_ViewKindEntity >":
        r"""
        Returns the view n0. <num> for a list of views. for a single views, may return <self> itself.

        Parameters
        ----------
        num: int

        Returns
        -------
        opencascade::handle<IGESData_ViewKindEntity>

        """
        return _IGESData.IGESData_ViewKindEntity_ViewItem(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_ViewKindEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_ViewKindEntity

# Register IGESData_ViewKindEntity in _IGESData:
_IGESData.IGESData_ViewKindEntity_swigregister(IGESData_ViewKindEntity)

class IGESData_FreeFormatEntity(IGESData_UndefinedEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a completely empty freeformatentity.

        Returns
        -------
        None

        """
        _IGESData.IGESData_FreeFormatEntity_swiginit(self, _IGESData.new_IGESData_FreeFormatEntity(*args))

    def AddEntities(self, *args) -> "void":
        r"""
        Adds a set of entities, given as a harray1ofigesentity causes creation of : an integer parameter which gives count of entities, then the list of entities of the array error if an entity is not an igesentity all these entities will be interpreted as 'positive pointers' by igeswriter.

        Parameters
        ----------
        ents: IGESData_HArray1OfIGESEntity

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FreeFormatEntity_AddEntities(self, *args)

    def AddEntity(self, *args) -> "void":
        r"""
        Adds a parameter which references an entity. if the entity is null, the added parameter will define a 'null pointer' (0) if <negative> is given true, this will command sending to file (see igeswriter) to produce a 'negative pointer' (default is false).

        Parameters
        ----------
        ptype: Interface_ParamType
        ent: IGESData_IGESEntity
        negative: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FreeFormatEntity_AddEntity(self, *args)

    def AddLiteral(self, *args) -> "void":
        r"""
        Adds a literal parameter to the list (as such).

        Parameters
        ----------
        ptype: Interface_ParamType
        val: TCollection_HAsciiString

        Returns
        -------
        None
        Adds a literal parameter to the list (builds an hasciistring).

        Parameters
        ----------
        ptype: Interface_ParamType
        val: char *

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FreeFormatEntity_AddLiteral(self, *args)

    def AddNegativePointers(self, *args) -> "void":
        r"""
        Adds a list of ranks of parameters to be noted as negative pointers (this will be taken into account for parameters which are entities).

        Parameters
        ----------
        list: TColStd_HSequenceOfInteger

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FreeFormatEntity_AddNegativePointers(self, *args)

    def ClearNegativePointers(self, *args) -> "void":
        r"""
        Clears all information about negative pointers, hence every entity kind parameter will be sent normally, as positive.

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FreeFormatEntity_ClearNegativePointers(self, *args)

    def IsNegativePointer(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if <num> is noted as for a 'negative pointer' (see addentity for details). senseful only if isparamentity answers true for <num>, else returns false.

        Parameters
        ----------
        num: int

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_FreeFormatEntity_IsNegativePointer(self, *args)

    def IsParamEntity(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if a parameter is recorded as an entity error if num is not between 1 and nbparams.

        Parameters
        ----------
        num: int

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_FreeFormatEntity_IsParamEntity(self, *args)

    def NbParams(self, *args) -> "Standard_Integer":
        r"""
        Gives count of recorded parameters.

        Returns
        -------
        int

        """
        return _IGESData.IGESData_FreeFormatEntity_NbParams(self, *args)

    def NegativePointers(self, *args) -> "opencascade::handle< TColStd_HSequenceOfInteger >":
        r"""
        Returns the complete list of ramks of parameters which have been noted as negative pointers warning : it is returned as a null handle if none was noted.

        Returns
        -------
        opencascade::handle<TColStd_HSequenceOfInteger>

        """
        return _IGESData.IGESData_FreeFormatEntity_NegativePointers(self, *args)

    def ParamData(self, *args) -> "Standard_Boolean":
        r"""
        Returns data of a parameter : its type, and the entity if it designates en entity ('ent') or its literal value else ('str') returned value (boolean) : true if it is an entity, false else.

        Parameters
        ----------
        num: int
        ptype: Interface_ParamType
        ent: IGESData_IGESEntity
        val: TCollection_HAsciiString

        Returns
        -------
        bool

        """
        return _IGESData.IGESData_FreeFormatEntity_ParamData(self, *args)

    def ParamEntity(self, *args) -> "opencascade::handle< IGESData_IGESEntity >":
        r"""
        Returns entity corresponding to a param, given its rank error if out of range or if param num does not designate an entity.

        Parameters
        ----------
        num: int

        Returns
        -------
        opencascade::handle<IGESData_IGESEntity>

        """
        return _IGESData.IGESData_FreeFormatEntity_ParamEntity(self, *args)

    def ParamType(self, *args) -> "Interface_ParamType":
        r"""
        Returns the paramtype of a param, given its rank error if num is not between 1 and nbparams.

        Parameters
        ----------
        num: int

        Returns
        -------
        Interface_ParamType

        """
        return _IGESData.IGESData_FreeFormatEntity_ParamType(self, *args)

    def ParamValue(self, *args) -> "opencascade::handle< TCollection_HAsciiString >":
        r"""
        Returns literal value of a parameter, given its rank error if num is out of range, or if parameter is not literal.

        Parameters
        ----------
        num: int

        Returns
        -------
        opencascade::handle<TCollection_HAsciiString>

        """
        return _IGESData.IGESData_FreeFormatEntity_ParamValue(self, *args)

    def SetFormNumber(self, *args) -> "void":
        r"""
        Sets form number to a new value (to called after settypenumber).

        Parameters
        ----------
        formnum: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FreeFormatEntity_SetFormNumber(self, *args)

    def SetTypeNumber(self, *args) -> "void":
        r"""
        Sets type number to a new value, and form number to zero.

        Parameters
        ----------
        typenum: int

        Returns
        -------
        None

        """
        return _IGESData.IGESData_FreeFormatEntity_SetTypeNumber(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_FreeFormatEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _IGESData.delete_IGESData_FreeFormatEntity

# Register IGESData_FreeFormatEntity in _IGESData:
_IGESData.IGESData_FreeFormatEntity_swigregister(IGESData_FreeFormatEntity)

class IGESData_HArray1OfIGESEntity(IGESData_Array1OfIGESEntity, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _IGESData.IGESData_HArray1OfIGESEntity_swiginit(self, _IGESData.new_IGESData_HArray1OfIGESEntity(*args))

    def Array1(self) -> "IGESData_Array1OfIGESEntity const &":
        return _IGESData.IGESData_HArray1OfIGESEntity_Array1(self)

    def ChangeArray1(self) -> "IGESData_Array1OfIGESEntity &":
        return _IGESData.IGESData_HArray1OfIGESEntity_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_IGESData_HArray1OfIGESEntity_DownCast(t)

    __swig_destroy__ = _IGESData.delete_IGESData_HArray1OfIGESEntity

# Register IGESData_HArray1OfIGESEntity in _IGESData:
_IGESData.IGESData_HArray1OfIGESEntity_swigregister(IGESData_HArray1OfIGESEntity)





