/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.text.ParseException;
import java.util.Comparator;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;

public class OsgiLatestStrategy
extends ComparatorLatestStrategy {
    private final Comparator mridComparator = new MridComparator();
    private final Comparator artifactInfoComparator = new ArtifactInfoComparator();

    public OsgiLatestStrategy() {
        OsgiLatestStrategy osgiLatestStrategy = this;
        osgiLatestStrategy.setComparator(osgiLatestStrategy.artifactInfoComparator);
        this.setName("latest-osgi");
    }

    final class ArtifactInfoComparator
    implements Comparator {
        ArtifactInfoComparator() {
        }

        public final int compare(Object object, Object object2) {
            return this.compare((ArtifactInfo)object, (ArtifactInfo)object2);
        }

        public final int compare(ArtifactInfo object, ArtifactInfo object2) {
            object = object.getRevision();
            object2 = object2.getRevision();
            VersionMatcher versionMatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            object = ModuleRevisionId.newInstance("", "", (String)object);
            object2 = ModuleRevisionId.newInstance("", "", (String)object2);
            if (versionMatcher.isDynamic((ModuleRevisionId)object)) {
                int n = versionMatcher.compare((ModuleRevisionId)object, (ModuleRevisionId)object2, OsgiLatestStrategy.this.mridComparator);
                if (n >= 0) {
                    return 1;
                }
                return -1;
            }
            if (versionMatcher.isDynamic((ModuleRevisionId)object2)) {
                int n = versionMatcher.compare((ModuleRevisionId)object2, (ModuleRevisionId)object, OsgiLatestStrategy.this.mridComparator);
                if (n >= 0) {
                    return -1;
                }
                return 1;
            }
            return OsgiLatestStrategy.this.mridComparator.compare(object, object2);
        }
    }

    final class MridComparator
    implements Comparator {
        MridComparator() {
        }

        public final int compare(Object object, Object object2) {
            return this.compare((ModuleRevisionId)object, (ModuleRevisionId)object2);
        }

        public final int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
            Version version;
            Version version2;
            try {
                version2 = new Version(moduleRevisionId.getRevision());
                version = new Version(moduleRevisionId2.getRevision());
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Uncomparable versions:" + moduleRevisionId.getRevision() + " and " + moduleRevisionId2.getRevision() + " (" + parseException.getMessage() + ")");
            }
            return version2.compareTo(version);
        }
    }
}

