import { DeviceKeys, GenericKeys, KeyClaim, KeyClaimResponse, KeyQueryResults, OlmEngine, OTKCounts, ToDeviceMessages } from "@turt2live/matrix-sdk-crypto-nodejs";
import { MatrixClient } from "../MatrixClient";
/**
 * A representation of a rust-sdk OlmEngine for the bot-sdk. You should not need to
 * instantiate this yourself.
 * @category Encryption
 */
export declare class SdkOlmEngine implements OlmEngine {
    private client;
    constructor(client: MatrixClient);
    claimOneTimeKeys(claim: KeyClaim): Promise<KeyClaimResponse>;
    queryOneTimeKeys(userIds: string[]): Promise<KeyQueryResults>;
    uploadOneTimeKeys(body: {
        device_keys?: DeviceKeys;
        one_time_keys?: GenericKeys;
    }): Promise<OTKCounts>;
    getEffectiveJoinedUsersInRoom(roomId: string): Promise<string[]>;
    sendToDevices(eventType: string, messages: ToDeviceMessages): Promise<void>;
}
