"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIZ_CONTAIN_XY_AXIS = exports.VALUEFIELD = exports.UNSELECTED_FIELDS = exports.UNITS_OF_MEASURE = exports.TIME_INTERVAL_OPTIONS = exports.TIME_FIELD = exports.TIMESTAMP = exports.TAB_TITLE = exports.TAB_ID_TXT_PFX = exports.TAB_EVENT_TITLE = exports.TAB_EVENT_ID_TXT_PFX = exports.TAB_EVENT_ID = exports.TAB_CREATED_TYPE = exports.TAB_CHART_TITLE = exports.TAB_CHART_ID_TXT_PFX = exports.TAB_CHART_ID = exports.SPAN = exports.SIMILAR_VIZ_TYPES = exports.SELECTED_TIMESTAMP = exports.SELECTED_QUERY_TAB = exports.SELECTED_PATTERN_FIELD = exports.SELECTED_FIELDS = exports.SELECTED_DATE_RANGE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECT_TYPE = exports.SAVED_OBJECT_ID = exports.ROW_DENSITIES = exports.REDUX_EXPL_SLICE_VISUALIZATION = exports.REDUX_EXPL_SLICE_QUERY_TABS = exports.REDUX_EXPL_SLICE_QUERY_RESULT = exports.REDUX_EXPL_SLICE_QUERIES = exports.REDUX_EXPL_SLICE_PATTERNS = exports.REDUX_EXPL_SLICE_FIELDS = exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = exports.REDIRECT_TAB = exports.RAW_QUERY = exports.QUERY_TAB_IDS = exports.QUERIED_FIELDS = exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = exports.PLOTLY_PIE_COLUMN_NUMBER = exports.PLOTLY_GAUGE_COLUMN_NUMBER = exports.PIE_YAXIS_GAP = exports.PIE_XAXIS_GAP = exports.PATTERN_REGEX = exports.PATTERNS_REGEX = exports.PATTERNS_EXTRACTOR_REGEX = exports.PARENTFIELDS = exports.PAGE_SIZE = exports.OTEL_TRACE_ID = exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = exports.NUMERICAL_TYPES = exports.NUMBER_INPUT_MIN_LIMIT = exports.NEW_TAB = exports.NEW_SELECTED_QUERY_TAB = exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = exports.METRICS_AXIS_MARGIN = exports.METRICS_ANNOTATION = exports.JAEGER_TRACE_ID = exports.INDEX = exports.HEADER_HEIGHT = exports.HAS_SAVED_TIMESTAMP = exports.GROUPBY = exports.GRID_PAGE_SIZES = exports.GRID_PAGE_RANGE_DISPLAY = exports.GRID_HEADER_COLUMN_MAX_WIDTH = exports.FINAL_QUERY = exports.FILTER_OPTIONS = exports.FILTERED_PATTERN = exports.EVENT_ANALYTICS_DOCUMENTATION_URL = exports.DISABLED_COLOUR = exports.DEFAULT_PIE_CHART_PARAMETERS = exports.DEFAULT_METRICS_CHART_PARAMETERS = exports.DEFAULT_GAUGE_CHART_PARAMETERS = exports.DEFAULT_COLUMNS = exports.DEFAULT_BAR_CHART_STYLES = exports.DEFAULT_AVAILABILITY_QUERY = exports.DATE_PICKER_FORMAT = exports.DATA_CONFIG_HINTS_INFO = exports.ConfigChartOptionsEnum = exports.CUSTOM_LABEL = exports.COLUMN_DEFAULT_MIN_WIDTH = exports.CHILDFIELD = exports.BREAKDOWNS = exports.AVAILABLE_FIELDS = exports.APP_ANALYTICS_TAB_ID_REGEX = exports.AGGREGATION_OPTIONS = exports.AGGREGATIONS = exports.ADD_BUTTON_TEXT = void 0;

var _eui = require("@elastic/eui");

var _shared = require("./shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const EVENT_ANALYTICS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/event-analytics/';
exports.EVENT_ANALYTICS_DOCUMENTATION_URL = EVENT_ANALYTICS_DOCUMENTATION_URL;
const OPEN_TELEMETRY_LOG_CORRELATION_LINK = 'https://opentelemetry.io/docs/reference/specification/logs/overview/#log-correlation';
exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = OPEN_TELEMETRY_LOG_CORRELATION_LINK;
const RAW_QUERY = 'rawQuery';
exports.RAW_QUERY = RAW_QUERY;
const FINAL_QUERY = 'finalQuery';
exports.FINAL_QUERY = FINAL_QUERY;
const SELECTED_DATE_RANGE = 'selectedDateRange';
exports.SELECTED_DATE_RANGE = SELECTED_DATE_RANGE;
const INDEX = 'index';
exports.INDEX = INDEX;
const SELECTED_PATTERN_FIELD = 'selectedPatternField';
exports.SELECTED_PATTERN_FIELD = SELECTED_PATTERN_FIELD;
const PATTERN_REGEX = 'patternRegex';
exports.PATTERN_REGEX = PATTERN_REGEX;
const FILTERED_PATTERN = 'filteredPattern';
exports.FILTERED_PATTERN = FILTERED_PATTERN;
const SELECTED_TIMESTAMP = 'selectedTimestamp';
exports.SELECTED_TIMESTAMP = SELECTED_TIMESTAMP;
const SELECTED_FIELDS = 'selectedFields';
exports.SELECTED_FIELDS = SELECTED_FIELDS;
const UNSELECTED_FIELDS = 'unselectedFields';
exports.UNSELECTED_FIELDS = UNSELECTED_FIELDS;
const AVAILABLE_FIELDS = 'availableFields';
exports.AVAILABLE_FIELDS = AVAILABLE_FIELDS;
const QUERIED_FIELDS = 'queriedFields';
exports.QUERIED_FIELDS = QUERIED_FIELDS;
const TAB_ID_TXT_PFX = 'explorer-tab-';
exports.TAB_ID_TXT_PFX = TAB_ID_TXT_PFX;
const TAB_TITLE = 'New query';
exports.TAB_TITLE = TAB_TITLE;
const TAB_CHART_TITLE = 'Visualizations';
exports.TAB_CHART_TITLE = TAB_CHART_TITLE;
const TAB_EVENT_TITLE = 'Events';
exports.TAB_EVENT_TITLE = TAB_EVENT_TITLE;
const TAB_EVENT_ID_TXT_PFX = 'main-content-events-';
exports.TAB_EVENT_ID_TXT_PFX = TAB_EVENT_ID_TXT_PFX;
const TAB_CHART_ID_TXT_PFX = 'main-content-vis-';
exports.TAB_CHART_ID_TXT_PFX = TAB_CHART_ID_TXT_PFX;
const TAB_EVENT_ID = 'main-content-events';
exports.TAB_EVENT_ID = TAB_EVENT_ID;
const TAB_CHART_ID = 'main-content-vis';
exports.TAB_CHART_ID = TAB_CHART_ID;
const HAS_SAVED_TIMESTAMP = 'hasSavedTimestamp';
exports.HAS_SAVED_TIMESTAMP = HAS_SAVED_TIMESTAMP;
const FILTER_OPTIONS = ['Visualization', 'Query', 'Metric'];
exports.FILTER_OPTIONS = FILTER_OPTIONS;
const SAVED_QUERY = 'savedQuery';
exports.SAVED_QUERY = SAVED_QUERY;
const SAVED_VISUALIZATION = 'savedVisualization';
exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const SAVED_OBJECT_ID = 'savedObjectId';
exports.SAVED_OBJECT_ID = SAVED_OBJECT_ID;
const SAVED_OBJECT_TYPE = 'objectType';
exports.SAVED_OBJECT_TYPE = SAVED_OBJECT_TYPE;
const TAB_CREATED_TYPE = 'tabCreatedType';
exports.TAB_CREATED_TYPE = TAB_CREATED_TYPE;
const NEW_TAB = 'newTab';
exports.NEW_TAB = NEW_TAB;
const REDIRECT_TAB = 'redirect_tab';
exports.REDIRECT_TAB = REDIRECT_TAB;
const PAGE_SIZE = 50;
exports.PAGE_SIZE = PAGE_SIZE;
const DEFAULT_COLUMNS = ['', 'Time', '_source'];
exports.DEFAULT_COLUMNS = DEFAULT_COLUMNS;
const OTEL_TRACE_ID = 'traceId';
exports.OTEL_TRACE_ID = OTEL_TRACE_ID;
const JAEGER_TRACE_ID = 'traceID';
exports.JAEGER_TRACE_ID = JAEGER_TRACE_ID;
const DATE_PICKER_FORMAT = 'YYYY-MM-DD HH:mm:ss';
exports.DATE_PICKER_FORMAT = DATE_PICKER_FORMAT;
const TIME_INTERVAL_OPTIONS = [{
  text: 'Minute',
  value: 'm'
}, {
  text: 'Hour',
  value: 'h'
}, {
  text: 'Day',
  value: 'd'
}, {
  text: 'Week',
  value: 'w'
}, {
  text: 'Month',
  value: 'M'
}, {
  text: 'Year',
  value: 'y'
}]; // redux

exports.TIME_INTERVAL_OPTIONS = TIME_INTERVAL_OPTIONS;
const SELECTED_QUERY_TAB = 'selectedQueryTab';
exports.SELECTED_QUERY_TAB = SELECTED_QUERY_TAB;
const QUERY_TAB_IDS = 'queryTabIds';
exports.QUERY_TAB_IDS = QUERY_TAB_IDS;
const NEW_SELECTED_QUERY_TAB = 'newSelectedQueryTab';
exports.NEW_SELECTED_QUERY_TAB = NEW_SELECTED_QUERY_TAB;
const REDUX_EXPL_SLICE_QUERIES = 'queries';
exports.REDUX_EXPL_SLICE_QUERIES = REDUX_EXPL_SLICE_QUERIES;
const REDUX_EXPL_SLICE_QUERY_RESULT = 'queryResults';
exports.REDUX_EXPL_SLICE_QUERY_RESULT = REDUX_EXPL_SLICE_QUERY_RESULT;
const REDUX_EXPL_SLICE_FIELDS = 'fields';
exports.REDUX_EXPL_SLICE_FIELDS = REDUX_EXPL_SLICE_FIELDS;
const REDUX_EXPL_SLICE_QUERY_TABS = 'queryTabs';
exports.REDUX_EXPL_SLICE_QUERY_TABS = REDUX_EXPL_SLICE_QUERY_TABS;
const REDUX_EXPL_SLICE_VISUALIZATION = 'explorerVisualization';
exports.REDUX_EXPL_SLICE_VISUALIZATION = REDUX_EXPL_SLICE_VISUALIZATION;
const REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = 'countDistributionVisualization';
exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = REDUX_EXPL_SLICE_COUNT_DISTRIBUTION;
const REDUX_EXPL_SLICE_PATTERNS = 'patterns';
exports.REDUX_EXPL_SLICE_PATTERNS = REDUX_EXPL_SLICE_PATTERNS;
const PLOTLY_GAUGE_COLUMN_NUMBER = 4;
exports.PLOTLY_GAUGE_COLUMN_NUMBER = PLOTLY_GAUGE_COLUMN_NUMBER;
const APP_ANALYTICS_TAB_ID_REGEX = /application-analytics-tab.+/;
exports.APP_ANALYTICS_TAB_ID_REGEX = APP_ANALYTICS_TAB_ID_REGEX;
const DEFAULT_AVAILABILITY_QUERY = 'stats count() by span( timestamp, 1h )';
exports.DEFAULT_AVAILABILITY_QUERY = DEFAULT_AVAILABILITY_QUERY;
const PPL_DEFAULT_PATTERN_REGEX_FILETER = '[a-zA-Z\\d]'; // Greedily matches the longest substring for example (patterns referer | patterns pattern='[0-9]' message | where ...) used to modify the query for patterns table

exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = PPL_DEFAULT_PATTERN_REGEX_FILETER;
const PATTERNS_REGEX = /\|\s*patterns.+?\|.*\s*where\s+patterns_field\s*\=\s*'[^a-zA-Z0-9]+'/; // Used to extract the initial pattern applied

exports.PATTERNS_REGEX = PATTERNS_REGEX;
const PATTERNS_EXTRACTOR_REGEX = /patterns\s+(?<pattern>\S+)/;
exports.PATTERNS_EXTRACTOR_REGEX = PATTERNS_EXTRACTOR_REGEX;
const ADD_BUTTON_TEXT = '+ Add color theme';
exports.ADD_BUTTON_TEXT = ADD_BUTTON_TEXT;
const NUMBER_INPUT_MIN_LIMIT = 1;
exports.NUMBER_INPUT_MIN_LIMIT = NUMBER_INPUT_MIN_LIMIT;
const VIZ_CONTAIN_XY_AXIS = [_shared.VIS_CHART_TYPES.Bar, _shared.VIS_CHART_TYPES.Histogram, _shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Pie, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar]; // default ppl aggregation method options

exports.VIZ_CONTAIN_XY_AXIS = VIZ_CONTAIN_XY_AXIS;
const AGGREGATION_OPTIONS = [{
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}, {
  label: 'var_samp'
}, {
  label: 'var_pop'
}, {
  label: 'stddev_samp'
}, {
  label: 'stddev_pop'
}]; // numeric fields type for metrics

exports.AGGREGATION_OPTIONS = AGGREGATION_OPTIONS;
const NUMERICAL_TYPES = ['float', 'double', 'bigint', 'long', 'octet', 'short', 'byte', 'integer']; // Data table constants

exports.NUMERICAL_TYPES = NUMERICAL_TYPES;
const GRID_HEADER_COLUMN_MAX_WIDTH = '150px';
exports.GRID_HEADER_COLUMN_MAX_WIDTH = GRID_HEADER_COLUMN_MAX_WIDTH;
const GRID_PAGE_RANGE_DISPLAY = 5;
exports.GRID_PAGE_RANGE_DISPLAY = GRID_PAGE_RANGE_DISPLAY;
const COLUMN_DEFAULT_MIN_WIDTH = 100;
exports.COLUMN_DEFAULT_MIN_WIDTH = COLUMN_DEFAULT_MIN_WIDTH;
const GRID_PAGE_SIZES = [10, 50, 100];
exports.GRID_PAGE_SIZES = GRID_PAGE_SIZES;
const ROW_DENSITIES = [{
  icon: 'tableDensityExpanded',
  height: 55,
  selected: false
}, {
  icon: 'tableDensityNormal',
  height: 45,
  selected: false
}, {
  icon: 'tableDensityCompact',
  height: 35,
  selected: true
}];
exports.ROW_DENSITIES = ROW_DENSITIES;
const HEADER_HEIGHT = 35; // gauge chart default parameters

exports.HEADER_HEIGHT = HEADER_HEIGHT;
const DEFAULT_GAUGE_CHART_PARAMETERS = {
  GaugeTitleSize: 14,
  DisplayDefaultGauges: 1,
  OrientationDefault: 'h',
  TickLength: 5,
  LegendPlacement: 'center',
  ThresholdsMaxLimit: 1
}; // pie chart default parameters

exports.DEFAULT_GAUGE_CHART_PARAMETERS = DEFAULT_GAUGE_CHART_PARAMETERS;
const PLOTLY_PIE_COLUMN_NUMBER = 2;
exports.PLOTLY_PIE_COLUMN_NUMBER = PLOTLY_PIE_COLUMN_NUMBER;
const PIE_XAXIS_GAP = 0.2;
exports.PIE_XAXIS_GAP = PIE_XAXIS_GAP;
const PIE_YAXIS_GAP = 0.1;
exports.PIE_YAXIS_GAP = PIE_YAXIS_GAP;
const DEFAULT_PIE_CHART_PARAMETERS = {
  DefaultMode: 'pie'
};
exports.DEFAULT_PIE_CHART_PARAMETERS = DEFAULT_PIE_CHART_PARAMETERS;
const GROUPBY = 'dimensions';
exports.GROUPBY = GROUPBY;
const AGGREGATIONS = 'series';
exports.AGGREGATIONS = AGGREGATIONS;
const PARENTFIELDS = 'parentFields';
exports.PARENTFIELDS = PARENTFIELDS;
const VALUEFIELD = 'valueField';
exports.VALUEFIELD = VALUEFIELD;
const CHILDFIELD = 'childField';
exports.CHILDFIELD = CHILDFIELD;
const TIMESTAMP = 'timestamp'; // metrics constants

exports.TIMESTAMP = TIMESTAMP;
const METRICS_GRID_SPACE_BETWEEN_X_AXIS = 0.01;
exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = METRICS_GRID_SPACE_BETWEEN_X_AXIS;
const METRICS_GRID_SPACE_BETWEEN_Y_AXIS = 100;
exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = METRICS_GRID_SPACE_BETWEEN_Y_AXIS;
const METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = 0.08;
exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = METRICS_REDUCE_VALUE_SIZE_PERCENTAGE;
const METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = 0.05;
exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = METRICS_REDUCE_TITLE_SIZE_PERCENTAGE;
const METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = 0.2;
exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE;
const METRICS_SERIES_UNIT_SUBSTRING_LENGTH = 3;
exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = METRICS_SERIES_UNIT_SUBSTRING_LENGTH;
const METRICS_AXIS_MARGIN = {
  l: 0,
  r: 0,
  b: 0,
  t: 80
};
exports.METRICS_AXIS_MARGIN = METRICS_AXIS_MARGIN;
const METRICS_ANNOTATION = {
  xref: 'paper',
  yref: 'paper',
  showarrow: false
};
exports.METRICS_ANNOTATION = METRICS_ANNOTATION;
const DEFAULT_METRICS_CHART_PARAMETERS = {
  DefaultTextMode: 'auto',
  DefaultOrientation: 'auto',
  DefaultTitleSize: 30,
  DefaultValueSize: 80,
  DefaultChartType: 'auto',
  TextAlignment: 'auto',
  DefaultPrecision: 1,
  BaseThreshold: {
    thid: (0, _eui.htmlIdGenerator)('thr')(),
    name: 'Base',
    color: '#3CA1C7',
    value: 0,
    isReadOnly: true
  },
  DefaultTextColor: '#FFFFFF'
};
exports.DEFAULT_METRICS_CHART_PARAMETERS = DEFAULT_METRICS_CHART_PARAMETERS;
const DEFAULT_BAR_CHART_STYLES = {
  BarMode: 'group',
  GroupWidth: 0.7,
  BarWidth: 0.97,
  LabelSize: 12
};
exports.DEFAULT_BAR_CHART_STYLES = DEFAULT_BAR_CHART_STYLES;
const SIMILAR_VIZ_TYPES = [_shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar, _shared.VIS_CHART_TYPES.Bar];
exports.SIMILAR_VIZ_TYPES = SIMILAR_VIZ_TYPES;
let ConfigChartOptionsEnum;
exports.ConfigChartOptionsEnum = ConfigChartOptionsEnum;

(function (ConfigChartOptionsEnum) {
  ConfigChartOptionsEnum["palettePicker"] = "palettePicker";
  ConfigChartOptionsEnum["singleColorPicker"] = "singleColorPicker";
  ConfigChartOptionsEnum["colorpicker"] = "colorpicker";
  ConfigChartOptionsEnum["treemapColorPicker"] = "treemapColorPicker";
  ConfigChartOptionsEnum["input"] = "input";
  ConfigChartOptionsEnum["textInput"] = "textInput";
  ConfigChartOptionsEnum["slider"] = "slider";
  ConfigChartOptionsEnum["switchButton"] = "switchButton";
  ConfigChartOptionsEnum["buttons"] = "buttons";
})(ConfigChartOptionsEnum || (exports.ConfigChartOptionsEnum = ConfigChartOptionsEnum = {}));

const CUSTOM_LABEL = 'customLabel';
exports.CUSTOM_LABEL = CUSTOM_LABEL;
const BREAKDOWNS = 'breakdowns';
exports.BREAKDOWNS = BREAKDOWNS;
const SPAN = 'span';
exports.SPAN = SPAN;
const TIME_FIELD = 'time_field';
exports.TIME_FIELD = TIME_FIELD;
const DISABLED_COLOUR = '#fafbfd';
exports.DISABLED_COLOUR = DISABLED_COLOUR;
const DATA_CONFIG_HINTS_INFO = {
  [AGGREGATIONS]: 'Series is an aggregation function (mandatory). The argument of an aggregation must be a field.',
  [GROUPBY]: "Dimensions are 'by' clauses. They are fields or expressions like scalar and aggregation functions. Besides, the span clause for a dimension can be used to split a specific field into buckets in the same interval, the stats then does the aggregation by these span buckets.",
  [BREAKDOWNS]: "Defines how each series is broken down. Breakdowns are 'by' clauses that subdivide the existing series."
}; // Metrics constants

exports.DATA_CONFIG_HINTS_INFO = DATA_CONFIG_HINTS_INFO;
const UNITS_OF_MEASURE = ['seconds (s)', 'hours (h)', 'celsius (C)', 'farenheit (F)', 'meters (m)', 'kilometers (k)'];
exports.UNITS_OF_MEASURE = UNITS_OF_MEASURE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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