/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.RedirectStrategy;
import com.azure.core.implementation.http.HttpHeadersHelper;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class DefaultRedirectStrategy
implements RedirectStrategy {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultRedirectStrategy.class);
    private static final int DEFAULT_MAX_REDIRECT_ATTEMPTS = 3;
    private static final String DEFAULT_REDIRECT_LOCATION_HEADER_NAME = "Location";
    private static final String DEFAULT_REDIRECT_LOCATION_HEADER_NAME_LOWER_CASE = "location";
    private static final int PERMANENT_REDIRECT_STATUS_CODE = 308;
    private static final int TEMPORARY_REDIRECT_STATUS_CODE = 307;
    private static final Set<HttpMethod> DEFAULT_REDIRECT_ALLOWED_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.HEAD));
    private static final String REDIRECT_URLS_KEY = "redirectUrls";
    private final int maxAttempts;
    private final String locationHeader;
    private final String locationHeaderLowerCase;
    private final Set<HttpMethod> allowedRedirectHttpMethods;

    public DefaultRedirectStrategy() {
        this(3, DEFAULT_REDIRECT_LOCATION_HEADER_NAME, DEFAULT_REDIRECT_ALLOWED_METHODS);
    }

    public DefaultRedirectStrategy(int maxAttempts) {
        this(maxAttempts, DEFAULT_REDIRECT_LOCATION_HEADER_NAME, DEFAULT_REDIRECT_ALLOWED_METHODS);
    }

    public DefaultRedirectStrategy(int maxAttempts, String locationHeader, Set<HttpMethod> allowedMethods) {
        if (maxAttempts < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max attempts cannot be less than 0."));
        }
        this.maxAttempts = maxAttempts;
        if (CoreUtils.isNullOrEmpty(locationHeader)) {
            LOGGER.error("'locationHeader' provided as null will be defaulted to {}", DEFAULT_REDIRECT_LOCATION_HEADER_NAME);
            this.locationHeader = DEFAULT_REDIRECT_LOCATION_HEADER_NAME;
            this.locationHeaderLowerCase = DEFAULT_REDIRECT_LOCATION_HEADER_NAME_LOWER_CASE;
        } else {
            this.locationHeader = locationHeader;
            this.locationHeaderLowerCase = locationHeader.toLowerCase(Locale.ROOT);
        }
        if (CoreUtils.isNullOrEmpty(allowedMethods)) {
            LOGGER.error("'allowedMethods' provided as null will be defaulted to {}", DEFAULT_REDIRECT_ALLOWED_METHODS);
            this.allowedRedirectHttpMethods = DEFAULT_REDIRECT_ALLOWED_METHODS;
        } else {
            this.allowedRedirectHttpMethods = allowedMethods;
        }
    }

    @Override
    public boolean shouldAttemptRedirect(HttpPipelineCallContext context, HttpResponse httpResponse, int tryCount, Set<String> attemptedRedirectUrls) {
        if (this.isValidRedirectStatusCode(httpResponse.getStatusCode()) && this.isValidRedirectCount(tryCount) && this.isAllowedRedirectMethod(httpResponse.getRequest().getHttpMethod())) {
            String redirectUrl = DefaultRedirectStrategy.tryGetRedirectHeader(httpResponse.getHeaders(), this.locationHeader, this.locationHeaderLowerCase);
            if (redirectUrl != null && !this.alreadyAttemptedRedirectUrl(redirectUrl, attemptedRedirectUrls)) {
                LOGGER.atVerbose().addKeyValue("tryCount", tryCount).addKeyValue(REDIRECT_URLS_KEY, attemptedRedirectUrls::toString).log("Redirecting.");
                attemptedRedirectUrls.add(redirectUrl);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public HttpRequest createRedirectRequest(HttpResponse httpResponse) {
        String responseLocation = DefaultRedirectStrategy.tryGetRedirectHeader(httpResponse.getHeaders(), this.locationHeader, this.locationHeaderLowerCase);
        return httpResponse.getRequest().setUrl(responseLocation);
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    String getLocationHeader() {
        return this.locationHeader;
    }

    Set<HttpMethod> getAllowedRedirectHttpMethods() {
        return this.allowedRedirectHttpMethods;
    }

    private boolean alreadyAttemptedRedirectUrl(String redirectUrl, Set<String> attemptedRedirectUrls) {
        if (attemptedRedirectUrls.contains(redirectUrl)) {
            LOGGER.atError().addKeyValue("redirectUrl", redirectUrl).log("Request was redirected more than once to the same URL.");
            return true;
        }
        return false;
    }

    private boolean isValidRedirectCount(int tryCount) {
        if (tryCount >= this.getMaxAttempts()) {
            LOGGER.atError().addKeyValue("maxAttempts", this.getMaxAttempts()).log("Redirect attempts have been exhausted.");
            return false;
        }
        return true;
    }

    private boolean isAllowedRedirectMethod(HttpMethod httpMethod) {
        if (this.getAllowedRedirectHttpMethods().contains((Object)httpMethod)) {
            return true;
        }
        LOGGER.atError().addKeyValue("method", (Object)httpMethod).log("Request was redirected from an invalid redirect allowed method.");
        return false;
    }

    private boolean isValidRedirectStatusCode(int statusCode) {
        return statusCode == 302 || statusCode == 301 || statusCode == 308 || statusCode == 307;
    }

    static String tryGetRedirectHeader(HttpHeaders headers, String headerName, String headerNameLowerCase) {
        String headerValue = HttpHeadersHelper.getValueNoKeyFormatting(headers, headerNameLowerCase);
        if (CoreUtils.isNullOrEmpty(headerValue)) {
            LOGGER.atError().addKeyValue("headerName", headerName).log("Redirect url header was null, request redirect was terminated.");
            return null;
        }
        return headerValue;
    }
}

