/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.StopPooledThreadException;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThread;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    protected static final StringManager sm = StringManager.getManager(ThreadPoolExecutor.class);
    private final AtomicInteger ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(-536870912, 0));
    private static final int COUNT_BITS = 29;
    private static final int COUNT_MASK = 0x1FFFFFFF;
    private static final int RUNNING = -536870912;
    private static final int SHUTDOWN = 0;
    private static final int STOP = 0x20000000;
    private static final int TIDYING = 0x40000000;
    private static final int TERMINATED = 0x60000000;
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet<Worker> workers = new HashSet();
    private final Condition termination = this.mainLock.newCondition();
    private int largestPoolSize;
    private long completedTaskCount;
    private final AtomicInteger submittedCount = new AtomicInteger(0);
    private final AtomicLong lastContextStoppedTime = new AtomicLong(0L);
    private final AtomicLong lastTimeThreadKilledItself = new AtomicLong(0L);
    private volatile long threadRenewalDelay = 1000L;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RejectedExecutionHandler defaultHandler = new RejectPolicy();
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private static final boolean ONLY_ONE = true;

    private static int workerCountOf(int n) {
        return n & 0x1FFFFFFF;
    }

    private static int ctlOf(int n, int n2) {
        return n | n2;
    }

    private static boolean runStateLessThan(int n, int n2) {
        return n < n2;
    }

    private static boolean runStateAtLeast(int n, int n2) {
        return n >= n2;
    }

    private static boolean isRunning(int n) {
        return n < 0;
    }

    private boolean compareAndIncrementWorkerCount(int n) {
        return this.ctl.compareAndSet(n, n + 1);
    }

    private boolean compareAndDecrementWorkerCount(int n) {
        return this.ctl.compareAndSet(n, n - 1);
    }

    private void decrementWorkerCount() {
        this.ctl.addAndGet(-1);
    }

    private void advanceRunState(int n) {
        int n2;
        while (!ThreadPoolExecutor.runStateAtLeast(n2 = this.ctl.get(), n) && !this.ctl.compareAndSet(n2, ThreadPoolExecutor.ctlOf(n, ThreadPoolExecutor.workerCountOf(n2)))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate() {
        int n;
        while (!(ThreadPoolExecutor.isRunning(n = this.ctl.get()) || ThreadPoolExecutor.runStateAtLeast(n, 0x40000000) || ThreadPoolExecutor.runStateLessThan(n, 0x20000000) && !this.workQueue.isEmpty())) {
            if (ThreadPoolExecutor.workerCountOf(n) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock reentrantLock = this.mainLock;
            reentrantLock.lock();
            try {
                if (!this.ctl.compareAndSet(n, ThreadPoolExecutor.ctlOf(0x40000000, 0))) continue;
                try {
                    this.terminated();
                }
                finally {
                    this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                    this.termination.signalAll();
                }
                return;
            }
            finally {
                reentrantLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    private void checkShutdownAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(shutdownPerm);
            for (Worker worker : this.workers) {
                securityManager.checkAccess(worker.thread);
            }
        }
    }

    private void interruptWorkers() {
        for (Worker worker : this.workers) {
            worker.interruptIfStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptIdleWorkers(boolean bl) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            for (Worker worker : this.workers) {
                Thread thread = worker.thread;
                if (!thread.isInterrupted() && worker.tryLock()) {
                    try {
                        thread.interrupt();
                    }
                    catch (SecurityException securityException) {
                    }
                    finally {
                        worker.unlock();
                    }
                }
                if (!bl) continue;
                break;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    final void reject(Runnable runnable) {
        this.handler.rejectedExecution(runnable, this);
    }

    void onShutdown() {
    }

    private List<Runnable> drainQueue() {
        BlockingQueue<Runnable> blockingQueue = this.workQueue;
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        blockingQueue.drainTo(arrayList);
        if (!blockingQueue.isEmpty()) {
            for (Runnable runnable : blockingQueue.toArray(new Runnable[0])) {
                if (!blockingQueue.remove(runnable)) continue;
                arrayList.add(runnable);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable runnable, boolean bl) {
        boolean bl2;
        block15: {
            int bl22 = this.ctl.get();
            block6: while (true) {
                int n;
                if (ThreadPoolExecutor.runStateAtLeast(n, 0) && (ThreadPoolExecutor.runStateAtLeast(n, 0x20000000) || runnable != null || this.workQueue.isEmpty())) {
                    return false;
                }
                do {
                    if (ThreadPoolExecutor.workerCountOf(n) >= ((bl ? this.corePoolSize : this.maximumPoolSize) & 0x1FFFFFFF)) {
                        return false;
                    }
                    if (this.compareAndIncrementWorkerCount(n)) break block6;
                } while (!ThreadPoolExecutor.runStateAtLeast(n = this.ctl.get(), 0));
            }
            boolean bl3 = false;
            boolean bl4 = false;
            Worker worker = null;
            try {
                worker = new Worker(runnable);
                Thread thread = worker.thread;
                if (thread == null) break block15;
                ReentrantLock reentrantLock = this.mainLock;
                reentrantLock.lock();
                try {
                    int n = this.ctl.get();
                    if (ThreadPoolExecutor.isRunning(n) || ThreadPoolExecutor.runStateLessThan(n, 0x20000000) && runnable == null) {
                        if (thread.getState() != Thread.State.NEW) {
                            throw new IllegalThreadStateException();
                        }
                        this.workers.add(worker);
                        bl4 = true;
                        int n2 = this.workers.size();
                        if (n2 > this.largestPoolSize) {
                            this.largestPoolSize = n2;
                        }
                    }
                }
                finally {
                    reentrantLock.unlock();
                }
                if (bl4) {
                    thread.start();
                    bl2 = true;
                }
            }
            finally {
                if (!bl2) {
                    this.addWorkerFailed(worker);
                }
            }
        }
        return bl2;
    }

    private void addWorkerFailed(Worker worker) {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (worker != null) {
                this.workers.remove(worker);
            }
            this.decrementWorkerCount();
            this.tryTerminate();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker worker, boolean bl) {
        if (bl) {
            this.decrementWorkerCount();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.completedTaskCount += worker.completedTasks;
            this.workers.remove(worker);
        }
        finally {
            reentrantLock.unlock();
        }
        this.tryTerminate();
        int n = this.ctl.get();
        if (ThreadPoolExecutor.runStateLessThan(n, 0x20000000)) {
            if (!bl) {
                int n2;
                int n3 = n2 = this.allowCoreThreadTimeOut ? 0 : this.corePoolSize;
                if (n2 == 0 && !this.workQueue.isEmpty()) {
                    n2 = 1;
                }
                if (ThreadPoolExecutor.workerCountOf(n) >= n2 && this.workQueue.isEmpty()) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private Runnable getTask() {
        boolean bl = false;
        while (true) {
            boolean bl2;
            int n;
            if (ThreadPoolExecutor.runStateAtLeast(n = this.ctl.get(), 0) && (ThreadPoolExecutor.runStateAtLeast(n, 0x20000000) || this.workQueue.isEmpty())) {
                this.decrementWorkerCount();
                return null;
            }
            int n2 = ThreadPoolExecutor.workerCountOf(n);
            boolean bl3 = bl2 = this.allowCoreThreadTimeOut || n2 > this.corePoolSize;
            if ((n2 > this.maximumPoolSize || bl2 && bl) && (n2 > 1 || this.workQueue.isEmpty())) {
                if (!this.compareAndDecrementWorkerCount(n)) continue;
                return null;
            }
            try {
                Runnable runnable;
                Runnable runnable2 = runnable = bl2 ? this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : this.workQueue.take();
                if (runnable != null) {
                    return runnable;
                }
                bl = true;
                continue;
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWorker(Worker worker) {
        Thread thread = Thread.currentThread();
        Runnable runnable = worker.firstTask;
        worker.firstTask = null;
        worker.unlock();
        boolean bl = true;
        try {
            while (runnable != null || (runnable = this.getTask()) != null) {
                worker.lock();
                if ((ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000) || Thread.interrupted() && ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000)) && !thread.isInterrupted()) {
                    thread.interrupt();
                }
                try {
                    this.beforeExecute(thread, runnable);
                    try {
                        runnable.run();
                        this.afterExecute(runnable, null);
                    }
                    catch (Throwable throwable) {
                        this.afterExecute(runnable, throwable);
                        throw throwable;
                    }
                }
                finally {
                    runnable = null;
                    ++worker.completedTasks;
                    worker.unlock();
                }
            }
            bl = false;
        }
        finally {
            this.processWorkerExit(worker, bl);
        }
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (n < 0 || n2 <= 0 || n2 < n || l < 0L) {
            throw new IllegalArgumentException();
        }
        if (blockingQueue == null || threadFactory == null || rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = n;
        this.maximumPoolSize = n2;
        this.workQueue = blockingQueue;
        this.keepAliveTime = timeUnit.toNanos(l);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
        this.prestartAllCoreThreads();
    }

    @Override
    public void execute(Runnable runnable) {
        this.submittedCount.incrementAndGet();
        try {
            this.executeInternal(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            if (this.getQueue() instanceof TaskQueue) {
                TaskQueue taskQueue = (TaskQueue)this.getQueue();
                if (!taskQueue.force(runnable)) {
                    this.submittedCount.decrementAndGet();
                    throw new RejectedExecutionException(sm.getString("threadPoolExecutor.queueFull"));
                }
            }
            this.submittedCount.decrementAndGet();
            throw rejectedExecutionException;
        }
    }

    private void executeInternal(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        int n = this.ctl.get();
        if (ThreadPoolExecutor.workerCountOf(n) < this.corePoolSize) {
            if (this.addWorker(runnable, true)) {
                return;
            }
            n = this.ctl.get();
        }
        if (ThreadPoolExecutor.isRunning(n) && this.workQueue.offer(runnable)) {
            int n2 = this.ctl.get();
            if (!ThreadPoolExecutor.isRunning(n2) && this.remove(runnable)) {
                this.reject(runnable);
            } else if (ThreadPoolExecutor.workerCountOf(n2) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(runnable, false)) {
            this.reject(runnable);
        }
    }

    @Override
    public void shutdown() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptIdleWorkers();
            this.onShutdown();
        }
        finally {
            reentrantLock.unlock();
        }
        this.tryTerminate();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> list;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0x20000000);
            this.interruptWorkers();
            list = this.drainQueue();
        }
        finally {
            reentrantLock.unlock();
        }
        this.tryTerminate();
        return list;
    }

    @Override
    public boolean isShutdown() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0);
    }

    boolean isStopped() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000);
    }

    public boolean isTerminating() {
        int n = this.ctl.get();
        return ThreadPoolExecutor.runStateAtLeast(n, 0) && ThreadPoolExecutor.runStateLessThan(n, 0x60000000);
    }

    @Override
    public boolean isTerminated() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            while (ThreadPoolExecutor.runStateLessThan(this.ctl.get(), 0x60000000)) {
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.termination.awaitNanos(l2);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.handler = rejectedExecutionHandler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public void setCorePoolSize(int n) {
        block3: {
            int n2;
            block2: {
                if (n < 0 || this.maximumPoolSize < n) {
                    throw new IllegalArgumentException();
                }
                n2 = n - this.corePoolSize;
                this.corePoolSize = n;
                if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) <= n) break block2;
                this.interruptIdleWorkers();
                break block3;
            }
            if (n2 <= 0) break block3;
            int n3 = Math.min(n2, this.workQueue.size());
            while (n3-- > 0 && this.addWorker(null, true) && !this.workQueue.isEmpty()) {
            }
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return ThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true);
    }

    void ensurePrestart() {
        int n = ThreadPoolExecutor.workerCountOf(this.ctl.get());
        if (n < this.corePoolSize) {
            this.addWorker(null, true);
        } else if (n == 0) {
            this.addWorker(null, false);
        }
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(null, true)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean bl) {
        if (bl && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        if (bl != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = bl;
            if (bl) {
                this.interruptIdleWorkers();
            }
        }
    }

    public void setMaximumPoolSize(int n) {
        if (n <= 0 || n < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = n;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > n) {
            this.interruptIdleWorkers();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = l2 - this.keepAliveTime;
        this.keepAliveTime = l2;
        if (l3 < 0L) {
            this.interruptIdleWorkers();
        }
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public long getThreadRenewalDelay() {
        return this.threadRenewalDelay;
    }

    public void setThreadRenewalDelay(long l) {
        this.threadRenewalDelay = l;
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable runnable) {
        boolean bl = this.workQueue.remove(runnable);
        this.tryTerminate();
        return bl;
    }

    public void purge() {
        BlockingQueue<Runnable> blockingQueue = this.workQueue;
        try {
            Iterator iterator = blockingQueue.iterator();
            while (iterator.hasNext()) {
                Runnable runnable = (Runnable)iterator.next();
                if (!(runnable instanceof Future) || !((Future)((Object)runnable)).isCancelled()) continue;
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            for (Object object : blockingQueue.toArray()) {
                if (!(object instanceof Future) || !((Future)object).isCancelled()) continue;
                blockingQueue.remove(object);
            }
        }
        this.tryTerminate();
    }

    public void contextStopping() {
        this.lastContextStoppedTime.set(System.currentTimeMillis());
        int n = this.getCorePoolSize();
        this.setCorePoolSize(0);
        this.setCorePoolSize(n);
    }

    public int getPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x40000000) ? 0 : this.workers.size();
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    protected int getPoolSizeNoLock() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x40000000) ? 0 : this.workers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = 0;
            for (Worker worker : this.workers) {
                if (!worker.isLocked()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public int getLargestPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
                if (!worker.isLocked()) continue;
                ++l;
            }
            long l2 = l + (long)this.workQueue.size();
            return l2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
            }
            long l2 = l;
            return l2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public int getSubmittedCount() {
        return this.submittedCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        int n2;
        long l;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            l = this.completedTaskCount;
            n2 = 0;
            n = this.workers.size();
            for (Worker object2 : this.workers) {
                l += object2.completedTasks;
                if (!object2.isLocked()) continue;
                ++n2;
            }
        }
        finally {
            reentrantLock.unlock();
        }
        int n3 = this.ctl.get();
        String string = ThreadPoolExecutor.isRunning(n3) ? "Running" : (ThreadPoolExecutor.runStateAtLeast(n3, 0x60000000) ? "Terminated" : "Shutting down");
        return super.toString() + "[" + string + ", pool size = " + n + ", active threads = " + n2 + ", queued tasks = " + this.workQueue.size() + ", completed tasks = " + l + "]";
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
        if (!(throwable instanceof StopPooledThreadException)) {
            this.submittedCount.decrementAndGet();
        }
        if (throwable == null) {
            this.stopCurrentThreadIfNeeded();
        }
    }

    protected void stopCurrentThreadIfNeeded() {
        long l;
        if (this.currentThreadShouldBeStopped() && (l = this.lastTimeThreadKilledItself.longValue()) + this.threadRenewalDelay < System.currentTimeMillis() && this.lastTimeThreadKilledItself.compareAndSet(l, System.currentTimeMillis() + 1L)) {
            String string = sm.getString("threadPoolExecutor.threadStoppedToAvoidPotentialLeak", Thread.currentThread().getName());
            throw new StopPooledThreadException(string);
        }
    }

    protected boolean currentThreadShouldBeStopped() {
        TaskThread taskThread;
        Thread thread = Thread.currentThread();
        return this.threadRenewalDelay >= 0L && thread instanceof TaskThread && (taskThread = (TaskThread)thread).getCreationTime() < this.lastContextStoppedTime.longValue();
    }

    protected void terminated() {
    }

    public static interface RejectedExecutionHandler {
        public void rejectedExecution(Runnable var1, ThreadPoolExecutor var2);
    }

    private static class RejectPolicy
    implements RejectedExecutionHandler {
        private RejectPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            throw new RejectedExecutionException();
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                threadPoolExecutor.getQueue().poll();
                threadPoolExecutor.execute(runnable);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            throw new RejectedExecutionException("Task " + runnable.toString() + " rejected from " + threadPoolExecutor.toString());
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                runnable.run();
            }
        }
    }

    private final class Worker
    extends AbstractQueuedSynchronizer
    implements Runnable {
        private static final long serialVersionUID = 6138294804551838833L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable runnable) {
            this.setState(-1);
            this.firstTask = runnable;
            this.thread = ThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }

        @Override
        public void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() != 0;
        }

        @Override
        protected boolean tryAcquire(int n) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int n) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        public void lock() {
            this.acquire(1);
        }

        public boolean tryLock() {
            return this.tryAcquire(1);
        }

        public void unlock() {
            this.release(1);
        }

        public boolean isLocked() {
            return this.isHeldExclusively();
        }

        void interruptIfStarted() {
            Thread thread;
            if (this.getState() >= 0 && (thread = this.thread) != null && !thread.isInterrupted()) {
                try {
                    thread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }
}

