/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumConstantElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;

class GroovyEnumElement
extends GroovyClassElement
implements EnumElement {
    protected List<EnumConstantElement> enumConstants;
    protected List<String> values;

    GroovyEnumElement(GroovyVisitorContext visitorContext, ClassNode classNode, AnnotationMetadata annotationMetadata) {
        this(visitorContext, classNode, annotationMetadata, 0);
    }

    GroovyEnumElement(GroovyVisitorContext visitorContext, ClassNode classNode, AnnotationMetadata annotationMetadata, int arrayDimensions) {
        super(visitorContext, classNode, annotationMetadata, null, arrayDimensions);
    }

    public List<String> values() {
        if (this.values != null) {
            return this.values;
        }
        this.initEnum();
        return this.values;
    }

    public List<EnumConstantElement> elements() {
        if (this.enumConstants != null) {
            return this.enumConstants;
        }
        this.initEnum();
        return this.enumConstants;
    }

    private void initEnum() {
        this.values = new ArrayList<String>();
        this.enumConstants = new ArrayList<EnumConstantElement>();
        ClassNode nativeType = (ClassNode)this.getNativeType();
        for (FieldNode field : nativeType.getFields()) {
            if (field.getName().equals("MAX_VALUE") || field.getName().equals("MIN_VALUE") || !field.isEnum()) continue;
            this.values.add(field.getName());
            this.enumConstants.add(new GroovyEnumConstantElement(this, this.visitorContext, field, (AnnotatedNode)field, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)field)));
        }
        this.values = Collections.unmodifiableList(this.values);
        this.enumConstants = Collections.unmodifiableList(this.enumConstants);
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new GroovyEnumElement(this.visitorContext, this.classNode, this.getAnnotationMetadata(), arrayDimensions);
    }
}

