/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputBinaryFile;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.extensions.ClassFileFactoryFinalizerExtension;
import org.jetbrains.kotlin.jvm.abi.AbiClassInfo;
import org.jetbrains.kotlin.jvm.abi.AbiMethodInfo;
import org.jetbrains.kotlin.jvm.abi.JvmAbiMetadataProcessorKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.ClassRemapper;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension;", "Lorg/jetbrains/kotlin/codegen/extensions/ClassFileFactoryFinalizerExtension;", "outputPath", "Ljava/io/File;", "abiClassInfos", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Ljava/io/File;Ljava/util/Map;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "finalizeClassFactory", "", "factory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "AbiOutputFiles", "InnerClassInfo", "jvm-abi-gen"})
public final class JvmAbiOutputExtension
implements ClassFileFactoryFinalizerExtension {
    @NotNull
    private final File outputPath;
    @NotNull
    private final Map<String, AbiClassInfo> abiClassInfos;
    @NotNull
    private final MessageCollector messageCollector;

    public JvmAbiOutputExtension(@NotNull File outputPath, @NotNull Map<String, ? extends AbiClassInfo> abiClassInfos, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter(abiClassInfos, (String)"abiClassInfos");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        this.outputPath = outputPath;
        this.abiClassInfos = abiClassInfos;
        this.messageCollector = messageCollector;
    }

    public void finalizeClassFactory(@NotNull ClassFileFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        AbiOutputFiles outputFiles = new AbiOutputFiles(this.abiClassInfos, (OutputFileCollection)factory);
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)this.outputPath), (Object)"jar")) {
            CompileEnvironmentUtil.writeToJar((File)this.outputPath, (boolean)false, (boolean)true, (boolean)true, null, (OutputFileCollection)outputFiles, (MessageCollector)this.messageCollector);
        } else {
            OutputUtilsKt.writeAllTo((OutputFileCollection)outputFiles, (File)this.outputPath);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J.\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00040\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u00032\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J&\u0010\u0017\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00040\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0003H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$AbiOutputFiles;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "abiClassInfos", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "outputFiles", "(Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;)V", "getAbiClassInfos", "()Ljava/util/Map;", "getOutputFiles", "()Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "asList", "", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "get", "relativePath", "addInnerClasses", "", "", "innerClassInfos", "Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$InnerClassInfo;", "internalName", "addOuterClasses", "jvm-abi-gen"})
    @SourceDebugExtension(value={"SMAP\nJvmAbiOutputExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiOutputExtension.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$AbiOutputFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,196:1\n766#2:197\n857#2,2:198\n1045#2:200\n1603#2,9:201\n1855#2:210\n1856#2:213\n1612#2:214\n1477#2:215\n1502#2,3:216\n1505#2,3:226\n1611#2:229\n1855#2:230\n1856#2:232\n1612#2:233\n1#3:211\n1#3:212\n1#3:231\n361#4,7:219\n*S KotlinDebug\n*F\n+ 1 JvmAbiOutputExtension.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$AbiOutputFiles\n*L\n57#1:197\n57#1:198,2\n59#1:200\n61#1:201,9\n61#1:210\n61#1:213\n61#1:214\n175#1:215\n175#1:216,3\n175#1:226,3\n181#1:229\n181#1:230\n181#1:232\n181#1:233\n61#1:212\n181#1:231\n175#1:219,7\n*E\n"})
    private static final class AbiOutputFiles
    implements OutputFileCollection {
        @NotNull
        private final Map<String, AbiClassInfo> abiClassInfos;
        @NotNull
        private final OutputFileCollection outputFiles;

        public AbiOutputFiles(@NotNull Map<String, ? extends AbiClassInfo> abiClassInfos, @NotNull OutputFileCollection outputFiles) {
            Intrinsics.checkNotNullParameter(abiClassInfos, (String)"abiClassInfos");
            Intrinsics.checkNotNullParameter((Object)outputFiles, (String)"outputFiles");
            this.abiClassInfos = abiClassInfos;
            this.outputFiles = outputFiles;
        }

        @NotNull
        public final Map<String, AbiClassInfo> getAbiClassInfos() {
            return this.abiClassInfos;
        }

        @NotNull
        public final OutputFileCollection getOutputFiles() {
            return this.outputFiles;
        }

        @Nullable
        public OutputFile get(@NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            throw new IllegalStateException("AbiOutputFiles does not implement `get`.".toString());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<OutputFile> asList() {
            void $this$mapNotNullTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.outputFiles.asList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OutputFile it = (OutputFile)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.endsWith$default((String)it.getRelativePath(), (String)".class", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$sortedBy$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List metadata = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    OutputFile it = (OutputFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getRelativePath());
                    it = (OutputFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getRelativePath())));
                }
            });
            Iterable $this$mapNotNull$iv = CollectionsKt.sorted((Iterable)this.abiClassInfos.keySet());
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                OutputFile outputFile;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String internalName = (String)element$iv$iv;
                boolean bl2 = false;
                OutputFile outputFile2 = this.outputFiles.get(internalName + ".class");
                AbiClassInfo abiInfo = (AbiClassInfo)MapsKt.getValue(this.abiClassInfos, (Object)internalName);
                if (outputFile2 == null) {
                    outputFile = null;
                } else if (abiInfo instanceof AbiClassInfo.Public) {
                    outputFile = outputFile2;
                } else {
                    Intrinsics.checkNotNull((Object)abiInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.jvm.abi.AbiClassInfo.Stripped");
                    Map<Method, AbiMethodInfo> methodInfo = ((AbiClassInfo.Stripped)abiInfo).getMethodInfo();
                    Map innerClassInfos = new LinkedHashMap();
                    Set innerClassesToKeep = new LinkedHashSet();
                    ClassWriter writer = new ClassWriter(0);
                    ClassRemapper remapper2 = new ClassRemapper((ClassVisitor)writer, new Remapper(innerClassesToKeep){
                        final /* synthetic */ Set<String> $innerClassesToKeep;
                        {
                            this.$innerClassesToKeep = $innerClassesToKeep;
                        }

                        @NotNull
                        public String map(@NotNull String internalName) {
                            Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
                            String string = internalName;
                            Set<String> set = this.$innerClassesToKeep;
                            String it = string;
                            boolean bl = false;
                            set.add(it);
                            return string;
                        }
                    });
                    new ClassReader(outputFile2.asByteArray()).accept(new ClassVisitor(remapper2, methodInfo, innerClassInfos){
                        final /* synthetic */ Map<Method, AbiMethodInfo> $methodInfo;
                        final /* synthetic */ Map<String, InnerClassInfo> $innerClassInfos;
                        {
                            this.$methodInfo = $methodInfo;
                            this.$innerClassInfos = $innerClassInfos;
                            super(589824, (ClassVisitor)$remapper);
                        }

                        @Nullable
                        public FieldVisitor visitField(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable Object value) {
                            if ((access & 2) != 0) {
                                return null;
                            }
                            return super.visitField(access, name, descriptor, signature, value);
                        }

                        @Nullable
                        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                            AbiMethodInfo abiMethodInfo = this.$methodInfo.get(new Method(name, descriptor));
                            if (abiMethodInfo == null) {
                                return null;
                            }
                            AbiMethodInfo info = abiMethodInfo;
                            MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                            if (info == AbiMethodInfo.KEEP || (access & 0x500) != 0) {
                                return visitor;
                            }
                            return new MethodVisitor(visitor){

                                public void visitCode() {
                                    MethodVisitor $this$visitCode_u24lambda_u240 = this.mv;
                                    boolean bl = false;
                                    $this$visitCode_u24lambda_u240.visitCode();
                                    $this$visitCode_u24lambda_u240.visitInsn(1);
                                    $this$visitCode_u24lambda_u240.visitInsn(191);
                                    $this$visitCode_u24lambda_u240.visitMaxs(0, 0);
                                    $this$visitCode_u24lambda_u240.visitEnd();
                                    this.mv = null;
                                }
                            };
                        }

                        public void visitSource(@Nullable String source, @Nullable String debug) {
                            boolean bl;
                            block5: {
                                Iterable $this$any$iv = this.$methodInfo.values();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        AbiMethodInfo it = (AbiMethodInfo)((Object)element$iv);
                                        boolean bl2 = false;
                                        if (!(it == AbiMethodInfo.KEEP)) continue;
                                        bl = true;
                                        break block5;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                super.visitSource(source, debug);
                            } else {
                                super.visitSource(source, null);
                            }
                        }

                        public void visitInnerClass(@NotNull String name, @Nullable String outerName, @Nullable String innerName, int access) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            this.$innerClassInfos.put(name, new InnerClassInfo(name, outerName, innerName, access));
                        }

                        @NotNull
                        public AnnotationVisitor visitAnnotation(@Nullable String descriptor, boolean visible) {
                            AnnotationVisitor delegate = super.visitAnnotation(descriptor, visible);
                            if (!Intrinsics.areEqual((Object)descriptor, (Object)JvmAnnotationNames.METADATA_DESC)) {
                                Intrinsics.checkNotNullExpressionValue((Object)delegate, (String)"delegate");
                                return delegate;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)delegate, (String)"delegate");
                            return JvmAbiMetadataProcessorKt.abiMetadataProcessor(delegate);
                        }

                        public void visitEnd() {
                        }
                    }, 0);
                    this.addInnerClasses(innerClassesToKeep, innerClassInfos, internalName);
                    this.addOuterClasses(innerClassesToKeep, innerClassInfos);
                    for (String name : CollectionsKt.sorted((Iterable)innerClassesToKeep)) {
                        InnerClassInfo it;
                        if ((InnerClassInfo)innerClassInfos.get(name) == null) continue;
                        boolean bl3 = false;
                        writer.visitInnerClass(it.getName(), it.getOuterName(), it.getInnerName(), it.getAccess());
                    }
                    writer.visitEnd();
                    List list = outputFile2.getSourceFiles();
                    String string = outputFile2.getRelativePath();
                    byte[] byArray = writer.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writer.toByteArray()");
                    outputFile = (OutputFile)new SimpleOutputBinaryFile(list, string, byArray);
                }
                if (outputFile == null) continue;
                OutputFile it$iv$iv = outputFile;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List classFiles2 = (List)destination$iv$iv2;
            return CollectionsKt.plus((Collection)metadata, (Iterable)classFiles2);
        }

        /*
         * WARNING - void declaration
         */
        private final void addInnerClasses(Set<String> $this$addInnerClasses, Map<String, InnerClassInfo> innerClassInfos, String internalName) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = innerClassInfos.values();
            boolean $i$f$groupBy22 = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                InnerClassInfo it = (InnerClassInfo)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getOuterName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map innerClassesByOuterName = destination$iv$iv;
            Object[] $i$f$groupBy22 = new String[]{internalName};
            List stack = CollectionsKt.mutableListOf((Object[])$i$f$groupBy22);
            while (!((Collection)stack).isEmpty()) {
                String next = (String)CollectionsKt.removeLast((List)stack);
                $this$addInnerClasses.add(next);
                List list = (List)innerClassesByOuterName.get(next);
                if (list == null) continue;
                Iterable $this$mapNotNullTo$iv = list;
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    InnerClassInfo it = (InnerClassInfo)element$iv;
                    boolean bl3 = false;
                    String string = it.getName();
                    Map<String, AbiClassInfo> map = this.abiClassInfos;
                    String p0 = string;
                    boolean bl4 = false;
                    if ((map.containsKey(p0) ? string : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl5 = false;
                    ((Collection)stack).add(it$iv);
                }
                List cfr_ignored_0 = (List)((Collection)stack);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void addOuterClasses(Set<String> $this$addOuterClasses, Map<String, InnerClassInfo> innerClassInfos) {
            for (String name : CollectionsKt.toList((Iterable)$this$addOuterClasses)) {
                info = innerClassInfos.get(name);
                while (info != null) {
                    v0 = info.getOuterName();
                    if (v0 == null) ** GOTO lbl-1000
                    p0 = var6_6 = v0;
                    $i$a$-takeIf-JvmAbiOutputExtension$AbiOutputFiles$addOuterClasses$1 = false;
                    v0 = $this$addOuterClasses.add(p0) != false ? var6_6 : null;
                    if (v0 != null) {
                        p0 = v0;
                        $i$a$-let-JvmAbiOutputExtension$AbiOutputFiles$addOuterClasses$2 = false;
                        v1 = innerClassInfos.get(p0);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = null;
                    }
                    info = v1;
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiOutputExtension$InnerClassInfo;", "", "name", "", "outerName", "innerName", "access", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getAccess", "()I", "getInnerName", "()Ljava/lang/String;", "getName", "getOuterName", "jvm-abi-gen"})
    private static final class InnerClassInfo {
        @NotNull
        private final String name;
        @Nullable
        private final String outerName;
        @Nullable
        private final String innerName;
        private final int access;

        public InnerClassInfo(@NotNull String name, @Nullable String outerName, @Nullable String innerName, int access) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.outerName = outerName;
            this.innerName = innerName;
            this.access = access;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getOuterName() {
            return this.outerName;
        }

        @Nullable
        public final String getInnerName() {
            return this.innerName;
        }

        public final int getAccess() {
            return this.access;
        }
    }
}

