/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.repository;

import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.transport.SniffConnectionStrategy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/replication/repository/RemoteClusterRepositoriesService;", "", "repositoriesService", "Ljava/util/function/Supplier;", "Lorg/opensearch/repositories/RepositoriesService;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Ljava/util/function/Supplier;Lorg/opensearch/cluster/service/ClusterService;)V", "listenForUpdates", "", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "updateRepositoryDetails", "alias", "", "seeds", "", "opensearch-cross-cluster-replication"})
public final class RemoteClusterRepositoriesService {
    @NotNull
    private final Supplier<RepositoriesService> repositoriesService;

    public RemoteClusterRepositoriesService(@NotNull Supplier<RepositoriesService> repositoriesService, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter(repositoriesService, (String)"repositoriesService");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.repositoriesService = repositoriesService;
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        Intrinsics.checkNotNullExpressionValue((Object)clusterSettings, (String)"clusterService.clusterSettings");
        this.listenForUpdates(clusterSettings);
    }

    private final void listenForUpdates(ClusterSettings clusterSettings) {
        clusterSettings.addAffixUpdateConsumer(SniffConnectionStrategy.REMOTE_CLUSTER_SEEDS, this::updateRepositoryDetails, RemoteClusterRepositoriesService::listenForUpdates$lambda-0);
    }

    private final void updateRepositoryDetails(String alias, List<String> seeds) {
        if (seeds == null || seeds.isEmpty()) {
            this.repositoriesService.get().unregisterInternalRepository(Intrinsics.stringPlus((String)"replication-remote-repo-", (Object)alias));
            return;
        }
        this.repositoriesService.get().registerInternalRepository(Intrinsics.stringPlus((String)"replication-remote-repo-", (Object)alias), "replication-remote-repository");
    }

    private static final void listenForUpdates$lambda-0(String $noName_0, List $noName_1) {
    }
}

