/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupRequest;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupResponse;
import org.opensearch.indexmanagement.rollup.action.index.TransportIndexRollupAction;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001*B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00022\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n \u0019*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/index/TransportIndexRollupAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupRequest;", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexManagementIndices", "Lorg/opensearch/indexmanagement/IndexManagementIndices;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/indexmanagement/IndexManagementIndices;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getIndexManagementIndices", "()Lorg/opensearch/indexmanagement/IndexManagementIndices;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/action/ActionListener;", "IndexRollupHandler", "opensearch-index-management"})
public final class TransportIndexRollupAction
extends HandledTransportAction<IndexRollupRequest, IndexRollupResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final IndexManagementIndices indexManagementIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportIndexRollupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull IndexManagementIndices indexManagementIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexManagementIndices, (String)"indexManagementIndices");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/rollup/index", transportService, actionFilters, IndexRollupRequest::new);
        this.client = client;
        this.indexManagementIndices = indexManagementIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportIndexRollupAction._init_$lambda-0(this, arg_0));
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final IndexManagementIndices getIndexManagementIndices() {
        return this.indexManagementIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    protected void doExecute(@NotNull Task task, @NotNull IndexRollupRequest request, @NotNull ActionListener<IndexRollupResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new IndexRollupHandler(this.client, listener, request, null, 8, null).start();
    }

    private static final void _init_$lambda-0(TransportIndexRollupAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J\u0006\u0010\u001a\u001a\u00020\rJ\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/index/TransportIndexRollupAction$IndexRollupHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupResponse;", "request", "Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/rollup/action/index/TransportIndexRollupAction;Lorg/opensearch/client/Client;Lorg/opensearch/action/ActionListener;Lorg/opensearch/indexmanagement/rollup/action/index/IndexRollupRequest;Lorg/opensearch/commons/authuser/User;)V", "getRollup", "", "modifiedImmutableProperties", "", "", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "newRollup", "onCreateMappingsResponse", "response", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "onGetRollup", "Lorg/opensearch/action/get/GetResponse;", "putRollup", "start", "validateTargetIndexName", "", "opensearch-index-management"})
    public final class IndexRollupHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexRollupResponse> actionListener;
        @NotNull
        private final IndexRollupRequest request;
        @Nullable
        private final User user;

        public IndexRollupHandler(@NotNull Client client, @NotNull ActionListener<IndexRollupResponse> actionListener, @Nullable IndexRollupRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportIndexRollupAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public /* synthetic */ IndexRollupHandler(Client client, ActionListener actionListener, IndexRollupRequest indexRollupRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = client.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"class IndexRollupHandler\u2026ains(\"?\")\n        }\n    }");
                user = SecurityUtils.Companion.buildUser(threadContext, indexRollupRequest.getRollup().getUser());
            }
            this(client, (ActionListener<IndexRollupResponse>)actionListener, indexRollupRequest, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            TransportIndexRollupAction.this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportIndexRollupAction transportIndexRollupAction = TransportIndexRollupAction.this;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                Boolean bl2 = transportIndexRollupAction.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"filterByEnabled");
                if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl2, this.actionListener)) {
                    return;
                }
                IndexManagementIndices indexManagementIndices = transportIndexRollupAction.getIndexManagementIndices();
                bl2 = ActionListener.wrap(this::onCreateMappingsResponse, arg_0 -> this.actionListener.onFailure(arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"wrap(::onCreateMappingsR\u2026ctionListener::onFailure)");
                indexManagementIndices.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)bl2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void onCreateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexRollupAction.this.log.info("Successfully created or updated .opendistro-ism-config with newest mappings.");
                if (this.request.opType() == DocWriteRequest.OpType.CREATE) {
                    if (!this.validateTargetIndexName()) {
                        this.actionListener.onFailure((Exception)new OpenSearchStatusException("target_index value is invalid: " + this.request.getRollup().getTargetIndex(), RestStatus.BAD_REQUEST, new Object[0]));
                        return;
                    }
                    this.putRollup();
                } else {
                    this.getRollup();
                }
            } else {
                String message = "Unable to create or update .opendistro-ism-config with newest mapping.";
                TransportIndexRollupAction.this.log.error(message);
                this.actionListener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }

        private final void getRollup() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getRollup().getId());
            this.client.get(getRequest, ActionListener.wrap(this::onGetRollup, arg_0 -> this.actionListener.onFailure(arg_0)));
        }

        private final void onGetRollup(GetResponse response2) {
            if (!response2.isExists()) {
                this.actionListener.onFailure((Exception)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            Rollup rollup2 = null;
            try {
                rollup2 = RollupUtilsKt.parseRollup(response2, TransportIndexRollupAction.this.getXContentRegistry());
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)new OpenSearchStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            User user = rollup2.getUser();
            Boolean e = TransportIndexRollupAction.this.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"filterByEnabled");
            if (!SecurityUtils.Companion.userHasPermissionForResource(this.user, user, e, "rollup", rollup2.getId(), this.actionListener)) {
                return;
            }
            List<String> modified = this.modifiedImmutableProperties(rollup2, this.request.getRollup());
            if (!((Collection)modified).isEmpty()) {
                this.actionListener.onFailure((Exception)new OpenSearchStatusException("Not allowed to modify " + modified, RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            if (!this.validateTargetIndexName()) {
                this.actionListener.onFailure((Exception)new OpenSearchStatusException("target_index value is invalid: " + this.request.getRollup().getTargetIndex(), RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            this.putRollup();
        }

        private final List<String> modifiedImmutableProperties(Rollup rollup2, Rollup newRollup) {
            List modified = new ArrayList();
            if (rollup2.getContinuous() != newRollup.getContinuous()) {
                modified.add("continuous");
            }
            if (!Intrinsics.areEqual(rollup2.getDimensions(), newRollup.getDimensions())) {
                modified.add("dimensions");
            }
            if (!Intrinsics.areEqual(rollup2.getMetrics(), newRollup.getMetrics())) {
                modified.add("metrics");
            }
            if (!Intrinsics.areEqual((Object)rollup2.getSourceIndex(), (Object)newRollup.getSourceIndex())) {
                modified.add("source_index");
            }
            if (!Intrinsics.areEqual((Object)rollup2.getTargetIndex(), (Object)newRollup.getTargetIndex())) {
                modified.add("target_index");
            }
            return CollectionsKt.toList((Iterable)modified);
        }

        private final void putRollup() {
            Rollup rollup2 = Rollup.copy$default(this.request.getRollup(), null, 0L, 0L, false, IndexUtils.Companion.getIndexManagementConfigSchemaVersion(), null, null, null, null, null, null, null, null, 0, null, false, null, null, this.user, 262127, null);
            IndexRequest indexRequest = ((IndexRequest)this.request.index(".opendistro-ism-config")).id(this.request.getRollup().getId());
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
            XContentBuilder xContentBuilder2 = xContentBuilder;
            xContentBuilder = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"EMPTY_PARAMS");
            indexRequest.source(rollup2.toXContent(xContentBuilder2, (ToXContent.Params)xContentBuilder)).timeout(IndexRequest.DEFAULT_TIMEOUT);
            this.client.index((IndexRequest)this.request, (ActionListener)new ActionListener<IndexResponse>(this, rollup2){
                final /* synthetic */ IndexRollupHandler this$0;
                final /* synthetic */ Rollup $rollup;
                {
                    this.this$0 = $receiver;
                    this.$rollup = $rollup;
                }

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (response2.getShardInfo().getFailed() > 0) {
                        ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                        Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"response.shardInfo.failures");
                        String failureReasons2 = ArraysKt.joinToString$default((Object[])failureArray, (CharSequence)", ", null, null, (int)0, null, (Function1)putRollup.onResponse.failureReasons.1.INSTANCE, (int)30, null);
                        IndexRollupHandler.access$getActionListener$p(this.this$0).onFailure((Exception)new OpenSearchStatusException(failureReasons2, response2.status(), new Object[0]));
                    } else {
                        RestStatus status = IndexRollupHandler.access$getRequest$p(this.this$0).opType() == DocWriteRequest.OpType.CREATE ? RestStatus.CREATED : RestStatus.OK;
                        ActionListener actionListener = IndexRollupHandler.access$getActionListener$p(this.this$0);
                        String string = response2.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                        actionListener.onResponse((Object)((Object)new IndexRollupResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), status, Rollup.copy$default(this.$rollup, null, response2.getSeqNo(), response2.getPrimaryTerm(), false, 0L, null, null, null, null, null, null, null, null, 0, null, false, null, null, null, 524281, null))));
                    }
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IndexRollupHandler.access$getActionListener$p(this.this$0).onFailure(e);
                }
            });
        }

        private final boolean validateTargetIndexName() {
            String targetIndexResolvedName = RollupFieldValueExpressionResolver.INSTANCE.resolve(this.request.getRollup(), this.request.getRollup().getTargetIndex());
            return !StringsKt.contains$default((CharSequence)targetIndexResolvedName, (CharSequence)"*", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)targetIndexResolvedName, (CharSequence)"?", (boolean)false, (int)2, null);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexRollupHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ IndexRollupRequest access$getRequest$p(IndexRollupHandler $this) {
            return $this.request;
        }
    }
}

