/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.uhighlight.CustomUnifiedHighlighter;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.annotatedtext.AnnotatedTextFieldMapper;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.subphase.highlight.AnnotatedPassageFormatter;
import org.opensearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.opensearch.search.fetch.subphase.highlight.UnifiedHighlighter;

public class AnnotatedTextHighlighter
extends UnifiedHighlighter {
    public static final String NAME = "annotated";

    protected List<Object> loadFieldValues(CustomUnifiedHighlighter highlighter, QueryShardContext context, MappedFieldType fieldType, FetchSubPhase.HitContext hitContext, boolean forceSource) throws IOException {
        List fieldValues = super.loadFieldValues(highlighter, context, fieldType, hitContext, forceSource);
        ArrayList<Object> strings = new ArrayList<Object>(fieldValues.size());
        AnnotatedTextFieldMapper.AnnotatedText[] annotations = new AnnotatedTextFieldMapper.AnnotatedText[fieldValues.size()];
        for (int i = 0; i < fieldValues.size(); ++i) {
            annotations[i] = AnnotatedTextFieldMapper.AnnotatedText.parse(fieldValues.get(i).toString());
            strings.add(annotations[i].textMinusMarkup);
        }
        ((AnnotatedPassageFormatter)highlighter.getFormatter()).setAnnotations(annotations);
        ((AnnotatedTextFieldMapper.AnnotatedHighlighterAnalyzer)highlighter.getIndexAnalyzer()).setAnnotations(annotations);
        return strings;
    }

    protected Analyzer getAnalyzer(DocumentMapper docMapper) {
        return new AnnotatedTextFieldMapper.AnnotatedHighlighterAnalyzer(super.getAnalyzer(docMapper));
    }

    protected PassageFormatter getPassageFormatter(FetchSubPhase.HitContext hitContext, SearchHighlightContext.Field field, Encoder encoder) {
        return new AnnotatedPassageFormatter(encoder);
    }
}

