/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.system;

import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;

public final class SystemFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(SystemFunctions.typeof());
    }

    private static FunctionResolver typeof() {
        return new FunctionResolver(){

            @Override
            public Pair<FunctionSignature, FunctionBuilder> resolve(FunctionSignature unresolvedSignature) {
                return Pair.of((Object)unresolvedSignature, (functionProperties, arguments) -> new FunctionExpression(BuiltinFunctionName.TYPEOF.getName(), arguments){

                    @Override
                    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
                        return new ExprStringValue(this.getArguments().get(0).type().toString());
                    }

                    @Override
                    public ExprType type() {
                        return ExprCoreType.STRING;
                    }
                });
            }

            @Override
            public FunctionName getFunctionName() {
                return BuiltinFunctionName.TYPEOF.getName();
            }
        };
    }

    @Generated
    private SystemFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

