/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.optimizer.rule.read;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.matching.pattern.CapturePattern;
import com.facebook.presto.matching.pattern.WithPattern;
import java.util.function.BiFunction;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;
import org.opensearch.sql.storage.read.TableScanBuilder;

public class TableScanPushDown<T extends LogicalPlan>
implements Rule<T> {
    public static final Rule<?> PUSH_DOWN_FILTER = TableScanPushDownBuilder.match(Patterns.filter(Patterns.scanBuilder())).apply((filter, scanBuilder) -> scanBuilder.pushDownFilter((LogicalFilter)filter));
    public static final Rule<?> PUSH_DOWN_AGGREGATION = TableScanPushDownBuilder.match(Patterns.aggregate(Patterns.scanBuilder())).apply((agg, scanBuilder) -> scanBuilder.pushDownAggregation((LogicalAggregation)agg));
    public static final Rule<?> PUSH_DOWN_SORT = TableScanPushDownBuilder.match(Patterns.sort(Patterns.scanBuilder())).apply((sort, scanBuilder) -> scanBuilder.pushDownSort((LogicalSort)sort));
    public static final Rule<?> PUSH_DOWN_LIMIT = TableScanPushDownBuilder.match(Patterns.limit(Patterns.scanBuilder())).apply((limit, scanBuilder) -> scanBuilder.pushDownLimit((LogicalLimit)limit));
    public static final Rule<?> PUSH_DOWN_PROJECT = TableScanPushDownBuilder.match(Patterns.project(Patterns.scanBuilder())).apply((project, scanBuilder) -> scanBuilder.pushDownProject((LogicalProject)project));
    public static final Rule<?> PUSH_DOWN_HIGHLIGHT = TableScanPushDownBuilder.match(Patterns.highlight(Patterns.scanBuilder())).apply((highlight, scanBuilder) -> scanBuilder.pushDownHighlight((LogicalHighlight)highlight));
    private final WithPattern<T> pattern;
    private final Capture<TableScanBuilder> capture;
    private final BiFunction<T, TableScanBuilder, Boolean> pushDownFunction;

    private TableScanPushDown(WithPattern<T> pattern, BiFunction<T, TableScanBuilder, Boolean> pushDownFunction) {
        this.pattern = pattern;
        this.capture = ((CapturePattern)pattern.getPattern()).capture();
        this.pushDownFunction = pushDownFunction;
    }

    @Override
    public Pattern<T> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(T plan, Captures captures) {
        TableScanBuilder scanBuilder = (TableScanBuilder)captures.get(this.capture);
        if (this.pushDownFunction.apply(plan, scanBuilder).booleanValue()) {
            return scanBuilder;
        }
        return plan;
    }

    static class TableScanPushDownBuilder<T extends LogicalPlan> {
        private WithPattern<T> pattern;

        TableScanPushDownBuilder() {
        }

        public static <T extends LogicalPlan> TableScanPushDownBuilder<T> match(Pattern<T> pattern) {
            TableScanPushDownBuilder<T> builder = new TableScanPushDownBuilder<T>();
            builder.pattern = (WithPattern)pattern;
            return builder;
        }

        public TableScanPushDown<T> apply(BiFunction<T, TableScanBuilder, Boolean> pushDownFunction) {
            return new TableScanPushDown<T>(this.pattern, pushDownFunction);
        }
    }
}

