/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.planner.physical.ADOperator;
import org.opensearch.sql.opensearch.planner.physical.MLCommonsOperator;
import org.opensearch.sql.opensearch.planner.physical.MLOperator;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.system.OpenSearchDescribeIndexRequest;
import org.opensearch.sql.opensearch.storage.OpenSearchIndexScan;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScanBuilder;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalAD;
import org.opensearch.sql.planner.logical.LogicalML;
import org.opensearch.sql.planner.logical.LogicalMLCommons;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.storage.read.TableScanBuilder;

public class OpenSearchIndex
implements Table {
    private final OpenSearchClient client;
    private final Settings settings;
    private final OpenSearchRequest.IndexName indexName;
    private Map<String, ExprType> cachedFieldTypes = null;
    private Integer cachedMaxResultWindow = null;

    public OpenSearchIndex(OpenSearchClient client, Settings settings, String indexName) {
        this.client = client;
        this.settings = settings;
        this.indexName = new OpenSearchRequest.IndexName(indexName);
    }

    public boolean exists() {
        return this.client.exists(this.indexName.toString());
    }

    public void create(Map<String, ExprType> schema) {
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        HashMap<String, String> properties = new HashMap<String, String>();
        mappings.put("properties", properties);
        for (Map.Entry<String, ExprType> colType : schema.entrySet()) {
            properties.put(colType.getKey(), OpenSearchDataType.getOpenSearchType(colType.getValue()));
        }
        this.client.createIndex(this.indexName.toString(), mappings);
    }

    public Map<String, ExprType> getFieldTypes() {
        if (this.cachedFieldTypes == null) {
            this.cachedFieldTypes = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getFieldTypes();
        }
        return this.cachedFieldTypes;
    }

    public Integer getMaxResultWindow() {
        if (this.cachedMaxResultWindow == null) {
            this.cachedMaxResultWindow = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getMaxResultWindow();
        }
        return this.cachedMaxResultWindow;
    }

    public PhysicalPlan implement(LogicalPlan plan) {
        return (PhysicalPlan)plan.accept((LogicalPlanNodeVisitor)new OpenSearchDefaultImplementor(this.client), null);
    }

    public LogicalPlan optimize(LogicalPlan plan) {
        return plan;
    }

    public TableScanBuilder createScanBuilder() {
        OpenSearchIndexScan indexScan = new OpenSearchIndexScan(this.client, this.settings, this.indexName, this.getMaxResultWindow(), new OpenSearchExprValueFactory(this.getFieldTypes()));
        return new OpenSearchIndexScanBuilder(indexScan);
    }

    @VisibleForTesting
    public static class OpenSearchDefaultImplementor
    extends DefaultImplementor<OpenSearchIndexScan> {
        private final OpenSearchClient client;

        public PhysicalPlan visitMLCommons(LogicalMLCommons node, OpenSearchIndexScan context) {
            return new MLCommonsOperator(this.visitChild((LogicalPlan)node, (Object)context), node.getAlgorithm(), node.getArguments(), this.client.getNodeClient());
        }

        public PhysicalPlan visitAD(LogicalAD node, OpenSearchIndexScan context) {
            return new ADOperator(this.visitChild((LogicalPlan)node, (Object)context), node.getArguments(), this.client.getNodeClient());
        }

        public PhysicalPlan visitML(LogicalML node, OpenSearchIndexScan context) {
            return new MLOperator(this.visitChild((LogicalPlan)node, (Object)context), node.getArguments(), this.client.getNodeClient());
        }

        @Generated
        public OpenSearchDefaultImplementor(OpenSearchClient client) {
            this.client = client;
        }
    }
}

