/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.storage.OpenSearchIndexScan;
import org.opensearch.sql.opensearch.storage.script.filter.FilterQueryBuilder;
import org.opensearch.sql.opensearch.storage.script.sort.SortQueryBuilder;
import org.opensearch.sql.opensearch.storage.serialization.DefaultExpressionSerializer;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.storage.TableScanOperator;
import org.opensearch.sql.storage.read.TableScanBuilder;

@VisibleForTesting
class OpenSearchIndexScanQueryBuilder
extends TableScanBuilder {
    private final OpenSearchIndexScan indexScan;

    OpenSearchIndexScanQueryBuilder(OpenSearchIndexScan indexScan) {
        this.indexScan = indexScan;
    }

    public TableScanOperator build() {
        return this.indexScan;
    }

    public boolean pushDownFilter(LogicalFilter filter) {
        FilterQueryBuilder queryBuilder = new FilterQueryBuilder(new DefaultExpressionSerializer());
        QueryBuilder query = queryBuilder.build(filter.getCondition());
        this.indexScan.getRequestBuilder().pushDown(query);
        return true;
    }

    public boolean pushDownSort(LogicalSort sort) {
        List sortList = sort.getSortList();
        SortQueryBuilder builder = new SortQueryBuilder();
        this.indexScan.getRequestBuilder().pushDownSort(sortList.stream().map(sortItem -> builder.build((Expression)sortItem.getValue(), (Sort.SortOption)sortItem.getKey())).collect(Collectors.toList()));
        return true;
    }

    public boolean pushDownLimit(LogicalLimit limit) {
        this.indexScan.getRequestBuilder().pushDownLimit(limit.getLimit(), limit.getOffset());
        return true;
    }

    public boolean pushDownProject(LogicalProject project) {
        this.indexScan.getRequestBuilder().pushDownProjects(OpenSearchIndexScanQueryBuilder.findReferenceExpressions(project.getProjectList()));
        return false;
    }

    public boolean pushDownHighlight(LogicalHighlight highlight) {
        this.indexScan.getRequestBuilder().pushDownHighlight(StringUtils.unquoteText((String)highlight.getHighlightField().toString()), highlight.getArguments());
        return true;
    }

    public static Set<ReferenceExpression> findReferenceExpressions(List<NamedExpression> expressions) {
        HashSet<ReferenceExpression> projectList = new HashSet<ReferenceExpression>();
        for (NamedExpression namedExpression : expressions) {
            projectList.addAll(OpenSearchIndexScanQueryBuilder.findReferenceExpression(namedExpression));
        }
        return projectList;
    }

    public static List<ReferenceExpression> findReferenceExpression(NamedExpression expression) {
        final ArrayList<ReferenceExpression> results = new ArrayList<ReferenceExpression>();
        expression.accept((ExpressionNodeVisitor)new ExpressionNodeVisitor<Object, Object>(){

            public Object visitReference(ReferenceExpression node, Object context) {
                return results.add(node);
            }
        }, null);
        return results;
    }
}

