/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.unload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class UnloadModelInput
implements ToXContentObject,
Writeable {
    private static final String MODEL_IDS_FIELD = "model_ids";
    private static final String NODE_IDS_FIELD = "node_ids";
    private String[] modelIds;
    private String[] nodeIds;

    public UnloadModelInput(StreamInput in) throws IOException {
        this.modelIds = in.readOptionalStringArray();
        this.nodeIds = in.readOptionalStringArray();
    }

    public UnloadModelInput(String[] modelIds, String[] nodeIds) {
        this.modelIds = modelIds;
        this.nodeIds = nodeIds;
    }

    public UnloadModelInput() {
    }

    public static UnloadModelInput parse(XContentParser parser) throws IOException {
        ArrayList<String> modelIds = new ArrayList<String>();
        ArrayList<String> nodeIds = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        modelIds.add(parser.text());
                    }
                    continue block8;
                }
                case "node_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        nodeIds.add(parser.text());
                    }
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new UnloadModelInput(modelIds.toArray(new String[0]), nodeIds.toArray(new String[0]));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringArray(this.modelIds);
        out.writeOptionalStringArray(this.nodeIds);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_IDS_FIELD, (Object)this.modelIds);
        builder.field(NODE_IDS_FIELD, (Object)this.nodeIds);
        builder.endObject();
        return builder;
    }

    @Generated
    public static UnloadModelInputBuilder builder() {
        return new UnloadModelInputBuilder();
    }

    @Generated
    public String[] getModelIds() {
        return this.modelIds;
    }

    @Generated
    public String[] getNodeIds() {
        return this.nodeIds;
    }

    @Generated
    public void setModelIds(String[] modelIds) {
        this.modelIds = modelIds;
    }

    @Generated
    public void setNodeIds(String[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnloadModelInput)) {
            return false;
        }
        UnloadModelInput other = (UnloadModelInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getModelIds(), other.getModelIds())) {
            return false;
        }
        return Arrays.deepEquals(this.getNodeIds(), other.getNodeIds());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnloadModelInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getModelIds());
        result = result * 59 + Arrays.deepHashCode(this.getNodeIds());
        return result;
    }

    @Generated
    public String toString() {
        return "UnloadModelInput(modelIds=" + Arrays.deepToString(this.getModelIds()) + ", nodeIds=" + Arrays.deepToString(this.getNodeIds()) + ")";
    }

    @Generated
    public static class UnloadModelInputBuilder {
        @Generated
        private String[] modelIds;
        @Generated
        private String[] nodeIds;

        @Generated
        UnloadModelInputBuilder() {
        }

        @Generated
        public UnloadModelInputBuilder modelIds(String[] modelIds) {
            this.modelIds = modelIds;
            return this;
        }

        @Generated
        public UnloadModelInputBuilder nodeIds(String[] nodeIds) {
            this.nodeIds = nodeIds;
            return this;
        }

        @Generated
        public UnloadModelInput build() {
            return new UnloadModelInput(this.modelIds, this.nodeIds);
        }

        @Generated
        public String toString() {
            return "UnloadModelInput.UnloadModelInputBuilder(modelIds=" + Arrays.deepToString(this.modelIds) + ", nodeIds=" + Arrays.deepToString(this.nodeIds) + ")";
        }
    }
}

