/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ti extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "\u1300\u122d\u1218\u1295";
        final String metaValue_la = "\u120b\u1272\u1295";
        final Object[][] data = new Object[][] {
            { "001", "\u12d3\u1208\u121d" },
            { "002", "\u12a3\u134d\u122a\u1243" },
            { "003", "\u1230\u121c\u1295 \u12a3\u1218\u122a\u12ab" },
            { "005", "\u12f0\u1261\u1265 \u12a3\u1218\u122a\u12ab" },
            { "009", "\u12a6\u123d\u12eb\u1295\u12eb" },
            { "011", "\u121d\u12d5\u122b\u1263\u12ca \u12a3\u134d\u122a\u1243" },
            { "013", "\u121b\u12a5\u12a8\u120b\u12ed \u12a3\u1218\u122a\u12ab" },
            { "014", "\u121d\u1265\u122b\u1253\u12ca \u12a3\u134d\u122a\u1243" },
            { "015", "\u1230\u121c\u1293\u12ca \u12a3\u134d\u122a\u1243" },
            { "017", "\u121b\u12a5\u12a8\u120b\u12ed \u12a3\u134d\u122a\u1243" },
            { "018", "\u12f0\u1261\u1263\u12ca \u12a3\u134d\u122a\u1243" },
            { "019", "\u12a3\u1218\u122a\u12ab\u1273\u1275" },
            { "021", "\u1230\u121c\u1293\u12ca \u12a3\u1218\u122a\u12ab" },
            { "029", "\u12ab\u122a\u1265\u12eb\u1295" },
            { "030", "\u121d\u1265\u122b\u1253\u12ca \u12a4\u1235\u12eb" },
            { "034", "\u12f0\u1261\u1263\u12ca \u12a4\u1235\u12eb" },
            { "035", "\u12f0\u1261\u1263\u12ca \u121d\u1265\u122b\u1255 \u12a4\u1235\u12eb" },
            { "039", "\u12f0\u1261\u1263\u12ca \u12a4\u12cd\u122e\u1333" },
            { "053", "\u12a3\u12cd\u1235\u1275\u122b\u120c\u12e5\u12eb" },
            { "054", "\u1218\u120b\u1290\u12e5\u12eb" },
            { "057", "\u12de\u1263 \u121b\u12ed\u12ad\u122e\u1290\u12e5\u12eb" },
            { "061", "\u1356\u120a\u1290\u12e5\u12eb" },
            { "142", "\u12a4\u1235\u12eb" },
            { "143", "\u121b\u12a5\u12a8\u120b\u12ed \u12a4\u1235\u12eb" },
            { "145", "\u121d\u12d5\u122b\u1263\u12ca \u12a4\u1235\u12eb" },
            { "150", "\u12a4\u12cd\u122e\u1333" },
            { "151", "\u121d\u1265\u122b\u1253\u12ca \u12a4\u12cd\u122e\u1333" },
            { "154", "\u1230\u121c\u1293\u12ca \u12a4\u12cd\u122e\u1333" },
            { "155", "\u121d\u12d5\u122b\u1263\u12ca \u12a4\u12cd\u122e\u1333" },
            { "202", "\u1295\u12a1\u1235 \u1230\u1203\u122b\u12ca \u12a3\u134d\u122a\u1243" },
            { "419", "\u120b\u1272\u1295 \u12a3\u1218\u122a\u12ab" },
            { "AC", "\u12f0\u1234\u1275 \u12a3\u1230\u1295\u1235\u12ee\u1295" },
            { "AD", "\u12a3\u1295\u12f6\u122b" },
            { "AE", "\u1215\u1261\u122b\u1275 \u12a2\u121b\u122b\u1275 \u12d3\u1228\u1265" },
            { "AF", "\u12a3\u134d\u130b\u1292\u1235\u1273\u1295" },
            { "AG", "\u12a3\u1295\u1272\u1313\u1295 \u1263\u122d\u1261\u12f3\u1295" },
            { "AI", "\u12a3\u1295\u1312\u120b" },
            { "AL", "\u12a3\u120d\u1263\u1295\u12eb" },
            { "AM", "\u12a3\u122d\u121c\u1295\u12eb" },
            { "AO", "\u12a3\u1295\u130e\u120b" },
            { "AQ", "\u12a3\u1295\u1273\u122d\u12ad\u1272\u12ab" },
            { "AR", "\u12a3\u122d\u1300\u1295\u1272\u1293" },
            { "AS", "\u12a3\u1218\u122a\u12ab\u12ca\u1275 \u1233\u121e\u12a3" },
            { "AT", "\u12a6\u1235\u1275\u122d\u12eb" },
            { "AU", "\u12a3\u12cd\u1235\u1275\u122b\u120d\u12eb" },
            { "AW", "\u12a3\u1229\u1263" },
            { "AX", "\u12f0\u1234\u1273\u1275 \u12a3\u120b\u1295\u12f5" },
            { "AZ", "\u12a3\u12d8\u122d\u1263\u1303\u1295" },
            { "BA", "\u1266\u12dd\u1295\u12eb\u1295 \u1204\u122d\u12d8\u130e\u126a\u1293\u1295" },
            { "BB", "\u1263\u122d\u1263\u12f6\u1235" },
            { "BD", "\u1263\u1295\u130d\u120b\u12f0\u123d" },
            { "BE", "\u1264\u120d\u1305\u12e9\u121d" },
            { "BF", "\u1261\u122d\u12aa\u1293 \u134b\u1236" },
            { "BG", "\u1261\u120d\u130b\u122d\u12eb" },
            { "BH", "\u1263\u1215\u122c\u1295" },
            { "BI", "\u1265\u1229\u1295\u12f2" },
            { "BJ", "\u1264\u1292\u1295" },
            { "BL", "\u1245\u12f1\u1235 \u1263\u122d\u1270\u1208\u121a" },
            { "BM", "\u1260\u122d\u1219\u12f3" },
            { "BN", "\u1265\u1229\u1290\u12ed" },
            { "BO", "\u1266\u120a\u126d\u12eb" },
            { "BQ", "\u12ab\u122a\u1265\u12eb\u1295 \u1294\u12d8\u122d\u120b\u1295\u12f5" },
            { "BR", "\u1265\u122b\u12da\u120d" },
            { "BS", "\u1263\u1203\u121b\u1235" },
            { "BT", "\u1261\u1273\u1295" },
            { "BV", "\u12f0\u1234\u1275 \u1261\u1268\u1275" },
            { "BW", "\u1266\u1275\u1235\u12cb\u1293" },
            { "BY", "\u1264\u120b\u1229\u1235" },
            { "BZ", "\u1260\u120a\u12dd" },
            { "CA", "\u12ab\u1293\u12f3" },
            { "CC", "\u12f0\u1234\u1273\u1275 \u12ae\u12ae\u1235" },
            { "CD", "\u12f0\u121e\u12ad\u122b\u1235\u12eb\u12ca\u1275 \u122a\u1353\u1265\u120a\u12ad \u12ae\u1295\u130e" },
            { "CF", "\u122a\u1353\u1265\u120a\u12ad \u121b\u12a5\u12a8\u120b\u12ed \u12a3\u134d\u122a\u1243" },
            { "CG", "\u12ae\u1295\u130e" },
            { "CH", "\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f5" },
            { "CI", "\u12ae\u1275 \u12f2\u126d\u12cb\u122d" },
            { "CK", "\u12f0\u1234\u1273\u1275 \u12a9\u12ad" },
            { "CL", "\u127a\u120c" },
            { "CM", "\u12ab\u121c\u1229\u1295" },
            { "CN", "\u127b\u12ed\u1293" },
            { "CO", "\u12ae\u120e\u121d\u1265\u12eb" },
            { "CP", "\u12f0\u1234\u1275 \u12ad\u120a\u1350\u122d\u1276\u1295" },
            { "CR", "\u12ae\u1235\u1273 \u122a\u12ab" },
            { "CU", "\u12a9\u1263" },
            { "CV", "\u12ac\u1355 \u1268\u122d\u12f0" },
            { "CW", "\u12a9\u122b\u1233\u12cd" },
            { "CX", "\u12f0\u1234\u1275 \u12ad\u122a\u1235\u121b\u1235" },
            { "CY", "\u1246\u1335\u122e\u1235" },
            { "CZ", "\u1278\u12ad\u12eb" },
            { "DE", metaValue_DE },
            { "DG", "\u12f5\u12e8\u130e \u130b\u122d\u1235\u12eb" },
            { "DJ", "\u1305\u1261\u1272" },
            { "DK", "\u12f0\u1295\u121b\u122d\u12ad" },
            { "DM", "\u12f6\u121a\u1292\u12ab" },
            { "DO", "\u12f6\u121a\u1292\u12ab\u12ca\u1275 \u122a\u1353\u1265\u120a\u12ad" },
            { "DZ", "\u12a3\u120d\u1300\u122d\u12eb" },
            { "EA", "\u1234\u12cd\u1273\u1295 \u1218\u120a\u120b\u1295" },
            { "EC", "\u12a4\u12b3\u12f6\u122d" },
            { "EE", "\u12a4\u1235\u1276\u1295\u12eb" },
            { "EG", "\u130d\u1265\u133a" },
            { "EH", "\u121d\u12d5\u122b\u1263\u12ca \u1230\u1203\u122b" },
            { "ER", "\u12a4\u122d\u1275\u122b" },
            { "ES", "\u1235\u1333\u129b" },
            { "ET", "\u12a2\u1275\u12ee\u1335\u12eb" },
            { "EU", "\u12a4\u12cd\u122e\u1333\u12ca \u1215\u1265\u1228\u1275" },
            { "EZ", "\u12de\u1263 \u12e9\u122e" },
            { "FI", "\u134a\u1295\u120b\u1295\u12f5" },
            { "FJ", "\u134a\u1302" },
            { "FK", "\u12f0\u1234\u1273\u1275 \u134e\u12ad\u120b\u1295\u12f5" },
            { "FM", "\u121b\u12ed\u12ad\u122e\u1290\u12e5\u12eb" },
            { "FO", "\u12f0\u1234\u1273\u1275 \u134b\u122e" },
            { "FR", "\u1348\u1228\u1295\u1233" },
            { "GA", "\u130b\u1266\u1295" },
            { "GB", "\u1265\u122a\u1323\u1295\u12eb" },
            { "GD", "\u130d\u1228\u1293\u12f3" },
            { "GE", "\u1306\u122d\u1305\u12eb" },
            { "GF", "\u1348\u1228\u1295\u1233\u12ca\u1275 \u130a\u12eb\u1293" },
            { "GG", "\u1308\u122d\u1295\u12da" },
            { "GH", "\u130b\u1293" },
            { "GI", "\u1302\u1265\u122b\u120d\u1273\u122d" },
            { "GL", "\u130d\u122a\u1295\u120b\u1295\u12f5" },
            { "GM", "\u130b\u121d\u1265\u12eb" },
            { "GN", "\u130a\u1292" },
            { "GP", "\u1313\u12f0\u1209\u1355" },
            { "GQ", "\u12a2\u12b3\u1276\u122d\u12eb\u120d \u130a\u1292" },
            { "GR", "\u130d\u122a\u12bd" },
            { "GS", "\u12f0\u1234\u1273\u1275 \u12f0\u1261\u1265 \u1306\u122d\u1305\u12eb\u1295 \u12f0\u1261\u1265 \u1233\u1295\u12f5\u12ca\u127d\u1295" },
            { "GT", "\u1313\u1272\u121b\u120b" },
            { "GU", "\u1313\u121d" },
            { "GW", "\u130a\u1292-\u1262\u1233\u12cd" },
            { "GY", "\u1309\u12eb\u1293" },
            { "HK", "\u134d\u1209\u12ed \u121d\u121d\u1215\u12f3\u122b\u12ca \u12de\u1263 \u1206\u1295\u130d \u12ae\u1295\u130d (\u127b\u12ed\u1293)" },
            { "HM", "\u12f0\u1234\u1273\u1275 \u1204\u122d\u12f5\u1295 \u121b\u12ad\u12f6\u1293\u120d\u12f5\u1295" },
            { "HN", "\u1206\u1295\u12f1\u122b\u1235" },
            { "HR", "\u12ad\u122e\u12a4\u123d\u12eb" },
            { "HT", "\u1203\u12ed\u1272" },
            { "HU", "\u1203\u1295\u130b\u122a" },
            { "IC", "\u12f0\u1234\u1273\u1275 \u12ab\u1293\u122a" },
            { "ID", "\u12a2\u1295\u12f6\u1290\u12e5\u12eb" },
            { "IE", "\u12a3\u12e8\u122d\u120b\u1295\u12f5" },
            { "IL", "\u12a5\u1235\u122b\u12a4\u120d" },
            { "IM", "\u12a3\u12ed\u120d \u12a6\u134d \u121b\u1295" },
            { "IN", "\u1205\u1295\u12f2" },
            { "IO", "\u1265\u122a\u1323\u1295\u12eb\u12ca \u1205\u1295\u12f3\u12ca \u12cd\u1245\u12eb\u1296\u1235 \u130d\u12dd\u12a3\u1275" },
            { "IQ", "\u12d2\u122b\u1255" },
            { "IR", "\u12a2\u122b\u1295" },
            { "IS", "\u12a3\u12ed\u1235\u120b\u1295\u12f5" },
            { "IT", "\u12a2\u1323\u120d\u12eb" },
            { "JE", "\u1300\u122d\u12da" },
            { "JM", "\u1303\u121b\u12ed\u12ab" },
            { "JO", "\u12ee\u122d\u12f3\u1296\u1235" },
            { "JP", "\u1303\u1353\u1295" },
            { "KE", "\u12ac\u1295\u12eb" },
            { "KG", "\u12aa\u122d\u130a\u12dd\u1235\u1273\u1295" },
            { "KH", "\u12ab\u121d\u1266\u12f5\u12eb" },
            { "KI", "\u12aa\u122a\u1263\u1272" },
            { "KM", "\u12ae\u121e\u122e\u1235" },
            { "KN", "\u1245\u12f1\u1235 \u12aa\u1275\u1235\u1295 \u1294\u126a\u1235\u1295" },
            { "KP", "\u1230\u121c\u1295 \u12ae\u122d\u12eb" },
            { "KR", "\u12f0\u1261\u1265 \u12ae\u122d\u12eb" },
            { "KW", "\u12a9\u12cc\u1275" },
            { "KY", "\u12f0\u1234\u1273\u1275 \u12ab\u12ed\u121b\u1295" },
            { "KZ", "\u12ab\u12db\u12aa\u1235\u1273\u1295" },
            { "LA", "\u120b\u12a6\u1235" },
            { "LB", "\u120a\u1263\u1296\u1235" },
            { "LC", "\u1245\u12f5\u1235\u1272 \u1209\u1235\u12eb" },
            { "LI", "\u120a\u12bd\u1270\u1295\u123d\u1273\u12ed\u1295" },
            { "LK", "\u1235\u122a \u120b\u1295\u12ab" },
            { "LR", "\u120b\u12ed\u1260\u122d\u12eb" },
            { "LS", "\u120c\u1236\u1276" },
            { "LT", "\u120a\u1275\u12cc\u1295\u12eb" },
            { "LU", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d" },
            { "LV", "\u120b\u1275\u126d\u12eb" },
            { "LY", "\u120a\u1265\u12eb" },
            { "MA", "\u121e\u122e\u12ae" },
            { "MC", "\u121e\u1293\u12ae" },
            { "MD", "\u121e\u120d\u12f6\u126b" },
            { "ME", "\u121e\u1295\u1270\u1294\u130d\u122e" },
            { "MF", "\u1245\u12f1\u1235 \u121b\u122d\u1272\u1295" },
            { "MG", "\u121b\u12f3\u130b\u1235\u12ab\u122d" },
            { "MH", "\u12f0\u1234\u1273\u1275 \u121b\u122d\u123b\u120d" },
            { "MK", "\u1230\u121c\u1295 \u1218\u1244\u12f6\u1295\u12eb" },
            { "ML", "\u121b\u120a" },
            { "MM", "\u121a\u12eb\u1295\u121b\u122d (\u1260\u122d\u121b)" },
            { "MN", "\u121e\u1295\u130e\u120d\u12eb" },
            { "MO", "\u134d\u1209\u12ed \u121d\u121d\u1215\u12f3\u122b\u12ca \u12de\u1263 \u121b\u12ab\u12cd (\u127b\u12ed\u1293)" },
            { "MP", "\u1230\u121c\u1293\u12ca \u12f0\u1234\u1273\u1275 \u121b\u122d\u12eb\u1293" },
            { "MQ", "\u121b\u122d\u1272\u1292\u12ad" },
            { "MR", "\u121b\u12cd\u122a\u1273\u1295\u12eb" },
            { "MS", "\u121e\u1295\u1275\u1230\u122b\u1275" },
            { "MT", "\u121b\u120d\u1273" },
            { "MU", "\u121b\u12cd\u122a\u1238\u1235" },
            { "MV", "\u121b\u120d\u12f2\u126d\u1235" },
            { "MW", "\u121b\u120b\u12ca" },
            { "MX", "\u121c\u12ad\u1232\u12ae" },
            { "MY", "\u121b\u1208\u12e5\u12eb" },
            { "MZ", "\u121e\u12db\u121d\u1262\u12ad" },
            { "NA", "\u1293\u121a\u1265\u12eb" },
            { "NC", "\u1292\u12cd \u12ab\u1208\u12f6\u1295\u12eb" },
            { "NE", "\u1292\u1300\u122d" },
            { "NF", "\u12f0\u1234\u1275 \u1296\u122d\u134e\u120d\u12ad" },
            { "NG", "\u1293\u12ed\u1300\u122d\u12eb" },
            { "NI", "\u1292\u12ab\u122b\u1313" },
            { "NL", "\u1294\u12d8\u122d\u120b\u1295\u12f5" },
            { "NO", "\u1296\u122d\u12c8\u12ed" },
            { "NP", "\u1294\u1353\u120d" },
            { "NR", "\u1293\u12cd\u1229" },
            { "NU", "\u1292\u12e9" },
            { "NZ", "\u1292\u12cd \u12da\u120b\u1295\u12f5" },
            { "OM", "\u12d6\u121b\u1295" },
            { "PA", "\u1353\u1293\u121b" },
            { "PE", "\u1354\u1229" },
            { "PF", "\u1348\u1228\u1295\u1233\u12ca\u1275 \u1356\u120a\u1290\u12e5\u12eb" },
            { "PG", "\u1353\u1355\u12cb \u1292\u12cd \u130a\u1292" },
            { "PH", "\u134a\u120a\u1352\u1295\u1235" },
            { "PK", "\u1353\u12aa\u1235\u1273\u1295" },
            { "PL", "\u1356\u120b\u1295\u12f5" },
            { "PM", "\u1245\u12f1\u1235 \u1355\u12e8\u122d\u1295 \u121a\u12a8\u120e\u1295\u1295" },
            { "PN", "\u12f0\u1234\u1273\u1275 \u1352\u1275\u12ab\u122d\u1295" },
            { "PR", "\u1356\u122d\u1276 \u122a\u12ae" },
            { "PS", "\u130d\u12dd\u12a3\u1273\u1275 \u134d\u120d\u1235\u1324\u121d" },
            { "PT", "\u1356\u122d\u1271\u130b\u120d" },
            { "PW", "\u1353\u120b\u12cd" },
            { "PY", "\u1353\u122b\u1313\u12ed" },
            { "QA", "\u1250\u1320\u122d" },
            { "QO", "\u12ab\u1265 \u12a6\u123d\u12eb\u1295\u12eb \u122d\u1212\u1256\u121d \u130d\u12dd\u12a3\u1273\u1275" },
            { "RE", "\u122d\u12e9\u1295\u12e8\u1295" },
            { "RO", "\u1229\u121b\u1295\u12eb" },
            { "RS", "\u1230\u122d\u1265\u12eb" },
            { "RU", "\u1229\u1235\u12eb" },
            { "RW", "\u122d\u12cb\u1295\u12f3" },
            { "SA", "\u1235\u12d1\u12f2 \u12d3\u1228\u1265" },
            { "SB", "\u12f0\u1234\u1273\u1275 \u1230\u120e\u121e\u1295" },
            { "SC", "\u1232\u1238\u120d\u1235" },
            { "SD", "\u1231\u12f3\u1295" },
            { "SE", "\u123d\u12c8\u12f0\u1295" },
            { "SG", "\u1232\u1295\u130b\u1356\u122d" },
            { "SH", "\u1245\u12f5\u1235\u1272 \u1204\u1208\u1293" },
            { "SI", "\u1235\u120e\u126c\u1295\u12eb" },
            { "SJ", "\u1235\u126b\u120d\u1263\u122d\u12f5\u1295 \u1303\u1295 \u121b\u12e8\u1295\u1295" },
            { "SK", "\u1235\u120e\u126b\u12ad\u12eb" },
            { "SL", "\u1234\u122b \u120d\u12ee\u1295" },
            { "SM", "\u1233\u1295 \u121b\u122a\u1296" },
            { "SN", "\u1230\u1290\u130b\u120d" },
            { "SO", "\u1236\u121b\u120d\u12eb" },
            { "SR", "\u1231\u122a\u1293\u121d" },
            { "SS", "\u12f0\u1261\u1265 \u1231\u12f3\u1295" },
            { "ST", "\u1233\u12a6 \u1276\u1218\u1295 \u1355\u122a\u1295\u1232\u1350\u1295" },
            { "SV", "\u12a4\u120d \u1233\u120d\u126b\u12f6\u122d" },
            { "SX", "\u1232\u1295\u1275 \u121b\u122d\u1270\u1295" },
            { "SY", "\u1236\u122d\u12eb" },
            { "SZ", "\u12a4\u1235\u12cb\u1272\u1292" },
            { "TA", "\u1275\u122a\u1235\u1273\u1295 \u12f3 \u12a9\u1295\u12eb" },
            { "TC", "\u12f0\u1234\u1273\u1275 \u1271\u122d\u12ab\u1275\u1295 \u12ab\u12ed\u12ae\u1235\u1295" },
            { "TD", "\u132b\u12f5" },
            { "TF", "\u1348\u1228\u1295\u1233\u12ca \u12f0\u1261\u1263\u12ca \u130d\u12dd\u12a3\u1273\u1275" },
            { "TG", "\u1276\u130e" },
            { "TH", "\u1273\u12ed\u120b\u1295\u12f5" },
            { "TJ", "\u1273\u1302\u12aa\u1235\u1273\u1295" },
            { "TK", "\u1276\u12a8\u120b\u12cd" },
            { "TL", "\u1272\u121e\u122d-\u1208\u1235\u1270" },
            { "TM", "\u1271\u122d\u12ad\u1218\u1292\u1235\u1273\u1295" },
            { "TN", "\u1271\u1292\u12dd\u12eb" },
            { "TO", "\u1276\u1295\u130b" },
            { "TR", "\u1271\u122d\u12aa" },
            { "TT", "\u1275\u122a\u1292\u12f3\u12f5\u1295 \u1276\u1263\u130e\u1295" },
            { "TV", "\u1271\u126b\u1209" },
            { "TW", "\u1273\u12ed\u12cb\u1295" },
            { "TZ", "\u1273\u1295\u12db\u1295\u12eb" },
            { "UA", "\u12e9\u12ad\u122c\u1295" },
            { "UG", "\u12a1\u130b\u1295\u12f3" },
            { "UM", "\u12ab\u1265 \u12a3\u1218\u122a\u12ab \u122d\u1212\u1250\u1295 \u1295\u12a3\u123d\u1271 \u12f0\u1234\u1273\u1275" },
            { "UN", "\u1215\u1261\u122b\u1275 \u1203\u1308\u122b\u1275" },
            { "US", "\u12a3\u1218\u122a\u12ab" },
            { "UY", "\u12a1\u122b\u1313\u12ed" },
            { "UZ", "\u12a1\u12dd\u1260\u12aa\u1235\u1273\u1295" },
            { "VA", "\u12a8\u1270\u121b \u126b\u1272\u12ab\u1295" },
            { "VC", "\u1245\u12f1\u1235 \u126a\u1295\u1230\u1295\u1275\u1295 \u130d\u1228\u1290\u12f2\u1290\u12dd\u1295" },
            { "VE", "\u126c\u1294\u12dd\u12cc\u120b" },
            { "VG", "\u12f0\u1234\u1273\u1275 \u12f0\u1293\u130d\u120d \u1265\u122a\u1323\u1295\u12eb" },
            { "VI", "\u12f0\u1234\u1273\u1275 \u12f0\u1293\u130d\u120d \u12a3\u1218\u122a\u12ab" },
            { "VN", "\u126c\u1275\u1293\u121d" },
            { "VU", "\u126b\u1295\u12cb\u1271" },
            { "WF", "\u12cb\u120a\u1235\u1295 \u1349\u1271\u1293\u1295" },
            { "WS", "\u1233\u121e\u12a3" },
            { "XA", "\u1293\u12ed \u1213\u1236\u1275 \u120b\u1205\u1303\u1273\u1275" },
            { "XB", "\u1293\u12ed \u1213\u1236\u1275 \u12ad\u120d\u1270 \u12a3\u1295\u1348\u1273\u12ca" },
            { "XK", "\u12ae\u1236\u126e" },
            { "YE", "\u12e8\u1218\u1295" },
            { "YT", "\u121b\u12ee\u1275" },
            { "ZA", "\u12f0\u1261\u1265 \u12a3\u134d\u122a\u1243" },
            { "ZM", "\u12db\u121d\u1265\u12eb" },
            { "ZW", "\u12da\u121d\u1263\u1265\u12cc" },
            { "ZZ", "\u12d8\u12ed\u1270\u1348\u120d\u1320 \u12de\u1263" },
            { "ab", "\u12a3\u1265\u12ab\u12dd\u129b" },
            { "af", "\u12a3\u134d\u122a\u12ab\u1295\u1235" },
            { "ak", "\u12a3\u12ab\u1295" },
            { "am", "\u12a3\u121d\u1213\u122d\u129b" },
            { "an", "\u12a3\u122b\u130e\u1295\u129b" },
            { "ar", "\u12d3\u1228\u1265" },
            { "as", "\u12a3\u1233\u121c\u12dd\u129b" },
            { "av", "\u12a3\u126b\u122d" },
            { "ay", "\u12a3\u12ed\u121b\u122b" },
            { "az", "\u12a3\u12d8\u122d\u1263\u1303\u1295\u129b" },
            { "ba", "\u1263\u123d\u12aa\u122d" },
            { "be", "\u1264\u120b\u1229\u1235\u129b" },
            { "bg", "\u1261\u120d\u130b\u122d\u129b" },
            { "bi", "\u1262\u1235\u120b\u121b" },
            { "bm", "\u1263\u121d\u1263\u122b" },
            { "bn", "\u1260\u1295\u130b\u120a" },
            { "bo", "\u1272\u1260\u1273\u1295\u129b" },
            { "br", "\u1265\u1228\u1276\u1295\u129b" },
            { "bs", "\u1266\u12dd\u1295\u129b" },
            { "ca", "\u12ab\u1273\u120b\u1295" },
            { "ce", "\u1278\u1278\u1295\u12ed\u1293" },
            { "ch", "\u127b\u121e\u122e" },
            { "co", "\u12ae\u122d\u1235\u129b" },
            { "cs", "\u1278\u12ad\u129b" },
            { "cu", "\u1264\u1270-\u12ad\u122d\u1235\u1275\u12eb\u1295 \u1235\u120b\u126d\u129b" },
            { "cv", "\u1279\u126b\u123d\u129b" },
            { "cy", "\u12cc\u120d\u1235\u129b" },
            { "da", "\u12f3\u1292\u123d" },
            { "de", metaValue_DE },
            { "dv", "\u12f2\u1268\u1202" },
            { "dz", "\u12f5\u12de\u1295\u130d\u12ab" },
            { "ee", "\u12a2\u12cd" },
            { "el", "\u130d\u122a\u12bd\u129b" },
            { "en", "\u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "eo", "\u12a4\u1235\u1350\u122b\u1295\u1276" },
            { "es", "\u1235\u1333\u1295\u129b" },
            { "et", "\u12a4\u1235\u1276\u1295\u129b" },
            { "eu", "\u1263\u1235\u12ad\u129b" },
            { "fa", "\u134b\u122d\u1235\u129b" },
            { "ff", "\u1349\u120b" },
            { "fi", "\u134a\u1295\u120b\u1295\u12f5\u129b" },
            { "fj", "\u134a\u1305\u12eb\u1295\u129b" },
            { "fo", "\u134b\u122e\u12a5\u12ed\u1293" },
            { "fr", "\u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "fy", "\u121d\u12d5\u122b\u1263\u12ca \u134d\u122a\u1235\u129b" },
            { "ga", "\u12a3\u12e8\u122d\u120b\u1295\u12f5\u129b" },
            { "gd", "\u1235\u12ae\u1275\u120b\u1295\u12f3\u12ca \u130b\u12a4\u120a\u12ad\u129b" },
            { "gl", "\u130b\u120a\u123d\u12eb\u1295" },
            { "gn", "\u1313\u122b\u1292" },
            { "gu", "\u1309\u1303\u122b\u1272" },
            { "gv", "\u121b\u1295\u12ad\u1235" },
            { "ha", "\u1203\u12cd\u1233" },
            { "he", "\u12a5\u1265\u122b\u12ed\u1235\u1322" },
            { "hi", "\u1202\u1295\u12f2" },
            { "hr", "\u12ad\u122e\u12a4\u123d\u12eb\u1295" },
            { "ht", "\u12ad\u122d\u12ee\u120d \u1203\u12ed\u1275\u129b" },
            { "hu", "\u1203\u1295\u130b\u122d\u129b" },
            { "hy", "\u12a3\u122d\u121c\u1295\u129b" },
            { "hz", "\u1204\u1228\u122e" },
            { "ia", "\u12a2\u1295\u1270\u122d\u120a\u1295\u1313" },
            { "id", "\u12a2\u1295\u12f6\u1290\u12e5\u129b" },
            { "ig", "\u12a2\u130d\u1266" },
            { "ii", "\u1232\u127d\u12cb\u1295 \u12ea" },
            { "io", "\u12a2\u12f6" },
            { "is", "\u12a3\u12ed\u1235\u120b\u1295\u12f5\u129b" },
            { "it", "\u1325\u120d\u12eb\u1295" },
            { "iu", "\u12a2\u1293\u12ad\u1272\u1271\u1275" },
            { "ja", "\u1303\u1353\u1295\u129b" },
            { "jv", "\u1303\u126b\u1295\u129b" },
            { "ka", "\u1306\u122d\u1305\u12eb\u1295\u129b" },
            { "ki", "\u12aa\u12a9\u12e9" },
            { "kj", "\u12ad\u12cb\u1295\u12eb\u121b" },
            { "kk", "\u12ab\u12db\u12ad" },
            { "kl", "\u130d\u122a\u1295\u120b\u1295\u12f5\u129b" },
            { "km", "\u12ad\u1218\u122d" },
            { "kn", "\u12ab\u1295\u1293\u12f3" },
            { "ko", "\u12ae\u122d\u12ed\u129b" },
            { "kr", "\u12ab\u1291\u122a" },
            { "ks", "\u12ab\u123d\u121a\u122a" },
            { "ku", "\u12a9\u122d\u12f2\u123d" },
            { "kv", "\u12ae\u121a" },
            { "kw", "\u12ae\u122d\u1295\u129b" },
            { "ky", "\u12aa\u122d\u130a\u12dd\u129b" },
            { "la", metaValue_la },
            { "lb", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d\u129b" },
            { "lg", "\u130b\u1295\u12f3" },
            { "li", "\u120a\u121d\u1260\u122d\u130d\u129b" },
            { "ln", "\u120a\u1295\u130b\u120b" },
            { "lo", "\u120b\u12a6" },
            { "lt", "\u120a\u1275\u12cc\u1295\u129b" },
            { "lu", "\u1209\u1263-\u12ab\u1273\u1295\u130b" },
            { "lv", "\u120b\u1275\u126d\u129b" },
            { "mg", "\u121b\u120b\u130b\u1232" },
            { "mh", "\u121b\u122d\u123b\u120a\u12dd\u129b" },
            { "mi", "\u121b\u12a6\u122a" },
            { "mk", "\u1218\u1244\u12f6\u1295\u129b" },
            { "ml", "\u121b\u120b\u12eb\u120b\u121d" },
            { "mn", "\u121e\u1295\u130e\u120d\u129b" },
            { "mr", "\u121b\u122b\u1272" },
            { "ms", "\u121b\u120b\u12ed\u129b" },
            { "mt", "\u121b\u120d\u1275\u129b" },
            { "my", "\u1260\u122d\u121d\u129b" },
            { "na", "\u1293\u12cd\u122d\u12cb\u1295\u129b" },
            { "nb", "\u1296\u122d\u12c8\u12eb\u12ca \u1266\u12ad\u121b\u120d" },
            { "nd", "\u1230\u121c\u1295 \u12a4\u1295\u12f0\u1260\u1208" },
            { "ne", "\u1294\u1353\u120a" },
            { "ng", "\u12a4\u1295\u12f6\u1295\u130b" },
            { "nl", "\u12f3\u127d" },
            { "nn", "\u1296\u122d\u12c8\u12eb\u12ca \u1293\u12ed\u1296\u122d\u1235\u12ad" },
            { "no", "\u1296\u122d\u12c8\u12ed\u129b" },
            { "nr", "\u12f0\u1261\u1265 \u12a4\u1295\u12f0\u1260\u1208" },
            { "nv", "\u1293\u126b\u1206" },
            { "ny", "\u1295\u12eb\u1295\u1303" },
            { "oc", "\u12a6\u12ad\u1232\u1273\u1295\u129b" },
            { "om", "\u12a6\u122e\u121e" },
            { "or", "\u12a6\u12f5\u12eb" },
            { "os", "\u12a6\u1230\u1275\u129b" },
            { "pa", "\u1351\u1295\u1303\u1262" },
            { "pl", "\u1356\u120a\u123d" },
            { "ps", "\u1353\u123d\u1276" },
            { "pt", "\u1356\u122d\u1271\u130a\u12dd\u129b" },
            { "qu", "\u1240\u127d\u12cb" },
            { "rm", "\u122e\u121b\u1295\u123d" },
            { "rn", "\u12aa\u1229\u1295\u12f2" },
            { "ro", "\u1229\u121b\u1295\u129b" },
            { "ru", "\u1229\u1235\u129b" },
            { "rw", "\u12aa\u1295\u12eb\u122d\u12cb\u1295\u12f3" },
            { "sa", "\u1233\u1295\u1235\u12ad\u122a\u1275" },
            { "sc", "\u1233\u122d\u12f2\u1295\u129b" },
            { "sd", "\u1232\u1295\u12f5\u1202" },
            { "se", "\u1230\u121c\u1293\u12ca \u1233\u121a" },
            { "sg", "\u1233\u1295\u130e" },
            { "sh", "\u1230\u122d\u1266-\u12ad\u122e\u12a4\u123d\u12eb\u1295" },
            { "si", "\u1232\u1295\u1203\u120b" },
            { "sk", "\u1235\u120e\u126b\u12ad\u129b" },
            { "sl", "\u1235\u120e\u126c\u1295\u129b" },
            { "sm", "\u1233\u121e\u12a5\u129b" },
            { "sn", "\u123e\u1293" },
            { "so", "\u1236\u121b\u120a" },
            { "sq", "\u12a3\u120d\u1263\u1295\u129b" },
            { "sr", "\u1243\u1295\u1243 \u1230\u122d\u1262\u12eb" },
            { "ss", "\u1235\u12cb\u12da" },
            { "st", "\u12f0\u1261\u1263\u12ca \u1236\u1276" },
            { "su", "\u1231\u1295\u12f3\u1295\u129b" },
            { "sv", "\u1235\u12ca\u12f5\u1295\u129b" },
            { "sw", "\u1235\u12cb\u1202\u120a" },
            { "ta", "\u1273\u121a\u120d" },
            { "te", "\u1270\u1209\u1309" },
            { "tg", "\u1273\u1302\u12ad\u129b" },
            { "th", "\u1273\u12ed\u129b" },
            { "ti", "\u1275\u130d\u122d\u129b" },
            { "tk", "\u1271\u122d\u12ad\u1218\u1295\u129b" },
            { "tn", "\u1235\u12cb\u1293" },
            { "to", "\u1276\u1295\u130b\u1295\u129b" },
            { "tr", "\u1271\u122d\u12ad\u129b" },
            { "ts", "\u1236\u1295\u130b" },
            { "tt", "\u1273\u1273\u122d" },
            { "tw", "\u1275\u12ca" },
            { "ty", "\u1273\u1202\u1275\u129b" },
            { "ug", "\u12a1\u12ed\u1309\u122d" },
            { "uk", "\u12e9\u12ad\u1228\u12ed\u1295\u129b" },
            { "ur", "\u12a1\u122d\u12f1" },
            { "uz", "\u12a1\u12dd\u1260\u12ad\u129b" },
            { "ve", "\u1268\u1295\u12f3" },
            { "vi", "\u126c\u1275\u1293\u121d\u129b" },
            { "vo", "\u126e\u120b\u1351\u12ad" },
            { "wa", "\u12cb\u120e\u1295" },
            { "wo", "\u12ce\u120e\u134d" },
            { "xh", "\u12ae\u1233" },
            { "yi", "\u12ed\u1201\u12f5\u129b" },
            { "yo", "\u12ee\u1229\u1263" },
            { "zh", "\u127b\u12ed\u1295\u129b" },
            { "zu", "\u12d9\u1209" },
            { "ace", "\u12a3\u1278\u1292\u12dd\u129b" },
            { "ada", "\u12a3\u12f3\u1295\u130d\u121c" },
            { "ady", "\u12a3\u12f2\u130a" },
            { "agq", "\u12a3\u1308\u121d" },
            { "ain", "\u12a3\u12ed\u1291" },
            { "ale", "\u12a3\u1208\u12cd\u1275\u129b" },
            { "alt", "\u12f0\u1261\u1263\u12ca \u12a3\u120d\u1273\u12ed" },
            { "ann", "\u12a6\u1266\u120e" },
            { "anp", "\u12a3\u1295\u1302\u12ab" },
            { "arn", "\u121b\u1351\u127a" },
            { "arp", "\u12a3\u122b\u1353\u1206" },
            { "ars", "\u1293\u1305\u12f2 \u12d3\u1228\u1265\u129b" },
            { "asa", "\u12a3\u1231" },
            { "ast", "\u12a3\u1235\u1271\u122d\u12eb\u1295" },
            { "atj", "\u12a3\u1272\u12ab\u1218\u12ad" },
            { "awa", "\u12a3\u12cb\u12f2" },
            { "ban", "\u1263\u120a\u1295\u129b" },
            { "bas", "\u1263\u1233" },
            { "bem", "\u1264\u121d\u1263" },
            { "bez", "\u1260\u1293" },
            { "bho", "\u1266\u1305\u1351\u122a" },
            { "bin", "\u1262\u1292" },
            { "bla", "\u1232\u12ad\u1232\u12ab" },
            { "brx", "\u1266\u12f6" },
            { "bug", "\u1261\u130a\u1295\u129b" },
            { "byn", "\u1265\u120a\u1295" },
            { "cay", "\u12ab\u12e9\u130b" },
            { "ccp", "\u127b\u12ad\u121b" },
            { "ceb", "\u1230\u1265\u12cb\u1296" },
            { "cgg", "\u127a\u130b" },
            { "chk", "\u1279\u12aa\u12dd\u129b" },
            { "chm", "\u121b\u122a" },
            { "cho", "\u127e\u12ad\u1276" },
            { "chp", "\u127a\u1350\u12cd\u12eb\u1295" },
            { "chr", "\u1278\u122e\u12aa" },
            { "chy", "\u123b\u12eb\u1295" },
            { "ckb", "\u1236\u122b\u1292 \u12a9\u122d\u12f2\u123d" },
            { "clc", "\u127a\u120d\u12ae\u1272\u1295" },
            { "crg", "\u121a\u127a\u134d" },
            { "crj", "\u12f0\u1261\u1263\u12ca \u121d\u1265\u122b\u1255 \u12ad\u122a" },
            { "crk", "\u12ad\u122a \u1355\u120c\u1295\u1235" },
            { "crl", "\u1230\u121c\u1293\u12ca \u121d\u1265\u122b\u1255 \u12ad\u122a" },
            { "crm", "\u1219\u1235 \u12ad\u122a" },
            { "crr", "\u12ab\u1276\u120a\u1293 \u12a0\u120d\u130e\u1295\u1309\u12eb\u129b" },
            { "csw", "\u12ad\u122a \u1228\u130d\u1228\u130d" },
            { "dak", "\u12f3\u12ae\u1273" },
            { "dar", "\u12f3\u122d\u130d\u12cb" },
            { "dav", "\u1273\u12ed\u1273" },
            { "dgr", "\u12f6\u130d\u122a\u1265" },
            { "dje", "\u12db\u122d\u121b" },
            { "doi", "\u12f6\u130d\u122a" },
            { "dsb", "\u1273\u1215\u1270\u12cb\u12ed \u1236\u122d\u1265\u129b" },
            { "dua", "\u12f5\u12cb\u120b" },
            { "dyo", "\u1306\u120b-\u134e\u1292\u12ed" },
            { "dzg", "\u12f3\u12db\u130b" },
            { "ebu", "\u12a4\u121d\u1261" },
            { "efi", "\u12a4\u134a\u12ad" },
            { "eka", "\u12a4\u12ab\u1301\u12ad" },
            { "ewo", "\u12a4\u12ce\u1295\u12f6" },
            { "fil", "\u134a\u120a\u1352\u1295\u129b" },
            { "fon", "\u134e\u1295" },
            { "frc", "\u12ab\u1301\u1295 \u1348\u1228\u1295\u1233\u12ed" },
            { "frr", "\u1230\u121c\u1293\u12ca \u134d\u122a\u1235\u129b" },
            { "fur", "\u134d\u122d\u12e9\u120d\u129b" },
            { "gaa", "\u130b" },
            { "gez", "\u130d\u12a5\u12dd" },
            { "gil", "\u130a\u120d\u1260\u122d\u1275\u129b" },
            { "gor", "\u130e\u122e\u1295\u1273\u120e" },
            { "gsw", "\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f3\u12ca \u1300\u122d\u1218\u1295" },
            { "guz", "\u1309\u1232" },
            { "gwi", "\u1312\u127a\u1295" },
            { "hai", "\u1203\u12ed\u12f3" },
            { "haw", "\u1203\u12cb\u12ed\u129b" },
            { "hax", "\u12f0\u1261\u1263\u12ca \u1203\u12ed\u12f3" },
            { "hil", "\u1202\u120a\u130b\u12ed\u1296\u1295" },
            { "hmn", "\u1205\u121e\u1295\u130d" },
            { "hsb", "\u120b\u12d5\u1208\u12cb\u12ed \u1236\u122d\u1265\u129b" },
            { "hup", "\u1201\u1353" },
            { "hur", "\u1203\u120d\u12ae\u1218\u1208\u121d" },
            { "iba", "\u12a2\u1263\u1295" },
            { "ibb", "\u12a2\u1262\u1265\u12ee" },
            { "ikt", "\u121d\u12d5\u122b\u1263\u12ca \u12ab\u1293\u12f3\u12ca \u12a2\u1293\u12ad\u1272\u1271\u1275" },
            { "ilo", "\u12a2\u120e\u12ab\u1296" },
            { "inh", "\u12a2\u1295\u1309\u123d\u129b" },
            { "jbo", "\u120e\u1305\u1263\u1295" },
            { "jgo", "\u12a4\u1295\u130e\u121d\u1263" },
            { "jmc", "\u121b\u12ac\u121d" },
            { "kab", "\u12ab\u1262\u120d\u129b" },
            { "kac", "\u12ab\u127a\u1295" },
            { "kaj", "\u1305\u1301" },
            { "kam", "\u12ab\u121d\u1263" },
            { "kbd", "\u12ab\u1263\u122d\u12f5\u129b" },
            { "kcg", "\u1273\u12eb\u1355" },
            { "kde", "\u121b\u12ae\u1295\u12f0" },
            { "kea", "\u12ad\u122d\u12ee\u120d \u12ac\u1355 \u1268\u122d\u12f5\u129b" },
            { "kfo", "\u12ae\u122e" },
            { "kgp", "\u12ab\u12ed\u1295\u130b\u1295\u130d" },
            { "kha", "\u12ab\u1232" },
            { "khq", "\u12ae\u12ed\u122b \u127a\u1292" },
            { "kkj", "\u12ab\u12ae" },
            { "kln", "\u12ab\u1208\u1295\u1302\u1295" },
            { "kmb", "\u12aa\u121d\u1261\u1295\u12f1" },
            { "kok", "\u12ae\u1295\u12ab\u1292" },
            { "kpe", "\u12ad\u1350\u1208" },
            { "krc", "\u12ab\u122b\u127b\u12ed-\u1263\u120d\u12ab\u122d\u129b" },
            { "krl", "\u12ab\u1228\u120d\u129b" },
            { "kru", "\u12a9\u1229\u12ad" },
            { "ksb", "\u123b\u121d\u1263\u120b" },
            { "ksf", "\u1263\u134d\u12eb" },
            { "ksh", "\u12ae\u120d\u123d" },
            { "kum", "\u12a9\u121a\u12ed\u12ad" },
            { "kwk", "\u12ad\u12cb\u12ad\u12cb\u120b" },
            { "lad", "\u120b\u12f2\u1296" },
            { "lag", "\u120b\u1295\u130a" },
            { "lez", "\u1208\u12dd\u130d\u129b" },
            { "lij", "\u120a\u1309\u122d\u129b" },
            { "lil", "\u120a\u1209\u1275" },
            { "lkt", "\u120b\u12ae\u1273" },
            { "lou", "\u12ad\u122d\u12ee\u120d \u1209\u12ca\u12dd\u12eb\u1293" },
            { "loz", "\u120e\u12da" },
            { "lrc", "\u1230\u121c\u1293\u12ca \u1209\u122a" },
            { "lsm", "\u1233\u121d\u12eb" },
            { "lua", "\u1209\u1263-\u1209\u120d\u12cb" },
            { "lun", "\u1209\u1295\u12f3" },
            { "luo", "\u1209\u12a6" },
            { "lus", "\u121b\u12ed\u12de" },
            { "luy", "\u1209\u12ed\u12eb" },
            { "mad", "\u121b\u12f1\u122a\u12dd\u129b" },
            { "mag", "\u121b\u130b\u1202" },
            { "mai", "\u121b\u12ed\u1272\u120a" },
            { "mak", "\u121b\u12ab\u1233\u122d" },
            { "mas", "\u121b\u1233\u12ed" },
            { "mdf", "\u121e\u12ad\u123b" },
            { "men", "\u1218\u1295\u12f4" },
            { "mer", "\u1218\u1229" },
            { "mfe", "\u12ad\u122d\u12ee\u120d \u121b\u12cd\u122a\u123d\u12ed\u1293" },
            { "mgh", "\u121b\u12ad\u12cb-\u121c\u1276" },
            { "mgo", "\u1218\u1273" },
            { "mic", "\u121a\u12ad\u121b\u12ad" },
            { "min", "\u121a\u1293\u1295\u130d\u12ab\u1263\u12cd" },
            { "mni", "\u121b\u1292\u1351\u122a" },
            { "moe", "\u12a2\u1291-\u12a4\u1218\u1295" },
            { "moh", "\u121e\u1203\u12cd\u12ad" },
            { "mos", "\u121e\u1232" },
            { "mua", "\u1219\u1295\u12f3\u1295\u130d" },
            { "mul", "\u12dd\u1270\u1348\u120b\u1208\u12e9 \u124b\u1295\u124b\u1273\u1275" },
            { "mus", "\u12ad\u122a\u12ad" },
            { "mwl", "\u121a\u122b\u1295\u12f2\u12dd\u129b" },
            { "myv", "\u12a4\u122d\u12dd\u12eb" },
            { "mzn", "\u121b\u12db\u1295\u12f0\u122b\u1292" },
            { "nap", "\u1293\u1356\u120a\u1273\u1295\u129b" },
            { "naq", "\u1293\u121b" },
            { "nds", "\u1275\u1211\u1275 \u1300\u122d\u1218\u1295" },
            { "new", "\u1290\u12cb\u122a" },
            { "nia", "\u1295\u12eb\u1235" },
            { "niu", "\u1295\u12cc\u1295\u129b" },
            { "nmg", "\u12ad\u12cb\u1235\u12ee" },
            { "nnh", "\u12a4\u1295\u130c\u121d\u1261\u1295" },
            { "nog", "\u1296\u130b\u12ed\u129b" },
            { "nqo", "\u12a4\u1295\u12ae" },
            { "nso", "\u1230\u121c\u1293\u12ca \u1236\u1276" },
            { "nus", "\u1295\u12cc\u122d" },
            { "nyn", "\u1295\u12eb\u1295\u12ae\u120d" },
            { "ojb", "\u1230\u121c\u1293\u12ca \u121d\u12d5\u122b\u1265 \u12a6\u1302\u1265\u12cb" },
            { "ojc", "\u121b\u12a5\u12a8\u120b\u12ed \u12a6\u1302\u1265\u12cb" },
            { "ojs", "\u12a6\u1302-\u12ad\u122a" },
            { "ojw", "\u121d\u12d5\u122b\u1263\u12ca \u12a6\u1302\u1265\u12cb" },
            { "oka", "\u12a6\u12ab\u1293\u130b\u1295" },
            { "pag", "\u1353\u1295\u130b\u1232\u1293\u1295" },
            { "pam", "\u1353\u121d\u1353\u1295\u130b" },
            { "pap", "\u1353\u1355\u12eb\u1218\u1295\u1276" },
            { "pau", "\u1353\u120b\u12cd\u129b" },
            { "pcm", "\u1352\u1302\u1295 \u1293\u12ed\u1300\u122d\u12eb" },
            { "pis", "\u1352\u1302\u1295" },
            { "pqm", "\u121b\u120a\u1232\u1275-\u1353\u1233\u121b\u12b3\u12f2" },
            { "prg", "\u1355\u1229\u1235\u129b" },
            { "rap", "\u122b\u1353\u1291\u12ed" },
            { "rar", "\u122b\u122e\u1276\u1295\u130b\u1295\u129b" },
            { "rhg", "\u122e\u1202\u1295\u130d\u12eb" },
            { "rof", "\u122e\u121d\u1266" },
            { "rup", "\u12a3\u1229\u121b\u1295\u129b" },
            { "rwk", "\u122d\u12cb" },
            { "sad", "\u1233\u1295\u12f3\u12c8" },
            { "sah", "\u1233\u12bb" },
            { "saq", "\u1233\u121d\u1261\u1229" },
            { "sat", "\u1233\u1295\u1273\u120a" },
            { "sba", "\u12a4\u1295\u130b\u121d\u1263\u12ed" },
            { "sbp", "\u1233\u1295\u1309" },
            { "scn", "\u1232\u1232\u120d\u129b" },
            { "sco", "\u1235\u12ae\u1275\u129b" },
            { "seh", "\u1230\u1293" },
            { "ses", "\u12ae\u12ed\u122b\u1266\u122e \u1230\u1292" },
            { "shi", "\u1273\u1278\u120d\u1202\u1275" },
            { "shn", "\u123b\u1295" },
            { "slh", "\u12f0\u1261\u1263\u12ca \u1209\u1239\u1275\u1232\u12f5" },
            { "smn", "\u1233\u121a \u12a2\u1293\u122a" },
            { "sms", "\u1233\u121a \u1235\u12ae\u120d\u1275" },
            { "snk", "\u1236\u1292\u1295\u12a8" },
            { "srn", "\u1235\u122b\u1293\u1295 \u1276\u1295\u130e" },
            { "str", "\u1233\u120a\u123d \u1218\u133b\u1265\u1266\u1273\u1275" },
            { "suk", "\u1231\u12a9\u121b" },
            { "swb", "\u12ae\u121e\u122d\u129b" },
            { "syr", "\u1231\u122d\u1235\u1275" },
            { "tce", "\u12f0\u1261\u1263\u12ca \u1273\u1275\u127e\u1295" },
            { "tem", "\u1272\u121d\u1294" },
            { "teo", "\u1270\u1236" },
            { "tet", "\u1272\u1270\u121d" },
            { "tgx", "\u1273\u130a\u123d" },
            { "tht", "\u1273\u120d\u1270\u1295" },
            { "tig", "\u1275\u130d\u1228" },
            { "tlh", "\u12ad\u120a\u1295\u130e\u1295" },
            { "tli", "\u1275\u120a\u1295\u130a\u1275" },
            { "tok", "\u1276\u12aa \u1356\u1293" },
            { "tpi", "\u1276\u12ad \u1352\u1232\u1295" },
            { "trv", "\u1273\u122e\u12ae" },
            { "ttm", "\u1230\u121c\u1293\u12ca \u1273\u1275\u127e\u1295" },
            { "tum", "\u1270\u121d\u1261\u12ab" },
            { "tvl", "\u1271\u126b\u120d\u12cb\u1295\u129b" },
            { "twq", "\u1273\u1233\u12cb\u1245" },
            { "tyv", "\u1271\u126a\u1295\u129b" },
            { "tzm", "\u121b\u12a5\u12a8\u120b\u12ed \u12a3\u1275\u120b\u1235 \u1273\u121b\u12db\u12ed\u1275" },
            { "udm", "\u12e9\u12f5\u1219\u122d\u1275" },
            { "umb", "\u12a3\u121d\u1261\u1295\u12f1" },
            { "und", "\u12d8\u12ed\u1270\u1348\u120d\u1320 \u124b\u1295\u124b" },
            { "vai", "\u126b\u12ed" },
            { "vec", "\u126c\u1295\u1272\u12eb\u1295\u129b" },
            { "vun", "\u1269\u1295\u1306" },
            { "wae", "\u12cb\u120d\u1230\u122d" },
            { "wal", "\u12ce\u120b\u12ed\u1273\u129b" },
            { "war", "\u12cb\u122b\u12ed" },
            { "wuu", "\u127b\u12ed\u1293\u12ca \u12c9" },
            { "xal", "\u12ab\u120d\u121d\u12ed\u12ad" },
            { "xog", "\u1236\u130b" },
            { "yav", "\u12eb\u1295\u130d\u1260\u1295" },
            { "ybb", "\u12e8\u121d\u1263" },
            { "yrl", "\u1292\u1295\u130b\u1271" },
            { "yue", "\u12ab\u1295\u1276\u1295\u129b" },
            { "zgh", "\u121e\u122e\u12ab\u12ca \u121d\u12f1\u1265 \u1273\u121b\u12db\u12ed\u1275" },
            { "zun", "\u12d9\u129a" },
            { "zxx", "\u124b\u1295\u124b\u12ca \u1275\u1215\u12dd\u1276 \u12e8\u1208\u1295" },
            { "zza", "\u12db\u12db\u12aa" },
            { "Ethi", "\u134a\u12f0\u120d" },
            { "Latn", metaValue_la },
            { "Zsye", "\u12a2\u121e\u1302" },
            { "Zsym", "\u121d\u120d\u12ad\u1273\u1275" },
            { "Zxxx", "\u12d8\u12ed\u1270\u133b\u1215\u1348" },
            { "en_US", "\u12a5\u1295\u130d\u120a\u12dd\u129b (\u1215\u1261\u122b\u1275 \u1218\u1295\u130d\u1235\u1273\u1275)" },
            { "fa_AF", "\u12f3\u122a" },
            { "nl_BE", "\u134d\u120b\u121a\u123d" },
            { "ro_MD", "\u121e\u120d\u12f6\u1268\u129b" },
            { "sw_CD", "\u1235\u12cb\u1202\u120a (\u12ae\u1295\u130e)" },
            { "ar_001", "\u12d8\u1218\u1293\u12ca \u121d\u12f1\u1265 \u12d3\u1228\u1265" },
            { "key.ca", "\u12d3\u12cd\u12f0-\u12a3\u12cb\u122d\u1215" },
            { "key.cf", "\u1245\u122d\u133a \u1263\u1324\u122b" },
            { "key.cu", "\u1263\u1324\u122b" },
            { "key.nu", "\u1241\u133d\u122d\u1273\u1275" },
            { "nds_NL", "\u1275\u1211\u1275 \u1233\u12ad\u1230\u1295" },
            { "zh_Hans", "\u1240\u120a\u120d \u127b\u12ed\u1295\u129b" },
            { "zh_Hant", "\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b" },
            { "%%1959ACAD", "\u12a3\u12ab\u12f3\u121d\u12eb\u12ca" },
            { "ListKeyTypePattern", "{0}\u1366 {1}" },
            { "ListCompositionPattern", "{0}\u1363 {1}" },
        };
        return data;
    }
}
