/* simple-query.c generated by valac 0.56.0, the Vala compiler
 * generated from simple-query.vala, do not modify */

/*
 * Copyright (C) 2011, 2015 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <locale.h>
#include <gee.h>

enum  {
	FOLKS_SIMPLE_QUERY_0_PROPERTY,
	FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY,
	FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY,
	FOLKS_SIMPLE_QUERY_NUM_PROPERTIES
};
static GParamSpec* folks_simple_query_properties[FOLKS_SIMPLE_QUERY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksSimpleQueryPrivate {
	gchar* _query_string;
	gchar** _query_tokens;
	gint _query_tokens_length1;
	gint __query_tokens_size_;
	gchar* _query_locale;
};

static gint FolksSimpleQuery_private_offset;
static gpointer folks_simple_query_parent_class = NULL;

static void _folks_simple_query_update_query_string (FolksSimpleQuery* self,
                                              const gchar* query_string,
                                              const gchar* query_locale);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static guint folks_simple_query_real_is_match (FolksQuery* base,
                                        FolksIndividual* individual);
static guint _folks_simple_query_prop_contains_token (FolksSimpleQuery* self,
                                               FolksIndividual* individual,
                                               const gchar* individual_translit_locale,
                                               const gchar* prop_name,
                                               GParamSpec* prop_spec,
                                               const gchar* token);
static inline guint _folks_simple_query_string_matches_token (FolksSimpleQuery* self,
                                                const gchar* str,
                                                const gchar* token,
                                                const gchar* str_translit_locale);
static guint _folks_simple_query_prop_contains_token_fd_string (FolksSimpleQuery* self,
                                                         FolksIndividual* individual,
                                                         const gchar* individual_translit_locale,
                                                         const gchar* prop_name,
                                                         GParamSpec* prop_spec,
                                                         FolksAbstractFieldDetails* val,
                                                         const gchar* token);
static guint _folks_simple_query_prop_contains_token_fd_role (FolksSimpleQuery* self,
                                                       FolksIndividual* individual,
                                                       const gchar* individual_translit_locale,
                                                       const gchar* prop_name,
                                                       GParamSpec* prop_spec,
                                                       FolksAbstractFieldDetails* val,
                                                       const gchar* token);
static guint _folks_simple_query_prop_contains_token_fd_postal_address (FolksSimpleQuery* self,
                                                                 FolksIndividual* individual,
                                                                 const gchar* individual_translit_locale,
                                                                 const gchar* prop_name,
                                                                 GParamSpec* prop_spec,
                                                                 FolksAbstractFieldDetails* val,
                                                                 const gchar* token);
static void folks_simple_query_finalize (GObject * obj);
static GType folks_simple_query_get_type_once (void);
static void _vala_folks_simple_query_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_folks_simple_query_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
folks_simple_query_get_instance_private (FolksSimpleQuery* self)
{
	return G_STRUCT_MEMBER_P (self, FolksSimpleQuery_private_offset);
}

static void
_folks_simple_query_update_query_string (FolksSimpleQuery* self,
                                         const gchar* query_string,
                                         const gchar* query_locale)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query_string != NULL);
	_tmp0_ = g_strdup (query_string);
	_g_free0 (self->priv->_query_string);
	self->priv->_query_string = _tmp0_;
	_tmp1_ = g_strdup (query_locale);
	_g_free0 (self->priv->_query_locale);
	self->priv->_query_locale = _tmp1_;
	_tmp2_ = self->priv->_query_string;
	_tmp3_ = folks_simple_query_get_query_locale (self);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_str_tokenize_and_fold (_tmp2_, _tmp4_, NULL);
	self->priv->_query_tokens = (_vala_array_free (self->priv->_query_tokens, self->priv->_query_tokens_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_query_tokens = _tmp6_;
	self->priv->_query_tokens_length1 = _vala_array_length (_tmp5_);
	self->priv->__query_tokens_size_ = self->priv->_query_tokens_length1;
	g_debug ("simple-query.vala:102: Created simple query with tokens:");
	_tmp7_ = self->priv->_query_tokens;
	_tmp7__length1 = self->priv->_query_tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp7_;
		token_collection_length1 = _tmp7__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			gchar* _tmp8_;
			gchar* token = NULL;
			_tmp8_ = g_strdup (token_collection[token_it]);
			token = _tmp8_;
			{
				const gchar* _tmp9_;
				_tmp9_ = token;
				g_debug ("simple-query.vala:104: \t%s", _tmp9_);
				_g_free0 (token);
			}
		}
	}
	g_object_freeze_notify ((GObject*) self);
	g_object_notify ((GObject*) self, "query-string");
	g_object_notify ((GObject*) self, "query-locale");
	g_object_thaw_notify ((GObject*) self);
}

/**
   * Create a simple text query.
   *
   * @param query_string text to match contacts against. Results will match all
   * tokens within the whitespace-delimited string (logical-ANDing the tokens).
   * A value of "" will match all contacts. However, it is recommended to not
   * use a query at all if filtering is not required.
   * @param match_fields the field names to apply this query to. See
   * {@link Query.match_fields} for more details. An empty array will match all
   * contacts. However, it is recommended to use the
   * {@link IndividualAggregator} directly if filtering is not required.
   * {@link PersonaDetail} and {@link PersonaStore.detail_key} for pre-defined
   * field names.
   *
   * @since 0.11.0
   */
static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

FolksSimpleQuery*
folks_simple_query_construct (GType object_type,
                              const gchar* query_string,
                              gchar** match_fields,
                              gint match_fields_length1)
{
	FolksSimpleQuery * self = NULL;
	gchar** match_fields_safe = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint match_fields_safe_length1;
	gint _match_fields_safe_size_;
	const gchar* _tmp1_;
	g_return_val_if_fail (query_string != NULL, NULL);
	_tmp0_ = (match_fields != NULL) ? _vala_array_dup6 (match_fields, match_fields_length1) : match_fields;
	_tmp0__length1 = match_fields_length1;
	match_fields_safe = _tmp0_;
	match_fields_safe_length1 = _tmp0__length1;
	_match_fields_safe_size_ = match_fields_safe_length1;
	_tmp1_ = setlocale (LC_ALL, NULL);
	self = (FolksSimpleQuery*) g_object_new (object_type, "query-string", query_string, "match-fields", match_fields_safe, "query-locale", _tmp1_, NULL);
	match_fields_safe = (_vala_array_free (match_fields_safe, match_fields_safe_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

FolksSimpleQuery*
folks_simple_query_new (const gchar* query_string,
                        gchar** match_fields,
                        gint match_fields_length1)
{
	return folks_simple_query_construct (FOLKS_TYPE_SIMPLE_QUERY, query_string, match_fields, match_fields_length1);
}

/**
   * {@inheritDoc}
   *
   * @since 0.11.0
   */
static gpointer
_g_param_spec_ref0 (gpointer self)
{
	return self ? g_param_spec_ref (self) : NULL;
}

static guint
folks_simple_query_real_is_match (FolksQuery* base,
                                  FolksIndividual* individual)
{
	FolksSimpleQuery * self;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GeeHashSet* tokens_remaining = NULL;
	GeeHashSet* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* individual_translit_locale = NULL;
	guint match_score = 0U;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GeeHashSet* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	guint result;
	self = (FolksSimpleQuery*) base;
	g_return_val_if_fail (individual != NULL, 0U);
	_tmp1_ = self->priv->_query_tokens;
	_tmp1__length1 = self->priv->_query_tokens_length1;
	if (_tmp1__length1 < 1) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_ = 0;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp2_ = folks_query_get_match_fields ((FolksQuery*) self, &_tmp3_);
		_tmp2__length1 = _tmp3_;
		_tmp4_ = _tmp2_;
		_tmp4__length1 = _tmp2__length1;
		_tmp0_ = _tmp4__length1 < 1;
	}
	if (_tmp0_) {
		result = (guint) 1;
		return result;
	}
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	tokens_remaining = _tmp5_;
	_tmp6_ = self->priv->_query_tokens;
	_tmp6__length1 = self->priv->_query_tokens_length1;
	{
		gchar** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = _tmp6_;
		t_collection_length1 = _tmp6__length1;
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			gchar* _tmp7_;
			gchar* t = NULL;
			_tmp7_ = g_strdup (t_collection[t_it]);
			t = _tmp7_;
			{
				GeeHashSet* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = tokens_remaining;
				_tmp9_ = t;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				_g_free0 (t);
			}
		}
	}
	individual_translit_locale = NULL;
	match_score = (guint) 0;
	_tmp10_ = folks_query_get_match_fields ((FolksQuery*) self, &_tmp11_);
	_tmp10__length1 = _tmp11_;
	_tmp12_ = _tmp10_;
	_tmp12__length1 = _tmp10__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp12_;
		prop_name_collection_length1 = _tmp12__length1;
		for (prop_name_it = 0; prop_name_it < prop_name_collection_length1; prop_name_it = prop_name_it + 1) {
			gchar* _tmp13_;
			gchar* prop_name = NULL;
			_tmp13_ = g_strdup (prop_name_collection[prop_name_it]);
			prop_name = _tmp13_;
			{
				GObjectClass* iclass = NULL;
				GObjectClass* _tmp14_;
				GParamSpec* prop_spec = NULL;
				GObjectClass* _tmp15_;
				const gchar* _tmp16_;
				GParamSpec* _tmp17_;
				GParamSpec* _tmp18_;
				GParamSpec* _tmp19_;
				_tmp14_ = G_OBJECT_GET_CLASS ((GObject*) individual);
				iclass = _tmp14_;
				_tmp15_ = iclass;
				_tmp16_ = prop_name;
				_tmp17_ = g_object_class_find_property (_tmp15_, _tmp16_);
				_tmp18_ = _g_param_spec_ref0 (_tmp17_);
				prop_spec = _tmp18_;
				_tmp19_ = prop_spec;
				if (_tmp19_ == NULL) {
					const gchar* _tmp20_;
					_tmp20_ = prop_name;
					g_warning ("simple-query.vala:182: Folks.Individual does not contain property '%s'", _tmp20_);
				} else {
					GeeIterator* iter = NULL;
					GeeHashSet* _tmp21_;
					GeeIterator* _tmp22_;
					_tmp21_ = tokens_remaining;
					_tmp22_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp21_);
					iter = _tmp22_;
					while (TRUE) {
						GeeIterator* _tmp23_;
						gchar* token = NULL;
						GeeIterator* _tmp24_;
						gpointer _tmp25_;
						guint inc = 0U;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						GParamSpec* _tmp28_;
						const gchar* _tmp29_;
						_tmp23_ = iter;
						if (!gee_iterator_next (_tmp23_)) {
							break;
						}
						_tmp24_ = iter;
						_tmp25_ = gee_iterator_get (_tmp24_);
						token = (gchar*) _tmp25_;
						_tmp26_ = individual_translit_locale;
						_tmp27_ = prop_name;
						_tmp28_ = prop_spec;
						_tmp29_ = token;
						inc = _folks_simple_query_prop_contains_token (self, individual, _tmp26_, _tmp27_, _tmp28_, _tmp29_);
						match_score += inc;
						if (inc > ((guint) 0)) {
							GeeIterator* _tmp30_;
							GeeHashSet* _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							_tmp30_ = iter;
							gee_iterator_remove (_tmp30_);
							_tmp31_ = tokens_remaining;
							_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
							_tmp33_ = _tmp32_;
							if (_tmp33_ == 0) {
								result = match_score;
								_g_free0 (token);
								_g_object_unref0 (iter);
								_g_param_spec_unref0 (prop_spec);
								_g_free0 (prop_name);
								_g_free0 (individual_translit_locale);
								_g_object_unref0 (tokens_remaining);
								return result;
							}
						}
						_g_free0 (token);
					}
					_g_object_unref0 (iter);
				}
				_g_param_spec_unref0 (prop_spec);
				_g_free0 (prop_name);
			}
		}
	}
	_tmp34_ = tokens_remaining;
	_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	_vala_assert (_tmp36_ > 0, "tokens_remaining.size > 0");
	result = (guint) 0;
	_g_free0 (individual_translit_locale);
	_g_object_unref0 (tokens_remaining);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static guint
_folks_simple_query_prop_contains_token (FolksSimpleQuery* self,
                                         FolksIndividual* individual,
                                         const gchar* individual_translit_locale,
                                         const gchar* prop_name,
                                         GParamSpec* prop_spec,
                                         const gchar* token)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	if (FALSE) {
	} else {
		if (prop_spec->value_type == G_TYPE_STRING) {
			gchar* prop_value = NULL;
			gchar* _tmp0_ = NULL;
			gboolean _tmp1_ = FALSE;
			const gchar* _tmp2_;
			guint score = 0U;
			const gchar* _tmp4_;
			g_object_get ((GObject*) individual, prop_name, &_tmp0_, NULL);
			_g_free0 (prop_value);
			prop_value = _tmp0_;
			_tmp2_ = prop_value;
			if (_tmp2_ == NULL) {
				_tmp1_ = TRUE;
			} else {
				const gchar* _tmp3_;
				_tmp3_ = prop_value;
				_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
			}
			if (_tmp1_) {
				result = (guint) 0;
				_g_free0 (prop_value);
				return result;
			}
			_tmp4_ = prop_value;
			score = _folks_simple_query_string_matches_token (self, _tmp4_, token, individual_translit_locale);
			if (score > ((guint) 0)) {
				gboolean _tmp5_ = FALSE;
				if (g_strcmp0 (prop_name, "full-name") == 0) {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = g_strcmp0 (prop_name, "nickname") == 0;
				}
				if (_tmp5_) {
					result = score * 10;
					_g_free0 (prop_value);
					return result;
				} else {
					result = score * 2;
					_g_free0 (prop_value);
					return result;
				}
			}
			_g_free0 (prop_value);
		} else {
			if (prop_spec->value_type == FOLKS_TYPE_STRUCTURED_NAME) {
				FolksStructuredName* prop_value = NULL;
				FolksStructuredName* _tmp6_ = NULL;
				FolksStructuredName* _tmp7_;
				guint score = 0U;
				FolksStructuredName* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				FolksStructuredName* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				FolksStructuredName* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				g_object_get ((GObject*) individual, prop_name, &_tmp6_, NULL);
				_g_object_unref0 (prop_value);
				prop_value = _tmp6_;
				_tmp7_ = prop_value;
				if (_tmp7_ == NULL) {
					result = (guint) 0;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp8_ = prop_value;
				_tmp9_ = folks_structured_name_get_given_name (_tmp8_);
				_tmp10_ = _tmp9_;
				score = _folks_simple_query_string_matches_token (self, _tmp10_, token, individual_translit_locale);
				if (score > ((guint) 0)) {
					result = score * 10;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp11_ = prop_value;
				_tmp12_ = folks_structured_name_get_family_name (_tmp11_);
				_tmp13_ = _tmp12_;
				score = _folks_simple_query_string_matches_token (self, _tmp13_, token, individual_translit_locale);
				if (score > ((guint) 0)) {
					result = score * 10;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp14_ = prop_value;
				_tmp15_ = folks_structured_name_get_additional_names (_tmp14_);
				_tmp16_ = _tmp15_;
				score = _folks_simple_query_string_matches_token (self, _tmp16_, token, individual_translit_locale);
				if (score > ((guint) 0)) {
					result = score * 5;
					_g_object_unref0 (prop_value);
					return result;
				}
				_g_object_unref0 (prop_value);
			} else {
				if (prop_spec->value_type == GEE_TYPE_SET) {
					GeeSet* prop_value_set = NULL;
					GeeSet* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					GeeSet* _tmp19_;
					GeeSet* _tmp23_;
					GType _tmp24_;
					GType _tmp25_;
					g_object_get ((GObject*) individual, prop_name, &_tmp17_, NULL);
					_g_object_unref0 (prop_value_set);
					prop_value_set = _tmp17_;
					_tmp19_ = prop_value_set;
					if (_tmp19_ == NULL) {
						_tmp18_ = TRUE;
					} else {
						GeeSet* _tmp20_;
						gboolean _tmp21_;
						gboolean _tmp22_;
						_tmp20_ = prop_value_set;
						_tmp21_ = gee_collection_get_is_empty ((GeeCollection*) _tmp20_);
						_tmp22_ = _tmp21_;
						_tmp18_ = _tmp22_;
					}
					if (_tmp18_) {
						result = (guint) 0;
						_g_object_unref0 (prop_value_set);
						return result;
					}
					_tmp23_ = prop_value_set;
					_tmp24_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp23_);
					_tmp25_ = _tmp24_;
					if (g_type_is_a (_tmp25_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS)) {
						GeeSet* prop_value_afd = NULL;
						GeeSet* _tmp26_;
						GeeSet* _tmp27_;
						_tmp26_ = prop_value_set;
						_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, GEE_TYPE_SET) ? ((GeeSet*) _tmp26_) : NULL);
						prop_value_afd = _tmp27_;
						{
							GeeIterator* _val_it = NULL;
							GeeSet* _tmp28_;
							GeeIterator* _tmp29_;
							_tmp28_ = prop_value_afd;
							_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
							_val_it = _tmp29_;
							while (TRUE) {
								GeeIterator* _tmp30_;
								FolksAbstractFieldDetails* val = NULL;
								GeeIterator* _tmp31_;
								gpointer _tmp32_;
								FolksAbstractFieldDetails* _tmp33_;
								GType _tmp34_;
								GType _tmp35_;
								_tmp30_ = _val_it;
								if (!gee_iterator_next (_tmp30_)) {
									break;
								}
								_tmp31_ = _val_it;
								_tmp32_ = gee_iterator_get (_tmp31_);
								val = (FolksAbstractFieldDetails*) _tmp32_;
								_tmp33_ = val;
								_tmp34_ = folks_abstract_field_details_get_value_type (_tmp33_);
								_tmp35_ = _tmp34_;
								if (_tmp35_ == G_TYPE_STRING) {
									guint score = 0U;
									FolksAbstractFieldDetails* _tmp36_;
									_tmp36_ = val;
									score = _folks_simple_query_prop_contains_token_fd_string (self, individual, individual_translit_locale, prop_name, prop_spec, _tmp36_, token);
									if (score > ((guint) 0)) {
										if (g_strcmp0 (prop_name, "email-addresses") == 0) {
											result = score * 4;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_afd);
											_g_object_unref0 (prop_value_set);
											return result;
										} else {
											result = score * 2;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_afd);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									}
								} else {
									FolksAbstractFieldDetails* _tmp37_;
									GType _tmp38_;
									GType _tmp39_;
									_tmp37_ = val;
									_tmp38_ = folks_abstract_field_details_get_value_type (_tmp37_);
									_tmp39_ = _tmp38_;
									if (_tmp39_ == FOLKS_TYPE_ROLE) {
										guint score = 0U;
										FolksAbstractFieldDetails* _tmp40_;
										_tmp40_ = val;
										score = _folks_simple_query_prop_contains_token_fd_role (self, individual, individual_translit_locale, prop_name, prop_spec, _tmp40_, token);
										if (score > ((guint) 0)) {
											result = score * 1;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_afd);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									} else {
										FolksAbstractFieldDetails* _tmp41_;
										GType _tmp42_;
										GType _tmp43_;
										_tmp41_ = val;
										_tmp42_ = folks_abstract_field_details_get_value_type (_tmp41_);
										_tmp43_ = _tmp42_;
										if (_tmp43_ == FOLKS_TYPE_POSTAL_ADDRESS) {
											guint score = 0U;
											FolksAbstractFieldDetails* _tmp44_;
											_tmp44_ = val;
											score = _folks_simple_query_prop_contains_token_fd_postal_address (self, individual, individual_translit_locale, prop_name, prop_spec, _tmp44_, token);
											if (score > ((guint) 0)) {
												result = score * 3;
												_g_object_unref0 (val);
												_g_object_unref0 (_val_it);
												_g_object_unref0 (prop_value_afd);
												_g_object_unref0 (prop_value_set);
												return result;
											}
										} else {
											FolksAbstractFieldDetails* _tmp45_;
											GType _tmp46_;
											GType _tmp47_;
											const gchar* _tmp48_;
											_tmp45_ = val;
											_tmp46_ = folks_abstract_field_details_get_value_type (_tmp45_);
											_tmp47_ = _tmp46_;
											_tmp48_ = g_type_name (_tmp47_);
											g_warning ("Cannot check for match in detail type " "Gee.Set<AbstractFieldDetails<%s>>", _tmp48_);
											result = (guint) 0;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_afd);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									}
								}
								_g_object_unref0 (val);
							}
							_g_object_unref0 (_val_it);
						}
						_g_object_unref0 (prop_value_afd);
					} else {
						GeeSet* _tmp49_;
						GType _tmp50_;
						GType _tmp51_;
						_tmp49_ = prop_value_set;
						_tmp50_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp49_);
						_tmp51_ = _tmp50_;
						if (_tmp51_ == G_TYPE_STRING) {
							GeeSet* prop_value_string = NULL;
							GeeSet* _tmp52_;
							GeeSet* _tmp53_;
							_tmp52_ = prop_value_set;
							_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, GEE_TYPE_SET) ? ((GeeSet*) _tmp52_) : NULL);
							prop_value_string = _tmp53_;
							{
								GeeIterator* _val_it = NULL;
								GeeSet* _tmp54_;
								GeeIterator* _tmp55_;
								_tmp54_ = prop_value_string;
								_tmp55_ = gee_iterable_iterator ((GeeIterable*) _tmp54_);
								_val_it = _tmp55_;
								while (TRUE) {
									GeeIterator* _tmp56_;
									gchar* val = NULL;
									GeeIterator* _tmp57_;
									gpointer _tmp58_;
									gboolean _tmp59_ = FALSE;
									const gchar* _tmp60_;
									guint score = 0U;
									const gchar* _tmp62_;
									_tmp56_ = _val_it;
									if (!gee_iterator_next (_tmp56_)) {
										break;
									}
									_tmp57_ = _val_it;
									_tmp58_ = gee_iterator_get (_tmp57_);
									val = (gchar*) _tmp58_;
									_tmp60_ = val;
									if (_tmp60_ == NULL) {
										_tmp59_ = TRUE;
									} else {
										const gchar* _tmp61_;
										_tmp61_ = val;
										_tmp59_ = g_strcmp0 (_tmp61_, "") == 0;
									}
									if (_tmp59_) {
										_g_free0 (val);
										continue;
									}
									_tmp62_ = val;
									score = _folks_simple_query_string_matches_token (self, _tmp62_, token, individual_translit_locale);
									if (score > ((guint) 0)) {
										result = score * 1;
										_g_free0 (val);
										_g_object_unref0 (_val_it);
										_g_object_unref0 (prop_value_string);
										_g_object_unref0 (prop_value_set);
										return result;
									}
									_g_free0 (val);
								}
								_g_object_unref0 (_val_it);
							}
							_g_object_unref0 (prop_value_string);
						} else {
							GeeSet* _tmp63_;
							GType _tmp64_;
							GType _tmp65_;
							const gchar* _tmp66_;
							_tmp63_ = prop_value_set;
							_tmp64_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp63_);
							_tmp65_ = _tmp64_;
							_tmp66_ = g_type_name (_tmp65_);
							g_warning ("Cannot check for match in property ‘%s’, detail type " "Gee.Set<%s>", prop_name, _tmp66_);
							result = (guint) 0;
							_g_object_unref0 (prop_value_set);
							return result;
						}
					}
					_g_object_unref0 (prop_value_set);
				} else {
					if (prop_spec->value_type == GEE_TYPE_MULTI_MAP) {
						GeeMultiMap* prop_value_multi_map = NULL;
						GeeMultiMap* _tmp67_ = NULL;
						gboolean _tmp68_ = FALSE;
						GeeMultiMap* _tmp69_;
						GType key_type = 0UL;
						GeeMultiMap* _tmp73_;
						GType _tmp74_;
						GType _tmp75_;
						GType value_type = 0UL;
						GeeMultiMap* _tmp76_;
						GType _tmp77_;
						GType _tmp78_;
						gboolean _tmp79_ = FALSE;
						g_object_get ((GObject*) individual, prop_name, &_tmp67_, NULL);
						_g_object_unref0 (prop_value_multi_map);
						prop_value_multi_map = _tmp67_;
						_tmp69_ = prop_value_multi_map;
						if (_tmp69_ == NULL) {
							_tmp68_ = TRUE;
						} else {
							GeeMultiMap* _tmp70_;
							gint _tmp71_;
							gint _tmp72_;
							_tmp70_ = prop_value_multi_map;
							_tmp71_ = gee_multi_map_get_size (_tmp70_);
							_tmp72_ = _tmp71_;
							_tmp68_ = _tmp72_ < 1;
						}
						if (_tmp68_) {
							result = (guint) 0;
							_g_object_unref0 (prop_value_multi_map);
							return result;
						}
						_tmp73_ = prop_value_multi_map;
						_tmp74_ = gee_multi_map_get_key_type (_tmp73_);
						_tmp75_ = _tmp74_;
						key_type = _tmp75_;
						_tmp76_ = prop_value_multi_map;
						_tmp77_ = gee_multi_map_get_value_type (_tmp76_);
						_tmp78_ = _tmp77_;
						value_type = _tmp78_;
						if (g_type_is_a (key_type, G_TYPE_STRING)) {
							_tmp79_ = g_type_is_a (value_type, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS);
						} else {
							_tmp79_ = FALSE;
						}
						if (_tmp79_) {
							GeeMultiMap* prop_value_multi_map_afd = NULL;
							GeeMultiMap* _tmp80_;
							GeeMultiMap* _tmp81_;
							GeeMapIterator* iter = NULL;
							GeeMultiMap* _tmp82_;
							GeeMapIterator* _tmp83_;
							_tmp80_ = prop_value_multi_map;
							_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, GEE_TYPE_MULTI_MAP) ? ((GeeMultiMap*) _tmp80_) : NULL);
							prop_value_multi_map_afd = _tmp81_;
							_tmp82_ = prop_value_multi_map_afd;
							_tmp83_ = gee_multi_map_map_iterator (_tmp82_);
							iter = _tmp83_;
							while (TRUE) {
								GeeMapIterator* _tmp84_;
								FolksAbstractFieldDetails* val = NULL;
								GeeMapIterator* _tmp85_;
								gpointer _tmp86_;
								FolksAbstractFieldDetails* _tmp87_;
								GType _tmp88_;
								GType _tmp89_;
								_tmp84_ = iter;
								if (!gee_map_iterator_next (_tmp84_)) {
									break;
								}
								_tmp85_ = iter;
								_tmp86_ = gee_map_iterator_get_value (_tmp85_);
								val = (FolksAbstractFieldDetails*) _tmp86_;
								_tmp87_ = val;
								_tmp88_ = folks_abstract_field_details_get_value_type (_tmp87_);
								_tmp89_ = _tmp88_;
								if (_tmp89_ == G_TYPE_STRING) {
									guint score = 0U;
									FolksAbstractFieldDetails* _tmp90_;
									_tmp90_ = val;
									score = _folks_simple_query_prop_contains_token_fd_string (self, individual, individual_translit_locale, prop_name, prop_spec, _tmp90_, token);
									if (score > ((guint) 0)) {
										result = score * 2;
										_g_object_unref0 (val);
										_g_object_unref0 (iter);
										_g_object_unref0 (prop_value_multi_map_afd);
										_g_object_unref0 (prop_value_multi_map);
										return result;
									}
								}
								_g_object_unref0 (val);
							}
							_g_object_unref0 (iter);
							_g_object_unref0 (prop_value_multi_map_afd);
						} else {
							const gchar* _tmp91_;
							const gchar* _tmp92_;
							_tmp91_ = g_type_name (key_type);
							_tmp92_ = g_type_name (value_type);
							g_warning ("Cannot check for match in detail type " "Gee.MultiMap<%s, %s>", _tmp91_, _tmp92_);
							result = (guint) 0;
							_g_object_unref0 (prop_value_multi_map);
							return result;
						}
						_g_object_unref0 (prop_value_multi_map);
					} else {
						const gchar* _tmp93_;
						_tmp93_ = g_type_name (prop_spec->value_type);
						g_warning ("simple-query.vala:398: Cannot check for match in detail type %s", _tmp93_);
					}
				}
			}
		}
	}
	result = (guint) 0;
	return result;
}

static guint
_folks_simple_query_prop_contains_token_fd_string (FolksSimpleQuery* self,
                                                   FolksIndividual* individual,
                                                   const gchar* individual_translit_locale,
                                                   const gchar* prop_name,
                                                   GParamSpec* prop_spec,
                                                   FolksAbstractFieldDetails* val,
                                                   const gchar* token)
{
	gconstpointer _tmp3_;
	gconstpointer _tmp4_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	if (G_TYPE_FROM_INSTANCE ((GObject*) val) == FOLKS_TYPE_PHONE_FIELD_DETAILS) {
		FolksPhoneFieldDetails* _tmp0_;
		FolksPhoneFieldDetails* _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = folks_phone_field_details_new (token, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = folks_abstract_field_details_values_equal (val, (FolksAbstractFieldDetails*) _tmp1_);
		_g_object_unref0 (_tmp1_);
		if (_tmp2_) {
			result = (guint) 2;
			return result;
		}
	}
	_tmp3_ = folks_abstract_field_details_get_value (val);
	_tmp4_ = _tmp3_;
	result = _folks_simple_query_string_matches_token (self, (const gchar*) _tmp4_, token, individual_translit_locale);
	return result;
}

static guint
_folks_simple_query_prop_contains_token_fd_postal_address (FolksSimpleQuery* self,
                                                           FolksIndividual* individual,
                                                           const gchar* individual_translit_locale,
                                                           const gchar* prop_name,
                                                           GParamSpec* prop_spec,
                                                           FolksAbstractFieldDetails* val,
                                                           const gchar* token)
{
	guint score = 0U;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gconstpointer _tmp8_;
	gconstpointer _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gconstpointer _tmp12_;
	gconstpointer _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	_tmp0_ = folks_abstract_field_details_get_value (val);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_postal_address_get_street ((FolksPostalAddress*) _tmp1_);
	_tmp3_ = _tmp2_;
	score = _folks_simple_query_string_matches_token (self, _tmp3_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp4_ = folks_abstract_field_details_get_value (val);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_postal_address_get_locality ((FolksPostalAddress*) _tmp5_);
	_tmp7_ = _tmp6_;
	score = _folks_simple_query_string_matches_token (self, _tmp7_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp8_ = folks_abstract_field_details_get_value (val);
	_tmp9_ = _tmp8_;
	_tmp10_ = folks_postal_address_get_region ((FolksPostalAddress*) _tmp9_);
	_tmp11_ = _tmp10_;
	score = _folks_simple_query_string_matches_token (self, _tmp11_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp12_ = folks_abstract_field_details_get_value (val);
	_tmp13_ = _tmp12_;
	_tmp14_ = folks_postal_address_get_country ((FolksPostalAddress*) _tmp13_);
	_tmp15_ = _tmp14_;
	score = _folks_simple_query_string_matches_token (self, _tmp15_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	result = (guint) 0;
	return result;
}

static guint
_folks_simple_query_prop_contains_token_fd_role (FolksSimpleQuery* self,
                                                 FolksIndividual* individual,
                                                 const gchar* individual_translit_locale,
                                                 const gchar* prop_name,
                                                 GParamSpec* prop_spec,
                                                 FolksAbstractFieldDetails* val,
                                                 const gchar* token)
{
	guint score = 0U;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gconstpointer _tmp8_;
	gconstpointer _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	_tmp0_ = folks_abstract_field_details_get_value (val);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_role_get_organisation_name ((FolksRole*) _tmp1_);
	_tmp3_ = _tmp2_;
	score = _folks_simple_query_string_matches_token (self, _tmp3_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp4_ = folks_abstract_field_details_get_value (val);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_role_get_title ((FolksRole*) _tmp5_);
	_tmp7_ = _tmp6_;
	score = _folks_simple_query_string_matches_token (self, _tmp7_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp8_ = folks_abstract_field_details_get_value (val);
	_tmp9_ = _tmp8_;
	_tmp10_ = folks_role_get_role ((FolksRole*) _tmp9_);
	_tmp11_ = _tmp10_;
	score = _folks_simple_query_string_matches_token (self, _tmp11_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	result = (guint) 0;
	return result;
}

static inline guint
_folks_simple_query_string_matches_token (FolksSimpleQuery* self,
                                          const gchar* str,
                                          const gchar* token,
                                          const gchar* str_translit_locale)
{
	gchar** alternates = NULL;
	gint alternates_length1 = 0;
	gint _alternates_size_ = 0;
	gchar** str_tokens = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint str_tokens_length1;
	gint _str_tokens_size_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (str != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	g_debug ("simple-query.vala:492: Matching string ‘%s’ against token ‘%s’.", str, token);
	_tmp2_ = _tmp1_ = g_str_tokenize_and_fold (str, str_translit_locale, &_tmp0_);
	alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
	alternates = _tmp0_;
	alternates_length1 = -1;
	_alternates_size_ = alternates_length1;
	alternates_length1 = _vala_array_length (alternates);
	str_tokens = _tmp2_;
	str_tokens_length1 = _vala_array_length (_tmp1_);
	_str_tokens_size_ = str_tokens_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				gchar* str_token = NULL;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = str_tokens;
				_tmp5__length1 = str_tokens_length1;
				_tmp6_ = _tmp5_[i];
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = str_tokens;
				_tmp7__length1 = str_tokens_length1;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = g_strdup (_tmp8_);
				str_token = _tmp9_;
				_tmp10_ = str_token;
				if (g_strcmp0 (_tmp10_, token) == 0) {
					result = (guint) 3;
					_g_free0 (str_token);
					str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
					alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
					return result;
				} else {
					const gchar* _tmp11_;
					_tmp11_ = str_token;
					if (g_str_has_prefix (_tmp11_, token)) {
						result = (guint) 2;
						_g_free0 (str_token);
						str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
						alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
				_g_free0 (str_token);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* str_token = NULL;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = alternates;
				_tmp14__length1 = alternates_length1;
				_tmp15_ = _tmp14_[i];
				if (!(_tmp15_ != NULL)) {
					break;
				}
				_tmp16_ = alternates;
				_tmp16__length1 = alternates_length1;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = g_strdup (_tmp17_);
				str_token = _tmp18_;
				_tmp19_ = str_token;
				if (g_strcmp0 (_tmp19_, token) == 0) {
					result = (guint) 2;
					_g_free0 (str_token);
					str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
					alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
					return result;
				} else {
					const gchar* _tmp20_;
					_tmp20_ = str_token;
					if (g_str_has_prefix (_tmp20_, token)) {
						result = (guint) 1;
						_g_free0 (str_token);
						str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
						alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
				_g_free0 (str_token);
			}
		}
	}
	result = (guint) 0;
	str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
	alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

const gchar*
folks_simple_query_get_query_string (FolksSimpleQuery* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query_string;
	result = _tmp0_;
	return result;
}

void
folks_simple_query_set_query_string (FolksSimpleQuery* self,
                                     const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		value = "";
	}
	_tmp0_ = self->priv->_query_string;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = self->priv->_query_locale;
	_folks_simple_query_update_query_string (self, value, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, folks_simple_query_properties[FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY]);
}

const gchar*
folks_simple_query_get_query_locale (FolksSimpleQuery* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query_locale;
	result = _tmp0_;
	return result;
}

void
folks_simple_query_set_query_locale (FolksSimpleQuery* self,
                                     const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_query_locale;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = self->priv->_query_string;
	_folks_simple_query_update_query_string (self, _tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, folks_simple_query_properties[FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY]);
}

static void
folks_simple_query_class_init (FolksSimpleQueryClass * klass,
                               gpointer klass_data)
{
	folks_simple_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksSimpleQuery_private_offset);
	((FolksQueryClass *) klass)->is_match = (guint (*) (FolksQuery*, FolksIndividual*)) folks_simple_query_real_is_match;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_simple_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_simple_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_simple_query_finalize;
	/**
	   * The text query string.
	   *
	   * This re-evaluates the query immediately, so most clients should implement
	   * de-bouncing to ensure re-evaluation only happens when (for example) the
	   * user has stopped typing a new query.
	   *
	   * @since 0.11.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY, folks_simple_query_properties[FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY] = g_param_spec_string ("query-string", "query-string", "query-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Locale to interpret the {@link SimpleQuery.query_string} in.
	   *
	   * If possible, locale-specific query string transliteration is done to
	   * increase the number of matches. Set this property to a POSIX locale name
	   * (e.g. ‘en’, ‘de_DE’, ‘de_DE@euro’ or ‘C’) to potentially improve the
	   * transliteration performed.
	   *
	   * This may be `null` if the locale is unknown, in which case the current
	   * locale will be used. To perform transliteration for no specific locale,
	   * use `C`.
	   *
	   * @since 0.11.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY, folks_simple_query_properties[FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY] = g_param_spec_string ("query-locale", "query-locale", "query-locale", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
folks_simple_query_instance_init (FolksSimpleQuery * self,
                                  gpointer klass)
{
	self->priv = folks_simple_query_get_instance_private (self);
	self->priv->_query_locale = NULL;
}

static void
folks_simple_query_finalize (GObject * obj)
{
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	_g_free0 (self->priv->_query_string);
	self->priv->_query_tokens = (_vala_array_free (self->priv->_query_tokens, self->priv->_query_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_query_locale);
	G_OBJECT_CLASS (folks_simple_query_parent_class)->finalize (obj);
}

/**
 * A simple text-based contact query.
 *
 * This is a generic implementation of the {@link Query} interface which
 * supports general UI-style search use cases. It implements case-insensitive
 * prefix matching, with transliteration of accents and other non-ASCII
 * characters to improve matching against accented characters. It also
 * normalises phone numbers to make matches invariant to hyphenation and spacing
 * in phone numbers.
 *
 * @see SearchView
 * @since 0.11.0
 */
static GType
folks_simple_query_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksSimpleQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_simple_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksSimpleQuery), 0, (GInstanceInitFunc) folks_simple_query_instance_init, NULL };
	GType folks_simple_query_type_id;
	folks_simple_query_type_id = g_type_register_static (FOLKS_TYPE_QUERY, "FolksSimpleQuery", &g_define_type_info, 0);
	FolksSimpleQuery_private_offset = g_type_add_instance_private (folks_simple_query_type_id, sizeof (FolksSimpleQueryPrivate));
	return folks_simple_query_type_id;
}

GType
folks_simple_query_get_type (void)
{
	static volatile gsize folks_simple_query_type_id__once = 0;
	if (g_once_init_enter (&folks_simple_query_type_id__once)) {
		GType folks_simple_query_type_id;
		folks_simple_query_type_id = folks_simple_query_get_type_once ();
		g_once_init_leave (&folks_simple_query_type_id__once, folks_simple_query_type_id);
	}
	return folks_simple_query_type_id__once;
}

static void
_vala_folks_simple_query_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	switch (property_id) {
		case FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY:
		g_value_set_string (value, folks_simple_query_get_query_string (self));
		break;
		case FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY:
		g_value_set_string (value, folks_simple_query_get_query_locale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_simple_query_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	switch (property_id) {
		case FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY:
		folks_simple_query_set_query_string (self, g_value_get_string (value));
		break;
		case FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY:
		folks_simple_query_set_query_locale (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

