/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ca extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Hora de l\u2019\u00c0frica Central",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Hora est\u00e0ndard de Moscou",
               "MSK",
               "Hora d\u2019estiu de Moscou",
               "MSD",
               "Hora de Moscou",
               "MT",
            };
        final String[] Japan = new String[] {
               "Hora est\u00e0ndard del Jap\u00f3",
               "JST",
               "Hora d\u2019estiu del Jap\u00f3",
               "JDT",
               "Hora del Jap\u00f3",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Hora est\u00e0ndard del Pakistan",
               "PKT",
               "Hora d\u2019estiu del Pakistan",
               "PKST",
               "Hora del Pakistan",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Hora est\u00e0ndard de Taipei",
               "CST",
               "Hora d\u2019estiu de Taipei",
               "CDT",
               "Hora de Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hora est\u00e0ndard de Hovd",
               "HOVT",
               "Hora d\u2019estiu de Hovd",
               "HOVST",
               "Hora de Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Hora est\u00e0ndard de Magadan",
               "MAGT",
               "Hora d\u2019estiu de Magadan",
               "MAGST",
               "Hora de Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora est\u00e0ndard d\u2019Austr\u00e0lia centre-occidental",
               "ACWST",
               "Hora d\u2019estiu d\u2019Austr\u00e0lia centre-occidental",
               "ACWDT",
               "Hora d\u2019Austr\u00e0lia centre-occidental",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Hora est\u00e0ndard del Centre d\u2019Europa",
               "CET",
               "Hora d\u2019estiu del Centre d\u2019Europa",
               "CEST",
               "Hora del Centre d\u2019Europa",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Hora est\u00e0ndard de Sakhalin",
               "SAKT",
               "Hora d\u2019estiu de Sakhalin",
               "SAKST",
               "Hora de Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Hora est\u00e0ndard del Paraguai",
               "PYT",
               "Hora d\u2019estiu del Paraguai",
               "PYST",
               "Hora del Paraguai",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Hora de Mal\u00e0isia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Hora est\u00e0ndard oriental d\u2019Am\u00e8rica del Nord",
               "EST",
               "Hora d\u2019estiu oriental d\u2019Am\u00e8rica del Nord",
               "EDT",
               "Hora oriental d\u2019Am\u00e8rica del Nord",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Hora est\u00e0ndard de Lord Howe",
               "LHST",
               "Horari d\u2019estiu de Lord Howe",
               "LHDT",
               "Hora de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Hora est\u00e0ndard de Nova Zelanda",
               "NZST",
               "Hora d\u2019estiu de Nova Zelanda",
               "NZDT",
               "Hora de Nova Zelanda",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora de l\u2019oce\u00e0 \u00cdndic",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Hora est\u00e0ndard de Iakutsk",
               "YAKT",
               "Hora d\u2019estiu de Iakutsk",
               "YAKST",
               "Hora de Iakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Hora est\u00e0ndard de Maurici",
               "MUT",
               "Hora d\u2019estiu de Maurici",
               "MUST",
               "Hora de Maurici",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora de l\u2019\u00c0frica Oriental",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Oriental",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Hora de Salom\u00f3",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora de les illes Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora est\u00e0ndard de l\u2019Est d\u2019Europa",
               "EET",
               "Hora d\u2019estiu de l\u2019Est d\u2019Europa",
               "EEST",
               "Hora de l\u2019Est d\u2019Europa",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Hora est\u00e0ndard de Terranova",
               "NST",
               "Hora d\u2019estiu de Terranova",
               "NDT",
               "Hora de Terranova",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Hora de l\u2019Afganistan",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hora est\u00e0ndard de Hong Kong",
               "HKT",
               "Hora d\u2019estiu de Hong Kong",
               "HKST",
               "Hora de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Hora est\u00e0ndard de l\u2019oest de l\u2019Argentina",
               "ART",
               "Hora d\u2019estiu de l\u2019oest de l\u2019Argentina",
               "ARST",
               "Hora de l\u2019oest de l\u2019Argentina",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Hora est\u00e0ndard de l\u2019Atl\u00e0ntic",
               "AST",
               "Hora d\u2019estiu de l\u2019Atl\u00e0ntic",
               "ADT",
               "Hora de l\u2019Atl\u00e0ntic",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Hora de Bol\u00edvia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora est\u00e0ndard de Saint-Pierre i Miquelon",
               "PMST",
               "Hora d\u2019estiu de Saint-Pierre i Miquelon",
               "PMDT",
               "Hora de Saint-Pierre i Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Hora d\u2019Indoxina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora est\u00e0ndard d\u2019Ekaterinburg",
               "YEKT",
               "Hora d\u2019estiu d\u2019Ekaterinburg",
               "YEKST",
               "Hora d\u2019Ekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Hora de les Maldives",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Hora de Tahit\u00ed",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Hora est\u00e0ndard d\u2019Israel",
               "IST",
               "Hora d\u2019estiu d\u2019Israel",
               "IDT",
               "Hora d\u2019Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora central d\u2019Indon\u00e8sia",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis i Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora est\u00e0ndard del sud de l\u2019\u00c0frica",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Hora de Line Islands",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Hora est\u00e0ndard de l\u2019Uzbekistan",
               "UZT",
               "Hora d\u2019estiu de l\u2019Uzbekistan",
               "UZST",
               "Hora de l\u2019Uzbekistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Hora est\u00e0ndard d\u2019Omsk",
               "OMST",
               "Hora d\u2019estiu d\u2019Omsk",
               "OMSST",
               "Hora d\u2019Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Hora de les Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Hora est\u00e0ndard de l\u2019Uruguai",
               "UYT",
               "Hora d\u2019estiu de l\u2019Uruguai",
               "UYST",
               "Hora de l\u2019Uruguai",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Hora del Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Hora est\u00e0ndard d\u2019Ulan Bator",
               "ULAT",
               "Hora d\u2019estiu d\u2019Ulan Bator",
               "ULAST",
               "Hora d\u2019Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Hora est\u00e0ndard central d\u2019Am\u00e8rica del Nord",
               "CST",
               "Hora d\u2019estiu central d\u2019Am\u00e8rica del Nord",
               "CDT",
               "Hora central d\u2019Am\u00e8rica del Nord",
               "CT",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Hora de Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Hora de Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Hora est\u00e0ndard de les illes Malvines",
               "FKT",
               "Hora d\u2019estiu de les illes Malvines",
               "FKST",
               "Hora de les illes Malvines",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Hora est\u00e0ndard de Vanatu",
               "VUT",
               "Hora d\u2019estiu de Vanatu",
               "VUST",
               "Hora de Vanatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora est\u00e0ndard de Novosibirsk",
               "NOVT",
               "Hora d\u2019estiu de Novosibirsk",
               "NOVST",
               "Hora de Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Hora de Singapur",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Hora est\u00e0ndard de les A\u00e7ores",
               "AZOT",
               "Hora d\u2019estiu de les A\u00e7ores",
               "AZOST",
               "Hora de les A\u00e7ores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Hora est\u00e0ndard d\u2019Apia",
               "WSST",
               "Hora d\u2019estiu d\u2019Apia",
               "WSDT",
               "Hora d\u2019Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Hora de Bhutan",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Hora de Surinam",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora est\u00e0ndard de Krasnoiarsk",
               "KRAT",
               "Hora d\u2019estiu de Krasnoiarsk",
               "KRAST",
               "Hora de Krasnoiarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora de l\u2019oest del Kazakhstan",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Hora de Myanmar",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Hora de Kiritimati",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Hora est\u00e0ndard de l\u2019Amazones",
               "AMT",
               "Hora d\u2019estiu de l\u2019Amazones",
               "AMST",
               "Hora de l\u2019Amazones",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora de l\u2019est del Kazakhstan",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Hora est\u00e0ndard de Fiji",
               "FJT",
               "Hora d\u2019estiu de Fiji",
               "FJST",
               "Hora de Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Hora de Reuni\u00f3",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Hora de les illes Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Hora est\u00e0ndard de Chatham",
               "CHAST",
               "Hora d\u2019estiu de Chatham",
               "CHADT",
               "Hora de Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Hora est\u00e0ndard de l\u2019Argentina",
               "ART",
               "Hora d\u2019estiu de l\u2019Argentina",
               "ARST",
               "Hora de l\u2019Argentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Hora est\u00e0ndard de Petropavlovsk de Kamtxatka",
               "PETT",
               "Horari d\u2019estiu de Petropavlovsk de Kamtxatka",
               "PETST",
               "Hora de Kamtxatka",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Hora de Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Hora de Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Hora de Vene\u00e7uela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora est\u00e0ndard de Hawaii-Aleutianes",
               "HAST",
               "Hora d\u2019estiu de Hawaii-Aleutianes",
               "HADT",
               "Hora de Hawaii-Aleutianes",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Hora est\u00e0ndard d\u2019Austr\u00e0lia Central",
               "ACST",
               "Hora d\u2019estiu d\u2019Austr\u00e0lia Central",
               "ACDT",
               "Hora d\u2019Austr\u00e0lia Central",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Hora est\u00e0ndard del Pac\u00edfic",
               "PST",
               "Hora d\u2019estiu del Pac\u00edfic",
               "PDT",
               "Hora del Pac\u00edfic",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora de les illes Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora est\u00e0ndard del Turkmenistan",
               "TMT",
               "Hora d\u2019estiu del Turkmenistan",
               "TMST",
               "Hora del Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Hora est\u00e0ndard de l\u2019Oest d\u2019Europa",
               "WET",
               "Hora d\u2019estiu de l\u2019Oest d\u2019Europa",
               "WEST",
               "Hora de l\u2019Oest d\u2019Europa",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Hora est\u00e0ndard de Cap Verd",
               "CVT",
               "Hora d\u2019estiu de Cap Verd",
               "CVST",
               "Hora de Cap Verd",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Hora de les illes Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Hora de Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Hora est\u00e0ndard de Samoa",
               "SST",
               "Hora d\u2019estiu de Samoa",
               "SDT",
               "Hora de Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Hora de l\u2019Extrem Orient Europeu",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Hora est\u00e0ndard d\u2019Azerbaidjan",
               "AZT",
               "Hora d\u2019estiu d\u2019Azerbaidjan",
               "AZST",
               "Hora d\u2019Azerbaidjan",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora est\u00e0ndard del Pac\u00edfic de M\u00e8xic",
               "MST",
               "Hora d\u2019estiu del Pac\u00edfic de M\u00e8xic",
               "MDT",
               "Hora del Pac\u00edfic de M\u00e8xic",
               "MT",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Hora est\u00e0ndard de Cuba",
               "CST",
               "Hora d\u2019estiu de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Hora est\u00e0ndard de l\u2019\u00c0frica Occidental",
               "CAT",
               "Hora d\u2019estiu de l\u2019\u00c0frica Occidental",
               "CAST",
               "Hora de l\u2019\u00c0frica Occidental",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Hora del Meridi\u00e0 de Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Hora est\u00e0ndard de Filipines",
               "PHT",
               "Hora d\u2019estiu de Filipines",
               "PHST",
               "Hora de Filipines",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Hora d\u2019Ant\u00e0rtida i Fran\u00e7a del Sud",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Hora de Ge\u00f2rgia del Sud",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Hora est\u00e0ndard de Nova Caled\u00f2nia",
               "NCT",
               "Hora d\u2019estiu de Nova Caled\u00f2nia",
               "NCST",
               "Hora de Nova Caled\u00f2nia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Hora de Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Hora est\u00e0ndard d\u2019Iran",
               "IRST",
               "Hora d\u2019estiu d\u2019Iran",
               "IRDT",
               "Hora d\u2019Iran",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Hora est\u00e0ndard de l\u2019illa de Pasqua",
               "EAST",
               "Hora d\u2019estiu de l\u2019illa de Pasqua",
               "EASST",
               "Hora de l\u2019illa de Pasqua",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hora est\u00e0ndard del nord-oest de M\u00e8xic",
               "PST",
               "Hora d\u2019estiu del nord-oest de M\u00e8xic",
               "PDT",
               "Hora del nord-oest de M\u00e8xic",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Hora del Tadjikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Hora est\u00e0ndard de Tonga",
               "TOT",
               "Hora d\u2019estiu de Tonga",
               "TOST",
               "Hora de Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Hora est\u00e0ndard de Bangla Desh",
               "BDT",
               "Hora d\u2019estiu de Bangla Desh",
               "BDST",
               "Hora de Bangla Desh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Hora est\u00e0ndard del Per\u00fa",
               "PET",
               "Hora d\u2019estiu del Per\u00fa",
               "PEST",
               "Hora del Per\u00fa",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Hora est\u00e0ndard de l\u2019Oest de Grenl\u00e0ndia",
               "WGT",
               "Hora d\u2019estiu de l\u2019Oest de Grenl\u00e0ndia",
               "WGST",
               "Hora de l\u2019Oest de Grenl\u00e0ndia",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Hora de l\u2019Equador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora est\u00e0ndard de l\u2019Est de Grenl\u00e0ndia",
               "EGT",
               "Hora d\u2019estiu de l\u2019Est de Grenl\u00e0ndia",
               "EGST",
               "Hora de l\u2019Est de Grenl\u00e0ndia",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Hora del Golf",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora de l\u2019est d\u2019Indon\u00e8sia",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Hora est\u00e0ndard de Corea",
               "KST",
               "Hora d\u2019estiu de Corea",
               "KDT",
               "Hora de Corea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Hora est\u00e0ndard d\u2019Austr\u00e0lia Occidental",
               "AWST",
               "Hora d\u2019estiu d\u2019Austr\u00e0lia Occidental",
               "AWDT",
               "Hora d\u2019Austr\u00e0lia Occidental",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Hora del Kirguizistan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora de l\u2019oest d\u2019Indon\u00e8sia",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora est\u00e0ndard d\u2019Austr\u00e0lia Oriental",
               "AEST",
               "Hora d\u2019estiu d\u2019Austr\u00e0lia Oriental",
               "AEDT",
               "Hora d\u2019Austr\u00e0lia Oriental",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Hora de la Guaiana Francesa",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Hora est\u00e0ndard de Col\u00f2mbia",
               "COT",
               "Hora d\u2019estiu de Col\u00f2mbia",
               "COST",
               "Hora de Col\u00f2mbia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Hora est\u00e0ndard de Xile",
               "CLT",
               "Hora d\u2019estiu de Xile",
               "CLST",
               "Hora de Xile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora de les illes Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Hora est\u00e0ndard de muntanya d\u2019Am\u00e8rica del Nord",
               "MST",
               "Hora d\u2019estiu de muntanya d\u2019Am\u00e8rica del Nord",
               "MDT",
               "Hora de muntanya d\u2019Am\u00e8rica del Nord",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Hora de les Marqueses",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Hora est\u00e0ndard \u00e0rab",
               "AST",
               "Hora d\u2019estiu \u00e0rab",
               "ADT",
               "Hora \u00e0rab",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Hora est\u00e0ndard d\u2019Alaska",
               "AKST",
               "Hora d\u2019estiu d\u2019Alaska",
               "AKDT",
               "Hora d\u2019Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Hora est\u00e0ndard de Vladivostok",
               "VLAT",
               "Hora d\u2019estiu de Vladivostok",
               "VLAST",
               "Hora de Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Hora de Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Hora est\u00e0ndard d\u2019Irkutsk",
               "IRKT",
               "Hora d\u2019estiu d\u2019Irkutsk",
               "IRKST",
               "Hora d\u2019Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Hora est\u00e0ndard de Ge\u00f2rgia",
               "GET",
               "Hora d\u2019estiu de Ge\u00f2rgia",
               "GEST",
               "Hora de Ge\u00f2rgia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Papua Nova Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Hora est\u00e0ndard de Fernando de Noronha",
               "FNT",
               "Hora d\u2019estiu de Fernando de Noronha",
               "FNST",
               "Hora de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Hora est\u00e0ndard de Choibalsan",
               "CHOT",
               "Hora d\u2019estiu de Choibalsan",
               "CHOST",
               "Hora de Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Hora est\u00e0ndard de Bras\u00edlia",
               "BRT",
               "Hora d\u2019estiu de Bras\u00edlia",
               "BRST",
               "Hora de Bras\u00edlia",
               "BRT",
            };
        final String[] China = new String[] {
               "Hora est\u00e0ndard de la Xina",
               "CST",
               "Hora d\u2019estiu de la Xina",
               "CDT",
               "Hora de la Xina",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Hora est\u00e0ndard d\u2019Arm\u00e8nia",
               "AMT",
               "Hora d\u2019estiu d\u2019Arm\u00e8nia",
               "AMST",
               "Hora d\u2019Arm\u00e8nia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Hora est\u00e0ndard de Samara",
               "SAMT",
               "Hora d\u2019estiu de Samara",
               "SAMST",
               "Hora de Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Hora est\u00e0ndard de l\u2019\u00cdndia",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Hora est\u00e0ndard de les illes Cook",
               "CKT",
               "Hora de mig estiu de les illes Cook",
               "CKHST",
               "Hora de les illes Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Hora del Meridi\u00e0 de Greenwich",
                    "GMT",
                    "Hora d\u2019estiu brit\u00e0nica",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Hora del Meridi\u00e0 de Greenwich",
                    "GMT",
                    "Hora est\u00e0ndard d\u2019Irlanda",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
