/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.catalina.Host;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class ExpandWar {
    private static final Log log = LogFactory.getLog(ExpandWar.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");

    public static String expand(Host host, URL uRL, String string) throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        jarURLConnection.setUseCaches(false);
        URL uRL2 = jarURLConnection.getJarFileURL();
        URLConnection uRLConnection = uRL2.openConnection();
        boolean bl = false;
        File file = new File(host.getAppBaseFile(), string);
        File file2 = new File(host.getAppBaseFile(), string + "/META-INF/war-tracker");
        long l = -1L;
        Object object = uRLConnection.getInputStream();
        Serializable serializable = null;
        try {
            l = uRLConnection.getLastModified();
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (serializable != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)serializable).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)object).close();
                }
            }
        }
        if (file.exists()) {
            if (!file2.exists() || file2.lastModified() == l) {
                bl = true;
                return file.getAbsolutePath();
            }
            log.info((Object)sm.getString("expandWar.deleteOld", new Object[]{file}));
            if (!ExpandWar.delete(file)) {
                throw new IOException(sm.getString("expandWar.deleteFailed", new Object[]{file}));
            }
        }
        if (!file.mkdir() && !file.isDirectory()) {
            throw new IOException(sm.getString("expandWar.createFailed", new Object[]{file}));
        }
        object = file.getCanonicalFile().toPath();
        serializable = file2.getParentFile();
        if (!((File)serializable).isDirectory() && !((File)serializable).mkdirs()) {
            throw new IOException(sm.getString("expandWar.createFailed", new Object[]{((File)serializable).getAbsolutePath()}));
        }
        try (JarFile jarFile = jarURLConnection.getJarFile();){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                Object object2;
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                File file3 = new File(file, string2);
                if (!file3.getCanonicalFile().toPath().startsWith((Path)object)) {
                    throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", new Object[]{uRL, string2, file3.getCanonicalPath(), object}));
                }
                int n = string2.lastIndexOf(47);
                if (n >= 0 && !((File)(object2 = new File(file, string2.substring(0, n)))).mkdirs() && !((File)object2).isDirectory()) {
                    throw new IOException(sm.getString("expandWar.createFailed", new Object[]{object2}));
                }
                if (string2.endsWith("/")) continue;
                object2 = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    if (null == object2) {
                        throw new ZipException(sm.getString("expandWar.missingJarEntry", new Object[]{jarEntry.getName()}));
                    }
                    ExpandWar.expand((InputStream)object2, file3);
                    long l2 = jarEntry.getTime();
                    if (l2 == -1L || l2 == 0L || file3.setLastModified(l2)) continue;
                    throw new IOException(sm.getString("expandWar.lastModifiedFailed", new Object[]{file3}));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object2 == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)object2).close();
                }
            }
            if (!file2.createNewFile()) {
                throw new IOException(sm.getString("expandWar.createFileFailed", new Object[]{file2}));
            }
            if (!file2.setLastModified(l)) {
                throw new IOException(sm.getString("expandWar.lastModifiedFailed", new Object[]{file2}));
            }
            bl = true;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (!bl) {
                ExpandWar.deleteDir(file);
            }
        }
        return file.getAbsolutePath();
    }

    public static void validate(Host host, URL uRL, String string) throws IOException {
        File file = new File(host.getAppBaseFile(), string);
        Path path = file.getCanonicalFile().toPath();
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        jarURLConnection.setUseCaches(false);
        try (JarFile jarFile = jarURLConnection.getJarFile();){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                File file2 = new File(file, string2);
                if (file2.getCanonicalFile().toPath().startsWith(path)) continue;
                throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", new Object[]{uRL, string2, file2.getCanonicalPath(), path}));
            }
        }
    }

    public static boolean copy(File file, File file2) {
        boolean bl = true;
        String[] stringArray = null;
        if (file.isDirectory()) {
            stringArray = file.list();
            bl = file2.mkdir();
        } else {
            stringArray = new String[]{""};
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length && bl; ++i) {
            File file3 = new File(file, stringArray[i]);
            File file4 = new File(file2, stringArray[i]);
            if (file3.isDirectory()) {
                bl = ExpandWar.copy(file3, file4);
                continue;
            }
            try (FileChannel fileChannel = new FileInputStream(file3).getChannel();
                 FileChannel fileChannel2 = new FileOutputStream(file4).getChannel();){
                long l;
                long l2 = 0L;
                for (long j = fileChannel.size(); j > 0L; j -= l) {
                    l = fileChannel.transferTo(l2, j, fileChannel2);
                    if (l > 0L) {
                        l2 += l;
                        continue;
                    }
                    throw new EOFException();
                }
                continue;
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("expandWar.copy", new Object[]{file3, file4}), (Throwable)iOException);
                bl = false;
            }
        }
        return bl;
    }

    public static boolean delete(File file) {
        return ExpandWar.delete(file, true);
    }

    public static boolean delete(File file, boolean bl) {
        boolean bl2 = file.isDirectory() ? ExpandWar.deleteDir(file, bl) : (file.exists() ? file.delete() : true);
        if (bl && !bl2) {
            log.error((Object)sm.getString("expandWar.deleteFailed", new Object[]{file.getAbsolutePath()}));
        }
        return bl2;
    }

    public static boolean deleteDir(File file) {
        return ExpandWar.deleteDir(file, true);
    }

    public static boolean deleteDir(File file, boolean bl) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (String string : stringArray) {
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                ExpandWar.deleteDir(file2, bl);
                continue;
            }
            file2.delete();
        }
        boolean bl2 = file.exists() ? file.delete() : true;
        if (bl && !bl2) {
            log.error((Object)sm.getString("expandWar.deleteFailed", new Object[]{file.getAbsolutePath()}));
        }
        return bl2;
    }

    private static void expand(InputStream inputStream, File file) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            int n;
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
    }
}

