/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.IOException;
import java.util.Map;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PerUserPoolDataSource;

public class PerUserPoolDataSourceFactory
extends InstanceKeyDataSourceFactory {
    private static final String PER_USER_POOL_CLASSNAME = PerUserPoolDataSource.class.getName();

    @Override
    protected boolean isCorrectClass(String string) {
        return PER_USER_POOL_CLASSNAME.equals(string);
    }

    @Override
    protected InstanceKeyDataSource getNewInstance(Reference reference) throws IOException, ClassNotFoundException {
        byte[] byArray;
        PerUserPoolDataSource perUserPoolDataSource = new PerUserPoolDataSource();
        RefAddr refAddr = reference.get("defaultMaxTotal");
        if (refAddr != null && refAddr.getContent() != null) {
            perUserPoolDataSource.setDefaultMaxTotal(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultMaxIdle")) != null && refAddr.getContent() != null) {
            perUserPoolDataSource.setDefaultMaxIdle(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("defaultMaxWaitMillis")) != null && refAddr.getContent() != null) {
            perUserPoolDataSource.setDefaultMaxWaitMillis(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("perUserDefaultAutoCommit")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.setPerUserDefaultAutoCommit((Map)PerUserPoolDataSourceFactory.deserialize(byArray));
        }
        if ((refAddr = reference.get("perUserDefaultTransactionIsolation")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.setPerUserDefaultTransactionIsolation((Map)PerUserPoolDataSourceFactory.deserialize(byArray));
        }
        if ((refAddr = reference.get("perUserMaxTotal")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.setPerUserMaxTotal((Map)PerUserPoolDataSourceFactory.deserialize(byArray));
        }
        if ((refAddr = reference.get("perUserMaxIdle")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.setPerUserMaxIdle((Map)PerUserPoolDataSourceFactory.deserialize(byArray));
        }
        if ((refAddr = reference.get("perUserMaxWaitMillis")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.setPerUserMaxWaitMillis((Map)PerUserPoolDataSourceFactory.deserialize(byArray));
        }
        if ((refAddr = reference.get("perUserDefaultReadOnly")) != null && refAddr.getContent() != null) {
            byArray = (byte[])refAddr.getContent();
            perUserPoolDataSource.setPerUserDefaultReadOnly((Map)PerUserPoolDataSourceFactory.deserialize(byArray));
        }
        return perUserPoolDataSource;
    }
}

