/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.tomcat.Jar;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.web.FragmentJarScannerCallback;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.apache.tomcat.util.scan.JarFactory;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanner;

public class JspCServletContext
implements ServletContext {
    private final Map<String, Object> myAttributes;
    private final ConcurrentMap<String, String> myParameters = new ConcurrentHashMap<String, String>();
    private final PrintWriter myLogWriter;
    private final URL myResourceBaseURL;
    private WebXml webXml;
    private List<URL> resourceJARs;
    private JspConfigDescriptor jspConfigDescriptor;
    private final ClassLoader loader;

    public JspCServletContext(PrintWriter printWriter, URL uRL, ClassLoader classLoader, boolean bl, boolean bl2) throws JasperException {
        this.myAttributes = new HashMap<String, Object>();
        this.myParameters.put("org.apache.jasper.XML_BLOCK_EXTERNAL", String.valueOf(bl2));
        this.myLogWriter = printWriter;
        this.myResourceBaseURL = uRL;
        this.loader = classLoader;
        this.webXml = this.buildMergedWebXml(bl, bl2);
        this.jspConfigDescriptor = this.webXml.getJspConfigDescriptor();
    }

    private WebXml buildMergedWebXml(boolean bl, boolean bl2) throws JasperException {
        Object object;
        WebXml webXml = new WebXml();
        WebXmlParser webXmlParser = new WebXmlParser(bl, bl, bl2);
        webXmlParser.setClassLoader(this.getClass().getClassLoader());
        try {
            object = this.getResource("/WEB-INF/web.xml");
            if (!webXmlParser.parseWebXml((URL)object, webXml, false)) {
                throw new JasperException(Localizer.getMessage("jspc.error.invalidWebXml"));
            }
        }
        catch (IOException iOException) {
            throw new JasperException(iOException);
        }
        if (webXml.isMetadataComplete()) {
            return webXml;
        }
        object = webXml.getAbsoluteOrdering();
        if (object != null && object.isEmpty()) {
            return webXml;
        }
        Map<String, WebXml> map = this.scanForFragments(webXmlParser);
        Set set = WebXml.orderWebFragments((WebXml)webXml, map, (ServletContext)this);
        this.resourceJARs = this.scanForResourceJARs(set, map.values());
        webXml.merge(set);
        return webXml;
    }

    private List<URL> scanForResourceJARs(Set<WebXml> set, Collection<WebXml> collection) throws JasperException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        LinkedHashSet<WebXml> linkedHashSet = new LinkedHashSet<WebXml>(set);
        for (WebXml webXml : collection) {
            if (linkedHashSet.contains(webXml)) continue;
            linkedHashSet.add(webXml);
        }
        for (WebXml webXml : linkedHashSet) {
            try {
                Jar jar = JarFactory.newInstance((URL)webXml.getURL());
                Throwable throwable = null;
                try {
                    if (jar.exists("META-INF/resources/")) {
                        arrayList.add(webXml.getURL());
                    }
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (IOException iOException) {
                throw new JasperException(iOException);
            }
        }
        return arrayList;
    }

    private Map<String, WebXml> scanForFragments(WebXmlParser webXmlParser) throws JasperException {
        StandardJarScanner standardJarScanner = new StandardJarScanner();
        standardJarScanner.setScanClassPath(false);
        standardJarScanner.setJarScanFilter((JarScanFilter)new StandardJarScanFilter());
        FragmentJarScannerCallback fragmentJarScannerCallback = new FragmentJarScannerCallback(webXmlParser, false, true);
        standardJarScanner.scan(JarScanType.PLUGGABILITY, (ServletContext)this, (JarScannerCallback)fragmentJarScannerCallback);
        if (!fragmentJarScannerCallback.isOk()) {
            throw new JasperException(Localizer.getMessage("jspc.error.invalidFragment"));
        }
        return fragmentJarScannerCallback.getFragments();
    }

    public Object getAttribute(String string) {
        return this.myAttributes.get(string);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.myAttributes.keySet());
    }

    public ServletContext getContext(String string) {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public String getInitParameter(String string) {
        return (String)this.myParameters.get(string);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.myParameters.keySet());
    }

    public int getMajorVersion() {
        return 3;
    }

    public String getMimeType(String string) {
        return null;
    }

    public int getMinorVersion() {
        return 1;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        return null;
    }

    public String getRealPath(String string) {
        if (!this.myResourceBaseURL.getProtocol().equals("file")) {
            return null;
        }
        if (!string.startsWith("/")) {
            return null;
        }
        try {
            File file = new File(this.getResource(string).toURI());
            return file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getResource(String string) throws MalformedURLException {
        URL uRL2;
        Object inputStream;
        Object object;
        URL uRL;
        block22: {
            if (!string.startsWith("/")) {
                throw new MalformedURLException(Localizer.getMessage("jsp.error.URLMustStartWithSlash", string));
            }
            string = string.substring(1);
            uRL = null;
            try {
                object = new URI(this.myResourceBaseURL.toExternalForm() + string);
                uRL = ((URI)object).toURL();
                inputStream = uRL.openStream();
                uRL2 = null;
                if (inputStream == null) break block22;
                if (uRL2 != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)uRL2)).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)inputStream).close();
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                uRL = null;
            }
        }
        if (uRL != null) return uRL;
        if (this.resourceJARs == null) return uRL;
        object = "META-INF/resources/" + string;
        inputStream = this.resourceJARs.iterator();
        while (inputStream.hasNext()) {
            uRL2 = (URL)inputStream.next();
            try {
                Jar jar = JarFactory.newInstance((URL)uRL2);
                Throwable throwable = null;
                try {
                    if (!jar.exists((String)object)) continue;
                    URL uRL3 = new URI(jar.getURL((String)object)).toURL();
                    return uRL3;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (IOException | URISyntaxException exception) {}
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            return this.getResource(string).openStream();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            return null;
        }
    }

    public Set<String> getResourcePaths(String string) {
        Object object;
        Object object2;
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if ((string2 = this.getRealPath(string)) != null && ((File)(object2 = new File(string2))).isDirectory() && (object = ((File)object2).list()) != null) {
            for (String throwable2 : object) {
                File file = new File(string2 + File.separator + throwable2);
                if (file.isFile()) {
                    hashSet.add(string + throwable2);
                    continue;
                }
                if (!file.isDirectory()) continue;
                hashSet.add(string + throwable2 + "/");
            }
        }
        if (this.resourceJARs != null) {
            object2 = "META-INF/resources" + string;
            for (URL uRL : this.resourceJARs) {
                try {
                    Jar jar = JarFactory.newInstance((URL)uRL);
                    Throwable throwable = null;
                    try {
                        String throwable2;
                        jar.nextEntry();
                        throwable2 = jar.getEntryName();
                        while (throwable2 != null) {
                            if (throwable2.startsWith((String)object2) && throwable2.length() > ((String)object2).length()) {
                                int n = throwable2.indexOf(47, ((String)object2).length());
                                if (n < 0) {
                                    hashSet.add(throwable2.substring(18));
                                } else {
                                    hashSet.add(throwable2.substring(18, n + 1));
                                }
                            }
                            jar.nextEntry();
                            throwable2 = jar.getEntryName();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jar == null) continue;
                        if (throwable != null) {
                            try {
                                jar.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jar.close();
                    }
                }
                catch (IOException iOException) {
                    this.log(iOException.getMessage(), iOException);
                }
            }
        }
        return hashSet;
    }

    public String getServerInfo() {
        return "JspC/ApacheTomcat8";
    }

    @Deprecated
    public Servlet getServlet(String string) throws ServletException {
        return null;
    }

    public String getServletContextName() {
        return this.getServerInfo();
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return new Vector().elements();
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return new Vector().elements();
    }

    public void log(String string) {
        this.myLogWriter.println(string);
    }

    @Deprecated
    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public void log(String string, Throwable throwable) {
        this.myLogWriter.println(string);
        throwable.printStackTrace(this.myLogWriter);
    }

    public void removeAttribute(String string) {
        this.myAttributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.myAttributes.put(string, object);
    }

    public FilterRegistration.Dynamic addFilter(String string, String string2) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String string, String string2) {
        return null;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return EnumSet.noneOf(SessionTrackingMode.class);
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return EnumSet.noneOf(SessionTrackingMode.class);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
    }

    public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> clazz) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String string, Servlet servlet) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> clazz) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return null;
    }

    public FilterRegistration getFilterRegistration(String string) {
        return null;
    }

    public ServletRegistration getServletRegistration(String string) {
        return null;
    }

    public boolean setInitParameter(String string, String string2) {
        return this.myParameters.putIfAbsent(string, string2) == null;
    }

    public void addListener(Class<? extends EventListener> clazz) {
    }

    public void addListener(String string) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return null;
    }

    public void declareRoles(String ... stringArray) {
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public int getEffectiveMajorVersion() {
        return this.webXml.getMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.webXml.getMinorVersion();
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.jspConfigDescriptor;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public String getVirtualServerName() {
        return null;
    }
}

