/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.catalina.Manager;
import org.apache.catalina.SessionListener;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.ClusterSession;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaManager;
import org.apache.catalina.ha.session.DeltaRequest;
import org.apache.catalina.ha.session.ReplicatedSessionListener;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.tribes.io.ReplicationStream;
import org.apache.catalina.tribes.tipis.ReplicatedMapEntry;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.res.StringManager;

public class DeltaSession
extends StandardSession
implements Externalizable,
ClusterSession,
ReplicatedMapEntry {
    public static final Log log = LogFactory.getLog(DeltaSession.class);
    protected static final StringManager sm = StringManager.getManager(DeltaSession.class);
    private transient boolean isPrimarySession = true;
    private transient DeltaRequest deltaRequest = null;
    private transient long lastTimeReplicated = System.currentTimeMillis();
    protected final Lock diffLock = new ReentrantReadWriteLock().writeLock();
    private long version;

    public DeltaSession() {
        this(null);
    }

    public DeltaSession(Manager manager) {
        super(manager);
        boolean bl = manager instanceof ClusterManagerBase && ((ClusterManagerBase)manager).isRecordAllActions();
        this.deltaRequest = this.createRequest(this.getIdInternal(), bl);
    }

    private DeltaRequest createRequest() {
        return this.createRequest(null, false);
    }

    protected DeltaRequest createRequest(String string, boolean bl) {
        return new DeltaRequest(string, bl);
    }

    public boolean isDirty() {
        return this.getDeltaRequest().getSize() > 0;
    }

    public boolean isDiffable() {
        return true;
    }

    public byte[] getDiff() throws IOException {
        SynchronizedStack<DeltaRequest> synchronizedStack = null;
        DeltaRequest deltaRequest = null;
        if (this.manager instanceof ClusterManagerBase) {
            synchronizedStack = ((ClusterManagerBase)this.manager).getDeltaRequestPool();
            deltaRequest = (DeltaRequest)synchronizedStack.pop();
            if (deltaRequest == null) {
                deltaRequest = this.createRequest(null, ((ClusterManagerBase)this.manager).isRecordAllActions());
            }
        } else {
            deltaRequest = this.createRequest();
        }
        DeltaRequest deltaRequest2 = this.replaceDeltaRequest(deltaRequest);
        byte[] byArray = deltaRequest2.serialize();
        if (synchronizedStack != null) {
            deltaRequest2.reset();
            synchronizedStack.push((Object)deltaRequest2);
        }
        return byArray;
    }

    public ClassLoader[] getClassLoaders() {
        if (this.manager instanceof ClusterManagerBase) {
            return ((ClusterManagerBase)this.manager).getClassLoaders();
        }
        if (this.manager instanceof ManagerBase) {
            ManagerBase managerBase = (ManagerBase)this.manager;
            return ClusterManagerBase.getClassLoaders(managerBase.getContext());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyDiff(byte[] byArray, int n, int n2) throws IOException, ClassNotFoundException {
        this.lockInternal();
        try (ReplicationStream replicationStream = ((ClusterManager)this.getManager()).getReplicationStream(byArray, n, n2);){
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            try {
                ClassLoader[] classLoaderArray = this.getClassLoaders();
                if (classLoaderArray != null && classLoaderArray.length > 0) {
                    thread.setContextClassLoader(classLoaderArray[0]);
                }
                this.getDeltaRequest().readExternal((ObjectInput)replicationStream);
                this.getDeltaRequest().execute(this, ((ClusterManager)this.getManager()).isNotifyListenersOnReplication());
            }
            finally {
                thread.setContextClassLoader(classLoader);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    public void resetDiff() {
        this.resetDeltaRequest();
    }

    public void lock() {
    }

    public void unlock() {
    }

    private void lockInternal() {
        this.diffLock.lock();
    }

    private void unlockInternal() {
        this.diffLock.unlock();
    }

    public void setOwner(Object object) {
        if (object instanceof ClusterManager && this.getManager() == null) {
            ClusterManager clusterManager = (ClusterManager)object;
            this.setManager(clusterManager);
            this.setValid(true);
            this.setPrimarySession(false);
            this.access();
            this.resetDeltaRequest();
            this.endAccess();
        }
    }

    public boolean isAccessReplicate() {
        long l = System.currentTimeMillis() - this.getLastTimeReplicated();
        return this.maxInactiveInterval >= 0 && l > (long)this.maxInactiveInterval * 1000L;
    }

    public void accessEntry() {
        this.access();
        this.setPrimarySession(false);
        this.endAccess();
    }

    @Override
    public boolean isPrimarySession() {
        return this.isPrimarySession;
    }

    @Override
    public void setPrimarySession(boolean bl) {
        this.isPrimarySession = bl;
    }

    public void setId(String string, boolean bl) {
        super.setId(string, bl);
        this.lockInternal();
        try {
            this.deltaRequest.setSessionId(this.getIdInternal());
        }
        finally {
            this.unlockInternal();
        }
    }

    public void setId(String string) {
        this.setId(string, true);
    }

    public void setMaxInactiveInterval(int n) {
        this.setMaxInactiveInterval(n, true);
    }

    public void setMaxInactiveInterval(int n, boolean bl) {
        this.maxInactiveInterval = n;
        if (bl) {
            this.lockInternal();
            try {
                this.deltaRequest.setMaxInactiveInterval(n);
            }
            finally {
                this.unlockInternal();
            }
        }
    }

    public void setNew(boolean bl) {
        this.setNew(bl, true);
    }

    public void setNew(boolean bl, boolean bl2) {
        super.setNew(bl);
        if (bl2) {
            this.lockInternal();
            try {
                this.deltaRequest.setNew(bl);
            }
            finally {
                this.unlockInternal();
            }
        }
    }

    public void setPrincipal(Principal principal) {
        this.setPrincipal(principal, true);
    }

    public void setPrincipal(Principal principal, boolean bl) {
        this.lockInternal();
        try {
            super.setPrincipal(principal);
            if (bl) {
                this.deltaRequest.setPrincipal(principal);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    public void setAuthType(String string) {
        this.setAuthType(string, true);
    }

    public void setAuthType(String string, boolean bl) {
        this.lockInternal();
        try {
            super.setAuthType(string);
            if (bl) {
                this.deltaRequest.setAuthType(string);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    public boolean isValid() {
        if (!this.isValid) {
            return false;
        }
        if (this.expiring) {
            return true;
        }
        if (ACTIVITY_CHECK && this.accessCount.get() > 0) {
            return true;
        }
        if (this.maxInactiveInterval > 0) {
            int n = (int)(this.getIdleTimeInternal() / 1000L);
            if (this.isPrimarySession()) {
                if (n >= this.maxInactiveInterval) {
                    this.expire(true);
                }
            } else if (n >= 2 * this.maxInactiveInterval) {
                this.expire(true, false);
            }
        }
        return this.isValid;
    }

    public void endAccess() {
        super.endAccess();
        if (this.manager instanceof ClusterManagerBase) {
            ((ClusterManagerBase)this.manager).registerSessionAtReplicationValve(this);
        }
    }

    public void expire(boolean bl) {
        this.expire(bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean bl, boolean bl2) {
        if (!this.isValid) {
            return;
        }
        DeltaSession deltaSession = this;
        synchronized (deltaSession) {
            if (!this.isValid) {
                return;
            }
            if (this.manager == null) {
                return;
            }
            String string = this.getIdInternal();
            if (bl2 && string != null && this.manager instanceof DeltaManager) {
                DeltaManager deltaManager = (DeltaManager)this.manager;
                CatalinaCluster catalinaCluster = deltaManager.getCluster();
                ClusterMessage clusterMessage = deltaManager.requestCompleted(string, true);
                if (clusterMessage != null) {
                    catalinaCluster.send(clusterMessage);
                }
            }
            super.expire(bl);
            if (bl2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("deltaSession.notifying", new Object[]{((ClusterManager)this.manager).getName(), this.isPrimarySession(), string}));
                }
                if (this.manager instanceof DeltaManager) {
                    ((DeltaManager)this.manager).sessionExpired(string);
                }
            }
        }
    }

    public void recycle() {
        this.lockInternal();
        try {
            super.recycle();
            this.deltaRequest.clear();
        }
        finally {
            this.unlockInternal();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DeltaSession[");
        stringBuilder.append(this.id);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.addSessionListener(sessionListener, true);
    }

    public void addSessionListener(SessionListener sessionListener, boolean bl) {
        this.lockInternal();
        try {
            super.addSessionListener(sessionListener);
            if (bl && sessionListener instanceof ReplicatedSessionListener) {
                this.deltaRequest.addSessionListener(sessionListener);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.removeSessionListener(sessionListener, true);
    }

    public void removeSessionListener(SessionListener sessionListener, boolean bl) {
        this.lockInternal();
        try {
            super.removeSessionListener(sessionListener);
            if (bl && sessionListener instanceof ReplicatedSessionListener) {
                this.deltaRequest.removeSessionListener(sessionListener);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.lockInternal();
        try {
            this.readObjectData(objectInput);
        }
        finally {
            this.unlockInternal();
        }
    }

    public void readObjectData(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.doReadObject((ObjectInput)objectInputStream);
    }

    public void readObjectData(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.doReadObject(objectInput);
    }

    public void writeObjectData(ObjectOutputStream objectOutputStream) throws IOException {
        this.writeObjectData((ObjectOutput)objectOutputStream);
    }

    public void writeObjectData(ObjectOutput objectOutput) throws IOException {
        this.doWriteObject(objectOutput);
    }

    public void resetDeltaRequest() {
        this.lockInternal();
        try {
            this.deltaRequest.reset();
            this.deltaRequest.setSessionId(this.getIdInternal());
        }
        finally {
            this.unlockInternal();
        }
    }

    public DeltaRequest getDeltaRequest() {
        return this.deltaRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeltaRequest replaceDeltaRequest(DeltaRequest deltaRequest) {
        this.lockInternal();
        try {
            DeltaRequest deltaRequest2 = this.deltaRequest;
            this.deltaRequest = deltaRequest;
            this.deltaRequest.setSessionId(this.getIdInternal());
            DeltaRequest deltaRequest3 = deltaRequest2;
            return deltaRequest3;
        }
        finally {
            this.unlockInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deserializeAndExecuteDeltaRequest(byte[] byArray) throws IOException, ClassNotFoundException {
        if (this.manager instanceof ClusterManagerBase) {
            SynchronizedStack<DeltaRequest> synchronizedStack = ((ClusterManagerBase)this.manager).getDeltaRequestPool();
            DeltaRequest deltaRequest = (DeltaRequest)synchronizedStack.pop();
            if (deltaRequest == null) {
                deltaRequest = this.createRequest(null, ((ClusterManagerBase)this.manager).isRecordAllActions());
            }
            ReplicationStream replicationStream = ((ClusterManagerBase)this.manager).getReplicationStream(byArray);
            deltaRequest.readExternal((ObjectInput)replicationStream);
            replicationStream.close();
            DeltaRequest deltaRequest2 = null;
            this.lockInternal();
            try {
                deltaRequest2 = this.replaceDeltaRequest(deltaRequest);
                deltaRequest.execute(this, ((ClusterManagerBase)this.manager).isNotifyListenersOnReplication());
                this.setPrimarySession(false);
            }
            finally {
                this.unlockInternal();
                if (deltaRequest2 != null) {
                    deltaRequest2.reset();
                    synchronizedStack.push((Object)deltaRequest2);
                }
            }
        }
    }

    public void removeAttribute(String string, boolean bl) {
        this.removeAttribute(string, bl, true);
    }

    public void removeAttribute(String string, boolean bl, boolean bl2) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.removeAttribute.ise"));
        }
        this.removeAttributeInternal(string, bl, bl2);
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(string, object, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        this.lockInternal();
        try {
            super.setAttribute(string, object, bl);
            if (bl2 && !this.exclude(string, object)) {
                this.deltaRequest.setAttribute(string, object);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    public void removeNote(String string) {
        this.removeNote(string, true);
    }

    public void removeNote(String string, boolean bl) {
        this.lockInternal();
        try {
            super.removeNote(string);
            if (bl && this.manager instanceof ManagerBase && ((ManagerBase)this.manager).getPersistAuthenticationNotes()) {
                this.deltaRequest.removeNote(string);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    public void setNote(String string, Object object) {
        this.setNote(string, object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String string, Object object, boolean bl) {
        if (object == null) {
            this.removeNote(string, bl);
            return;
        }
        this.lockInternal();
        try {
            super.setNote(string, object);
            if (bl && this.manager instanceof ManagerBase && ((ManagerBase)this.manager).getPersistAuthenticationNotes()) {
                this.deltaRequest.setNote(string, object);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    protected void doReadObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.doReadObject((ObjectInput)objectInputStream);
    }

    private void doReadObject(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        String string;
        int n;
        Object object;
        this.authType = null;
        this.creationTime = (Long)objectInput.readObject();
        this.lastAccessedTime = (Long)objectInput.readObject();
        this.maxInactiveInterval = (Integer)objectInput.readObject();
        this.isNew = (Boolean)objectInput.readObject();
        this.isValid = (Boolean)objectInput.readObject();
        this.thisAccessedTime = (Long)objectInput.readObject();
        this.version = (Long)objectInput.readObject();
        boolean bl = objectInput.readBoolean();
        this.principal = null;
        if (bl) {
            this.principal = (Principal)objectInput.readObject();
        }
        this.id = (String)objectInput.readObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaSession.readSession", new Object[]{this.id}));
        }
        if (!((object = objectInput.readObject()) instanceof Integer)) {
            if (object != null) {
                this.notes.put("org.apache.catalina.authenticator.SESSION_ID", object);
            }
            if ((object = objectInput.readObject()) != null) {
                this.notes.put("org.apache.catalina.authenticator.REQUEST", object);
            }
            object = objectInput.readObject();
        }
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap();
        }
        int n2 = (Integer)object;
        boolean bl2 = this.isValid;
        this.isValid = true;
        for (n = 0; n < n2; ++n) {
            Object object2;
            string = (String)objectInput.readObject();
            try {
                object2 = objectInput.readObject();
            }
            catch (WriteAbortedException writeAbortedException) {
                if (writeAbortedException.getCause() instanceof NotSerializableException) continue;
                throw writeAbortedException;
            }
            if (this.exclude(string, object2) || null == object2) continue;
            this.attributes.put(string, object2);
        }
        this.isValid = bl2;
        n2 = (Integer)objectInput.readObject();
        if (this.listeners == null || n2 > 0) {
            this.listeners = new ArrayList();
        }
        for (n = 0; n < n2; ++n) {
            string = (SessionListener)objectInput.readObject();
            this.listeners.add(string);
        }
        if (this.notes == null) {
            this.notes = new ConcurrentHashMap();
        }
        this.activate();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.lockInternal();
        try {
            this.doWriteObject(objectOutput);
        }
        finally {
            this.unlockInternal();
        }
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.doWriteObject((ObjectOutput)objectOutputStream);
    }

    private void doWriteObject(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.creationTime);
        objectOutput.writeObject(this.lastAccessedTime);
        objectOutput.writeObject(this.maxInactiveInterval);
        objectOutput.writeObject(this.isNew);
        objectOutput.writeObject(this.isValid);
        objectOutput.writeObject(this.thisAccessedTime);
        objectOutput.writeObject(this.version);
        objectOutput.writeBoolean(this.getPrincipal() instanceof Serializable);
        if (this.getPrincipal() instanceof Serializable) {
            objectOutput.writeObject(this.getPrincipal());
        }
        objectOutput.writeObject(this.id);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaSession.writeSession", new Object[]{this.id}));
        }
        if (this.manager instanceof ManagerBase && ((ManagerBase)this.manager).getPersistAuthenticationNotes()) {
            objectOutput.writeObject(this.notes.get("org.apache.catalina.authenticator.SESSION_ID"));
            objectOutput.writeObject(this.notes.get("org.apache.catalina.authenticator.REQUEST"));
        }
        String[] stringArray = this.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            Object e = null;
            e = this.attributes.get(string);
            if (e == null || this.exclude(string, e) || !this.isAttributeDistributable(string, e)) continue;
            arrayList.add(string);
            arrayList2.add(e);
        }
        int n2 = arrayList.size();
        objectOutput.writeObject(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeObject(arrayList.get(n));
            try {
                objectOutput.writeObject(arrayList2.get(n));
                continue;
            }
            catch (NotSerializableException notSerializableException) {
                log.error((Object)sm.getString("standardSession.notSerializable", new Object[]{arrayList.get(n), this.id}), (Throwable)notSerializableException);
            }
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String string : this.listeners) {
            if (!(string instanceof ReplicatedSessionListener)) continue;
            arrayList3.add(string);
        }
        objectOutput.writeObject(arrayList3.size());
        for (String string : arrayList3) {
            objectOutput.writeObject(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAttributeInternal(String string, boolean bl, boolean bl2) {
        this.lockInternal();
        try {
            Object v = this.attributes.get(string);
            if (v == null) {
                return;
            }
            super.removeAttributeInternal(string, bl);
            if (bl2 && !this.exclude(string, null)) {
                this.deltaRequest.removeAttribute(string);
            }
        }
        finally {
            this.unlockInternal();
        }
    }

    public long getLastTimeReplicated() {
        return this.lastTimeReplicated;
    }

    public long getVersion() {
        return this.version;
    }

    public void setLastTimeReplicated(long l) {
        this.lastTimeReplicated = l;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    protected void setAccessCount(int n) {
        if (this.accessCount == null && ACTIVITY_CHECK) {
            this.accessCount = new AtomicInteger();
        }
        if (this.accessCount != null) {
            this.accessCount.set(n);
        }
    }
}

