/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.tomcat.util.res.StringManager;

public class CoyoteOutputStream
extends ServletOutputStream {
    protected static final StringManager sm = StringManager.getManager(CoyoteOutputStream.class);
    protected OutputBuffer ob;

    protected CoyoteOutputStream(OutputBuffer outputBuffer) {
        this.ob = outputBuffer;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ob = null;
    }

    public void write(int n) throws IOException {
        boolean bl = this.checkNonBlockingWrite();
        this.ob.writeByte(n);
        if (bl) {
            this.checkRegisterForWrite();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        boolean bl = this.checkNonBlockingWrite();
        this.ob.write(byArray, n, n2);
        if (bl) {
            this.checkRegisterForWrite();
        }
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        boolean bl = this.checkNonBlockingWrite();
        this.ob.write(byteBuffer);
        if (bl) {
            this.checkRegisterForWrite();
        }
    }

    public void flush() throws IOException {
        boolean bl = this.checkNonBlockingWrite();
        this.ob.flush();
        if (bl) {
            this.checkRegisterForWrite();
        }
    }

    private boolean checkNonBlockingWrite() {
        boolean bl;
        boolean bl2 = bl = !this.ob.isBlocking();
        if (bl && !this.ob.isReady()) {
            throw new IllegalStateException(sm.getString("coyoteOutputStream.nbNotready"));
        }
        return bl;
    }

    private void checkRegisterForWrite() {
        this.ob.checkRegisterForWrite();
    }

    public void close() throws IOException {
        this.ob.close();
    }

    public boolean isReady() {
        if (this.ob == null) {
            throw new IllegalStateException(sm.getString("coyoteOutputStream.null"));
        }
        return this.ob.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.ob.setWriteListener(writeListener);
    }
}

