/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class JPopupMenuUtils {
    private static boolean problemTested = false;
    private static boolean problem = false;
    private static RequestProcessor reqProc;
    private static RequestProcessor.Task task;

    public static void dynamicChange(JPopupMenu jPopupMenu, boolean bl) {
        if (!jPopupMenu.isShowing()) {
            return;
        }
        if (JPopupMenuUtils.isProblemConfig()) {
            JPopupMenuUtils.callRefreshLater(jPopupMenu);
            return;
        }
        JPopupMenuUtils.refreshPopup(jPopupMenu);
        Point point = jPopupMenu.getLocationOnScreen();
        Point point2 = JPopupMenuUtils.getPopupMenuOrigin(jPopupMenu, point);
        boolean bl2 = JPopupMenuUtils.willPopupBeContained(jPopupMenu, point2);
        if (bl != bl2) {
            jPopupMenu.setVisible(false);
        }
        if (!point2.equals(point)) {
            // empty if block
        }
        if (bl != bl2) {
            jPopupMenu.setVisible(true);
        }
    }

    private static void refreshPopup(JPopupMenu jPopupMenu) {
        jPopupMenu.pack();
        jPopupMenu.invalidate();
        Container container = jPopupMenu.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
    }

    private static void callRefreshLater(final JPopupMenu jPopupMenu) {
        if (reqProc == null) {
            reqProc = new RequestProcessor();
        }
        if (task == null) {
            task = reqProc.create(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JPopupMenuUtils.task = null;
                            if (!jPopupMenu.isShowing()) {
                                return;
                            }
                            Point point = jPopupMenu.getLocationOnScreen();
                            Point point2 = JPopupMenuUtils.getPopupMenuOrigin(jPopupMenu, point);
                            jPopupMenu.setVisible(false);
                            JPopupMenuUtils.refreshPopup(jPopupMenu);
                            if (!point2.equals(point)) {
                                // empty if block
                            }
                            jPopupMenu.setVisible(true);
                        }
                    });
                }
            });
        }
        task.schedule(100);
    }

    private static boolean isProblemConfig() {
        if (problemTested) {
            return problem;
        }
        problem = false;
        String string = System.getProperty("netbeans.popup.linuxhack");
        if (string != null) {
            problem = true;
        }
        return problem;
    }

    public static void dynamicChangeToSubmenu(JPopupMenu jPopupMenu, boolean bl) {
        Component component = jPopupMenu.getInvoker();
        if (!(component instanceof JMenu)) {
            return;
        }
        JMenu jMenu = (JMenu)component;
        if (!jPopupMenu.isShowing()) {
            return;
        }
        if (JPopupMenuUtils.isProblemConfig()) {
            JPopupMenuUtils.callRefreshLater2(jPopupMenu, jMenu);
            return;
        }
        JPopupMenuUtils.refreshPopup(jPopupMenu);
        Point point = jPopupMenu.getLocationOnScreen();
        Dimension dimension = jPopupMenu.getPreferredSize();
        Rectangle rectangle = new Rectangle(point, dimension);
        Rectangle rectangle2 = JPopupMenuUtils.getScreenRect();
        boolean bl2 = JPopupMenuUtils.isPopupContained(jPopupMenu);
        if (!rectangle2.contains(rectangle)) {
            jMenu.setPopupMenuVisible(false);
            jMenu.setPopupMenuVisible(true);
        } else if (bl != bl2) {
            jPopupMenu.setVisible(false);
            jPopupMenu.setVisible(true);
        }
    }

    private static void callRefreshLater2(final JPopupMenu jPopupMenu, final JMenu jMenu) {
        if (reqProc == null) {
            reqProc = new RequestProcessor();
        }
        if (task == null) {
            task = reqProc.create(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JPopupMenuUtils.task = null;
                            if (!jPopupMenu.isShowing()) {
                                return;
                            }
                            jPopupMenu.setVisible(false);
                            JPopupMenuUtils.refreshPopup(jPopupMenu);
                            jPopupMenu.setVisible(true);
                            Point point = jPopupMenu.getLocationOnScreen();
                            Dimension dimension = jPopupMenu.getPreferredSize();
                            Rectangle rectangle = new Rectangle(point, dimension);
                            Rectangle rectangle2 = JPopupMenuUtils.getScreenRect();
                            if (!rectangle2.contains(rectangle)) {
                                jMenu.setPopupMenuVisible(false);
                                jMenu.setPopupMenuVisible(true);
                            }
                        }
                    });
                }
            });
        }
        task.schedule(100);
    }

    static Point getPopupMenuOrigin(JPopupMenu jPopupMenu, Point point) {
        Point point2 = new Point(point);
        Dimension dimension = jPopupMenu.getPreferredSize();
        Rectangle rectangle = JPopupMenuUtils.getScreenRect();
        int n = point2.x + dimension.width;
        int n2 = point2.y + dimension.height;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        if (n > n3) {
            point2.x = n3 - dimension.width;
        }
        if (point2.x < rectangle.x) {
            point2.x = rectangle.x;
        }
        if (n2 > n4) {
            point2.y = n4 - dimension.height;
        }
        if (point2.y < rectangle.y) {
            point2.y = rectangle.y;
        }
        return point2;
    }

    public static boolean isPopupContained(JPopupMenu jPopupMenu) {
        if (!jPopupMenu.isShowing()) {
            return false;
        }
        return JPopupMenuUtils.willPopupBeContained(jPopupMenu, jPopupMenu.getLocationOnScreen());
    }

    private static boolean willPopupBeContained(JPopupMenu jPopupMenu, Point point) {
        if (!jPopupMenu.isShowing()) {
            return false;
        }
        Window window = SwingUtilities.windowForComponent(jPopupMenu.getInvoker());
        Rectangle rectangle = new Rectangle(point, jPopupMenu.getSize());
        return window != null && window.getBounds().contains(rectangle);
    }

    public static Rectangle getScreenRect() {
        return Utilities.getUsableScreenBounds();
    }
}

