/* pathentry.c generated by valac 0.56.3, the Vala compiler
 * generated from pathentry.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BROWSER_ENTRY (browser_entry_get_type ())
#define BROWSER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_ENTRY, BrowserEntry))
#define BROWSER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_ENTRY, BrowserEntryClass))
#define IS_BROWSER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_ENTRY))
#define IS_BROWSER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_ENTRY))
#define BROWSER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_ENTRY, BrowserEntryClass))

typedef struct _BrowserEntry BrowserEntry;
typedef struct _BrowserEntryClass BrowserEntryClass;
typedef struct _BrowserEntryPrivate BrowserEntryPrivate;
enum  {
	BROWSER_ENTRY_0_PROPERTY,
	BROWSER_ENTRY_NUM_PROPERTIES
};
static GParamSpec* browser_entry_properties[BROWSER_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_PATH_ENTRY (path_entry_get_type ())
#define PATH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_ENTRY, PathEntry))
#define PATH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_ENTRY, PathEntryClass))
#define IS_PATH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_ENTRY))
#define IS_PATH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_ENTRY))
#define PATH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_ENTRY, PathEntryClass))

typedef struct _PathEntry PathEntry;
typedef struct _PathEntryClass PathEntryClass;
typedef struct _PathEntryPrivate PathEntryPrivate;
enum  {
	PATH_ENTRY_0_PROPERTY,
	PATH_ENTRY_NUM_PROPERTIES
};
static GParamSpec* path_entry_properties[PATH_ENTRY_NUM_PROPERTIES];
typedef enum  {
	PATH_ENTRY_SEARCH_MODE_UNCLEAR,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_LAST_WORD,
	PATH_ENTRY_SEARCH_MODE_SEARCH
} PathEntrySearchMode;

#define PATH_ENTRY_TYPE_SEARCH_MODE (path_entry_search_mode_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BrowserEntry {
	GtkSearchEntry parent_instance;
	BrowserEntryPrivate * priv;
};

struct _BrowserEntryClass {
	GtkSearchEntryClass parent_class;
};

struct _BrowserEntryPrivate {
	GtkStyleContext* context;
	gboolean has_error_class;
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _PathEntry {
	GtkBox parent_instance;
	PathEntryPrivate * priv;
};

struct _PathEntryClass {
	GtkBoxClass parent_class;
};

struct _PathEntryPrivate {
	GtkButton* hide_search_button;
	GtkButton* reload_search_button;
	BrowserEntry* search_entry;
	GtkButton* search_action_button;
	gchar* current_path;
	gulong can_reload_handler;
	gboolean thin_window;
	gulong search_changed_handler;
};

static gint BrowserEntry_private_offset;
static gpointer browser_entry_parent_class = NULL;
static gint PathEntry_private_offset;
static gpointer path_entry_parent_class = NULL;
static AdaptativeWidgetIface * path_entry_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType browser_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserEntry, g_object_unref)
VALA_EXTERN void browser_entry_check_error (BrowserEntry* self,
                                gchar** path);
VALA_EXTERN gboolean browser_window_is_path_invalid (const gchar* path);
VALA_EXTERN void browser_entry_set_is_thin_window (BrowserEntry* self,
                                       gboolean thin_window);
VALA_EXTERN BrowserEntry* browser_entry_new (void);
VALA_EXTERN BrowserEntry* browser_entry_construct (GType object_type);
static GObject * browser_entry_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void browser_entry_finalize (GObject * obj);
static GType browser_entry_get_type_once (void);
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType path_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PathEntry, g_object_unref)
VALA_EXTERN GType path_entry_search_mode_get_type (void) G_GNUC_CONST ;
static void path_entry_real_get_preferred_width (GtkWidget* base,
                                          gint* minimum_width,
                                          gint* natural_width);
static void path_entry_real_set_window_size (AdaptativeWidget* base,
                                      AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_quite_thin (AdaptativeWidgetWindowSize window_size);
static void ___lambda15_ (PathEntry* self);
static void ____lambda15__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN void path_entry_entry_grab_focus_without_selecting (PathEntry* self);
static void _path_entry_entry_grab_focus_without_selecting (BrowserEntry* search_entry);
VALA_EXTERN void path_entry_entry_grab_focus (PathEntry* self);
VALA_EXTERN gboolean path_entry_handle_event (PathEntry* self,
                                  GdkEventKey* event);
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void path_entry_set_path (PathEntry* self,
                          ViewType type,
                          const gchar* _path);
VALA_EXTERN void path_entry_prepare (PathEntry* self,
                         PathEntrySearchMode mode,
                         const gchar* nullable_search);
static inline void _path_entry_prepare (PathEntrySearchMode mode,
                          const gchar* nullable_search,
                          gchar** current_path,
                          BrowserEntry* search_entry);
static inline void _path_entry_prepare_move_end (gchar** text,
                                   BrowserEntry* search_entry);
static inline void _path_entry_prepare_search (gchar** text,
                                 BrowserEntry* search_entry);
static inline void _path_entry_prepare_select_last_word (gchar** current_path,
                                           BrowserEntry* search_entry);
VALA_EXTERN gchar* model_utils_get_parent_path (const gchar* path);
VALA_EXTERN PathEntry* path_entry_new (void);
VALA_EXTERN PathEntry* path_entry_construct (GType object_type);
static GObject * path_entry_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void _path_entry___lambda16_ (PathEntry* self);
static void __path_entry___lambda16__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                               gpointer self);
static void _path_entry___lambda17_ (PathEntry* self);
static void __path_entry___lambda17__gtk_search_entry_stop_search (GtkSearchEntry* _sender,
                                                            gpointer self);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void path_entry_finalize (GObject * obj);
static GType path_entry_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
browser_entry_get_instance_private (BrowserEntry* self)
{
	return G_STRUCT_MEMBER_P (self, BrowserEntry_private_offset);
}

void
browser_entry_check_error (BrowserEntry* self,
                           gchar** path)
{
	gboolean is_invalid = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*path != NULL);
	is_invalid = browser_window_is_path_invalid (*path);
	if (!self->priv->has_error_class) {
		_tmp0_ = is_invalid;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkStyleContext* _tmp1_;
		self->priv->has_error_class = TRUE;
		_tmp1_ = self->priv->context;
		gtk_style_context_add_class (_tmp1_, "error");
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->has_error_class) {
			_tmp2_ = !is_invalid;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GtkStyleContext* _tmp3_;
			self->priv->has_error_class = FALSE;
			_tmp3_ = self->priv->context;
			gtk_style_context_remove_class (_tmp3_, "error");
		}
	}
}

void
browser_entry_set_is_thin_window (BrowserEntry* self,
                                  gboolean thin_window)
{
	g_return_if_fail (self != NULL);
	if (thin_window) {
		gtk_entry_set_icon_from_pixbuf ((GtkEntry*) self, GTK_ENTRY_ICON_PRIMARY, NULL);
	} else {
		gtk_entry_set_icon_from_icon_name ((GtkEntry*) self, GTK_ENTRY_ICON_PRIMARY, "edit-find-symbolic");
	}
}

BrowserEntry*
browser_entry_construct (GType object_type)
{
	BrowserEntry * self = NULL;
	self = (BrowserEntry*) g_object_new (object_type, NULL);
	return self;
}

BrowserEntry*
browser_entry_new (void)
{
	return browser_entry_construct (TYPE_BROWSER_ENTRY);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
browser_entry_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BrowserEntry * self;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	parent_class = G_OBJECT_CLASS (browser_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_ENTRY, BrowserEntry);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	return obj;
}

static void
browser_entry_class_init (BrowserEntryClass * klass,
                          gpointer klass_data)
{
	browser_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BrowserEntry_private_offset);
	G_OBJECT_CLASS (klass)->constructor = browser_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = browser_entry_finalize;
}

static void
browser_entry_instance_init (BrowserEntry * self,
                             gpointer klass)
{
	self->priv = browser_entry_get_instance_private (self);
	self->priv->has_error_class = FALSE;
}

static void
browser_entry_finalize (GObject * obj)
{
	BrowserEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_ENTRY, BrowserEntry);
	_g_object_unref0 (self->priv->context);
	G_OBJECT_CLASS (browser_entry_parent_class)->finalize (obj);
}

static GType
browser_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrowserEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browser_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrowserEntry), 0, (GInstanceInitFunc) browser_entry_instance_init, NULL };
	GType browser_entry_type_id;
	browser_entry_type_id = g_type_register_static (gtk_search_entry_get_type (), "BrowserEntry", &g_define_type_info, 0);
	BrowserEntry_private_offset = g_type_add_instance_private (browser_entry_type_id, sizeof (BrowserEntryPrivate));
	return browser_entry_type_id;
}

GType
browser_entry_get_type (void)
{
	static volatile gsize browser_entry_type_id__once = 0;
	if (g_once_init_enter (&browser_entry_type_id__once)) {
		GType browser_entry_type_id;
		browser_entry_type_id = browser_entry_get_type_once ();
		g_once_init_leave (&browser_entry_type_id__once, browser_entry_type_id);
	}
	return browser_entry_type_id__once;
}

static inline gpointer
path_entry_get_instance_private (PathEntry* self)
{
	return G_STRUCT_MEMBER_P (self, PathEntry_private_offset);
}

static GType
path_entry_search_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{PATH_ENTRY_SEARCH_MODE_UNCLEAR, "PATH_ENTRY_SEARCH_MODE_UNCLEAR", "unclear"}, {PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END, "PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END", "edit-path-move-end"}, {PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL, "PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL", "edit-path-select-all"}, {PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_LAST_WORD, "PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_LAST_WORD", "edit-path-select-last-word"}, {PATH_ENTRY_SEARCH_MODE_SEARCH, "PATH_ENTRY_SEARCH_MODE_SEARCH", "search"}, {0, NULL, NULL}};
	GType path_entry_search_mode_type_id;
	path_entry_search_mode_type_id = g_enum_register_static ("PathEntrySearchMode", values);
	return path_entry_search_mode_type_id;
}

GType
path_entry_search_mode_get_type (void)
{
	static volatile gsize path_entry_search_mode_type_id__once = 0;
	if (g_once_init_enter (&path_entry_search_mode_type_id__once)) {
		GType path_entry_search_mode_type_id;
		path_entry_search_mode_type_id = path_entry_search_mode_get_type_once ();
		g_once_init_leave (&path_entry_search_mode_type_id__once, path_entry_search_mode_type_id);
	}
	return path_entry_search_mode_type_id__once;
}

static void
path_entry_real_get_preferred_width (GtkWidget* base,
                                     gint* minimum_width,
                                     gint* natural_width)
{
	PathEntry * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = (PathEntry*) base;
	GTK_WIDGET_CLASS (path_entry_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_vala_minimum_width = 72;
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static void
___lambda15_ (PathEntry* self)
{
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->reload_search_button;
	_tmp1_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkButton* _tmp3_;
		GtkButton* _tmp4_;
		_tmp3_ = self->priv->hide_search_button;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->reload_search_button;
		gtk_widget_show ((GtkWidget*) _tmp4_);
	} else {
		GtkButton* _tmp5_;
		GtkButton* _tmp6_;
		_tmp5_ = self->priv->reload_search_button;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->hide_search_button;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	}
}

static void
____lambda15__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda15_ ((PathEntry*) self);
}

static void
path_entry_real_set_window_size (AdaptativeWidget* base,
                                 AdaptativeWidgetWindowSize new_size)
{
	PathEntry * self;
	gboolean _thin_window = FALSE;
	BrowserEntry* _tmp0_;
	self = (PathEntry*) base;
	_thin_window = adaptative_widget_window_size_is_quite_thin (new_size);
	if (self->priv->thin_window == _thin_window) {
		return;
	}
	self->priv->thin_window = _thin_window;
	_tmp0_ = self->priv->search_entry;
	browser_entry_set_is_thin_window (_tmp0_, _thin_window);
	if (_thin_window) {
		GtkButton* _tmp1_;
		gulong _tmp2_;
		GtkButton* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = self->priv->reload_search_button;
		_tmp2_ = g_signal_connect_object ((GObject*) _tmp1_, "notify::sensitive", (GCallback) ____lambda15__g_object_notify, self, 0);
		self->priv->can_reload_handler = _tmp2_;
		_tmp3_ = self->priv->reload_search_button;
		_tmp4_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (!_tmp5_) {
			GtkButton* _tmp6_;
			GtkButton* _tmp7_;
			_tmp6_ = self->priv->reload_search_button;
			gtk_widget_hide ((GtkWidget*) _tmp6_);
			_tmp7_ = self->priv->hide_search_button;
			gtk_widget_show ((GtkWidget*) _tmp7_);
		}
	} else {
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		GtkButton* _tmp10_;
		_tmp8_ = self->priv->reload_search_button;
		g_signal_handler_disconnect ((GObject*) _tmp8_, self->priv->can_reload_handler);
		_tmp9_ = self->priv->hide_search_button;
		gtk_widget_hide ((GtkWidget*) _tmp9_);
		_tmp10_ = self->priv->reload_search_button;
		gtk_widget_show ((GtkWidget*) _tmp10_);
	}
}

void
path_entry_entry_grab_focus_without_selecting (PathEntry* self)
{
	BrowserEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_path_entry_entry_grab_focus_without_selecting (_tmp0_);
}

static void
_path_entry_entry_grab_focus_without_selecting (BrowserEntry* search_entry)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (search_entry != NULL);
	_tmp0_ = gtk_entry_get_text_length ((GtkEntry*) search_entry);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != ((guint) 0)) {
		gint _tmp2_;
		gint _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		g_object_get ((GtkEntry*) search_entry, "cursor-position", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_entry_get_text_length ((GtkEntry*) search_entry);
		_tmp5_ = _tmp4_;
		if (((guint) _tmp3_) == _tmp5_) {
			g_signal_emit_by_name ((GtkEntry*) search_entry, "move-cursor", GTK_MOVEMENT_DISPLAY_LINE_ENDS, -1, FALSE);
		}
		g_signal_emit_by_name ((GtkEntry*) search_entry, "move-cursor", GTK_MOVEMENT_DISPLAY_LINE_ENDS, 1, FALSE);
	}
	gtk_entry_grab_focus_without_selecting ((GtkEntry*) search_entry);
}

void
path_entry_entry_grab_focus (PathEntry* self)
{
	BrowserEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

gboolean
path_entry_handle_event (PathEntry* self,
                         GdkEventKey* event)
{
	BrowserEntry* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	result = gtk_search_entry_handle_event ((GtkSearchEntry*) _tmp0_, (GdkEvent*) event);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
path_entry_set_path (PathEntry* self,
                     ViewType type,
                     const gchar* _path)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	BrowserEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_path != NULL);
	_tmp0_ = string_strip (_path);
	path = _tmp0_;
	_tmp1_ = self->priv->search_entry;
	browser_entry_check_error (_tmp1_, &path);
	_tmp2_ = path;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->current_path);
	self->priv->current_path = _tmp3_;
	_g_free0 (path);
}

void
path_entry_prepare (PathEntry* self,
                    PathEntrySearchMode mode,
                    const gchar* nullable_search)
{
	BrowserEntry* _tmp0_;
	BrowserEntry* _tmp1_;
	BrowserEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->search_changed_handler != ((gulong) 0), "search_changed_handler != 0");
	_tmp0_ = self->priv->search_entry;
	g_signal_handler_block (_tmp0_, self->priv->search_changed_handler);
	_tmp1_ = self->priv->search_entry;
	_path_entry_prepare (mode, nullable_search, &self->priv->current_path, _tmp1_);
	_tmp2_ = self->priv->search_entry;
	g_signal_handler_unblock (_tmp2_, self->priv->search_changed_handler);
}

static inline void
_path_entry_prepare (PathEntrySearchMode mode,
                     const gchar* nullable_search,
                     gchar** current_path,
                     BrowserEntry* search_entry)
{
	gchar* search = NULL;
	g_return_if_fail (*current_path != NULL);
	g_return_if_fail (search_entry != NULL);
	switch (mode) {
		case PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			if (nullable_search == NULL) {
				_tmp0_ = *current_path;
			} else {
				_tmp0_ = (const gchar*) nullable_search;
			}
			_tmp1_ = g_strdup (_tmp0_);
			_g_free0 (search);
			search = _tmp1_;
			_path_entry_prepare_move_end (&search, search_entry);
			_g_free0 (search);
			return;
		}
		case PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			if (nullable_search == NULL) {
				_tmp2_ = *current_path;
			} else {
				_tmp2_ = (const gchar*) nullable_search;
			}
			_tmp3_ = g_strdup (_tmp2_);
			_g_free0 (search);
			search = _tmp3_;
			_path_entry_prepare_search (&search, search_entry);
			_g_free0 (search);
			return;
		}
		case PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_LAST_WORD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (*current_path);
			_g_free0 (search);
			search = _tmp4_;
			_path_entry_prepare_select_last_word (&search, search_entry);
			_g_free0 (search);
			return;
		}
		case PATH_ENTRY_SEARCH_MODE_SEARCH:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			_g_free0 (search);
			search = _tmp5_;
			_path_entry_prepare_search (&search, search_entry);
			_g_free0 (search);
			return;
		}
		default:
		case PATH_ENTRY_SEARCH_MODE_UNCLEAR:
		{
			g_assert_not_reached ();
		}
	}
}

static inline void
_path_entry_prepare_move_end (gchar** text,
                              BrowserEntry* search_entry)
{
	g_return_if_fail (*text != NULL);
	g_return_if_fail (search_entry != NULL);
	gtk_entry_set_text ((GtkEntry*) search_entry, *text);
	_path_entry_entry_grab_focus_without_selecting (search_entry);
}

static inline void
_path_entry_prepare_search (gchar** text,
                            BrowserEntry* search_entry)
{
	g_return_if_fail (*text != NULL);
	g_return_if_fail (search_entry != NULL);
	gtk_entry_set_text ((GtkEntry*) search_entry, *text);
	gtk_widget_grab_focus ((GtkWidget*) search_entry);
}

static inline void
_path_entry_prepare_select_last_word (gchar** current_path,
                                      BrowserEntry* search_entry)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (*current_path != NULL);
	g_return_if_fail (search_entry != NULL);
	g_signal_emit_by_name ((GtkEntry*) search_entry, "move-cursor", GTK_MOVEMENT_DISPLAY_LINE_ENDS, -1, FALSE);
	gtk_entry_set_text ((GtkEntry*) search_entry, *current_path);
	_tmp0_ = gtk_entry_get_text_length ((GtkEntry*) search_entry);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ((guint) 1)) {
		gtk_widget_grab_focus ((GtkWidget*) search_entry);
		return;
	}
	_tmp2_ = gtk_entry_get_text_length ((GtkEntry*) search_entry);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != ((guint) 0)) {
		gint _tmp4_;
		gint _tmp5_;
		guint _tmp6_;
		guint _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		g_object_get ((GtkEntry*) search_entry, "cursor-position", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_entry_get_text_length ((GtkEntry*) search_entry);
		_tmp7_ = _tmp6_;
		if (((guint) _tmp5_) == _tmp7_) {
			g_signal_emit_by_name ((GtkEntry*) search_entry, "move-cursor", GTK_MOVEMENT_DISPLAY_LINE_ENDS, -1, FALSE);
		}
		_tmp8_ = model_utils_get_parent_path (*current_path);
		_tmp9_ = _tmp8_;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		g_signal_emit_by_name ((GtkEntry*) search_entry, "move-cursor", GTK_MOVEMENT_VISUAL_POSITIONS, _tmp11_, FALSE);
		_g_free0 (_tmp9_);
		g_signal_emit_by_name ((GtkEntry*) search_entry, "move-cursor", GTK_MOVEMENT_DISPLAY_LINE_ENDS, 1, TRUE);
	}
	gtk_entry_grab_focus_without_selecting ((GtkEntry*) search_entry);
}

PathEntry*
path_entry_construct (GType object_type)
{
	PathEntry * self = NULL;
	self = (PathEntry*) g_object_new (object_type, NULL);
	return self;
}

PathEntry*
path_entry_new (void)
{
	return path_entry_construct (TYPE_PATH_ENTRY);
}

static void
_path_entry___lambda16_ (PathEntry* self)
{
	GtkButton* _tmp0_;
	BrowserEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkButton* _tmp4_;
	_tmp0_ = self->priv->search_action_button;
	_tmp1_ = self->priv->search_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_actionable_set_action_target ((GtkActionable*) _tmp0_, "ms", _tmp3_, NULL);
	_tmp4_ = self->priv->search_action_button;
	gtk_button_clicked (_tmp4_);
}

static void
__path_entry___lambda16__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                          gpointer self)
{
	_path_entry___lambda16_ ((PathEntry*) self);
}

static void
_path_entry___lambda17_ (PathEntry* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	_tmp0_ = self->priv->search_action_button;
	gtk_actionable_set_action_target ((GtkActionable*) _tmp0_, "ms", NULL, NULL);
	_tmp1_ = self->priv->search_action_button;
	gtk_button_clicked (_tmp1_);
}

static void
__path_entry___lambda17__gtk_search_entry_stop_search (GtkSearchEntry* _sender,
                                                       gpointer self)
{
	_path_entry___lambda17_ ((PathEntry*) self);
}

static GObject *
path_entry_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PathEntry * self;
	BrowserEntry* _tmp0_;
	gulong _tmp1_;
	BrowserEntry* _tmp2_;
	parent_class = G_OBJECT_CLASS (path_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PATH_ENTRY, PathEntry);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = g_signal_connect_object ((GtkSearchEntry*) _tmp0_, "search-changed", (GCallback) __path_entry___lambda16__gtk_search_entry_search_changed, self, 0);
	self->priv->search_changed_handler = _tmp1_;
	_tmp2_ = self->priv->search_entry;
	g_signal_connect_object ((GtkSearchEntry*) _tmp2_, "stop-search", (GCallback) __path_entry___lambda17__gtk_search_entry_stop_search, self, 0);
	return obj;
}

static void
path_entry_class_init (PathEntryClass * klass,
                       gpointer klass_data)
{
	path_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PathEntry_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) path_entry_real_get_preferred_width;
	G_OBJECT_CLASS (klass)->constructor = path_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = path_entry_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/pathentry.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hide_search_button", FALSE, PathEntry_private_offset + G_STRUCT_OFFSET (PathEntryPrivate, hide_search_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reload_search_button", FALSE, PathEntry_private_offset + G_STRUCT_OFFSET (PathEntryPrivate, reload_search_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, PathEntry_private_offset + G_STRUCT_OFFSET (PathEntryPrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_action_button", FALSE, PathEntry_private_offset + G_STRUCT_OFFSET (PathEntryPrivate, search_action_button));
}

static void
path_entry_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                             gpointer iface_data)
{
	path_entry_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) path_entry_real_set_window_size;
}

static void
path_entry_instance_init (PathEntry * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = path_entry_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->current_path = _tmp0_;
	self->priv->can_reload_handler = (gulong) 0;
	self->priv->thin_window = FALSE;
	self->priv->search_changed_handler = (gulong) 0;
	g_type_ensure (TYPE_BROWSER_ENTRY);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
path_entry_finalize (GObject * obj)
{
	PathEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PATH_ENTRY, PathEntry);
	_g_free0 (self->priv->current_path);
	G_OBJECT_CLASS (path_entry_parent_class)->finalize (obj);
}

static GType
path_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PathEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) path_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PathEntry), 0, (GInstanceInitFunc) path_entry_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) path_entry_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType path_entry_type_id;
	path_entry_type_id = g_type_register_static (gtk_box_get_type (), "PathEntry", &g_define_type_info, 0);
	g_type_add_interface_static (path_entry_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	PathEntry_private_offset = g_type_add_instance_private (path_entry_type_id, sizeof (PathEntryPrivate));
	return path_entry_type_id;
}

GType
path_entry_get_type (void)
{
	static volatile gsize path_entry_type_id__once = 0;
	if (g_once_init_enter (&path_entry_type_id__once)) {
		GType path_entry_type_id;
		path_entry_type_id = path_entry_get_type_once ();
		g_once_init_leave (&path_entry_type_id__once, path_entry_type_id);
	}
	return path_entry_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

